/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import org.micromanager.script.ScriptingEngine;
import org.micromanager.script.ScriptingGUI;
import org.micromanager.utils.MMScriptException;

public class BeanshellEngine
implements ScriptingEngine {
    Interpreter interp_;
    boolean running_ = false;
    boolean error_ = false;
    EvalThread evalThd_ = new EvalThread("");
    boolean stop_ = false;
    private ScriptingGUI gui_;
    private Interpreter interp_old_;

    @Override
    public void setInterpreter(Interpreter interp) {
        this.interp_old_ = this.interp_;
        this.interp_ = interp;
    }

    @Override
    public void resetInterpreter() {
        this.interp_ = this.interp_old_;
    }

    public BeanshellEngine(ScriptingGUI gui) {
        this.gui_ = gui;
    }

    @Override
    public void evaluate(String script) throws MMScriptException {
        try {
            this.interp_.eval(script);
        }
        catch (EvalError e) {
            throw new MMScriptException(this.formatBeanshellError(e, e.getErrorLineNumber()));
        }
    }

    @Override
    public void joinEvalThread() throws InterruptedException {
        if (this.evalThd_.isAlive()) {
            this.evalThd_.join();
        }
    }

    @Override
    public void evaluateAsync(String script) throws MMScriptException {
        if (this.evalThd_.isAlive()) {
            throw new MMScriptException("Another script execution in progress!");
        }
        this.evalThd_ = new EvalThread(script);
        this.evalThd_.start();
    }

    @Override
    public void insertGlobalObject(String name, Object obj) throws MMScriptException {
        try {
            this.interp_.set(name, obj);
        }
        catch (EvalError e) {
            throw new MMScriptException(e);
        }
    }

    @Override
    public void stopRequest(boolean shouldInterrupt) {
        if (this.evalThd_.isAlive()) {
            if (shouldInterrupt) {
                this.evalThd_.interrupt();
            } else {
                this.evalThd_.stop();
                this.stop_ = true;
            }
        }
    }

    @Override
    public boolean stopRequestPending() {
        if (this.evalThd_.isAlive() && this.stop_) {
            return this.stop_;
        }
        this.stop_ = false;
        return this.stop_;
    }

    private String formatBeanshellError(EvalError e, int line) {
        if (e instanceof TargetError) {
            Throwable t = ((TargetError)((Object)e)).getTarget();
            return "Line " + line + ": run-time error : " + (t != null ? t.getMessage() : e.getErrorText());
        }
        if (e instanceof ParseException) {
            return "Line " + line + ": syntax error : " + e.getErrorText();
        }
        Throwable t = e.getCause();
        return "Line " + line + ": general error : " + (t != null ? t.getMessage() : e.getErrorText());
    }

    @Override
    public void sleep(long ms) throws MMScriptException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new MMScriptException("Execution interrupted by the user");
        }
    }

    public class EvalThread
    extends Thread {
        String script_;
        String errorText_;

        public EvalThread(String script) {
            this.script_ = script;
            this.errorText_ = new String();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BeanshellEngine.this.stop_ = false;
            BeanshellEngine.this.running_ = true;
            this.errorText_ = new String();
            try {
                BeanshellEngine.this.interp_.eval(this.script_);
            }
            catch (TargetError e) {
                int lineNo = e.getErrorLineNumber();
                BeanshellEngine.this.gui_.displayError(BeanshellEngine.this.formatBeanshellError((EvalError)((Object)e), lineNo), lineNo);
            }
            catch (ParseException e) {
                String msg = e.getMessage();
                String lineNumberTxt = msg.substring(20, msg.indexOf(44));
                BeanshellEngine.this.gui_.displayError("Parse error: " + msg, Integer.parseInt(lineNumberTxt));
            }
            catch (EvalError e) {
                int lineNo = e.getErrorLineNumber();
                BeanshellEngine.this.gui_.displayError(BeanshellEngine.this.formatBeanshellError(e, lineNo), lineNo);
            }
            finally {
                BeanshellEngine.this.running_ = false;
            }
        }

        public String getError() {
            return this.errorText_;
        }
    }
}

