/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.MMOptions;
import org.micromanager.api.MMListenerInterface;
import org.micromanager.api.MultiStagePosition;
import org.micromanager.api.StagePosition;
import org.micromanager.positionlist.PositionListDlg;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class TileCreatorDlg
extends MMDialog
implements MMListenerInterface {
    private static final long serialVersionUID = 1L;
    private CMMCore core_;
    private MultiStagePosition[] endPosition_;
    private boolean[] endPositionSet_;
    private PositionListDlg positionListDlg_;
    private JTextField overlapField_;
    private JComboBox overlapUnitsCombo_;
    private OverlapUnitEnum overlapUnit_ = OverlapUnitEnum.UM;
    private int centeredFrames_ = 0;
    private JTextField pixelSizeField_;
    private final JLabel labelLeft_ = new JLabel();
    private final JLabel labelTop_ = new JLabel();
    private final JLabel labelRight_ = new JLabel();
    private final JLabel labelBottom_ = new JLabel();
    private final JLabel labelWidth_ = new JLabel();
    private final JLabel labelWidthUmPx_ = new JLabel();
    private static int prefix_ = 0;
    private static final DecimalFormat FMT_POS = new DecimalFormat("000");

    public TileCreatorDlg(CMMCore core, MMOptions opts, PositionListDlg positionListDlg) {
        this.setResizable(false);
        this.setName("tileDialog");
        this.getContentPane().setLayout(null);
        this.core_ = core;
        this.positionListDlg_ = positionListDlg;
        this.positionListDlg_.activateAxisTable(false);
        this.endPosition_ = new MultiStagePosition[4];
        this.endPositionSet_ = new boolean[4];
        this.setTitle("Tile Creator");
        this.loadAndRestorePosition(300, 300);
        this.setSize(344, 280);
        JButton goToLeftButton = new JButton();
        goToLeftButton.setFont(new Font("", 0, 10));
        goToLeftButton.setText("Go To");
        goToLeftButton.setBounds(20, 89, 93, 23);
        this.getContentPane().add(goToLeftButton);
        goToLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TileCreatorDlg.this.endPositionSet_[3]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[3]);
                }
            }
        });
        this.labelLeft_.setFont(new Font("", 0, 8));
        this.labelLeft_.setHorizontalAlignment(0);
        this.labelLeft_.setText("");
        this.labelLeft_.setBounds(0, 112, 130, 14);
        this.getContentPane().add(this.labelLeft_);
        JButton setLeftButton = new JButton();
        setLeftButton.setBounds(20, 66, 93, 23);
        setLeftButton.setFont(new Font("", 0, 10));
        setLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.labelLeft_.setText(TileCreatorDlg.this.thisPosition(TileCreatorDlg.this.markPosition(3)));
            }
        });
        setLeftButton.setText("Set");
        this.getContentPane().add(setLeftButton);
        this.labelTop_.setFont(new Font("", 0, 8));
        this.labelTop_.setHorizontalAlignment(0);
        this.labelTop_.setText("");
        this.labelTop_.setBounds(115, 51, 130, 14);
        this.getContentPane().add(this.labelTop_);
        JButton goToTopButton = new JButton();
        goToTopButton.setFont(new Font("", 0, 10));
        goToTopButton.setText("Go To");
        goToTopButton.setBounds(129, 28, 93, 23);
        this.getContentPane().add(goToTopButton);
        goToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TileCreatorDlg.this.endPositionSet_[0]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[0]);
                }
            }
        });
        JButton setTopButton = new JButton();
        setTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.labelTop_.setText(TileCreatorDlg.this.thisPosition(TileCreatorDlg.this.markPosition(0)));
            }
        });
        setTopButton.setBounds(129, 5, 93, 23);
        setTopButton.setFont(new Font("", 0, 10));
        setTopButton.setText("Set");
        this.getContentPane().add(setTopButton);
        this.labelRight_.setFont(new Font("", 0, 8));
        this.labelRight_.setHorizontalAlignment(0);
        this.labelRight_.setText("");
        this.labelRight_.setBounds(214, 112, 130, 14);
        this.getContentPane().add(this.labelRight_);
        JButton setRightButton = new JButton();
        setRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.labelRight_.setText(TileCreatorDlg.this.thisPosition(TileCreatorDlg.this.markPosition(1)));
            }
        });
        setRightButton.setBounds(234, 66, 93, 23);
        setRightButton.setFont(new Font("", 0, 10));
        setRightButton.setText("Set");
        this.getContentPane().add(setRightButton);
        this.labelBottom_.setFont(new Font("", 0, 8));
        this.labelBottom_.setHorizontalAlignment(0);
        this.labelBottom_.setText("");
        this.labelBottom_.setBounds(115, 172, 130, 14);
        this.getContentPane().add(this.labelBottom_);
        JButton setBottomButton = new JButton();
        setBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.labelBottom_.setText(TileCreatorDlg.this.thisPosition(TileCreatorDlg.this.markPosition(2)));
            }
        });
        setBottomButton.setFont(new Font("", 0, 10));
        setBottomButton.setText("Set");
        setBottomButton.setBounds(129, 126, 93, 23);
        this.getContentPane().add(setBottomButton);
        JButton goToRightButton = new JButton();
        goToRightButton.setFont(new Font("", 0, 10));
        goToRightButton.setText("Go To");
        goToRightButton.setBounds(234, 89, 93, 23);
        this.getContentPane().add(goToRightButton);
        goToRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TileCreatorDlg.this.endPositionSet_[1]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[1]);
                }
            }
        });
        JButton goToBottomButton = new JButton();
        goToBottomButton.setFont(new Font("", 0, 10));
        goToBottomButton.setText("Go To");
        goToBottomButton.setBounds(129, 149, 93, 23);
        this.getContentPane().add(goToBottomButton);
        goToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TileCreatorDlg.this.endPositionSet_[2]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[2]);
                }
            }
        });
        JButton gridCenteredHereButton = new JButton();
        gridCenteredHereButton.setFont(new Font("", 0, 10));
        gridCenteredHereButton.setText("Center Here");
        gridCenteredHereButton.setBounds(129, 66, 93, 23);
        gridCenteredHereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    TileCreatorDlg.this.centerGridHere();
                }
                catch (TileCreatorException tileCreatorException) {
                    // empty catch block
                }
            }
        });
        this.getContentPane().add(gridCenteredHereButton);
        JButton centeredPlusButton = new JButton();
        centeredPlusButton.setFont(new Font("", 0, 10));
        centeredPlusButton.setText("+");
        centeredPlusButton.setBounds(184, 89, 38, 19);
        centeredPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ++TileCreatorDlg.this.centeredFrames_;
                TileCreatorDlg.this.labelWidth_.setText(String.format("%dx%d", TileCreatorDlg.this.centeredFrames_, TileCreatorDlg.this.centeredFrames_));
                TileCreatorDlg.this.updateCenteredSizeLabel();
            }
        });
        this.getContentPane().add(centeredPlusButton);
        this.labelWidth_.setFont(new Font("", 0, 10));
        this.labelWidth_.setHorizontalAlignment(0);
        this.labelWidth_.setText("");
        this.labelWidth_.setBounds(157, 89, 37, 19);
        this.getContentPane().add(this.labelWidth_);
        JButton centeredMinusButton = new JButton();
        centeredMinusButton.setFont(new Font("", 0, 10));
        centeredMinusButton.setText("-");
        centeredMinusButton.setBounds(129, 89, 38, 19);
        centeredMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                --TileCreatorDlg.this.centeredFrames_;
                if (TileCreatorDlg.this.centeredFrames_ < 1) {
                    TileCreatorDlg.this.centeredFrames_ = 1;
                }
                TileCreatorDlg.this.labelWidth_.setText(String.format("%dx%d", TileCreatorDlg.this.centeredFrames_, TileCreatorDlg.this.centeredFrames_));
                TileCreatorDlg.this.updateCenteredSizeLabel();
            }
        });
        this.getContentPane().add(centeredMinusButton);
        this.labelWidthUmPx_.setFont(new Font("", 0, 8));
        this.labelWidthUmPx_.setHorizontalAlignment(0);
        this.labelWidthUmPx_.setText("");
        this.labelWidthUmPx_.setBounds(129, 108, 93, 14);
        this.getContentPane().add(this.labelWidthUmPx_);
        JLabel overlapLabel = new JLabel();
        overlapLabel.setFont(new Font("", 0, 10));
        overlapLabel.setText("Overlap");
        overlapLabel.setBounds(20, 189, 80, 14);
        this.getContentPane().add(overlapLabel);
        this.overlapField_ = new JTextField();
        this.overlapField_.setBounds(70, 186, 50, 20);
        this.overlapField_.setFont(new Font("", 0, 10));
        this.overlapField_.setText("0");
        this.overlapField_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.updateCenteredSizeLabel();
            }
        });
        this.getContentPane().add(this.overlapField_);
        String[] unitStrings = new String[]{"um", "px", "%"};
        this.overlapUnitsCombo_ = new JComboBox<String>(unitStrings);
        this.overlapUnitsCombo_.setSelectedIndex(0);
        this.overlapUnitsCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox cb = (JComboBox)arg0.getSource();
                TileCreatorDlg.this.overlapUnit_ = OverlapUnitEnum.values()[cb.getSelectedIndex()];
                TileCreatorDlg.this.updateCenteredSizeLabel();
            }
        });
        this.overlapUnitsCombo_.setBounds(125, 186, 75, 20);
        this.getContentPane().add(this.overlapUnitsCombo_);
        JLabel pixelSizeLabel = new JLabel();
        pixelSizeLabel.setFont(new Font("", 0, 10));
        pixelSizeLabel.setText("Pixel Size [um]");
        pixelSizeLabel.setBounds(205, 189, 80, 14);
        this.getContentPane().add(pixelSizeLabel);
        this.pixelSizeField_ = new JTextField();
        this.pixelSizeField_.setFont(new Font("", 0, 10));
        this.pixelSizeField_.setBounds(280, 186, 50, 20);
        this.pixelSizeField_.setText(NumberUtils.doubleToDisplayString(this.core_.getPixelSizeUm()));
        this.pixelSizeField_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.updateCenteredSizeLabel();
            }
        });
        this.getContentPane().add(this.pixelSizeField_);
        JButton okButton = new JButton();
        okButton.setFont(new Font("", 0, 10));
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.addToPositionList();
            }
        });
        okButton.setBounds(20, 216, 93, 23);
        this.getContentPane().add(okButton);
        JButton cancelButton = new JButton();
        cancelButton.setBounds(129, 216, 93, 23);
        cancelButton.setFont(new Font("", 0, 10));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.positionListDlg_.activateAxisTable(true);
                TileCreatorDlg.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        this.getContentPane().add(cancelButton);
        JButton resetButton = new JButton();
        resetButton.setBounds(234, 216, 93, 23);
        resetButton.setFont(new Font("", 0, 10));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TileCreatorDlg.this.reset();
            }
        });
        resetButton.setText("Reset");
        this.getContentPane().add(resetButton);
    }

    private MultiStagePosition markPosition(int location) {
        MultiStagePosition msp = new MultiStagePosition();
        try {
            String xyStage;
            String zStage = this.positionListDlg_.get1DAxis();
            if (zStage != null) {
                msp.setDefaultZStage(zStage);
                StagePosition sp = new StagePosition();
                sp.stageName = zStage;
                sp.numAxes = 1;
                sp.x = this.core_.getPosition(zStage);
                msp.add(sp);
            }
            if ((xyStage = this.positionListDlg_.get2DAxis()) != null) {
                msp.setDefaultXYStage(xyStage);
                StagePosition sp = new StagePosition();
                sp.stageName = xyStage;
                sp.numAxes = 2;
                sp.x = this.core_.getXPosition(xyStage);
                sp.y = this.core_.getYPosition(xyStage);
                msp.add(sp);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.endPosition_[location] = msp;
        this.endPositionSet_[location] = true;
        return msp;
    }

    private String thisPosition(MultiStagePosition msp) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < msp.size(); ++i) {
            StagePosition sp = msp.get(i);
            sb.append(sp.getVerbose()).append("\n");
        }
        return sb.toString();
    }

    private void updateCenteredSizeLabel() {
        try {
            double[] centeredSize = this.getCenteredSize();
            if (centeredSize[0] == 0.0) {
                this.labelWidthUmPx_.setText("");
            } else {
                this.labelWidthUmPx_.setText(Integer.toString((int)centeredSize[0]) + "x" + Integer.toString((int)centeredSize[1]) + "um");
            }
        }
        catch (TileCreatorException tileCreatorException) {
            // empty catch block
        }
    }

    private double[] getCenteredSize() throws TileCreatorException {
        double imageSizeXUm = this.getImageSize()[0];
        double imageSizeYUm = this.getImageSize()[1];
        double tileSizeXUm = this.getTileSize()[0];
        double tileSizeYUm = this.getTileSize()[1];
        double overlapXUm = imageSizeXUm - tileSizeXUm;
        double overlapYUm = imageSizeYUm - tileSizeYUm;
        double totalXUm = tileSizeXUm * (double)this.centeredFrames_ + overlapXUm;
        double totalYUm = tileSizeYUm * (double)this.centeredFrames_ + overlapYUm;
        return new double[]{totalXUm, totalYUm};
    }

    private void centerGridHere() throws TileCreatorException {
        double imageSizeXUm = this.getImageSize()[0];
        double imageSizeYUm = this.getImageSize()[1];
        double tileSizeXUm = this.getTileSize()[0];
        double tileSizeYUm = this.getTileSize()[1];
        double overlapXUm = imageSizeXUm - tileSizeXUm;
        double overlapYUm = imageSizeYUm - tileSizeYUm;
        double[] centeredSize = this.getCenteredSize();
        if (centeredSize[0] == 0.0) {
            return;
        }
        double offsetXUm = centeredSize[0] / 2.0 - imageSizeXUm / 2.0 - 1.0;
        double offsetYUm = centeredSize[1] / 2.0 - imageSizeYUm / 2.0 - 1.0;
        block14: for (int location = 0; location < 4; ++location) {
            MultiStagePosition msp = new MultiStagePosition();
            StringBuilder sb = new StringBuilder();
            try {
                String xyStage;
                String zStage = this.positionListDlg_.get1DAxis();
                if (zStage != null) {
                    msp.setDefaultZStage(zStage);
                    StagePosition sp = new StagePosition();
                    sp.stageName = zStage;
                    sp.numAxes = 1;
                    sp.x = this.core_.getPosition(zStage);
                    msp.add(sp);
                    sb.append(sp.getVerbose()).append("\n");
                }
                if ((xyStage = this.positionListDlg_.get2DAxis()) != null) {
                    msp.setDefaultXYStage(xyStage);
                    StagePosition sp = new StagePosition();
                    sp.stageName = xyStage;
                    sp.numAxes = 2;
                    sp.x = this.core_.getXPosition(xyStage);
                    sp.y = this.core_.getYPosition(xyStage);
                    switch (location) {
                        case 0: {
                            sp.y += offsetYUm;
                            break;
                        }
                        case 1: {
                            sp.x += offsetXUm;
                            break;
                        }
                        case 2: {
                            sp.y -= offsetYUm;
                            break;
                        }
                        case 3: {
                            sp.x -= offsetXUm;
                        }
                    }
                    msp.add(sp);
                    sb.append(sp.getVerbose()).append("\n");
                }
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
            this.endPosition_[location] = msp;
            this.endPositionSet_[location] = true;
            switch (location) {
                case 0: {
                    this.labelTop_.setText(sb.toString());
                    continue block14;
                }
                case 1: {
                    this.labelRight_.setText(sb.toString());
                    continue block14;
                }
                case 2: {
                    this.labelBottom_.setText(sb.toString());
                    continue block14;
                }
                case 3: {
                    this.labelLeft_.setText(sb.toString());
                }
            }
        }
    }

    private boolean isSwappedXY() {
        boolean transposeXY;
        boolean correction;
        String camera = this.core_.getCameraDevice();
        if (camera == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return false;
        }
        try {
            String tmp = this.core_.getProperty(camera, "TransposeCorrection");
            correction = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            if (tmp.equals("0")) {
                boolean mirrorX = false;
            } else {
                boolean mirrorX = true;
            }
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            if (tmp.equals("0")) {
                boolean mirrorY = false;
            } else {
                boolean mirrorY = true;
            }
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            transposeXY = !tmp.equals("0");
        }
        catch (Exception exc) {
            ReportingUtils.showError(exc);
            return false;
        }
        return !correction && transposeXY;
    }

    private double getPixelSizeUm() throws TileCreatorException {
        double pixSizeUm = 0.0;
        try {
            pixSizeUm = NumberUtils.displayStringToDouble(this.pixelSizeField_.getText());
        }
        catch (ParseException e) {
            ReportingUtils.logError(e);
        }
        if (pixSizeUm <= 0.0) {
            JOptionPane.showMessageDialog(this, "Pixel Size should be a value > 0 (usually 0.1 -1 um).  It should be experimentally determined. ");
            throw new TileCreatorException("Zero pixel size");
        }
        return pixSizeUm;
    }

    private double[] getTileSize() throws TileCreatorException {
        double overlapUmX;
        double overlapUmY;
        double pixSizeUm = this.getPixelSizeUm();
        double overlap = 0.0;
        try {
            overlap = NumberUtils.displayStringToDouble(this.overlapField_.getText());
        }
        catch (ParseException e) {
            ReportingUtils.logError(e, "Number Parse error in Tile Creator Dialog");
        }
        if (this.overlapUnit_ == OverlapUnitEnum.UM) {
            overlapUmX = overlapUmY = overlap;
        } else if (this.overlapUnit_ == OverlapUnitEnum.PERCENT) {
            overlapUmX = pixSizeUm * (overlap / 100.0) * (double)this.core_.getImageWidth();
            overlapUmY = pixSizeUm * (overlap / 100.0) * (double)this.core_.getImageHeight();
        } else {
            overlapUmX = overlap * pixSizeUm;
            overlapUmY = overlap * pixSizeUm;
        }
        boolean swapXY = this.isSwappedXY();
        double tileSizeXUm = swapXY ? pixSizeUm * (double)this.core_.getImageHeight() - overlapUmY : pixSizeUm * (double)this.core_.getImageWidth() - overlapUmX;
        double tileSizeYUm = swapXY ? pixSizeUm * (double)this.core_.getImageWidth() - overlapUmX : pixSizeUm * (double)this.core_.getImageHeight() - overlapUmY;
        return new double[]{tileSizeXUm, tileSizeYUm};
    }

    private double[] getImageSize() throws TileCreatorException {
        double pixSizeUm = this.getPixelSizeUm();
        boolean swapXY = this.isSwappedXY();
        double imageSizeXUm = swapXY ? pixSizeUm * (double)this.core_.getImageHeight() : pixSizeUm * (double)this.core_.getImageWidth();
        double imageSizeYUm = swapXY ? pixSizeUm * (double)this.core_.getImageWidth() : pixSizeUm * (double)this.core_.getImageHeight();
        return new double[]{imageSizeXUm, imageSizeYUm};
    }

    private void addToPositionList() {
        if (this.positionListDlg_.get2DAxis() == null) {
            return;
        }
        try {
            int nrSet = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.endPositionSet_[i]) continue;
                ++nrSet;
            }
            if (nrSet < 2) {
                JOptionPane.showMessageDialog(this, "At least two corners should be set");
                return;
            }
            boolean hasZPlane = nrSet >= 3 && this.positionListDlg_.get1DAxis() != null;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double meanZ = 0.0;
            for (int i = 0; i < 4; ++i) {
                if (!this.endPositionSet_[i]) continue;
                StagePosition sp = this.endPosition_[i].get(this.endPosition_[i].getDefaultXYStage());
                if (sp.x < minX) {
                    minX = sp.x;
                }
                if (sp.x > maxX) {
                    maxX = sp.x;
                }
                if (sp.y < minY) {
                    minY = sp.y;
                }
                if (sp.y > maxY) {
                    maxY = sp.y;
                }
                if (!hasZPlane) continue;
                sp = this.endPosition_[i].get(this.endPosition_[i].getDefaultZStage());
                meanZ += sp.x;
            }
            meanZ /= (double)nrSet;
            double zPlaneA = 0.0;
            double zPlaneB = 0.0;
            double zPlaneC = 0.0;
            if (hasZPlane) {
                double x1 = 0.0;
                double y1 = 0.0;
                double z1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                double z2 = 0.0;
                double x3 = 0.0;
                double y3 = 0.0;
                double z3 = 0.0;
                boolean sp1Set = false;
                boolean sp2Set = false;
                boolean sp3Set = false;
                for (int i = 0; i < 4; ++i) {
                    if (this.endPositionSet_[i] && !sp1Set) {
                        x1 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).x;
                        y1 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).y;
                        z1 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultZStage()).x;
                        sp1Set = true;
                        continue;
                    }
                    if (this.endPositionSet_[i] && !sp2Set) {
                        x2 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).x;
                        y2 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).y;
                        z2 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultZStage()).x;
                        sp2Set = true;
                        continue;
                    }
                    if (!this.endPositionSet_[i] || sp3Set) continue;
                    x3 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).x;
                    y3 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultXYStage()).y;
                    z3 = this.endPosition_[i].get((String)this.endPosition_[i].getDefaultZStage()).x;
                    sp3Set = true;
                }
                double x12 = x2 - x1;
                double y12 = y2 - y1;
                double z12 = z2 - z1;
                double x13 = x3 - x1;
                double y13 = y3 - y1;
                double z13 = z3 - z1;
                double dot_prod = x12 * x13 + y12 * y13 + z12 * z13;
                double magnitude12 = x12 * x12 + y12 * y12 + z12 * z12;
                magnitude12 = Math.sqrt(magnitude12);
                double magnitude13 = x13 * x13 + y13 * y13 + z13 * z13;
                double cosTheta = dot_prod / (magnitude12 * (magnitude13 = Math.sqrt(magnitude13)));
                double theta = Math.acos(cosTheta);
                if (theta < 0.5 || theta > 5.783185307179586 || theta > 2.641592653589793 && theta < 3.641592653589793) {
                    hasZPlane = false;
                }
                if (Double.isNaN(theta)) {
                    hasZPlane = false;
                }
                double a = y12 * z13 - y13 * z12;
                double b = z12 * x13 - z13 * x12;
                double c = x12 * y13 - x13 * y12;
                double d = -1.0 * (a * x1 + b * y1 + c * z1);
                zPlaneA = a / (-1.0 * c);
                zPlaneB = b / (-1.0 * c);
                zPlaneC = d / (-1.0 * c);
            }
            double pixSizeUm = this.getPixelSizeUm();
            double imageSizeXUm = this.getImageSize()[0];
            double imageSizeYUm = this.getImageSize()[1];
            double tileSizeXUm = this.getTileSize()[0];
            double tileSizeYUm = this.getTileSize()[1];
            double overlapXUm = imageSizeXUm - tileSizeXUm;
            double overlapYUm = imageSizeYUm - tileSizeYUm;
            double boundingXUm = maxX - minX + imageSizeXUm;
            double boundingYUm = maxY - minY + imageSizeYUm;
            int nrImagesX = (int)Math.ceil((boundingXUm - overlapXUm) / tileSizeXUm);
            int nrImagesY = (int)Math.ceil((boundingYUm - overlapYUm) / tileSizeYUm);
            double totalSizeXUm = (double)nrImagesX * tileSizeXUm + overlapXUm;
            double totalSizeYUm = (double)nrImagesY * tileSizeYUm + overlapYUm;
            double offsetXUm = (totalSizeXUm - boundingXUm) / 2.0;
            double offsetYUm = (totalSizeYUm - boundingYUm) / 2.0;
            ++prefix_;
            for (int y = 0; y < nrImagesY; ++y) {
                for (int x = 0; x < nrImagesX; ++x) {
                    int tmpX = x;
                    if ((y & 1) == 1) {
                        tmpX = nrImagesX - x - 1;
                    }
                    MultiStagePosition msp = new MultiStagePosition();
                    String xyStage = this.positionListDlg_.get2DAxis();
                    msp.setDefaultXYStage(xyStage);
                    StagePosition spXY = new StagePosition();
                    spXY.stageName = xyStage;
                    spXY.numAxes = 2;
                    spXY.x = minX - offsetXUm + (double)tmpX * tileSizeXUm;
                    spXY.y = minY - offsetYUm + (double)y * tileSizeYUm;
                    msp.add(spXY);
                    String zStage = this.positionListDlg_.get1DAxis();
                    if (zStage != null) {
                        double z;
                        msp.setDefaultZStage(zStage);
                        StagePosition spZ = new StagePosition();
                        spZ.stageName = zStage;
                        spZ.numAxes = 1;
                        spZ.x = hasZPlane ? (z = zPlaneA * spXY.x + zPlaneB * spXY.y + zPlaneC) : meanZ;
                        msp.add(spZ);
                    }
                    msp.setGridCoordinates(y, tmpX);
                    if (this.overlapUnit_ == OverlapUnitEnum.UM || this.overlapUnit_ == OverlapUnitEnum.PX) {
                        msp.setProperty("OverlapUm", NumberUtils.doubleToCoreString(overlapXUm));
                        int overlapPix = (int)Math.floor(overlapXUm / pixSizeUm);
                        msp.setProperty("OverlapPixels", NumberUtils.intToCoreString(overlapPix));
                    } else {
                        msp.setProperty("OverlapUmX", NumberUtils.doubleToCoreString(overlapXUm));
                        msp.setProperty("OverlapUmY", NumberUtils.doubleToCoreString(overlapYUm));
                        int overlapPixX = (int)Math.floor(overlapXUm / pixSizeUm);
                        int overlapPixY = (int)Math.floor(overlapYUm / pixSizeUm);
                        msp.setProperty("OverlapPixelsX", NumberUtils.intToCoreString(overlapPixX));
                        msp.setProperty("OverlapPixelsY", NumberUtils.intToCoreString(overlapPixY));
                    }
                    this.positionListDlg_.addPosition(msp, TileCreatorDlg.generatePosLabel(prefix_ + "-Pos", tmpX, y));
                }
            }
            this.positionListDlg_.activateAxisTable(true);
            this.dispose();
        }
        catch (TileCreatorException tileCreatorException) {
            // empty catch block
        }
    }

    private void reset() {
        for (int i = 0; i < 4; ++i) {
            this.endPositionSet_[i] = false;
        }
        this.labelTop_.setText("");
        this.labelRight_.setText("");
        this.labelBottom_.setText("");
        this.labelLeft_.setText("");
        this.labelWidth_.setText("");
        this.labelWidthUmPx_.setText("");
        double pxsz = this.core_.getPixelSizeUm();
        this.pixelSizeField_.setText(NumberUtils.doubleToDisplayString(pxsz));
        this.centeredFrames_ = 0;
    }

    private void goToPosition(MultiStagePosition position) {
        try {
            MultiStagePosition.goToPosition(position, this.core_);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
    }

    public static String generatePosLabel(String prefix, int x, int y) {
        String name = prefix + "_" + FMT_POS.format(x) + "_" + FMT_POS.format(y);
        return name;
    }

    @Override
    public void propertiesChangedAlert() {
    }

    @Override
    public void propertyChangedAlert(String device, String property, String value) {
    }

    @Override
    public void configGroupChangedAlert(String groupName, String newConfig) {
    }

    @Override
    public void systemConfigurationLoaded() {
    }

    @Override
    public void pixelSizeChangedAlert(double newPixelSizeUm) {
        this.pixelSizeField_.setText(NumberUtils.doubleToDisplayString(newPixelSizeUm));
        this.updateCenteredSizeLabel();
    }

    @Override
    public void stagePositionChangedAlert(String deviceName, double pos) {
    }

    @Override
    public void xyStagePositionChanged(String deviceName, double xPos, double yPos) {
    }

    @Override
    public void exposureChanged(String cameraName, double newExposureTime) {
    }

    @Override
    public void slmExposureChanged(String cameraName, double newExposureTime) {
    }

    private class TileCreatorException
    extends Exception {
        private static final long serialVersionUID = -84723856111238971L;
        private Throwable cause;
        private static final String MSG_PREFIX = "MMScript error: ";

        public TileCreatorException(String message) {
            super(MSG_PREFIX + message);
        }

        public TileCreatorException(Throwable t) {
            super(MSG_PREFIX + t.getMessage());
            this.cause = t;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    private static enum OverlapUnitEnum {
        UM,
        PX,
        PERCENT;

    }
}

