/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import javax.swing.table.AbstractTableModel;
import org.micromanager.api.MultiStagePosition;
import org.micromanager.api.PositionList;
import org.micromanager.api.StagePosition;

class PositionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Label", "Position [um]"};
    private PositionList posList_;
    private MultiStagePosition curMsp_;

    PositionTableModel() {
    }

    public void setData(PositionList pl) {
        this.posList_ = pl;
    }

    public PositionList getPositionList() {
        return this.posList_;
    }

    @Override
    public int getRowCount() {
        return this.posList_.getNumberOfPositions() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MultiStagePosition msp = rowIndex == 0 ? this.curMsp_ : this.posList_.getPosition(rowIndex - 1);
        if (columnIndex == 0) {
            return msp.getLabel();
        }
        if (columnIndex == 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < msp.size(); ++i) {
                StagePosition sp = msp.get(i);
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(sp.getVerbose());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return false;
        }
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MultiStagePosition msp;
        if (columnIndex == 0 && (msp = this.posList_.getPosition(rowIndex - 1)) != null) {
            msp.setLabel(((String)value).replaceAll("[^0-9a-zA-Z_]", "-"));
        }
    }

    public void setCurrentMSP(MultiStagePosition msp) {
        this.curMsp_ = msp;
    }
}

