/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import net.miginfocom.swing.MigLayout;
import org.micromanager.MMOptions;
import org.micromanager.MMStudio;
import org.micromanager.api.MultiStagePosition;
import org.micromanager.api.PositionList;
import org.micromanager.api.ScriptInterface;
import org.micromanager.api.StagePosition;
import org.micromanager.api.events.StagePositionChangedEvent;
import org.micromanager.api.events.XYStagePositionChangedEvent;
import org.micromanager.dialogs.AcqControlDlg;
import org.micromanager.events.EventManager;
import org.micromanager.positionlist.AxisData;
import org.micromanager.positionlist.AxisList;
import org.micromanager.positionlist.AxisTableModel;
import org.micromanager.positionlist.CellEditor;
import org.micromanager.positionlist.FirstRowRenderer;
import org.micromanager.positionlist.MergeStageDevicePopupMenu;
import org.micromanager.positionlist.MoversChangedEvent;
import org.micromanager.positionlist.OffsetPositionsDialog;
import org.micromanager.positionlist.PositionTableModel;
import org.micromanager.positionlist.TileCreatorDlg;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

public class PositionListDlg
extends MMDialog
implements MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private String posListDir_;
    private File curFile_;
    private static final String POS = "pos";
    private static final String POS_COL0_WIDTH = "posCol0WIDTH";
    private static final String AXIS_COL0_WIDTH = "axisCol0WIDTH";
    private static final FileDialogs.FileType POSITION_LIST_FILE = new FileDialogs.FileType("POSITION_LIST_FILE", "Position list file", System.getProperty("user.home") + "/PositionList.pos", true, "pos");
    private Font arialSmallFont_;
    private JTable posTable_;
    private final JTable axisTable_;
    private final AxisTableModel axisModel_;
    private CMMCore core_;
    private ScriptInterface studio_;
    private AcqControlDlg acqControlDlg_;
    private MMOptions opts_;
    private Preferences prefs_;
    private GUIColors guiColors_;
    private AxisList axisList_;
    private final JButton tileButton_;
    private MultiStagePosition curMsp_;
    public JButton markButton_;
    private final PositionTableModel positionModel_;
    private EventBus bus_;
    private static int lastRowClicked_;

    @Subscribe
    public void onTileUpdate(MoversChangedEvent event) {
        this.setTileButtonEnabled();
    }

    private void setTileButtonEnabled() {
        int n2DStages = 0;
        for (int i = 0; i < this.axisList_.getNumberOfPositions(); ++i) {
            AxisData ad = this.axisList_.get(i);
            if (!ad.getUse() || ad.getType() != AxisData.AxisType.twoD) continue;
            ++n2DStages;
        }
        if (n2DStages == 1) {
            this.tileButton_.setEnabled(true);
        } else {
            this.tileButton_.setEnabled(false);
        }
    }

    public PositionListDlg(CMMCore core, ScriptInterface gui, PositionList posList, AcqControlDlg acd, MMOptions opts) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                int posCol0Width = PositionListDlg.this.posTable_.getColumnModel().getColumn(0).getWidth();
                PositionListDlg.this.prefs_.putInt(PositionListDlg.POS_COL0_WIDTH, posCol0Width);
                int axisCol0Width = PositionListDlg.this.axisTable_.getColumnModel().getColumn(0).getWidth();
                PositionListDlg.this.prefs_.putInt(PositionListDlg.AXIS_COL0_WIDTH, axisCol0Width);
            }
        });
        this.core_ = core;
        this.studio_ = gui;
        this.bus_ = new EventBus();
        this.bus_.register((Object)this);
        this.opts_ = opts;
        this.acqControlDlg_ = acd;
        this.guiColors_ = new GUIColors();
        this.prefs_ = this.getPrefsNode();
        this.setTitle("Stage Position List");
        this.setLayout((LayoutManager)new MigLayout("flowy, filly, insets 8", "[grow][]", "[top]"));
        this.setMinimumSize(new Dimension(275, 365));
        this.loadAndRestorePosition(100, 100, 362, 595);
        this.arialSmallFont_ = new Font("Arial", 0, 10);
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "split, spany, growy, growx, bottom 1:push");
        JScrollPane axisPane = new JScrollPane();
        axisPane.setVerticalScrollBarPolicy(21);
        this.add((Component)axisPane, "growx, wrap");
        final FirstRowRenderer firstRowRenderer = new FirstRowRenderer(this.arialSmallFont_);
        this.posTable_ = new JTable(){
            private static final long serialVersionUID = -3873504142761785021L;

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (row == 0) {
                    return firstRowRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.posTable_.setFont(this.arialSmallFont_);
        this.positionModel_ = new PositionTableModel();
        this.positionModel_.setData(posList);
        this.posTable_.setModel(this.positionModel_);
        scrollPane.setViewportView(this.posTable_);
        CellEditor cellEditor_ = new CellEditor(this.arialSmallFont_);
        cellEditor_.addListener();
        this.posTable_.setDefaultEditor(Object.class, cellEditor_);
        this.posTable_.setSelectionMode(2);
        int posCol0Width = this.prefs_.getInt(POS_COL0_WIDTH, 75);
        this.posTable_.getColumnModel().getColumn(0).setWidth(posCol0Width);
        this.posTable_.getColumnModel().getColumn(0).setPreferredWidth(posCol0Width);
        this.posTable_.setAutoResizeMode(3);
        this.axisTable_ = new JTable();
        this.axisTable_.setFont(this.arialSmallFont_);
        this.axisList_ = new AxisList(this.core_, this.prefs_);
        this.axisModel_ = new AxisTableModel(this.axisList_, this.axisTable_, this.bus_, this.prefs_);
        this.axisTable_.setModel(this.axisModel_);
        axisPane.setViewportView(this.axisTable_);
        int tableHeight = this.axisList_.getNumberOfPositions() * this.axisTable_.getRowHeight();
        axisPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 30 + tableHeight));
        axisPane.setMinimumSize(new Dimension(50, 30 + tableHeight));
        int axisCol0Width = this.prefs_.getInt(AXIS_COL0_WIDTH, 75);
        this.axisTable_.getColumnModel().getColumn(0).setWidth(axisCol0Width);
        this.axisTable_.getColumnModel().getColumn(0).setPreferredWidth(axisCol0Width);
        this.axisTable_.setAutoResizeMode(3);
        Dimension buttonSize = new Dimension(88, 21);
        this.markButton_ = this.posListButton(buttonSize, this.arialSmallFont_);
        this.markButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.markPosition();
                PositionListDlg.this.posTable_.clearSelection();
                PositionListDlg.this.updateMarkButtonText();
            }
        });
        this.markButton_.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/flag_green.png")));
        this.markButton_.setText("Mark");
        this.markButton_.setToolTipText("Adds point with coordinates of current stage position");
        this.add((Component)this.markButton_, "split, spany, align left");
        this.posTable_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PositionListDlg.this.updateMarkButtonText();
            }

            @Override
            public void focusGained(FocusEvent evt) {
                PositionListDlg.this.updateMarkButtonText();
            }
        });
        Dimension arrowSize = new Dimension(40, buttonSize.height);
        JPanel arrowPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fillx"));
        JButton upButton = this.posListButton(arrowSize, this.arialSmallFont_);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.incrementOrderOfSelectedPosition(-1);
            }
        });
        upButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/arrow_up.png")));
        upButton.setText("");
        upButton.setToolTipText("Move currently selected position up list (positions higher on list are acquired earlier)");
        arrowPanel.add((Component)upButton, "dock west");
        JButton downButton = this.posListButton(arrowSize, this.arialSmallFont_);
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.incrementOrderOfSelectedPosition(1);
            }
        });
        downButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/arrow_down.png")));
        downButton.setText("");
        downButton.setToolTipText("Move currently selected position down list (lower positions on list are acquired later)");
        arrowPanel.add((Component)downButton, "dock east");
        this.add((Component)arrowPanel, "growx");
        JButton mergeButton = this.posListButton(buttonSize, this.arialSmallFont_);
        mergeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                PositionListDlg.this.mergePositions(event);
            }
        });
        mergeButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/asterisk_orange.png")));
        mergeButton.setText("Merge");
        mergeButton.setToolTipText("Select an axis, and set the selected positions' value along that axis to the current stage position.");
        this.add(mergeButton);
        JButton gotoButton = this.posListButton(buttonSize, this.arialSmallFont_);
        gotoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.goToCurrentPosition();
            }
        });
        gotoButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/resultset_next.png")));
        gotoButton.setText("Go to");
        gotoButton.setToolTipText("Moves stage to currently selected position");
        this.add(gotoButton);
        JButton refreshButton = this.posListButton(buttonSize, this.arialSmallFont_);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.refreshCurrentPosition();
            }
        });
        refreshButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/arrow_refresh.png")));
        refreshButton.setText("Refresh");
        this.add(refreshButton);
        JButton removeButton = this.posListButton(buttonSize, this.arialSmallFont_);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.removeSelectedPositions();
            }
        });
        removeButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/cross.png")));
        removeButton.setText("Remove");
        removeButton.setToolTipText("Removes currently selected position from list");
        this.add(removeButton);
        JButton setOriginButton = this.posListButton(buttonSize, this.arialSmallFont_);
        setOriginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.calibrate();
            }
        });
        setOriginButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        setOriginButton.setText("Set Origin");
        setOriginButton.setToolTipText("Drives X and Y stages back to their original positions and zeros their position values");
        this.add(setOriginButton);
        JButton offsetButton = this.posListButton(buttonSize, this.arialSmallFont_);
        offsetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.offsetPositions();
            }
        });
        offsetButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        offsetButton.setText("Add Offset");
        offsetButton.setToolTipText("Add an offset to the selected positions.");
        this.add(offsetButton);
        JButton removeAllButton = this.posListButton(buttonSize, this.arialSmallFont_);
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int ret = JOptionPane.showConfirmDialog(null, "Are you sure you want to erase\nall positions from the position list?", "Clear all positions?", 0);
                if (ret == 0) {
                    PositionListDlg.this.clearAllPositions();
                }
            }
        });
        removeAllButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/delete.png")));
        removeAllButton.setText("Clear All");
        removeAllButton.setToolTipText("Removes all positions from list");
        this.add(removeAllButton);
        JButton loadButton = this.posListButton(buttonSize, this.arialSmallFont_);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.loadPositionList();
            }
        });
        loadButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        loadButton.setText("Load...");
        loadButton.setToolTipText("Load position list");
        this.add((Component)loadButton, "gaptop 4:push");
        JButton saveAsButton = this.posListButton(buttonSize, this.arialSmallFont_);
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.savePositionListAs();
            }
        });
        saveAsButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        saveAsButton.setText("Save As...");
        saveAsButton.setToolTipText("Save position list as");
        this.add(saveAsButton);
        this.tileButton_ = this.posListButton(buttonSize, this.arialSmallFont_);
        this.tileButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.showCreateTileDlg();
            }
        });
        this.tileButton_.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        this.tileButton_.setText("Create Grid");
        this.tileButton_.setToolTipText("Open new window to create grid of equally spaced positions");
        this.add(this.tileButton_);
        this.setTileButtonEnabled();
        JButton closeButton = this.posListButton(buttonSize, this.arialSmallFont_);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PositionListDlg.this.dispose();
            }
        });
        closeButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/empty.png")));
        closeButton.setText("Close");
        this.add((Component)closeButton, "wrap");
        EventManager.register(this);
        this.refreshCurrentPosition();
    }

    private JButton posListButton(Dimension buttonSize, Font font) {
        JButton button = new JButton();
        button.setPreferredSize(buttonSize);
        button.setMinimumSize(buttonSize);
        button.setFont(font);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public void addListeners() {
        this.axisTable_.addMouseListener(this);
        this.posTable_.addMouseListener(this);
        this.getPositionList().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            GUIUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PositionListDlg.this.posTable_.revalidate();
                    PositionListDlg.this.axisTable_.revalidate();
                }
            });
        }
        catch (InterruptedException ex) {
            ReportingUtils.logError(ex);
        }
        catch (InvocationTargetException ex) {
            ReportingUtils.logError(ex);
        }
    }

    protected void updateMarkButtonText() {
        PositionTableModel tm = (PositionTableModel)this.posTable_.getModel();
        MultiStagePosition msp = tm.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        if (this.markButton_ != null) {
            if (msp == null) {
                this.markButton_.setText("Mark");
            } else {
                this.markButton_.setText("Replace");
            }
        }
    }

    public void addPosition(MultiStagePosition msp, String label) {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        msp.setLabel(label);
        ptm.getPositionList().addPosition(msp);
        ptm.fireTableDataChanged();
    }

    public void addPosition(MultiStagePosition msp) {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        msp.setLabel(ptm.getPositionList().generateLabel());
        ptm.getPositionList().addPosition(msp);
        ptm.fireTableDataChanged();
    }

    protected boolean savePositionListAs() {
        File f = FileDialogs.save(this, "Save the position list", POSITION_LIST_FILE);
        if (f != null) {
            this.curFile_ = f;
            String fileName = this.curFile_.getAbsolutePath();
            int i = fileName.lastIndexOf(46);
            int j = fileName.lastIndexOf(File.separatorChar);
            if (i <= 0 || i < j) {
                i = fileName.length();
            }
            fileName = fileName.substring(0, i);
            fileName = fileName + ".pos";
            try {
                this.getPositionList().save(fileName);
                this.posListDir_ = this.curFile_.getParent();
            }
            catch (MMException e) {
                ReportingUtils.showError(e);
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPositionList() {
        File f = FileDialogs.openFile(this, "Load a position list", POSITION_LIST_FILE);
        if (f != null) {
            this.curFile_ = f;
            try {
                this.getPositionList().load(this.curFile_.getAbsolutePath());
                this.posListDir_ = this.curFile_.getParent();
            }
            catch (MMException e) {
                ReportingUtils.showError(e);
            }
            finally {
                this.updatePositionData();
            }
        }
    }

    public void updatePositionData() {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        ptm.fireTableDataChanged();
    }

    public void rebuildAxisList() {
        this.axisList_ = new AxisList(this.core_, this.prefs_);
        AxisTableModel axm = (AxisTableModel)this.axisTable_.getModel();
        axm.fireTableDataChanged();
    }

    public void activateAxisTable(boolean state) {
        this.axisModel_.setEditable(state);
        this.axisTable_.setEnabled(state);
    }

    public void setPositionList(PositionList pl) {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        ptm.setData(pl);
        ptm.fireTableDataChanged();
    }

    protected void goToCurrentPosition() {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        MultiStagePosition msp = ptm.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        if (msp == null) {
            return;
        }
        try {
            MultiStagePosition.goToPosition(msp, this.core_);
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.refreshCurrentPosition();
    }

    protected void clearAllPositions() {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        ptm.getPositionList().clearAllPositions();
        ptm.fireTableDataChanged();
        this.acqControlDlg_.updateGUIContents();
    }

    protected void incrementOrderOfSelectedPosition(int direction) {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        int currentRow = this.posTable_.getSelectedRow() - 1;
        int newEdittingRow = -1;
        if (0 <= currentRow) {
            int destinationRow = currentRow + direction;
            if (0 <= destinationRow) {
                if (destinationRow < this.posTable_.getRowCount()) {
                    PositionList pl = ptm.getPositionList();
                    MultiStagePosition[] mspos = pl.getPositions();
                    MultiStagePosition tmp = mspos[currentRow];
                    pl.replacePosition(currentRow, mspos[destinationRow]);
                    pl.replacePosition(destinationRow, tmp);
                    ptm.setData(pl);
                    if (destinationRow + 1 < ptm.getRowCount()) {
                        newEdittingRow = destinationRow + 1;
                    }
                } else {
                    newEdittingRow = this.posTable_.getRowCount() - 1;
                }
            } else {
                newEdittingRow = 1;
            }
        }
        ptm.fireTableDataChanged();
        if (-1 < newEdittingRow) {
            this.posTable_.changeSelection(newEdittingRow, newEdittingRow, false, false);
            this.posTable_.requestFocusInWindow();
        }
        this.updateMarkButtonText();
    }

    protected void removeSelectedPositions() {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        int[] selectedRows = this.posTable_.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            ptm.getPositionList().removePosition(selectedRows[i] - 1);
        }
        ptm.fireTableDataChanged();
        this.acqControlDlg_.updateGUIContents();
    }

    public void markPosition() {
        this.refreshCurrentPosition();
        MultiStagePosition msp = this.curMsp_;
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        MultiStagePosition selMsp = ptm.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        if (selMsp == null) {
            msp.setLabel(ptm.getPositionList().generateLabel());
            ptm.getPositionList().addPosition(msp);
            ptm.fireTableDataChanged();
            this.acqControlDlg_.updateGUIContents();
        } else {
            msp.setLabel(ptm.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1).getLabel());
            int selectedRow = this.posTable_.getSelectedRow();
            ptm.getPositionList().replacePosition(this.posTable_.getSelectedRow() - 1, msp);
            ptm.fireTableCellUpdated(selectedRow, 1);
            this.posTable_.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    public void mergePositions(MouseEvent event) {
        MergeStageDevicePopupMenu menu = new MergeStageDevicePopupMenu(this, this.core_);
        menu.show(event.getComponent(), event.getX(), event.getY());
    }

    public void mergePositionsWithDevice(String deviceName) {
        int[] selectedRows = this.posTable_.getSelectedRows();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int posIndex = 0; posIndex < this.curMsp_.size(); ++posIndex) {
            StagePosition subPos = this.curMsp_.get(posIndex);
            if (!subPos.stageName.equals(deviceName)) continue;
            x = subPos.x;
            y = subPos.y;
            z = subPos.z;
        }
        for (int row : selectedRows) {
            MultiStagePosition listPos = this.positionModel_.getPositionList().getPosition(row - 1);
            for (int posIndex = 0; posIndex < listPos.size(); ++posIndex) {
                StagePosition subPos = listPos.get(posIndex);
                if (!subPos.stageName.equals(deviceName)) continue;
                subPos.x = x;
                subPos.y = y;
                subPos.z = z;
            }
        }
        this.positionModel_.fireTableDataChanged();
        this.acqControlDlg_.updateGUIContents();
    }

    @Subscribe
    public void onStagePositionChanged(StagePositionChangedEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PositionListDlg.this.refreshCurrentPosition();
            }
        });
    }

    @Subscribe
    public void onXYStagePositionChanged(XYStagePositionChangedEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PositionListDlg.this.refreshCurrentPosition();
            }
        });
    }

    private void refreshCurrentPosition() {
        StringBuilder sb = new StringBuilder();
        MultiStagePosition msp = new MultiStagePosition();
        msp.setDefaultXYStage(this.core_.getXYStageDevice());
        msp.setDefaultZStage(this.core_.getFocusDevice());
        try {
            StrVector stages = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
            int i = 0;
            while ((long)i < stages.size()) {
                if (this.axisList_.use(stages.get(i))) {
                    StagePosition sp = new StagePosition();
                    sp.stageName = stages.get(i);
                    sp.numAxes = 1;
                    sp.x = this.core_.getPosition(stages.get(i));
                    msp.add(sp);
                    sb.append(sp.getVerbose()).append("\n");
                }
                ++i;
            }
            StrVector stages2D = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int i2 = 0;
            while ((long)i2 < stages2D.size()) {
                if (this.axisList_.use(stages2D.get(i2))) {
                    StagePosition sp = new StagePosition();
                    sp.stageName = stages2D.get(i2);
                    sp.numAxes = 2;
                    sp.x = this.core_.getXPosition(stages2D.get(i2));
                    sp.y = this.core_.getYPosition(stages2D.get(i2));
                    msp.add(sp);
                    sb.append(sp.getVerbose()).append("\n");
                }
                ++i2;
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.curMsp_ = msp;
        this.curMsp_.setLabel("Current");
        this.positionModel_.setCurrentMSP(this.curMsp_);
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        int selectedRow = this.posTable_.getSelectedRow();
        ptm.fireTableCellUpdated(0, 1);
        ptm.fireTableCellUpdated(0, 0);
        if (selectedRow > 0) {
            this.posTable_.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.posTable_.revalidate();
        this.axisTable_.revalidate();
    }

    public boolean useDrive(String drive) {
        return this.axisList_.use(drive);
    }

    private String getAxis(AxisData.AxisType type) {
        for (int i = 0; i < this.axisList_.getNumberOfPositions(); ++i) {
            AxisData axis = this.axisList_.get(i);
            if (!axis.getUse() || axis.getType() != type) continue;
            return axis.getAxisName();
        }
        return null;
    }

    public String get2DAxis() {
        return this.getAxis(AxisData.AxisType.twoD);
    }

    public String get1DAxis() {
        return this.getAxis(AxisData.AxisType.oneD);
    }

    protected void showCreateTileDlg() {
        TileCreatorDlg tileCreatorDlg = new TileCreatorDlg(this.core_, this.opts_, this);
        this.studio_.addMMListener(tileCreatorDlg);
        tileCreatorDlg.setVisible(true);
    }

    private PositionList getPositionList() {
        PositionTableModel ptm = (PositionTableModel)this.posTable_.getModel();
        return ptm.getPositionList();
    }

    private void calibrate() {
        JOptionPane.showMessageDialog(this, "ALERT! Please REMOVE objectives! It may damage lens!", "Calibrate the XY stage", 2);
        Object[] options = new Object[]{"Yes", "No"};
        if (0 != JOptionPane.showOptionDialog(this, "Really calibrate your XY stage?", "Are you sure?", -1, 2, null, options, options[1])) {
            return;
        }
        try {
            StrVector stages2D = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int i = 0;
            while ((long)i < stages2D.size()) {
                String deviceName = stages2D.get(i);
                double[] x1 = new double[1];
                double[] y1 = new double[1];
                this.core_.getXYPosition(deviceName, x1, y1);
                StopCalThread stopThread = new StopCalThread();
                CalThread calThread = new CalThread();
                stopThread.setPara(calThread, this, deviceName, x1, y1);
                calThread.setPara(stopThread, this, deviceName, x1, y1);
                stopThread.start();
                Thread.sleep(100L);
                calThread.start();
                ++i;
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        int rowIndex = this.posTable_.rowAtPoint(p);
        if (rowIndex >= 0) {
            if (rowIndex == this.posTable_.getSelectedRow() && rowIndex == lastRowClicked_) {
                this.posTable_.clearSelection();
                lastRowClicked_ = -1;
            } else {
                lastRowClicked_ = rowIndex;
            }
        }
        this.updateMarkButtonText();
    }

    private void offsetPositions() {
        new OffsetPositionsDialog(this, this.core_);
    }

    public void offsetSelectedSites(String deviceName, ArrayList<Float> offsets) {
        PositionList positions = this.positionModel_.getPositionList();
        for (int rowIndex : this.posTable_.getSelectedRows()) {
            MultiStagePosition multiPos = positions.getPosition(rowIndex - 1);
            for (int posIndex = 0; posIndex < multiPos.size(); ++posIndex) {
                StagePosition subPos = multiPos.get(posIndex);
                if (!subPos.stageName.equals(deviceName)) continue;
                if (subPos.numAxes >= 3) {
                    subPos.z += (double)offsets.get(2).floatValue();
                }
                if (subPos.numAxes >= 2) {
                    subPos.y += (double)offsets.get(1).floatValue();
                }
                subPos.x += (double)offsets.get(0).floatValue();
            }
        }
        this.positionModel_.fireTableDataChanged();
        this.acqControlDlg_.updateGUIContents();
    }

    class BackThread
    extends Thread {
        MMDialog d;

        BackThread() {
        }

        public void setPara(MMDialog d) {
            this.d = d;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(this.d, "Going back to the original position!");
        }
    }

    class CalThread
    extends Thread {
        double[] x1;
        double[] y1;
        String deviceName;
        MMDialog d;
        Thread stopThread;

        CalThread() {
        }

        public void setPara(Thread stopThread, MMDialog d, String deviceName, double[] x1, double[] y1) {
            this.stopThread = stopThread;
            this.d = d;
            this.deviceName = deviceName;
            this.x1 = x1;
            this.y1 = y1;
        }

        @Override
        public void run() {
            try {
                PositionListDlg.this.core_.home(this.deviceName);
                boolean busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                int delay = 500;
                int period = 600000;
                for (int elapse = 0; busy && elapse < period; elapse += delay) {
                    Thread.sleep(delay);
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                }
                this.stopThread.interrupt();
                this.stopThread = null;
                double[] x2 = new double[1];
                double[] y2 = new double[1];
                PositionListDlg.this.core_.getXYPosition(this.deviceName, x2, y2);
                PositionListDlg.this.core_.setOriginXY(this.deviceName);
                BackThread bt = new BackThread();
                bt.setPara(this.d);
                bt.start();
                PositionListDlg.this.core_.setXYPosition(this.deviceName, this.x1[0] - x2[0], this.y1[0] - y2[0]);
                if (this.isInterrupted()) {
                    return;
                }
                busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                while (busy) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(100L);
                    if (this.isInterrupted()) {
                        return;
                    }
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                }
                bt.interrupt();
            }
            catch (InterruptedException e) {
                ReportingUtils.logError(e);
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }
    }

    class StopCalThread
    extends Thread {
        double[] x1;
        double[] y1;
        String deviceName;
        MMDialog d;
        Thread otherThread;

        StopCalThread() {
        }

        public void setPara(Thread calThread, MMDialog d, String deviceName, double[] x1, double[] y1) {
            this.otherThread = calThread;
            this.d = d;
            this.deviceName = deviceName;
            this.x1 = x1;
            this.y1 = y1;
        }

        @Override
        public void run() {
            try {
                Object[] options = new Object[]{"Stop"};
                int option = JOptionPane.showOptionDialog(this.d, "Stop calibration?", "Calibration", 2, 3, null, options, options[0]);
                if (option == 0) {
                    this.otherThread.interrupt();
                    this.otherThread = null;
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(50L);
                    PositionListDlg.this.core_.stop(this.deviceName);
                    if (this.isInterrupted()) {
                        return;
                    }
                    boolean busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (busy) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        PositionListDlg.this.core_.stop(this.deviceName);
                        if (this.isInterrupted()) {
                            return;
                        }
                        busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    Object[] options2 = new Object[]{"Yes", "No"};
                    option = JOptionPane.showOptionDialog(this.d, "RESUME calibration?", "Calibration", 0, 3, null, options2, options2[0]);
                    if (option == 1) {
                        return;
                    }
                    PositionListDlg.this.core_.home(this.deviceName);
                    StopCalThread sct = new StopCalThread();
                    sct.setPara(this, this.d, this.deviceName, this.x1, this.y1);
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    if (busy) {
                        sct.start();
                    }
                    if (this.isInterrupted()) {
                        return;
                    }
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (busy) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        Thread.sleep(100L);
                        if (this.isInterrupted()) {
                            return;
                        }
                        busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    sct.interrupt();
                    double[] x2 = new double[1];
                    double[] y2 = new double[1];
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    int delay = 500;
                    int period = 600000;
                    for (int elapse = 0; busy && elapse < period; elapse += delay) {
                        Thread.sleep(delay);
                        busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    PositionListDlg.this.core_.getXYPosition(this.deviceName, x2, y2);
                    PositionListDlg.this.core_.setOriginXY(this.deviceName);
                    BackThread bt = new BackThread();
                    bt.setPara(this.d);
                    bt.start();
                    PositionListDlg.this.core_.setXYPosition(this.deviceName, this.x1[0] - x2[0], this.y1[0] - y2[0]);
                    if (this.isInterrupted()) {
                        return;
                    }
                    busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (busy) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        Thread.sleep(100L);
                        if (this.isInterrupted()) {
                            return;
                        }
                        busy = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    bt.interrupt();
                }
            }
            catch (InterruptedException e) {
                ReportingUtils.logError(e);
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }
    }
}

