/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import net.miginfocom.swing.MigLayout;
import org.micromanager.positionlist.PositionListDlg;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

class OffsetPositionsDialog
extends MMDialog {
    private PositionListDlg parent_;
    private final CMMCore core_;
    private final JPanel axisPanel_;
    private ArrayList<JTextField> axisInputs_;
    private String deviceName_;

    public OffsetPositionsDialog(PositionListDlg parent, CMMCore core) {
        this.parent_ = parent;
        this.core_ = core;
        this.axisInputs_ = new ArrayList();
        this.loadAndRestorePosition(100, 100, 320, 300);
        this.setTitle("Add offset to stage positions");
        this.setResizable(false);
        this.setModal(true);
        this.setLayout((LayoutManager)new MigLayout("flowx"));
        JLabel label = new JLabel("<html><p>Add offsets to the currently-selected stage positions.</p></html>");
        label.setPreferredSize(new Dimension(300, 20));
        this.add((Component)label, "span 4, align center, wrap");
        ArrayList<String> options = new ArrayList<String>();
        StrVector xyStages = core.getLoadedDevicesOfType(DeviceType.XYStageDevice);
        int i = 0;
        while ((long)i < xyStages.size()) {
            options.add(xyStages.get(i));
            ++i;
        }
        StrVector stages = core.getLoadedDevicesOfType(DeviceType.StageDevice);
        int i2 = 0;
        while ((long)i2 < stages.size()) {
            options.add(stages.get(i2));
            ++i2;
        }
        this.deviceName_ = (String)options.get(0);
        final JComboBox<Object> stageOptions = new JComboBox<Object>(options.toArray());
        stageOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String stageName = (String)stageOptions.getSelectedItem();
                OffsetPositionsDialog.this.setControlsFor(stageName);
            }
        });
        this.add((Component)new JLabel("Select stage device: "), "span 2");
        this.add(stageOptions, "wrap");
        this.axisPanel_ = new JPanel((LayoutManager)new MigLayout("flowy"));
        this.add((Component)this.axisPanel_, "span 4, align left, wrap");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList<Float> offsets = new ArrayList<Float>();
                for (JTextField input : OffsetPositionsDialog.this.axisInputs_) {
                    try {
                        Float value = Float.valueOf(Float.parseFloat(input.getText()));
                        offsets.add(value);
                    }
                    catch (NumberFormatException e) {
                        offsets.add(new Float(0.0f));
                    }
                }
                OffsetPositionsDialog.this.parent_.offsetSelectedSites(OffsetPositionsDialog.this.deviceName_, offsets);
                OffsetPositionsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        this.add((Component)okButton, "tag ok, span 4, split");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OffsetPositionsDialog.this.dispose();
            }
        });
        this.add((Component)cancelButton, "tag cancel, wrap");
        this.setControlsFor(this.deviceName_);
        this.setVisible(true);
    }

    private void setControlsFor(String deviceName) {
        DeviceType type;
        this.axisPanel_.removeAll();
        this.axisInputs_.clear();
        this.deviceName_ = deviceName;
        ArrayList<String> axes = new ArrayList<String>();
        try {
            type = this.core_.getDeviceType(deviceName);
        }
        catch (Exception e) {
            ReportingUtils.logError("Couldn't determine type of device named " + deviceName);
            return;
        }
        if (type == DeviceType.StageDevice) {
            axes.add("Z offset:");
        } else if (type == DeviceType.XYStageDevice) {
            axes.add("X offset:");
            axes.add("Y offset:");
        }
        for (String axis : axes) {
            JLabel prompt = new JLabel(axis);
            this.axisPanel_.add((Component)prompt, "split 2, flowx");
            JTextField field = new JTextField(4);
            field.setText("0");
            this.axisPanel_.add(field);
            this.axisInputs_.add(field);
        }
        this.pack();
        this.invalidate();
    }
}

