/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import com.google.common.eventbus.EventBus;
import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.micromanager.positionlist.AxisData;
import org.micromanager.positionlist.AxisList;
import org.micromanager.positionlist.MoversChangedEvent;

class AxisTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private boolean isEditable_ = true;
    private AxisList axisList_;
    private JTable axisTable_;
    private EventBus bus_;
    private Preferences prefs_;
    public final String[] COLUMN_NAMES = new String[]{"Use", "Stage name"};

    public AxisTableModel(AxisList list, JTable table, EventBus bus, Preferences prefs) {
        this.axisList_ = list;
        this.axisTable_ = table;
        this.bus_ = bus;
        this.prefs_ = prefs;
    }

    @Override
    public int getRowCount() {
        return this.axisList_.getNumberOfPositions();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AxisData aD = this.axisList_.get(rowIndex);
        if (aD != null) {
            if (columnIndex == 0) {
                return aD.getUse();
            }
            if (columnIndex == 1) {
                return aD.getAxisName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setEditable(boolean state) {
        this.isEditable_ = state;
        if (state) {
            for (int i = 0; i < this.getRowCount(); ++i) {
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.isEditable_;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.axisList_.get(rowIndex).setUse((Boolean)value);
            this.prefs_.putBoolean(this.axisList_.get(rowIndex).getAxisName(), (Boolean)value);
            this.bus_.post((Object)new MoversChangedEvent());
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
        this.axisTable_.clearSelection();
    }
}

