/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.positionlist;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import org.micromanager.positionlist.AxisData;
import org.micromanager.utils.ReportingUtils;

class AxisList {
    private ArrayList<AxisData> axisList_ = new ArrayList();
    private CMMCore core_;
    private Preferences prefs_;

    public AxisList(CMMCore core, Preferences prefs) {
        this.core_ = core;
        this.prefs_ = prefs;
        try {
            StrVector stages = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
            int i = 0;
            while ((long)i < stages.size()) {
                this.axisList_.add(new AxisData(this.prefs_.getBoolean(stages.get(i), true), stages.get(i), AxisData.AxisType.oneD));
                ++i;
            }
            StrVector stages2D = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int i2 = 0;
            while ((long)i2 < stages2D.size()) {
                this.axisList_.add(new AxisData(this.prefs_.getBoolean(stages2D.get(i2), true), stages2D.get(i2), AxisData.AxisType.twoD));
                ++i2;
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    public AxisData get(int i) {
        if (i >= 0 && i < this.axisList_.size()) {
            return this.axisList_.get(i);
        }
        return null;
    }

    public int getNumberOfPositions() {
        return this.axisList_.size();
    }

    public boolean use(String axisName) {
        for (int i = 0; i < this.axisList_.size(); ++i) {
            if (!axisName.equals(this.get(i).getAxisName())) continue;
            return this.get(i).getUse();
        }
        return true;
    }
}

