/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pluginmanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import mmcorej.TaggedImage;
import org.micromanager.MMStudio;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.MMPlugin;
import org.micromanager.api.MMProcessorPlugin;
import org.micromanager.pluginmanagement.PluginItem;
import org.micromanager.pluginmanagement.PluginLoader;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class PluginManager {
    private JMenu pluginMenu_;
    private final Map<String, JMenu> pluginSubMenus_ = new HashMap<String, JMenu>();
    private final PluginLoader pluginLoader_;
    private MMStudio studio_;
    private JMenuBar menuBar_;

    public PluginManager(MMStudio studio, JMenuBar menuBar) {
        this.studio_ = studio;
        this.menuBar_ = menuBar;
        this.pluginLoader_ = new PluginLoader(this);
    }

    public Thread initializePlugins() {
        this.pluginMenu_ = GUIUtils.createMenuInMenuBar(this.menuBar_, "Plugins");
        Thread loadThread = new Thread(new ThreadGroup("Plugin loading"), new Runnable(){

            @Override
            public void run() {
                PluginManager.this.pluginLoader_.loadPlugins();
            }
        });
        loadThread.setContextClassLoader(this.getClass().getClassLoader());
        loadThread.start();
        return loadThread;
    }

    public void addPluginToMenu(final PluginItem plugin) {
        List<String> path = plugin.getMenuPath();
        final PluginManager thisInstance = this;
        if (path.size() == 1) {
            GUIUtils.addMenuItem(this.pluginMenu_, plugin.getMenuItem(), plugin.getTooltip(), new Runnable(){

                @Override
                public void run() {
                    thisInstance.displayPlugin(plugin);
                }
            });
        } else if (path.size() == 2) {
            String groupName = path.get(0);
            JMenu submenu = this.pluginSubMenus_.get(groupName);
            if (submenu == null) {
                submenu = new JMenu(groupName);
                this.pluginSubMenus_.put(groupName, submenu);
                submenu.validate();
                this.pluginMenu_.add(submenu);
                if (groupName.equals("On-The-Fly Processors")) {
                    this.addImageProcessorConfigureMenuItem(submenu);
                    submenu.addSeparator();
                }
            }
            GUIUtils.addMenuItem(submenu, plugin.getMenuItem(), plugin.getTooltip(), new Runnable(){

                @Override
                public void run() {
                    thisInstance.displayPlugin(plugin);
                }
            });
        }
        this.pluginMenu_.validate();
        this.menuBar_.validate();
    }

    private void addImageProcessorConfigureMenuItem(JMenu menu) {
        GUIUtils.addMenuItem(menu, "Configure Processors...", "Set up the image processor pipeline", new Runnable(){

            @Override
            public void run() {
                PluginManager.this.studio_.showPipelinePanel();
            }
        });
    }

    private void displayPlugin(PluginItem plugin) {
        ReportingUtils.logMessage("Plugin command: " + plugin.getMenuItem());
        plugin.instantiate();
        switch (plugin.getPluginType()) {
            case PLUGIN_STANDARD: {
                ((MMPlugin)plugin.getPlugin()).show();
                break;
            }
            case PLUGIN_PROCESSOR: {
                this.studio_.showPipelinePanel();
                MMProcessorPlugin procPlugin = (MMProcessorPlugin)plugin.getPlugin();
                String procName = PluginLoader.getNameForPluginClass(procPlugin.getClass());
                DataProcessor<TaggedImage> pipelineProcessor = this.studio_.getAcquisitionEngine().getProcessorRegisteredAs(procName);
                if (pipelineProcessor == null) {
                    pipelineProcessor = this.studio_.getAcquisitionEngine().makeProcessor(procName, this.studio_);
                }
                if (pipelineProcessor == null) break;
                pipelineProcessor.makeConfigurationGUI();
                break;
            }
            default: {
                ReportingUtils.logError("Unrecognized plugin type " + (Object)((Object)plugin.getPluginType()));
            }
        }
    }

    public void disposePlugins() {
        this.pluginLoader_.disposePlugins();
    }
}

