/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pluginmanagement;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.api.Autofocus;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.MMPlugin;
import org.micromanager.api.MMProcessorPlugin;
import org.micromanager.pluginmanagement.PluginItem;
import org.micromanager.pluginmanagement.PluginManager;
import org.micromanager.pluginmanagement.PluginType;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;

class PluginLoader {
    public static final String MMPLUGINSDIR = "mmplugins";
    public static final String MMAUTOFOCUSDIR = "mmautofocus";
    private ArrayList<PluginItem> plugins_ = new ArrayList();
    private PluginManager manager_;

    public PluginLoader(PluginManager manager) {
        this.manager_ = manager;
    }

    private PluginItem declarePlugin(Class<?> cl, String dir, PluginType pluginType) {
        String className = cl.getSimpleName();
        String msg = className + " module loaded.";
        try {
            for (PluginItem plugin : this.plugins_) {
                if (!plugin.getClassName().contentEquals(className)) continue;
                msg = className + " already loaded";
                return new PluginItem(cl, "", pluginType, "", "", dir, msg);
            }
            String menuItem = PluginLoader.getNameForPluginClass(cl);
            String toolTipDescription = "";
            try {
                toolTipDescription = (String)cl.getDeclaredField("tooltipDescription").get(null);
            }
            catch (SecurityException e) {
                ReportingUtils.logError(e);
                toolTipDescription = "Description not available";
            }
            catch (NoSuchFieldException e) {
                toolTipDescription = "Description not available";
                ReportingUtils.logMessage(cl.getName() + " fails to implement static String tooltipDescription.");
            }
            catch (IllegalArgumentException e) {
                ReportingUtils.logError(e);
            }
            catch (IllegalAccessException e) {
                ReportingUtils.logError(e);
            }
            menuItem = menuItem.replace("_", " ");
            PluginItem pi = new PluginItem(cl, className, pluginType, menuItem, toolTipDescription, dir, msg);
            this.plugins_.add(pi);
            return pi;
        }
        catch (NoClassDefFoundError e) {
            msg = className + " class definition not found.";
            ReportingUtils.logError(e, msg);
            return new PluginItem(cl, "", pluginType, "", "", "", msg);
        }
    }

    private void addPluginToMenuLater(final PluginItem pi) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginLoader.this.manager_.addPluginToMenu(pi);
            }
        });
    }

    public void loadPlugins() {
        List<Class<?>> classes;
        File pluginRootDir = new File(System.getProperty("org.micromanager.plugin.path", MMPLUGINSDIR));
        File autofocusRootDir = new File(System.getProperty("org.micromanager.autofocus.path", MMAUTOFOCUSDIR));
        ArrayList<Class> autofocusClasses = new ArrayList<Class>();
        ArrayList<PluginItem> pis = new ArrayList<PluginItem>();
        FilenameFilter dirFilter = new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        };
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add("");
        String[] dirNames = pluginRootDir.list(dirFilter);
        if (dirNames != null) {
            dirs.addAll(Arrays.asList(dirNames));
        }
        for (String string : dirs) {
            try {
                classes = JavaUtils.findAndLoadClasses(new File(pluginRootDir, string), 0);
                for (Class<?> clazz : classes) {
                    PluginType pluginType = null;
                    for (Class<?> iface : clazz.getInterfaces()) {
                        if (iface == MMPlugin.class) {
                            pluginType = PluginType.PLUGIN_STANDARD;
                            continue;
                        }
                        if (iface != MMProcessorPlugin.class) continue;
                        pluginType = PluginType.PLUGIN_PROCESSOR;
                    }
                    if (pluginType == null) continue;
                    try {
                        ReportingUtils.logMessage("Installing plugin " + clazz.getName() + "...");
                        PluginItem pi = this.declarePlugin(clazz, string, pluginType);
                        if (pi == null) continue;
                        if (pluginType == PluginType.PLUGIN_PROCESSOR) {
                            AcquisitionWrapperEngine engine = MMStudio.getInstance().getAcquisitionEngine();
                            MMProcessorPlugin plugin = (MMProcessorPlugin)pi.getPlugin();
                            String processorName = PluginLoader.getNameForPluginClass(clazz);
                            Class<? extends DataProcessor<TaggedImage>> processorClass = PluginLoader.getProcessorClassForPluginClass(clazz);
                            if (processorClass != null) {
                                engine.registerProcessorClass(processorClass, processorName);
                            }
                        }
                        if (pi == null || pi.getClassName().isEmpty()) continue;
                        pis.add(pi);
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(e, "Failed to install the \"" + clazz.getName() + "\" plugin.");
                    }
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e, "Couldn't load plugins from directory " + string);
            }
        }
        Collections.sort(pis, new PluginItemComparator());
        for (PluginItem pluginItem : pis) {
            if (pluginItem == null) continue;
            this.addPluginToMenuLater(pluginItem);
        }
        classes = JavaUtils.findAndLoadClasses(autofocusRootDir, 2);
        for (Class clazz : classes) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (iface != Autofocus.class) continue;
                autofocusClasses.add(clazz);
            }
        }
        for (Class clazz : autofocusClasses) {
            try {
                ReportingUtils.logMessage("Attempting to install autofocus plugin " + clazz.getName());
                MMStudio.getInstance().installAutofocusPlugin(clazz.getName());
            }
            catch (Exception e) {
                ReportingUtils.logError("Failed to install the \"" + clazz.getName() + "\" autofocus plugin.");
            }
        }
    }

    public void disposePlugins() {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            this.plugins_.get(i).dispose();
        }
    }

    public static Class<? extends DataProcessor<TaggedImage>> getProcessorClassForPluginClass(Class<?> cl) {
        try {
            Method procMethod = cl.getDeclaredMethod("getProcessorClass", new Class[0]);
            Class procClass = (Class)procMethod.invoke(null, new Object[0]);
            return procClass;
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    public static String getNameForPluginClass(Class<?> cl) {
        try {
            return (String)cl.getDeclaredField("menuName").get(null);
        }
        catch (Exception e) {
            ReportingUtils.logError("Plugin [" + cl.getName() + "] has no menuName field");
            return cl.getSimpleName().replace("_", " ");
        }
    }

    private class PluginItemComparator
    implements Comparator<PluginItem> {
        private PluginItemComparator() {
        }

        @Override
        public int compare(PluginItem t1, PluginItem t2) {
            ArrayList<String> path1 = new ArrayList<String>(t1.getMenuPath());
            ArrayList<String> path2 = new ArrayList<String>(t2.getMenuPath());
            int commonLength = Math.min(path1.size(), path2.size());
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            for (int i = 0; i < commonLength; ++i) {
                int c = collator.compare((String)path1.get(i), (String)path2.get(i));
                if (c == 0) continue;
                return c;
            }
            return new Integer(path1.size()).compareTo(path2.size());
        }
    }
}

