/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pluginmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.micromanager.MMStudio;
import org.micromanager.api.MMBasePlugin;
import org.micromanager.api.MMPlugin;
import org.micromanager.api.MMProcessorPlugin;
import org.micromanager.pluginmanagement.PluginType;
import org.micromanager.utils.ReportingUtils;

public class PluginItem {
    private Class<?> pluginClass_ = null;
    private MMBasePlugin plugin_ = null;
    private PluginType pluginType_ = PluginType.PLUGIN_STANDARD;
    private String className_ = "";
    private String menuItem_ = "undefined";
    private String tooltip_ = "";
    private String directory_ = "";
    private String msg_ = "";

    public PluginItem(Class<?> pluginClass, String className, PluginType pluginType, String menuItem, String tooltip, String directory, String msg) {
        this.pluginClass_ = pluginClass;
        this.className_ = className;
        this.pluginType_ = pluginType;
        this.menuItem_ = menuItem;
        this.tooltip_ = tooltip;
        this.directory_ = directory;
        this.msg_ = msg;
    }

    public PluginItem(PluginItem pio) {
        this.pluginClass_ = pio.pluginClass_;
        this.className_ = pio.className_;
        this.pluginType_ = pio.pluginType_;
        this.menuItem_ = pio.menuItem_;
        this.plugin_ = pio.plugin_;
        this.directory_ = pio.directory_;
        this.msg_ = pio.msg_;
    }

    public PluginType getPluginType() {
        return this.pluginType_;
    }

    public String getMenuItem() {
        return this.menuItem_;
    }

    public String getMessage() {
        return this.msg_;
    }

    public String getClassName() {
        return this.className_;
    }

    public String getTooltip() {
        return this.tooltip_;
    }

    public MMBasePlugin getPlugin() {
        return this.plugin_;
    }

    public List<String> getMenuPath() {
        String sepPat = Pattern.quote(File.separator);
        ArrayList<String> menuPath = new ArrayList<String>(Arrays.asList(this.directory_.split(sepPat)));
        if (this.directory_.equals("")) {
            menuPath.clear();
        }
        for (int i = 0; i < menuPath.size(); ++i) {
            menuPath.set(i, ((String)menuPath.get(i)).replace('_', ' '));
        }
        menuPath.add(this.menuItem_);
        return menuPath;
    }

    public void instantiate() {
        try {
            if (this.plugin_ == null) {
                switch (this.pluginType_) {
                    case PLUGIN_STANDARD: {
                        this.plugin_ = (MMPlugin)this.pluginClass_.newInstance();
                        break;
                    }
                    case PLUGIN_PROCESSOR: {
                        this.plugin_ = (MMProcessorPlugin)this.pluginClass_.newInstance();
                        break;
                    }
                    default: {
                        ReportingUtils.logError("Can't instantiate unrecognized plugin type " + (Object)((Object)this.pluginType_));
                    }
                }
            }
        }
        catch (InstantiationException e) {
            ReportingUtils.logError("Failed instantiating plugin: " + e);
        }
        catch (IllegalAccessException e) {
            ReportingUtils.logError("Failed instantiating plugin: " + e);
        }
        if (this.pluginType_ == PluginType.PLUGIN_STANDARD) {
            ((MMPlugin)this.plugin_).setApp(MMStudio.getInstance());
        }
    }

    public void dispose() {
        if (this.pluginType_ == PluginType.PLUGIN_STANDARD && this.plugin_ != null) {
            ((MMPlugin)this.plugin_).dispose();
        }
    }
}

