/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pipelineinterface;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mmcorej.TaggedImage;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.DataProcessor;
import org.micromanager.events.EventManager;
import org.micromanager.events.PipelineEvent;
import org.micromanager.events.ProcessorEnabledEvent;

public class PipelineTableModel
extends AbstractTableModel {
    static final int ENABLED_COLUMN = 0;
    static final int NAME_COLUMN = 1;
    static final int CONFIGURE_COLUMN = 2;
    private static final int NUM_COLUMNS = 3;
    private final AcquisitionEngine engine_;
    private List<DataProcessor<TaggedImage>> pipeline_;

    PipelineTableModel(AcquisitionEngine engine) {
        this.engine_ = engine;
        this.pipeline_ = this.engine_.getImageProcessorPipeline();
        EventManager.register(this);
    }

    @Subscribe
    public void pipelineChanged(PipelineEvent event) {
        this.pipeline_ = event.getPipeline();
        this.fireTableDataChanged();
    }

    @Subscribe
    public void processorEnabledChanged(ProcessorEnabledEvent event) {
        int i = this.pipeline_.indexOf(event.getProcessor());
        if (i >= 0) {
            this.fireTableCellUpdated(i, 0);
        }
    }

    @Override
    public int getRowCount() {
        return this.pipeline_.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return DataProcessor.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Processor";
            }
            case 2: {
                return "Settings";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.pipeline_.get(row).getIsEnabled();
            }
            case 1: {
                return this.getProcessorName(this.pipeline_.get(row));
            }
            case 2: {
                return this.pipeline_.get(row);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 0) {
            boolean enabled = (Boolean)value;
            this.pipeline_.get(row).setEnabled(enabled);
        }
    }

    private String getProcessorName(DataProcessor<TaggedImage> processor) {
        Class<?> procCls = processor.getClass();
        return this.engine_.getNameForProcessorClass(procCls);
    }
}

