/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pipelineinterface;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mmcorej.TaggedImage;
import net.miginfocom.swing.MigLayout;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.pipelineinterface.PipelineTableModel;

public class PipelineTable
extends JTable {
    private final ScriptInterface gui_;
    private static final String buttonCellLayoutConstraints = "fill, insets 0, align center center";

    PipelineTable(ScriptInterface gui, AcquisitionEngine engine) {
        super(new PipelineTableModel(engine));
        this.gui_ = gui;
        this.setSelectionMode(0);
        this.setDefaultRenderer(DataProcessor.class, new ConfigureButtonCellRenderer());
        this.setDefaultEditor(DataProcessor.class, new ConfigureButtonCellEditor());
        TableColumn enabledColumn = this.getColumnModel().getColumn(0);
        enabledColumn.setMinWidth(enabledColumn.getPreferredWidth());
        enabledColumn.setMaxWidth(enabledColumn.getPreferredWidth());
    }

    DataProcessor<TaggedImage> getSelectedProcessor() {
        int i = this.getSelectedRow();
        if (i >= 0) {
            Object cellValue = this.getModel().getValueAt(i, 2);
            DataProcessor processor = (DataProcessor)cellValue;
            return processor;
        }
        return null;
    }

    private class ConfigureButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final JPanel panel_ = new JPanel();
        private final JButton button_ = new JButton("Configure...");
        private DataProcessor<TaggedImage> processor_;

        public ConfigureButtonCellEditor() {
            this.panel_.setLayout((LayoutManager)new MigLayout(PipelineTable.buttonCellLayoutConstraints));
            this.panel_.add(this.button_);
            this.button_.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.processor_.makeConfigurationGUI();
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.processor_;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object cellValue, boolean isSelected, int row, int column) {
            DataProcessor dataProcessor;
            this.processor_ = dataProcessor = (DataProcessor)cellValue;
            if (isSelected) {
                this.panel_.setBackground(table.getSelectionBackground());
            } else {
                this.panel_.setBackground(table.getBackground());
            }
            return this.panel_;
        }
    }

    private class ConfigureButtonCellRenderer
    implements TableCellRenderer {
        private final JPanel panel_ = new JPanel();
        private final JButton button_ = new JButton("Configure...");

        public ConfigureButtonCellRenderer() {
            this.panel_.setLayout((LayoutManager)new MigLayout(PipelineTable.buttonCellLayoutConstraints));
            this.panel_.add(this.button_);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object dataProcessor, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.panel_.setBackground(table.getSelectionBackground());
            } else {
                this.panel_.setBackground(table.getBackground());
            }
            return this.panel_;
        }
    }
}

