/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.pipelineinterface;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mmcorej.TaggedImage;
import net.miginfocom.swing.MigLayout;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.events.EventManager;
import org.micromanager.events.ProcessorEvent;
import org.micromanager.pipelineinterface.PipelineTable;
import org.micromanager.utils.MMFrame;

public final class PipelineFrame
extends MMFrame
implements ListSelectionListener {
    private final ScriptInterface gui_;
    private final AcquisitionEngine engine_;
    private final JPopupMenu addProcessorPopup_;
    private final PipelineTable pipelineTable_;
    private final JScrollPane pipelineScrollPane_;
    private final JButton removeButton_;
    private final JButton moveUpButton_;
    private final JButton moveDownButton_;

    public PipelineFrame(ScriptInterface gui, AcquisitionEngine engine) {
        super("On-The-Fly Processor Pipeline");
        this.gui_ = gui;
        this.engine_ = engine;
        this.setLayout((LayoutManager)new MigLayout("fill, flowy, insets dialog", "[align center, grow]unrelated[align left]", "[][align top, grow][]"));
        String downwardsArrow = "<html><b>\u2193</b></html>";
        this.add((Component)new JLabel("<html><b>Camera</b></html>"), "split 2");
        this.add(new JLabel("<html><b>\u2193</b></html>"));
        this.pipelineTable_ = new PipelineTable(this.gui_, this.engine_);
        this.pipelineTable_.setRowHeight(this.pipelineTable_.getRowHeight() * 2);
        this.pipelineTable_.getSelectionModel().addListSelectionListener(this);
        this.pipelineScrollPane_ = new JScrollPane(this.pipelineTable_, 20, 31);
        this.pipelineScrollPane_.setPreferredSize(new Dimension(320, 80));
        this.pipelineScrollPane_.setMinimumSize(new Dimension(320, this.pipelineTable_.getRowHeight()));
        this.add((Component)this.pipelineScrollPane_, "growx, growy");
        this.add((Component)new JLabel("<html><b>\u2193</b></html>"), "split 2");
        this.add((Component)new JLabel("<html><b>Dataset</b></html>"), "wrap");
        this.addProcessorPopup_ = new JPopupMenu();
        JButton addButton = new JButton("Add...");
        addButton.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/plus.png")));
        addButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Component button = e.getComponent();
                PipelineFrame.this.addProcessorPopup_.show(button, 0, button.getHeight());
            }
        });
        this.add((Component)addButton, "sizegroup btns, skip 1, split 5");
        this.removeButton_ = new JButton("Remove");
        this.removeButton_.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/minus.png")));
        this.removeButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PipelineFrame.this.removeSelectedProcessor();
            }
        });
        this.add((Component)this.removeButton_, "sizegroup btns");
        this.moveUpButton_ = new JButton("Move Up");
        this.moveUpButton_.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/arrow_up.png")));
        this.moveUpButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PipelineFrame.this.moveSelectedProcessor(-1);
            }
        });
        this.add((Component)this.moveUpButton_, "sizegroup btns");
        this.moveDownButton_ = new JButton("Move Down");
        this.moveDownButton_.setIcon(new ImageIcon(MMStudio.class.getResource("/org/micromanager/icons/arrow_down.png")));
        this.moveDownButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PipelineFrame.this.moveSelectedProcessor(1);
            }
        });
        this.add((Component)this.moveDownButton_, "sizegroup btns, gapbottom push");
        JLabel explanationLabel = new JLabel("<html><div width=\"125\" style=\"font-size: small\">Enabled processors in the pipeline are applied in order to images acquired by the camera.</div></html>");
        this.add(explanationLabel);
        this.pack();
        Dimension contentSize = this.getContentPane().getPreferredSize();
        Dimension minSize = this.getContentPane().getMinimumSize();
        int widthDelta = this.getSize().width - this.getContentPane().getSize().width;
        int heightDelta = this.getSize().height - this.getContentPane().getSize().height;
        Dimension frameSize = new Dimension(contentSize.width + widthDelta, contentSize.height + heightDelta);
        Dimension minFrameSize = new Dimension(minSize.width + widthDelta, minSize.height + heightDelta);
        this.setPreferredSize(frameSize);
        this.setMinimumSize(minFrameSize);
        this.loadAndRestorePosition(200, 200);
        EventManager.register(this);
        this.reloadProcessors();
        this.updateEditButtonStatus(this.pipelineTable_.getSelectionModel());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel model = (ListSelectionModel)e.getSource();
        this.updateEditButtonStatus(model);
    }

    private void updateEditButtonStatus(ListSelectionModel model) {
        boolean enableEditButtons = !model.isSelectionEmpty();
        this.removeButton_.setEnabled(enableEditButtons);
        this.moveUpButton_.setEnabled(enableEditButtons && model.getMaxSelectionIndex() > 0);
        this.moveDownButton_.setEnabled(enableEditButtons && model.getMinSelectionIndex() < this.pipelineTable_.getRowCount() - 1);
    }

    @Subscribe
    public void newProcessorRegistered(ProcessorEvent event) {
        this.reloadProcessors();
    }

    private void reloadProcessors() {
        List<String> names = this.engine_.getSortedDataProcessorNames();
        this.addProcessorPopup_.removeAll();
        for (final String name : names) {
            AbstractAction addAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PipelineFrame.this.engine_.makeProcessor(name, PipelineFrame.this.gui_);
                }
            };
            addAction.putValue("Name", name);
            this.addProcessorPopup_.add(new JMenuItem(addAction));
        }
    }

    private void removeSelectedProcessor() {
        DataProcessor<TaggedImage> processor = this.pipelineTable_.getSelectedProcessor();
        this.gui_.removeImageProcessor(processor);
    }

    private void moveSelectedProcessor(int offset) {
        int i = this.pipelineTable_.getSelectedRow();
        this.moveProcessor(this.pipelineTable_.getSelectedProcessor(), offset);
        this.pipelineTable_.getSelectionModel().setSelectionInterval(i + offset, i + offset);
    }

    private void moveProcessor(DataProcessor<TaggedImage> processor, int offset) {
        List<DataProcessor<TaggedImage>> pipeline = this.gui_.getImageProcessorPipeline();
        int oldIndex = pipeline.indexOf(processor);
        if (oldIndex < 0) {
            return;
        }
        int newIndex = oldIndex + offset;
        newIndex = Math.max(0, newIndex);
        newIndex = Math.min(newIndex, pipeline.size() - 1);
        pipeline.remove(oldIndex);
        pipeline.add(newIndex, processor);
        this.gui_.setImageProcessorPipeline(pipeline);
    }
}

