/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mmcorej.CMMCore;
import org.micromanager.MMStudio;
import org.micromanager.internalinterfaces.LiveModeListener;
import org.micromanager.utils.ReportingUtils;

public class ZWheelListener
implements MouseWheelListener,
LiveModeListener {
    private CMMCore core_;
    private MMStudio studio_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private static final double moveIncrement_ = 0.2;

    public ZWheelListener(CMMCore core, MMStudio gui) {
        this.core_ = core;
        this.studio_ = gui;
    }

    public void start() {
        if (WindowManager.getCurrentWindow() != null) {
            this.start(WindowManager.getCurrentWindow());
        }
    }

    public void start(ImageWindow win) {
        if (isRunning_) {
            this.stop();
        }
        isRunning_ = true;
        if (win != null) {
            this.attach(win);
        }
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeMouseWheelListener((MouseWheelListener)this);
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow win) {
        if (!isRunning_) {
            return;
        }
        this.canvas_ = win.getCanvas();
        this.canvas_.addMouseWheelListener((MouseWheelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        ZWheelListener zWheelListener = this;
        synchronized (zWheelListener) {
            String zStage = this.core_.getFocusDevice();
            if (zStage == null || zStage.equals("")) {
                return;
            }
            double moveIncrement = 0.2;
            double pixSizeUm = this.core_.getPixelSizeUm();
            if (pixSizeUm > 0.0) {
                moveIncrement = 2.0 * pixSizeUm;
            }
            int move = e.getWheelRotation();
            try {
                this.core_.setRelativePosition(zStage, (double)move * moveIncrement);
            }
            catch (Exception ex) {
                ReportingUtils.showError(ex);
                return;
            }
            this.studio_.updateZPosRelative((double)move * moveIncrement);
        }
    }

    @Override
    public void liveModeEnabled(boolean enabled) {
        if (enabled) {
            this.start();
        } else {
            this.stop();
        }
    }
}

