/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.IJ;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.MMStudio;
import org.micromanager.internalinterfaces.LiveModeListener;
import org.micromanager.utils.ReportingUtils;

public final class XYZKeyListener
implements KeyListener,
LiveModeListener {
    private final CMMCore core_;
    private final MMStudio studio_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private boolean mirrorX_;
    private boolean mirrorY_;
    private boolean transposeXY_;
    private boolean correction_;
    private static final double zmoveIncrement_ = 0.2;
    public static int ctrlZStep = 1;
    public static int normalZStep = 3;
    public static int shiftZStep = 10;
    public static int ctrlXYStep = 1;
    public static int normalXYStep = 10;
    private int step;
    private double stepX;
    private double stepY;

    public XYZKeyListener(CMMCore core, MMStudio gui) {
        this.core_ = core;
        this.studio_ = gui;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        block0 : switch (e.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.stepX = this.stepY = (double)normalXYStep;
                if (e.isControlDown()) {
                    this.stepX = this.stepY = (double)ctrlXYStep;
                } else if (e.isShiftDown()) {
                    this.stepX = this.core_.getImageWidth();
                    this.stepY = this.core_.getImageHeight();
                } else if (e.isAltDown()) {
                    this.stepX = this.core_.getImageWidth() / 2L;
                    this.stepY = this.core_.getImageHeight() / 2L;
                }
                switch (e.getKeyCode()) {
                    case 37: {
                        this.IncrementXY(-this.stepX, 0.0);
                        break;
                    }
                    case 39: {
                        this.IncrementXY(this.stepX, 0.0);
                        break;
                    }
                    case 38: {
                        this.IncrementXY(0.0, this.stepY);
                        break;
                    }
                    case 40: {
                        this.IncrementXY(0.0, -this.stepY);
                    }
                }
                break;
            }
            case 33: 
            case 34: 
            case 49: 
            case 50: 
            case 74: 
            case 85: {
                this.step = normalZStep;
                if (e.isControlDown()) {
                    this.step = ctrlZStep;
                } else if (e.isShiftDown()) {
                    this.step = shiftZStep;
                }
                switch (e.getKeyCode()) {
                    case 33: 
                    case 49: 
                    case 85: {
                        this.IncrementZ(-this.step);
                        break block0;
                    }
                    case 34: 
                    case 50: 
                    case 74: {
                        this.IncrementZ(this.step);
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void start() {
        if (WindowManager.getCurrentWindow() != null) {
            this.start(WindowManager.getCurrentWindow());
        }
    }

    public void start(ImageWindow win) {
        if (isRunning_) {
            this.stop();
        }
        isRunning_ = true;
        if (win != null) {
            this.attach(win);
        }
        this.getOrientation();
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeKeyListener((KeyListener)this);
            this.canvas_.addKeyListener((KeyListener)IJ.getInstance());
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow win) {
        if (!isRunning_) {
            return;
        }
        this.canvas_ = win.getCanvas();
        this.canvas_.removeKeyListener((KeyListener)IJ.getInstance());
        this.canvas_.addKeyListener((KeyListener)this);
    }

    public void IncrementXY(double stepX, double stepY) {
        this.getOrientation();
        String xyStage = this.core_.getXYStageDevice();
        if (xyStage == null) {
            return;
        }
        try {
            if (this.core_.deviceBusy(xyStage)) {
                return;
            }
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
            return;
        }
        double pixSizeUm = this.core_.getPixelSizeUm();
        if (!(pixSizeUm > 0.0)) {
            JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
            return;
        }
        double tmpXUm = stepX * pixSizeUm;
        double tmpYUm = stepY * pixSizeUm;
        double mXUm = tmpXUm;
        double mYUm = tmpYUm;
        if (!this.correction_) {
            if (this.transposeXY_) {
                mXUm = tmpYUm;
                mYUm = tmpXUm;
            }
            if (this.mirrorX_) {
                mXUm = -mXUm;
            }
            if (this.mirrorY_) {
                mYUm = -mYUm;
            }
        }
        try {
            this.core_.setRelativeXYPosition(xyStage, mXUm, mYUm);
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
            return;
        }
        this.studio_.updateXYPosRelative(mXUm, mYUm);
    }

    public void IncrementZ(int step) {
        String zStage = this.core_.getFocusDevice();
        if (zStage == null || zStage.length() == 0) {
            return;
        }
        double moveIncrement = 0.2;
        double pixSizeUm = this.core_.getPixelSizeUm();
        if (pixSizeUm > 0.0) {
            moveIncrement = pixSizeUm;
        }
        try {
            this.core_.setRelativePosition(zStage, moveIncrement * (double)step);
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
        }
    }

    public void getOrientation() {
        String camera = this.core_.getCameraDevice();
        if (camera == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String tmp = this.core_.getProperty(camera, "TransposeCorrection");
            this.correction_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            this.mirrorX_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            this.mirrorY_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            this.transposeXY_ = !tmp.equals("0");
        }
        catch (Exception exc) {
            ReportingUtils.showError(exc);
        }
    }

    @Override
    public void liveModeEnabled(boolean enabled) {
        if (enabled) {
            this.start();
        } else {
            this.stop();
        }
    }
}

