/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.gui.ImageWindow;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.utils.ReportingUtils;

public abstract class NavigationListenerBase {
    private CMMCore core_;
    private static boolean isRunning_ = false;
    private boolean mirrorX_;
    private boolean mirrorY_;
    private boolean transposeXY_;
    private boolean correction_;

    public NavigationListenerBase(CMMCore core) {
        this.core_ = core;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void start() {
        isRunning_ = true;
    }

    public void stop() {
        isRunning_ = false;
    }

    protected boolean needMirrorX() {
        return this.mirrorX_;
    }

    protected boolean needMirrorY() {
        return this.mirrorY_;
    }

    protected boolean needTransposeXY() {
        return this.transposeXY_;
    }

    protected boolean needCorrection() {
        return this.correction_;
    }

    public abstract void start(ImageWindow var1);

    public abstract void attach(ImageWindow var1);

    public void getOrientation() {
        String camera = this.core_.getCameraDevice();
        if (camera == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String tmp = this.core_.getProperty(camera, "TransposeCorrection");
            this.correction_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            this.mirrorX_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            this.mirrorY_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            this.transposeXY_ = !tmp.equals("0");
        }
        catch (Exception exc) {
            ReportingUtils.logError(exc);
        }
    }
}

