/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.MMStudio;
import org.micromanager.utils.ReportingUtils;

public class CenterAndDragListener
implements MouseListener,
MouseMotionListener,
WindowListener {
    private CMMCore core_;
    private MMStudio studio_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private boolean mirrorX_;
    private boolean mirrorY_;
    private boolean transposeXY_;
    private boolean correction_;
    private int lastX_;
    private int lastY_;

    public CenterAndDragListener(MMStudio gui) {
        this.studio_ = gui;
        this.core_ = gui.getMMCore();
    }

    public void start() {
        if (isRunning_) {
            return;
        }
        isRunning_ = true;
        ImageWindow win = WindowManager.getCurrentWindow();
        if (win != null) {
            this.attach(win);
        }
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeMouseListener((MouseListener)this);
            this.canvas_.removeMouseMotionListener((MouseMotionListener)this);
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow win) {
        if (win == null) {
            return;
        }
        if (!isRunning_) {
            return;
        }
        this.canvas_ = win.getCanvas();
        if (!Arrays.asList(this.canvas_.getMouseListeners()).contains(this)) {
            this.canvas_.addMouseListener((MouseListener)this);
        }
        if (!Arrays.asList(this.canvas_.getMouseMotionListeners()).contains(this)) {
            this.canvas_.addMouseMotionListener((MouseMotionListener)this);
        }
        if (!Arrays.asList(win.getWindowListeners()).contains(this)) {
            win.addWindowListener((WindowListener)this);
        }
        this.getOrientation();
    }

    public void getOrientation() {
        String camera = this.core_.getCameraDevice();
        if (camera == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String tmp = this.core_.getProperty(camera, "TransposeCorrection");
            this.correction_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            this.mirrorX_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            this.mirrorY_ = !tmp.equals("0");
            tmp = this.core_.getProperty(camera, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            this.transposeXY_ = !tmp.equals("0");
        }
        catch (Exception exc) {
            ReportingUtils.showError(exc);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (Toolbar.getInstance() != null && Toolbar.getToolId() == 12) {
            int nc = e.getClickCount();
            if ((e.getModifiers() & 4) != 0 || nc < 2) {
                return;
            }
            this.getOrientation();
            String xyStage = this.core_.getXYStageDevice();
            if (xyStage == null) {
                return;
            }
            double pixSizeUm = this.core_.getPixelSizeUm();
            if (!(pixSizeUm > 0.0)) {
                JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
                return;
            }
            int width = (int)this.core_.getImageWidth();
            int height = (int)this.core_.getImageHeight();
            int x = e.getX();
            int y = e.getY();
            int cX = this.canvas_.offScreenX(x);
            int cY = this.canvas_.offScreenY(y);
            double tmpXUm = (0.5 * (double)width - (double)cX) * pixSizeUm;
            double tmpYUm = (0.5 * (double)height - (double)cY) * pixSizeUm;
            double mXUm = tmpXUm;
            double mYUm = tmpYUm;
            if (!this.correction_) {
                if (this.transposeXY_) {
                    mXUm = tmpYUm;
                    mYUm = tmpXUm;
                }
                if (this.mirrorX_) {
                    mXUm = -mXUm;
                }
                if (this.mirrorY_) {
                    mYUm = -mYUm;
                }
            }
            try {
                this.core_.setRelativeXYPosition(xyStage, mXUm, mYUm);
            }
            catch (Exception ex) {
                ReportingUtils.showError(ex);
                return;
            }
            this.studio_.updateXYStagePosition();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.lastX_ = this.canvas_.offScreenX(x);
        this.lastY_ = this.canvas_.offScreenY(y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            return;
        }
        if (Toolbar.getInstance() != null && Toolbar.getToolId() != 12) {
            return;
        }
        this.getOrientation();
        String xyStage = this.core_.getXYStageDevice();
        if (xyStage == null && !xyStage.equals("")) {
            return;
        }
        try {
            if (this.core_.deviceBusy(xyStage)) {
                return;
            }
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
            return;
        }
        double pixSizeUm = this.core_.getPixelSizeUm();
        if (!(pixSizeUm > 0.0)) {
            JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int cX = this.canvas_.offScreenX(x);
        int cY = this.canvas_.offScreenY(y);
        double tmpXUm = cX - this.lastX_;
        double tmpYUm = cY - this.lastY_;
        double mXUm = tmpXUm *= pixSizeUm;
        double mYUm = tmpYUm *= pixSizeUm;
        if (!this.correction_) {
            if (this.transposeXY_) {
                mXUm = tmpYUm;
                mYUm = tmpXUm;
            }
            if (this.mirrorX_) {
                mXUm = -mXUm;
            }
            if (this.mirrorY_) {
                mYUm = -mYUm;
            }
        }
        try {
            this.core_.setRelativeXYPosition(xyStage, mXUm, mYUm);
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
            return;
        }
        this.lastX_ = cX;
        this.lastY_ = cY;
        this.studio_.updateXYPosRelative(mXUm, mYUm);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
        this.stop();
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }
}

