/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.menus;

import ij.IJ;
import java.awt.Cursor;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import org.micromanager.MMOptions;
import org.micromanager.MMStudio;
import org.micromanager.MainFrame;
import org.micromanager.conf2.ConfiguratorDlg2;
import org.micromanager.dialogs.OptionsDlg;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.HotKeysDialog;
import org.micromanager.utils.ReportingUtils;

public class ToolsMenu {
    private static final String MOUSE_MOVES_STAGE = "mouse_moves_stage";
    private JMenu toolsMenu_;
    private final JMenu switchConfigurationMenu_;
    private JCheckBoxMenuItem centerAndDragMenuItem_;
    private final MMStudio studio_;
    private final CMMCore core_;
    private final MMOptions options_;

    public ToolsMenu(MMStudio studio, CMMCore core, MMOptions options) {
        this.studio_ = studio;
        this.core_ = core;
        this.options_ = options;
        this.switchConfigurationMenu_ = new JMenu();
    }

    public void initializeToolsMenu(JMenuBar menuBar, final Preferences prefs) {
        this.toolsMenu_ = GUIUtils.createMenuInMenuBar(menuBar, "Tools");
        GUIUtils.addMenuItem(this.toolsMenu_, "Refresh GUI", "Refresh all GUI controls directly from the hardware", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.core_.updateSystemStateCache();
                ToolsMenu.this.studio_.updateGUI(true);
            }
        }, "arrow_refresh.png");
        GUIUtils.addMenuItem(this.toolsMenu_, "Rebuild GUI", "Regenerate Micro-Manager user interface", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.initializeGUI();
                ToolsMenu.this.core_.updateSystemStateCache();
            }
        });
        this.toolsMenu_.addSeparator();
        GUIUtils.addMenuItem(this.toolsMenu_, "Script Panel...", "Open Micro-Manager script editor window", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.showScriptPanel();
            }
        });
        GUIUtils.addMenuItem(this.toolsMenu_, "Shortcuts...", "Create keyboard shortcuts to activate image acquisition, mark positions, or run custom scripts", new Runnable(){

            @Override
            public void run() {
                HotKeysDialog hk = new HotKeysDialog();
            }
        });
        GUIUtils.addMenuItem(this.toolsMenu_, "Device Property Browser...", "Open new window to view and edit device property values", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.createPropertyEditor();
            }
        });
        this.toolsMenu_.addSeparator();
        GUIUtils.addMenuItem(this.toolsMenu_, "Stage Position List...", "Open the stage position list window", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.showXYPositionList();
            }
        }, "application_view_list.png");
        GUIUtils.addMenuItem(this.toolsMenu_, "Multi-Dimensional Acquisition...", "Open multi-dimensional acquisition setup window", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.openAcqControlDialog();
            }
        }, "film.png");
        this.centerAndDragMenuItem_ = GUIUtils.addCheckBoxMenuItem(this.toolsMenu_, "Mouse Moves Stage (Use Hand Tool)", "When enabled, double clicking or dragging in the snap/live\nwindow moves the XY-stage. Requires the hand tool.", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.updateCenterAndDragListener();
                IJ.setTool((int)12);
                prefs.putBoolean(ToolsMenu.MOUSE_MOVES_STAGE, ToolsMenu.this.centerAndDragMenuItem_.isSelected());
            }
        }, prefs.getBoolean(MOUSE_MOVES_STAGE, false));
        GUIUtils.addMenuItem(this.toolsMenu_, "Pixel Size Calibration...", "Define size calibrations specific to each objective lens.  When the objective in use has a calibration defined, micromanager will automatically use it when calculating metadata", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.createCalibrationListDlg();
            }
        });
        this.toolsMenu_.addSeparator();
        GUIUtils.addMenuItem(this.toolsMenu_, "Hardware Configuration Wizard...", "Open wizard to create new hardware configuration", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.runHardwareWizard(prefs);
            }
        });
        GUIUtils.addMenuItem(this.toolsMenu_, "Load Hardware Configuration...", "Un-initialize current configuration and initialize new one", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.loadConfiguration();
                ToolsMenu.this.studio_.initializeGUI();
            }
        });
        GUIUtils.addMenuItem(this.toolsMenu_, "Reload Hardware Configuration", "Shutdown current configuration and initialize most recently loaded configuration", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.loadSystemConfiguration();
                ToolsMenu.this.studio_.initializeGUI();
            }
        });
        for (int i = 0; i < 5; ++i) {
            JMenuItem configItem = new JMenuItem();
            configItem.setText(Integer.toString(i));
            this.switchConfigurationMenu_.add(configItem);
        }
        this.switchConfigurationMenu_.setText("Switch Hardware Configuration");
        this.toolsMenu_.add(this.switchConfigurationMenu_);
        this.switchConfigurationMenu_.setToolTipText("Switch between recently used configurations");
        GUIUtils.addMenuItem(this.toolsMenu_, "Save Configuration Settings As...", "Save current configuration settings as new configuration file", new Runnable(){

            @Override
            public void run() {
                ToolsMenu.this.studio_.saveConfigPresets();
                ToolsMenu.this.studio_.updateChannelCombos();
            }
        });
        this.toolsMenu_.addSeparator();
        GUIUtils.addMenuItem(this.toolsMenu_, "Options...", "Set a variety of Micro-Manager configuration options", new Runnable(){

            @Override
            public void run() {
                int oldBufsize = ((ToolsMenu)ToolsMenu.this).options_.circularBufferSizeMB_;
                OptionsDlg dlg = new OptionsDlg(ToolsMenu.this.options_, ToolsMenu.this.core_, prefs, ToolsMenu.this.studio_);
                dlg.setVisible(true);
                if (oldBufsize != ((ToolsMenu)ToolsMenu.this).options_.circularBufferSizeMB_) {
                    try {
                        ToolsMenu.this.core_.setCircularBufferMemoryFootprint((long)((ToolsMenu)ToolsMenu.this).options_.circularBufferSizeMB_);
                    }
                    catch (Exception exc) {
                        ReportingUtils.showError(exc);
                    }
                }
            }
        });
    }

    private void loadConfiguration() {
        File configFile = FileDialogs.openFile(MMStudio.getFrame(), "Load a config file", MMStudio.MM_CONFIG_FILE);
        if (configFile != null) {
            this.studio_.setSysConfigFile(configFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHardwareWizard(Preferences prefs) {
        try {
            if (this.studio_.getIsConfigChanged()) {
                Object[] options = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(null, "Save Changed Configuration?", "Micro-Manager", 0, 3, null, options, options[0]);
                if (n == 0) {
                    this.studio_.saveConfigPresets();
                }
                this.studio_.setConfigChanged(false);
            }
            boolean liveRunning = false;
            if (this.studio_.isLiveModeOn()) {
                liveRunning = true;
                this.studio_.enableLiveMode(false);
            }
            this.core_.reset();
            GUIUtils.preventDisplayAdapterChangeExceptions();
            ConfiguratorDlg2 cfg2 = null;
            MainFrame frame = MMStudio.getFrame();
            try {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                cfg2 = new ConfiguratorDlg2(this.core_, this.studio_.getSysConfigFile());
            }
            finally {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            if (cfg2 == null) {
                ReportingUtils.showError("Failed to launch Hardware Configuration Wizard");
                return;
            }
            cfg2.setVisible(true);
            GUIUtils.preventDisplayAdapterChangeExceptions();
            this.studio_.setSysConfigFile(cfg2.getFileName());
            GUIUtils.preventDisplayAdapterChangeExceptions();
            if (liveRunning) {
                this.studio_.enableLiveMode(liveRunning);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    public boolean getIsCenterAndDragChecked() {
        return this.centerAndDragMenuItem_.isSelected();
    }

    public void updateSwitchConfigurationMenu() {
        this.switchConfigurationMenu_.removeAll();
        for (final String configFile : this.studio_.getMRUConfigFiles()) {
            if (configFile.equals(this.studio_.getSysConfigFile())) continue;
            GUIUtils.addMenuItem(this.switchConfigurationMenu_, configFile, null, new Runnable(){

                @Override
                public void run() {
                    ToolsMenu.this.studio_.setSysConfigFile(configFile);
                }
            });
        }
    }
}

