/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.menus;

import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.micromanager.MMStudio;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class FileMenu {
    private final MMStudio studio_;
    private final JMenu openRecentRamMenu_;
    private final EvictingQueue<File> recentFiles_;
    private final Preferences prefs_;
    private final int RECENTFILESSIZE = 8;
    private final String PREFKEYBASE = "file";

    public FileMenu(MMStudio studio) {
        this.studio_ = studio;
        this.openRecentRamMenu_ = new JMenu("Open Recent (RAM)...");
        this.recentFiles_ = EvictingQueue.create((int)8);
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.restoreFilesFromPref(this.prefs_, "file", this.recentFiles_);
    }

    public void initializeFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = GUIUtils.createMenuInMenuBar(menuBar, "File");
        GUIUtils.addMenuItem(fileMenu, "Open (Virtual)...", null, new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        FileMenu.this.studio_.promptForAcquisitionToOpen(false);
                    }
                }.start();
            }
        });
        GUIUtils.addMenuItem(fileMenu, "Open (RAM)...", null, new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        File f = FileMenu.this.studio_.promptForAcquisitionToOpen(true);
                        FileMenu.this.addFileToRecentlyOpenedMenu(f);
                    }
                }.start();
            }
        });
        this.makeRecentFileRamMenu(this.openRecentRamMenu_, this.recentFiles_);
        fileMenu.add(this.openRecentRamMenu_);
        fileMenu.addSeparator();
        GUIUtils.addMenuItem(fileMenu, "Exit", null, new Runnable(){

            @Override
            public void run() {
                FileMenu.this.studio_.closeSequence(false);
            }
        });
    }

    public void addFileToRecentlyOpenedMenu(File f) {
        if (!this.recentFiles_.contains((Object)f)) {
            this.recentFiles_.add((Object)f);
        }
        FileMenu.writeFilesToPref(this.prefs_, "file", this.recentFiles_);
        this.makeRecentFileRamMenu(this.openRecentRamMenu_, this.recentFiles_);
    }

    private void restoreFilesFromPref(Preferences prefs, String keyBase, EvictingQueue<File> fileQueue) {
        String notFound = "";
        boolean hasKey = true;
        int i = 0;
        while (hasKey) {
            String key = keyBase + i;
            String filePath = prefs.get(key, "");
            if (filePath.equals("")) {
                hasKey = false;
                continue;
            }
            fileQueue.add((Object)new File(filePath));
            ++i;
        }
    }

    private static void writeFilesToPref(Preferences prefs, String keyBase, EvictingQueue<File> fileQueue) {
        try {
            prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int i = 0;
        for (File f : (File[])fileQueue.toArray((Object[])new File[fileQueue.size()])) {
            String path = f.getParent();
            if (f.isDirectory()) {
                path = f.getAbsolutePath();
            }
            prefs.put(keyBase + i, path);
            ++i;
        }
    }

    private void makeRecentFileRamMenu(JMenu recentFileMenu, EvictingQueue<File> fileQueue) {
        recentFileMenu.removeAll();
        File[] fileQueueArray = (File[])fileQueue.toArray((Object[])new File[fileQueue.size()]);
        for (int i = fileQueueArray.length - 1; i >= 0; --i) {
            final File f = fileQueueArray[i];
            String p = f.getParent();
            if (f.isDirectory()) {
                p = f.getAbsolutePath();
            }
            final String path = p;
            f.getName();
            try {
                GUIUtils.addMenuItem(recentFileMenu, f.getCanonicalPath(), null, new Runnable(){

                    @Override
                    public void run() {
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    FileMenu.this.studio_.openAcquisitionData(path, true, true);
                                }
                                catch (MMScriptException ex) {
                                    ReportingUtils.showError("Failed to open file: " + f.getName());
                                }
                            }
                        }.start();
                    }
                });
                continue;
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex, "Failed to add file: " + f.getName() + " to the recent file menu");
            }
        }
    }
}

