/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogFileManager {
    public static String makeLogFileNameForCurrentSession() {
        String filename = System.getProperty("org.micromanager.corelog.file");
        if (filename != null && filename.length() > 0) {
            return filename;
        }
        return new File(LogFileManager.getLogFileDirectory(), LogFileManager.makeLogFileLeafName()).getAbsolutePath();
    }

    public static void deleteLogFilesDaysOld(int days, String fileToExclude) {
        File excludedFile = null;
        if (fileToExclude != null && fileToExclude.length() > 0) {
            try {
                excludedFile = new File(fileToExclude).getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Calendar cutoffDate = Calendar.getInstance();
        cutoffDate.add(5, -days);
        CoreLogFilenameFilter coreLogFilter = new CoreLogFilenameFilter();
        File[] legacyLogFiles = LogFileManager.getLegacyLogFileDirectory().listFiles(coreLogFilter);
        if (legacyLogFiles == null) {
            legacyLogFiles = new File[]{};
        }
        for (File file : Arrays.asList(legacyLogFiles)) {
            Calendar fileDate = LogFileManager.getLegacyLogFileDate(file.getName());
            if (fileDate == null || !fileDate.before(cutoffDate) || LogFileManager.fileShouldBeExcluded(file, excludedFile)) continue;
            file.delete();
        }
        File[] modernLogFiles = LogFileManager.getLogFileDirectory().listFiles(coreLogFilter);
        if (modernLogFiles == null) {
            modernLogFiles = new File[]{};
        }
        for (File file : Arrays.asList(modernLogFiles)) {
            Calendar fileDate = LogFileManager.getLogFileDate(file.getName());
            if (fileDate == null || !fileDate.before(cutoffDate) || LogFileManager.fileShouldBeExcluded(file, excludedFile)) continue;
            file.delete();
        }
    }

    public static File getLogFileDirectory() {
        String dirname = System.getProperty("org.micromanager.corelog.dir");
        if (dirname == null || dirname.length() == 0) {
            dirname = "CoreLogs";
        }
        return new File(dirname);
    }

    public static File getLegacyLogFileDirectory() {
        String dirname = System.getProperty("org.micromanager.corelog.dir");
        if (dirname == null || dirname.length() == 0) {
            dirname = System.getProperty("user.dir");
        }
        return new File(dirname);
    }

    private static String makeLogFileLeafName() {
        String pidStr;
        String dateTime = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date());
        RuntimeMXBean rtMXB = ManagementFactory.getRuntimeMXBean();
        String jvmName = rtMXB.getName();
        try {
            pidStr = "_pid" + Integer.parseInt(jvmName.split("@")[0]);
        }
        catch (NumberFormatException e) {
            pidStr = "";
        }
        return "CoreLog" + dateTime + pidStr + ".txt";
    }

    private static Calendar getLogFileDate(String filename) {
        Pattern modernPattern = Pattern.compile("CoreLog(\\d{4})(\\d{2})(\\d{2})T(\\d{2})(\\d{2})(\\d{2})(_pid\\d+)?\\.txt");
        Matcher m = modernPattern.matcher(filename);
        if (m.matches()) {
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2)) - 1;
            int day = Integer.parseInt(m.group(3));
            int hour = Integer.parseInt(m.group(4));
            int minute = Integer.parseInt(m.group(5));
            int second = Integer.parseInt(m.group(6));
            return new GregorianCalendar(year, month, day, hour, minute, second);
        }
        return null;
    }

    private static Calendar getLegacyLogFileDate(String filename) {
        Pattern legacyPattern = Pattern.compile("CoreLog(\\d{4})(\\d{2})(\\d{2})\\.txt");
        Matcher m = legacyPattern.matcher(filename);
        if (m.matches()) {
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2)) - 1;
            int day = Integer.parseInt(m.group(3));
            return new GregorianCalendar(year, month, day);
        }
        return null;
    }

    private static boolean fileShouldBeExcluded(File file, File canonicalExcludedFile) {
        try {
            if (file.getCanonicalFile().equals(canonicalExcludedFile)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    private static class CoreLogFilenameFilter
    implements FilenameFilter {
        private CoreLogFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("CoreLog") && name.endsWith(".txt");
        }
    }
}

