/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.measure.Calibration;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ImageCacheListener;
import org.micromanager.api.ScriptInterface;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.api.events.PixelSizeChangedEvent;
import org.micromanager.events.DisplayCreatedEvent;
import org.micromanager.events.EventManager;
import org.micromanager.graph.HistogramControlsState;
import org.micromanager.graph.HistogramSettings;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.graph.SingleChannelHistogram;
import org.micromanager.imagedisplay.AcquisitionVirtualStack;
import org.micromanager.imagedisplay.DisplaySettings;
import org.micromanager.imagedisplay.DisplayWindow;
import org.micromanager.imagedisplay.DrawEvent;
import org.micromanager.imagedisplay.FPSEvent;
import org.micromanager.imagedisplay.HyperstackControls;
import org.micromanager.imagedisplay.IMMImagePlus;
import org.micromanager.imagedisplay.MMCompositeImage;
import org.micromanager.imagedisplay.MMImagePlus;
import org.micromanager.imagedisplay.MetadataPanel;
import org.micromanager.imagedisplay.NewImageEvent;
import org.micromanager.imagedisplay.UpdateTitleEvent;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.CanvasPaintPending;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class VirtualAcquisitionDisplay
implements ImageCacheListener {
    private static final int ANIMATION_AND_LOCK_RESTART_DELAY = 800;
    final ImageCache imageCache_;
    private AcquisitionEngine eng_;
    private boolean isAcquisitionFinished_ = false;
    private boolean promptToSave_ = true;
    private boolean amClosing_ = false;
    private final String name_;
    private String title_;
    private int numComponents_;
    private LinkedBlockingQueue<JSONObject> imageTagsQueue_;
    private Thread displayThread_;
    private final AtomicBoolean shouldStopDisplayThread_ = new AtomicBoolean(false);
    private long lastImageIndex_ = 0L;
    private int imagesDisplayed_ = 0;
    private long lastFPSUpdateTimestamp_ = -1L;
    private ImagePlus hyperImage_;
    private DisplayControls controls_;
    private boolean shouldUseSimpleControls_ = false;
    public AcquisitionVirtualStack virtualStack_;
    private boolean isMDA_ = false;
    private MetadataPanel mdPanel_;
    private boolean contrastInitialized_ = false;
    private boolean firstImage_ = true;
    private String channelGroup_ = "none";
    private Histograms histograms_;
    private HistogramControlsState histogramControlsState_;
    private boolean albumSaved_ = false;
    private JPopupMenu saveTypePopup_;
    private final AtomicBoolean updatePixelSize_ = new AtomicBoolean(false);
    private final AtomicLong newPixelSize_ = new AtomicLong();
    private final Object imageReceivedObject_ = new Object();
    private EventBus bus_;

    public static VirtualAcquisitionDisplay getDisplay(ImagePlus imgp) {
        ImageStack stack = imgp.getStack();
        if (stack instanceof AcquisitionVirtualStack) {
            return ((AcquisitionVirtualStack)stack).getVirtualAcquisitionDisplay();
        }
        return null;
    }

    @Subscribe
    public void onPixelSizeChanged(PixelSizeChangedEvent event) {
        this.newPixelSize_.set(Double.doubleToLongBits(event.getNewPixelSizeUm()));
        this.updatePixelSize_.set(true);
    }

    public VirtualAcquisitionDisplay(ImageCache imageCache, AcquisitionEngine eng, String name, boolean shouldUseNameAsTitle) {
        this.name_ = name;
        this.title_ = name;
        if (!shouldUseNameAsTitle) {
            this.title_ = WindowManager.getUniqueName((String)"Untitled");
        }
        this.imageCache_ = imageCache;
        this.eng_ = eng;
        this.isMDA_ = eng != null;
        this.albumSaved_ = imageCache.isFinished();
        this.setupEventBus();
        this.setupDisplayThread();
    }

    private void setupEventBus() {
        this.bus_ = new EventBus();
        this.bus_.register((Object)this);
    }

    private void setupDisplayThread() {
        this.imageTagsQueue_ = new LinkedBlockingQueue();
        this.displayThread_ = new Thread(new Runnable(){

            @Override
            public void run() {
                JSONObject tags = null;
                while (!VirtualAcquisitionDisplay.this.shouldStopDisplayThread_.get()) {
                    boolean haveValidImage = false;
                    do {
                        try {
                            tags = (JSONObject)VirtualAcquisitionDisplay.this.imageTagsQueue_.poll(500L, TimeUnit.MILLISECONDS);
                            boolean bl = haveValidImage = tags != null;
                            if (tags != null) continue;
                            try {
                                VirtualAcquisitionDisplay.this.sendFPSUpdate(null);
                            }
                            catch (Exception e) {
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            if (!VirtualAcquisitionDisplay.this.shouldStopDisplayThread_.get()) continue;
                            return;
                        }
                    } while (VirtualAcquisitionDisplay.this.imageTagsQueue_.peek() != null);
                    if (tags == null || !haveValidImage) continue;
                    if (VirtualAcquisitionDisplay.this.hyperImage_ != null && VirtualAcquisitionDisplay.this.hyperImage_.getCanvas() != null) {
                        while (CanvasPaintPending.isMyPaintPending(VirtualAcquisitionDisplay.this.hyperImage_.getCanvas(), VirtualAcquisitionDisplay.this.imageReceivedObject_)) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                if (!VirtualAcquisitionDisplay.this.shouldStopDisplayThread_.get()) continue;
                                return;
                            }
                        }
                        CanvasPaintPending.setPaintPending(VirtualAcquisitionDisplay.this.hyperImage_.getCanvas(), VirtualAcquisitionDisplay.this.imageReceivedObject_);
                    }
                    VirtualAcquisitionDisplay.this.showImage(tags, true);
                    VirtualAcquisitionDisplay.this.imagesDisplayed_++;
                    VirtualAcquisitionDisplay.this.sendFPSUpdate(tags);
                }
            }
        }, "VirtualAcquisitionDisplay display thread");
        this.displayThread_.start();
    }

    private void sendFPSUpdate(JSONObject tags) {
        long curTimestamp = System.currentTimeMillis();
        if (tags == null) {
            this.bus_.post((Object)new FPSEvent(0.0, 0.0));
            return;
        }
        if (this.lastFPSUpdateTimestamp_ == -1L) {
            this.lastFPSUpdateTimestamp_ = curTimestamp;
        } else if (curTimestamp - this.lastFPSUpdateTimestamp_ >= 500L) {
            double elapsedTime = (double)(curTimestamp - this.lastFPSUpdateTimestamp_) / 1000.0;
            try {
                long imageIndex = MDUtils.getSequenceNumber(tags);
                if (this.lastImageIndex_ != 0L) {
                    this.bus_.post((Object)new FPSEvent((double)(imageIndex - this.lastImageIndex_) / elapsedTime, (double)this.imagesDisplayed_ / elapsedTime));
                }
                this.lastImageIndex_ = imageIndex;
            }
            catch (Exception e) {
                this.bus_.post((Object)new FPSEvent(0.0, 0.0));
            }
            this.imagesDisplayed_ = 0;
            this.lastFPSUpdateTimestamp_ = curTimestamp;
        }
    }

    public EventBus getEventBus() {
        return this.bus_;
    }

    @Subscribe
    public void onDraw(DrawEvent event) {
        if (!this.amClosing_) {
            this.imageChangedUpdate();
        }
    }

    public VirtualAcquisitionDisplay(ImageCache imageCache, String name) throws MMScriptException {
        this.imageCache_ = imageCache;
        this.name_ = name;
        this.title_ = name;
        this.isMDA_ = false;
        this.shouldUseSimpleControls_ = true;
        this.albumSaved_ = imageCache.isFinished();
        this.setupEventBus();
        this.setupDisplayThread();
        EventManager.register(this);
    }

    private void startup(JSONObject firstImageMetadata, AcquisitionVirtualStack virtualStack) {
        this.mdPanel_ = MMStudio.getInstance().getMetadataPanel();
        JSONObject summaryMetadata = this.getSummaryMetadata();
        int numSlices = 1;
        int numFrames = 1;
        int numChannels = 1;
        int width = 0;
        int height = 0;
        int numComponents = 1;
        try {
            int imageChannelIndex;
            if (firstImageMetadata != null) {
                width = MDUtils.getWidth(firstImageMetadata);
                height = MDUtils.getHeight(firstImageMetadata);
                try {
                    imageChannelIndex = MDUtils.getChannelIndex(firstImageMetadata);
                }
                catch (JSONException e) {
                    imageChannelIndex = -1;
                }
            } else {
                width = MDUtils.getWidth(summaryMetadata);
                height = MDUtils.getHeight(summaryMetadata);
                imageChannelIndex = -1;
            }
            numSlices = Math.max(summaryMetadata.getInt("Slices"), 1);
            numFrames = this.imageCache_.lastAcquiredFrame();
            if (numFrames <= 0) {
                numFrames = Math.max(summaryMetadata.getInt("Frames"), 1);
            }
            numChannels = Math.max(1 + imageChannelIndex, Math.max(summaryMetadata.getInt("Channels"), 1));
            numComponents = Math.max(MDUtils.getNumberOfComponents(summaryMetadata), 1);
        }
        catch (JSONException e) {
            ReportingUtils.showError(e);
        }
        catch (MMScriptException e) {
            ReportingUtils.showError(e);
        }
        this.numComponents_ = numComponents;
        int numGrayChannels = this.numComponents_ * numChannels;
        if (this.imageCache_.getDisplayAndComments() == null || this.imageCache_.getDisplayAndComments().isNull("Channels")) {
            try {
                this.imageCache_.setDisplayAndComments(DisplaySettings.getDisplaySettingsFromSummary(summaryMetadata));
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex, "Problem setting display and Comments");
            }
        }
        int type = 0;
        try {
            type = firstImageMetadata != null ? MDUtils.getSingleChannelType(firstImageMetadata) : MDUtils.getSingleChannelType(summaryMetadata);
        }
        catch (JSONException ex) {
            ReportingUtils.showError((Throwable)ex, "Unable to determine acquisition type.");
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError((Throwable)ex, "Unable to determine acquisition type.");
        }
        this.virtualStack_ = virtualStack != null ? virtualStack : new AcquisitionVirtualStack(width, height, type, null, this.imageCache_, numGrayChannels * numSlices * numFrames, this);
        if (summaryMetadata.has("PositionIndex")) {
            try {
                this.virtualStack_.setPositionIndex(MDUtils.getPositionIndex(summaryMetadata));
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        }
        this.hyperImage_ = this.createHyperImage(this.createMMImagePlus(this.virtualStack_), numGrayChannels, numSlices, numFrames, this.virtualStack_);
        if (this.controls_ == null) {
            this.controls_ = new HyperstackControls(this, this.bus_, this.shouldUseSimpleControls_, this.isMDA_);
        }
        this.applyPixelSizeCalibration(this.hyperImage_);
        this.histogramControlsState_ = this.mdPanel_.getContrastPanel().createDefaultControlsState();
        this.createWindow();
        this.windowToFront();
        this.updateAndDraw(true);
        this.updateWindowTitleAndStatus();
    }

    public void setDisplayMode(int displayMode) {
        this.mdPanel_.getContrastPanel().setDisplayMode(displayMode);
    }

    public void promptToSave(boolean promptToSave) {
        this.promptToSave_ = promptToSave;
    }

    @Override
    public void imageReceived(TaggedImage taggedImage) {
        this.updateDisplay(taggedImage);
    }

    @Override
    public void imagingFinished(String path) {
        if (this.amClosing_) {
            return;
        }
        this.updateDisplay(null);
        if (this.eng_ == null || !this.eng_.abortRequested()) {
            this.updateWindowTitleAndStatus();
        }
    }

    public void updateDisplay(TaggedImage taggedImage) {
        JSONObject tags = taggedImage == null || taggedImage.tags == null ? this.imageCache_.getLastImageTags() : taggedImage.tags;
        if (tags == null) {
            return;
        }
        try {
            this.imageTagsQueue_.add(tags);
        }
        catch (IllegalStateException e) {
            ReportingUtils.logError("Ran out of space in the imageQueue! Inconceivable!");
        }
    }

    public int rgbToGrayChannel(int channelIndex) {
        try {
            if (MDUtils.getNumberOfComponents(this.imageCache_.getSummaryMetadata()) == 3) {
                return channelIndex * 3;
            }
            return channelIndex;
        }
        catch (MMScriptException ex) {
            ReportingUtils.logError(ex);
            return 0;
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
            return 0;
        }
    }

    public int grayToRGBChannel(int grayIndex) {
        try {
            if (this.imageCache_ != null && this.imageCache_.getSummaryMetadata() != null && MDUtils.getNumberOfComponents(this.imageCache_.getSummaryMetadata()) == 3) {
                return grayIndex / 3;
            }
            return grayIndex;
        }
        catch (MMScriptException ex) {
            ReportingUtils.logError(ex);
            return 0;
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
            return 0;
        }
    }

    private void applyPixelSizeCalibration(ImagePlus hyperImage) {
        String pixSizeTag = "PixelSizeUm";
        try {
            JSONObject tags = this.getCurrentMetadata();
            JSONObject summary = this.getSummaryMetadata();
            double pixSizeUm = tags != null && tags.has("PixelSizeUm") ? tags.getDouble("PixelSizeUm") : MDUtils.getPixelSizeUm(summary);
            if (pixSizeUm > 0.0) {
                String zStepUm;
                Calibration cal = new Calibration();
                cal.setUnit("um");
                cal.pixelWidth = pixSizeUm;
                cal.pixelHeight = pixSizeUm;
                String intMs = "Interval_ms";
                if (summary.has(intMs)) {
                    cal.frameInterval = summary.getDouble(intMs) / 1000.0;
                }
                if (summary.has(zStepUm = "z-step_um")) {
                    cal.pixelDepth = summary.getDouble(zStepUm);
                }
                hyperImage.setCalibration(cal);
                ImageWindow win = hyperImage.getWindow();
                if (win != null) {
                    win.repaint();
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public ImagePlus getHyperImage() {
        return this.hyperImage_;
    }

    public int getStackSize() {
        if (this.hyperImage_ == null) {
            return -1;
        }
        int s = this.hyperImage_.getNSlices();
        int c = this.hyperImage_.getNChannels();
        int f = this.hyperImage_.getNFrames();
        if (s > 1 && c > 1 || c > 1 && f > 1 || f > 1 && s > 1) {
            return s * c * f;
        }
        return Math.max(Math.max(s, c), f);
    }

    private void imageChangedWindowUpdate() {
        JSONObject md;
        if (this.hyperImage_ != null && this.hyperImage_.isVisible() && (md = this.getCurrentMetadata()) != null) {
            this.controls_.newImageUpdate(md);
        }
    }

    public void updateAndDraw(boolean force) {
        this.imageChangedUpdate();
        if (this.hyperImage_ != null && this.hyperImage_.isVisible()) {
            if (this.hyperImage_ instanceof MMCompositeImage) {
                ((MMCompositeImage)this.hyperImage_).updateAndDraw(force);
            } else {
                this.hyperImage_.updateAndDraw();
            }
        }
    }

    @Subscribe
    public void onUpdateTitleEvent(UpdateTitleEvent event) {
        this.updateWindowTitleAndStatus();
    }

    public void updateWindowTitleAndStatus() {
        String path;
        if (this.controls_ == null) {
            return;
        }
        String status = "";
        AcquisitionEngine eng = this.eng_;
        if (eng != null) {
            if (this.acquisitionIsRunning()) {
                if (!this.abortRequested()) {
                    this.controls_.acquiringImagesUpdate(true);
                    status = this.isPaused() ? "paused" : "running";
                } else {
                    this.controls_.acquiringImagesUpdate(false);
                    status = "interrupted";
                }
            } else {
                this.controls_.acquiringImagesUpdate(false);
                if (!status.contentEquals("interrupted") && eng.isFinished()) {
                    status = "finished";
                    this.eng_ = null;
                }
            }
            status = status + ", ";
            if (eng.isFinished()) {
                this.eng_ = null;
                this.isAcquisitionFinished_ = true;
            }
        } else {
            if (this.isAcquisitionFinished_) {
                status = "finished, ";
            }
            this.controls_.acquiringImagesUpdate(false);
        }
        status = this.isDiskCached() || this.albumSaved_ ? status + "on disk" : status + "not yet saved";
        this.controls_.imagesOnDiskUpdate(this.imageCache_.getDiskLocation() != null);
        String string = path = this.isDiskCached() ? new File(this.imageCache_.getDiskLocation()).getName() : this.title_;
        if (this.hyperImage_.isVisible()) {
            int mag = (int)(100.0 * this.hyperImage_.getCanvas().getMagnification());
            this.hyperImage_.getWindow().setTitle(path + " (" + status + ") (" + mag + "%)");
        }
    }

    private void windowToFront() {
        if (this.hyperImage_ == null || this.hyperImage_.getWindow() == null) {
            return;
        }
        this.hyperImage_.getWindow().toFront();
    }

    private void showImage(final JSONObject tags, final boolean waitForDisplay) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VirtualAcquisitionDisplay.this.doShowImage(tags, waitForDisplay);
            }
        });
    }

    private void doShowImage(JSONObject tags, boolean waitForDisplay) {
        this.updateWindowTitleAndStatus();
        if (tags == null) {
            return;
        }
        if (this.hyperImage_ == null) {
            this.startup(tags, null);
        }
        int channel = 0;
        int frame = 0;
        int slice = 0;
        int position = 0;
        try {
            frame = MDUtils.getFrameIndex(tags);
            slice = MDUtils.getSliceIndex(tags);
            channel = MDUtils.getChannelIndex(tags);
            position = MDUtils.getPositionIndex(tags);
            HashMap<String, Integer> axisToPosition = new HashMap<String, Integer>();
            axisToPosition.put("channel", channel);
            axisToPosition.put("position", position);
            axisToPosition.put("time", frame);
            axisToPosition.put("z", slice);
            this.bus_.post((Object)new NewImageEvent(axisToPosition));
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
        if (this.hyperImage_ != null && this.hyperImage_.getProcessor() != null && frame == 0) {
            IMMImagePlus img = (IMMImagePlus)this.hyperImage_;
            if (img.getNChannelsUnverified() == 1) {
                if (img.getNSlicesUnverified() == 1) {
                    this.hyperImage_.getProcessor().setPixels(this.virtualStack_.getPixels(1));
                }
            } else if (this.hyperImage_ instanceof MMCompositeImage) {
                MMCompositeImage ci = (MMCompositeImage)this.hyperImage_;
                ci.reset();
                ci.getProcessor().setPixels(this.virtualStack_.getPixels(ci.getCurrentSlice()));
            }
        } else if (this.hyperImage_ instanceof MMCompositeImage) {
            MMCompositeImage ci = (MMCompositeImage)this.hyperImage_;
            ci.reset();
        }
        if (this.hyperImage_ != null) {
            IMMImagePlus immi = (IMMImagePlus)this.hyperImage_;
            if (immi.getNFramesUnverified() <= frame + 1) {
                immi.setNFramesUnverified(frame + 1);
            }
            if (immi.getNSlicesUnverified() <= slice + 1) {
                immi.setNSlicesUnverified(slice + 1);
            }
            if (immi.getNChannelsUnverified() <= channel + 1) {
                immi.setNChannelsUnverified(channel + 1);
            }
        }
        if (this.firstImage_) {
            try {
                this.channelGroup_ = MDUtils.getChannelGroup(tags);
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Couldn't find Core-ChannelGroup in image metadata");
            }
            this.firstImage_ = false;
        }
        if (frame == 0) {
            this.initializeContrast();
        }
        this.updateAndDraw(true);
    }

    private void initializeContrast() {
        if (this.contrastInitialized_) {
            return;
        }
        int numChannels = this.imageCache_.getNumDisplayChannels();
        for (int channel = 0; channel < numChannels; ++channel) {
            String channelName = this.imageCache_.getChannelName(channel);
            HistogramSettings settings = MMStudio.getInstance().loadStoredChannelHistogramSettings(this.channelGroup_, channelName, this.isMDA_);
            this.histograms_.setChannelContrast(channel, settings.min_, settings.max_, settings.gamma_);
            this.histograms_.setChannelHistogramDisplayMax(channel, settings.histMax_);
            if (this.imageCache_.getNumDisplayChannels() <= 1) continue;
            this.setDisplayMode(settings.displayMode_);
        }
        this.histograms_.applyLUTToImage();
        this.contrastInitialized_ = true;
    }

    public void storeChannelHistogramSettings(int channelIndex, int min, int max, double gamma, int histMax, int displayMode) {
        if (!this.contrastInitialized_) {
            return;
        }
        if (this.imageCache_.getDisplayAndComments() != null) {
            this.imageCache_.storeChannelDisplaySettings(channelIndex, min, max, gamma, histMax, displayMode);
            if (this.isMDA_) {
                MMStudio.getInstance().saveChannelHistogramSettings(this.channelGroup_, this.imageCache_.getChannelName(channelIndex), this.isMDA_, new HistogramSettings(min, max, gamma, histMax, displayMode));
            }
        }
    }

    public void updatePosition(int p) {
        if (this.virtualStack_.getPositionIndex() == p) {
            return;
        }
        this.virtualStack_.setPositionIndex(p);
        if (!this.hyperImage_.isComposite()) {
            Object pixels = this.virtualStack_.getPixels(this.hyperImage_.getCurrentSlice());
            this.hyperImage_.getProcessor().setPixels(pixels);
        } else {
            CompositeImage ci = (CompositeImage)this.hyperImage_;
            if (ci.getMode() == 1) {
                for (int i = 0; i < ((MMCompositeImage)ci).getNChannelsUnverified(); ++i) {
                    if (ci.getProcessor(i + 1) == null) continue;
                    ci.getProcessor(i + 1).setPixels(this.virtualStack_.getPixels(ci.getCurrentSlice() - ci.getChannel() + i + 1));
                }
            }
            ci.getProcessor().setPixels(this.virtualStack_.getPixels(this.hyperImage_.getCurrentSlice()));
        }
        this.imageChangedUpdate();
        this.updateAndDraw(true);
    }

    public void setPosition(int p) {
        this.controls_.setPosition(p);
    }

    public int getPosition() {
        return this.controls_.getPosition();
    }

    public void setSliceIndex(int i) {
        int f = this.hyperImage_.getFrame();
        int c = this.hyperImage_.getChannel();
        this.hyperImage_.setPosition(c, i + 1, f);
    }

    public int getSliceIndex() {
        return this.hyperImage_.getSlice() - 1;
    }

    public void setChannel(int c) {
        this.controls_.setChannel(c);
    }

    public boolean pause() {
        if (this.eng_ != null) {
            if (this.eng_.isPaused()) {
                this.eng_.setPause(false);
            } else {
                this.eng_.setPause(true);
            }
            this.updateWindowTitleAndStatus();
            return this.eng_.isPaused();
        }
        return false;
    }

    public boolean abort() {
        if (this.eng_ != null && this.eng_.abortRequest()) {
            this.updateWindowTitleAndStatus();
            return true;
        }
        return false;
    }

    public boolean acquisitionIsRunning() {
        if (this.eng_ != null) {
            return this.eng_.isAcquisitionRunning();
        }
        return false;
    }

    public long getNextWakeTime() {
        return this.eng_.getNextWakeTime();
    }

    public boolean abortRequested() {
        if (this.eng_ != null) {
            return this.eng_.abortRequested();
        }
        return false;
    }

    private boolean isPaused() {
        if (this.eng_ != null) {
            return this.eng_.isPaused();
        }
        return false;
    }

    public void albumChanged() {
        this.albumSaved_ = false;
    }

    private Class createSaveTypePopup() {
        JPopupMenu menu;
        if (this.saveTypePopup_ != null) {
            this.saveTypePopup_.setVisible(false);
            this.saveTypePopup_ = null;
        }
        this.saveTypePopup_ = menu = new JPopupMenu();
        JMenuItem single = new JMenuItem("Save as separate image files");
        JMenuItem multi = new JMenuItem("Save as image stack file");
        JMenuItem cancel = new JMenuItem("Cancel");
        menu.add(single);
        menu.add(multi);
        menu.addSeparator();
        menu.add(cancel);
        final AtomicInteger ai = new AtomicInteger(-1);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ai.set(0);
            }
        });
        single.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ai.set(1);
            }
        });
        multi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ai.set(2);
            }
        });
        MouseInputAdapter highlighter = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JMenuItem)e.getComponent()).setArmed(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JMenuItem)e.getComponent()).setArmed(false);
            }
        };
        single.addMouseListener(highlighter);
        multi.addMouseListener(highlighter);
        cancel.addMouseListener(highlighter);
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        menu.show(null, mouseLocation.x, mouseLocation.y);
        while (ai.get() == -1) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (menu.isVisible()) continue;
            return null;
        }
        menu.setVisible(false);
        this.saveTypePopup_ = null;
        if (ai.get() == 0) {
            return null;
        }
        if (ai.get() == 1) {
            return TaggedImageStorageDiskDefault.class;
        }
        return TaggedImageStorageMultipageTiff.class;
    }

    boolean saveAs() {
        return this.saveAs(null, true);
    }

    boolean saveAs(boolean pointToNewStorage) {
        return this.saveAs(null, pointToNewStorage);
    }

    private boolean saveAs(Class<?> storageClass, boolean pointToNewStorage) {
        String root;
        String prefix;
        if (this.eng_ != null && this.eng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(null, "Data can not be saved while acquisition is running.");
            return false;
        }
        if (storageClass == null) {
            storageClass = this.createSaveTypePopup();
        }
        if (storageClass == null) {
            return false;
        }
        while (true) {
            File f;
            if ((f = FileDialogs.save((Window)this.hyperImage_.getWindow(), "Please choose a location for the data set", MMStudio.MM_DATA_SET)) == null) {
                return false;
            }
            prefix = f.getName();
            root = new File(f.getParent()).getAbsolutePath();
            if (!f.exists()) break;
            ReportingUtils.showMessage(prefix + " is write only! Please choose another name.");
        }
        try {
            if (this.getSummaryMetadata() != null) {
                this.getSummaryMetadata().put("Prefix", prefix);
            }
            TaggedImageStorage newFileManager = (TaggedImageStorage)storageClass.getConstructor(String.class, Boolean.class, JSONObject.class).newInstance(root + "/" + prefix, true, this.getSummaryMetadata());
            if (pointToNewStorage) {
                this.albumSaved_ = true;
            }
            this.imageCache_.saveAs(newFileManager, pointToNewStorage);
        }
        catch (IllegalAccessException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (IllegalArgumentException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (InstantiationException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (NoSuchMethodException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (SecurityException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (InvocationTargetException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        catch (JSONException ex) {
            ReportingUtils.showError((Throwable)ex, "Failed to save file");
        }
        MMStudio.getInstance().setAcqDirectory(root);
        this.updateWindowTitleAndStatus();
        return true;
    }

    public final MMImagePlus createMMImagePlus(AcquisitionVirtualStack virtualStack) {
        MMImagePlus img = new MMImagePlus(this.imageCache_.getDiskLocation(), (ImageStack)virtualStack, virtualStack.getVirtualAcquisitionDisplay().getEventBus());
        FileInfo fi = new FileInfo();
        fi.width = virtualStack.getWidth();
        fi.height = virtualStack.getHeight();
        String diskLocation = this.imageCache_.getDiskLocation();
        if (diskLocation != null) {
            File tmp = new File(diskLocation);
            fi.fileName = tmp.getName();
            fi.directory = tmp.getParent();
        }
        fi.url = null;
        img.setFileInfo(fi);
        return img;
    }

    public final ImagePlus createHyperImage(MMImagePlus mmIP, int channels, int slices, int frames, AcquisitionVirtualStack virtualStack) {
        IMMImagePlus hyperImage;
        mmIP.setNChannelsUnverified(channels);
        mmIP.setNFramesUnverified(frames);
        mmIP.setNSlicesUnverified(slices);
        if (channels > 1) {
            hyperImage = new MMCompositeImage(mmIP, this.imageCache_.getDisplayMode(), this.title_, this.bus_);
            hyperImage.setOpenAsHyperStack(true);
        } else {
            hyperImage = mmIP;
            mmIP.setOpenAsHyperStack(true);
        }
        return hyperImage;
    }

    private void createWindow() {
        this.makeHistograms();
        DisplayWindow win = new DisplayWindow(this.hyperImage_, this.controls_, this.bus_);
        this.mdPanel_.displayChanged((ImageWindow)win);
        this.imageChangedUpdate();
        EventManager.post(new DisplayCreatedEvent(this, win));
    }

    @Subscribe
    public void onWindowClose(DisplayWindow.RequestToCloseEvent event) {
        Object[] options;
        int result;
        if (this.eng_ != null && this.eng_.isAcquisitionRunning() && !this.abort()) {
            return;
        }
        if (this.imageCache_.getDiskLocation() == null && this.promptToSave_ && !this.albumSaved_ && ((result = JOptionPane.showOptionDialog((Component)((Object)event.window_), "Do you want to save this data set before closing?", "Micro-Manager", -1, 3, null, options = new String[]{"Save Separate Files", "Save Stack File", "Discard", "Cancel"}, options[1])) == 0 ? !this.saveAs(TaggedImageStorageDiskDefault.class, true) : (result == 1 ? !this.saveAs(TaggedImageStorageMultipageTiff.class, true) : result == 3))) {
            return;
        }
        this.amClosing_ = true;
        this.shouldStopDisplayThread_.set(true);
        this.displayThread_.interrupt();
        try {
            this.displayThread_.join();
        }
        catch (InterruptedException e) {
            ReportingUtils.logError(e, "Display thread interrupted while waiting for it to finish on its own");
        }
        CanvasPaintPending.removeAllPaintPending(this.hyperImage_.getCanvas());
        this.bus_.unregister((Object)this);
        this.imageCache_.finished();
        this.removeFromAcquisitionManager(MMStudio.getInstance());
        this.controls_.prepareForClose();
        this.mdPanel_.displayChanged(null);
        this.imageCache_.close();
        DisplayWindow window = event.window_;
        window.forceClosed();
    }

    private void removeFromAcquisitionManager(ScriptInterface gui) {
        if (gui.acquisitionExists(this.name_).booleanValue()) {
            try {
                gui.closeAcquisition(this.name_);
            }
            catch (MMScriptException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    public JSONObject getCurrentMetadata() {
        if (this.hyperImage_ != null) {
            JSONObject md = this.virtualStack_.getImageTags(this.hyperImage_.getCurrentSlice());
            return md;
        }
        return null;
    }

    public int getCurrentPosition() {
        return this.virtualStack_.getPositionIndex();
    }

    public int getNumSlices() {
        return this.hyperImage_ == null ? 1 : ((IMMImagePlus)this.hyperImage_).getNSlicesUnverified();
    }

    public int getNumFrames() {
        return ((IMMImagePlus)this.hyperImage_).getNFramesUnverified();
    }

    public int getNumPositions() throws JSONException {
        return MDUtils.getNumPositions(this.imageCache_.getSummaryMetadata());
    }

    public ImagePlus getImagePlus() {
        return this.hyperImage_;
    }

    public ImageCache getImageCache() {
        return this.imageCache_;
    }

    public ImagePlus getImagePlus(int position) {
        this.virtualStack_.setPositionIndex(position);
        ImagePlus iP = new ImagePlus();
        iP.setStack((ImageStack)this.virtualStack_);
        iP.setDimensions(this.numComponents_ * this.getNumChannels(), this.getNumSlices(), this.getNumFrames());
        iP.setFileInfo(this.hyperImage_.getFileInfo());
        return iP;
    }

    public void setComment(String comment) throws MMScriptException {
        try {
            this.getSummaryMetadata().put("Comment", comment);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
    }

    public final JSONObject getSummaryMetadata() {
        return this.imageCache_.getSummaryMetadata();
    }

    public boolean close() {
        try {
            if (this.hyperImage_ != null) {
                if (this.hyperImage_.getWindow() != null && !this.hyperImage_.getWindow().close()) {
                    return false;
                }
                this.hyperImage_.close();
            }
        }
        catch (NullPointerException npe) {
            ReportingUtils.logError(npe);
        }
        return true;
    }

    public synchronized boolean windowClosed() {
        if (this.hyperImage_ != null) {
            ImageWindow win = this.hyperImage_.getWindow();
            return win == null || win.isClosed();
        }
        return true;
    }

    public void showFolder() {
        if (this.isDiskCached()) {
            try {
                File location = new File(this.imageCache_.getDiskLocation());
                if (JavaUtils.isWindows()) {
                    Runtime.getRuntime().exec("Explorer /n,/select," + location.getAbsolutePath());
                } else if (JavaUtils.isMac()) {
                    if (!location.isDirectory()) {
                        location = location.getParentFile();
                    }
                    Runtime.getRuntime().exec("open " + location.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    public String getSummaryComment() {
        return this.imageCache_.getComment();
    }

    public void setSummaryComment(String comment) {
        this.imageCache_.setComment(comment);
    }

    void setImageComment(String comment) {
        this.imageCache_.setImageComment(comment, this.getCurrentMetadata());
    }

    String getImageComment() {
        try {
            return this.imageCache_.getImageComment(this.getCurrentMetadata());
        }
        catch (NullPointerException ex) {
            return "";
        }
    }

    public boolean isDiskCached() {
        ImageCache imageCache = this.imageCache_;
        if (imageCache == null) {
            return false;
        }
        return imageCache.getDiskLocation() != null;
    }

    public void show(final AcquisitionVirtualStack virtualStack) {
        if (this.hyperImage_ == null) {
            try {
                GUIUtils.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        VirtualAcquisitionDisplay.this.startup(null, virtualStack);
                    }
                });
            }
            catch (InterruptedException ex) {
                ReportingUtils.logError(ex);
            }
            catch (InvocationTargetException ex) {
                ReportingUtils.logError(ex);
            }
        }
        this.hyperImage_.show();
        this.hyperImage_.getWindow().toFront();
    }

    public void show() {
        this.show(null);
    }

    public int getNumChannels() {
        return this.hyperImage_ == null ? 1 : ((IMMImagePlus)this.hyperImage_).getNChannelsUnverified();
    }

    public int getNumGrayChannels() {
        return this.getNumChannels();
    }

    public void setWindowTitle(String title) {
        this.title_ = title;
        this.updateWindowTitleAndStatus();
    }

    public void displayStatusLine(String status) {
        this.controls_.setImageInfoLabel(status);
    }

    public void setChannelContrast(int channelIndex, int min, int max, double gamma) {
        this.histograms_.setChannelContrast(channelIndex, min, max, gamma);
        this.histograms_.applyLUTToImage();
        this.drawWithoutUpdate();
    }

    public void updateChannelNamesAndColors() {
        if (this.histograms_ != null && this.histograms_ instanceof MultiChannelHistograms) {
            ((MultiChannelHistograms)this.histograms_).updateChannelNamesAndColors();
        }
    }

    public void setChannelHistogramDisplayMax(int channelIndex, int histMax) {
        this.histograms_.setChannelHistogramDisplayMax(channelIndex, histMax);
    }

    private void imageChangedUpdate() {
        boolean updatePixelSize = this.updatePixelSize_.get();
        if (updatePixelSize) {
            try {
                JSONObject summary = this.getSummaryMetadata();
                if (summary != null) {
                    summary.put("PixelSize_um", Double.longBitsToDouble(this.newPixelSize_.get()));
                }
                if (this.hyperImage_ != null) {
                    this.applyPixelSizeCalibration(this.hyperImage_);
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Error in imageChangedUpdate in VirtualAcquisitionDisplay.java");
            }
            this.updatePixelSize_.set(false);
        } else if (this.hyperImage_ != null) {
            Calibration cal = this.hyperImage_.getCalibration();
            double calPixSize = cal.pixelWidth;
            double zStep = cal.pixelHeight;
            JSONObject tags = this.getCurrentMetadata();
            if (tags != null) {
                try {
                    double imgZStep;
                    double imgPixSize = MDUtils.getPixelSizeUm(tags);
                    if (calPixSize != imgPixSize) {
                        this.applyPixelSizeCalibration(this.hyperImage_);
                    }
                    if ((imgZStep = MDUtils.getZStepUm(tags)) != zStep) {
                        this.applyPixelSizeCalibration(this.hyperImage_);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        if (this.histograms_ != null) {
            this.histograms_.imageChanged();
        }
        if (this.isActiveDisplay()) {
            this.mdPanel_.imageChangedUpdate(this);
            if (updatePixelSize) {
                this.mdPanel_.redrawSizeBar();
            }
        }
        this.imageChangedWindowUpdate();
    }

    public boolean isActiveDisplay() {
        if (this.hyperImage_ == null || this.hyperImage_.getWindow() == null) {
            return false;
        }
        return this.hyperImage_.getWindow() == this.mdPanel_.getCurrentWindow();
    }

    public void drawWithoutUpdate() {
        if (this.hyperImage_ != null) {
            ((IMMImagePlus)this.hyperImage_).drawWithoutUpdate();
        }
    }

    private void makeHistograms() {
        this.histograms_ = this.getNumChannels() == 1 ? new SingleChannelHistogram(this) : new MultiChannelHistograms(this);
    }

    public Histograms getHistograms() {
        return this.histograms_;
    }

    public HistogramControlsState getHistogramControlsState() {
        return this.histogramControlsState_;
    }

    public void disableAutoStretchCheckBox() {
        if (this.isActiveDisplay()) {
            this.mdPanel_.getContrastPanel().disableAutostretch();
        } else {
            this.histogramControlsState_.autostretch = false;
        }
    }

    public ContrastSettings getChannelContrastSettings(int channel) {
        return this.histograms_.getChannelContrastSettings(channel);
    }

    public int getIntensityAt(int x, int y) {
        if (this.hyperImage_ == null) {
            return -1;
        }
        return ((IMMImagePlus)this.hyperImage_).getPixelIntensities(x, y)[0];
    }
}

