/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.micromanager.imagedisplay.AxisScroller;
import org.micromanager.imagedisplay.NewImageEvent;

public class ScrollerPanel
extends JPanel {
    private EventBus bus_;
    protected ArrayList<AxisScroller> scrollers_;
    private HashMap<String, Integer> lastImagePosition_ = null;
    private boolean canMakeTimers_ = true;
    private Timer animationUpdateTimer_ = null;
    private Timer snapBackTimer_ = null;
    private double framesPerSec_;

    public ScrollerPanel(EventBus bus, String[] axes, Integer[] maximums, double framesPerSec) {
        super((LayoutManager)new MigLayout("insets 0, fillx"));
        this.bus_ = bus;
        this.bus_.register((Object)this);
        this.framesPerSec_ = framesPerSec;
        this.scrollers_ = new ArrayList();
        for (int i = 0; i < maximums.length; ++i) {
            int max = maximums[i];
            if (max < 1) {
                max = 1;
            }
            AxisScroller scroller = new AxisScroller(axes[i], max, bus, true);
            if (max <= 1) {
                scroller.setVisible(false);
            } else {
                this.add((Component)scroller, "wrap 0px, align center, growx");
            }
            this.scrollers_.add(scroller);
        }
    }

    @Subscribe
    public void onScrollPositionChanged(AxisScroller.ScrollPositionEvent event) {
        this.checkForImagePositionChanged();
    }

    private void checkForImagePositionChanged() {
        boolean shouldPostEvent = false;
        if (this.lastImagePosition_ == null) {
            this.lastImagePosition_ = new HashMap();
        }
        for (AxisScroller scroller : this.scrollers_) {
            String axis = scroller.getAxis();
            Integer position = scroller.getPosition();
            if (!this.lastImagePosition_.containsKey(axis) || this.lastImagePosition_.get(axis) != position) {
                shouldPostEvent = true;
            }
            this.lastImagePosition_.put(axis, position);
        }
        if (shouldPostEvent) {
            this.bus_.post((Object)new SetImageEvent(this.lastImagePosition_));
        }
    }

    @Subscribe
    public void onAnimationToggle(AxisScroller.AnimationToggleEvent event) {
        this.resetAnimationTimer();
    }

    public void prepareForClose() {
        this.canMakeTimers_ = false;
        for (AxisScroller scroller : this.scrollers_) {
            scroller.setIsAnimated(false);
        }
        if (this.animationUpdateTimer_ != null) {
            this.animationUpdateTimer_.cancel();
        }
        if (this.snapBackTimer_ != null) {
            this.snapBackTimer_.cancel();
        }
    }

    private void resetAnimationTimer() {
        if (this.animationUpdateTimer_ != null) {
            this.animationUpdateTimer_.cancel();
        }
        if (!this.canMakeTimers_) {
            return;
        }
        int stepSize = 1;
        long interval = (long)(1000.0 / this.framesPerSec_);
        if (interval < 33L) {
            interval = 33L;
            stepSize = (int)Math.round(this.framesPerSec_ * 33.0 / 1000.0);
        }
        boolean isAnimated = false;
        final int[] offsets = new int[this.scrollers_.size()];
        for (int i = 0; i < offsets.length; ++i) {
            if (this.scrollers_.get(i).getIsAnimated()) {
                isAnimated = true;
                offsets[i] = stepSize;
                continue;
            }
            offsets[i] = 0;
        }
        if (isAnimated) {
            this.animationUpdateTimer_ = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    for (int i = 0; i < ScrollerPanel.this.scrollers_.size(); ++i) {
                        if (offsets[i] == 0) continue;
                        ScrollerPanel.this.scrollers_.get(i).advancePosition(offsets[i], false);
                    }
                    ScrollerPanel.this.checkForImagePositionChanged();
                }
            };
            this.animationUpdateTimer_.schedule(task, 0L, interval);
        }
    }

    @Subscribe
    public void onNewImageEvent(NewImageEvent event) {
        boolean didShowNewScrollers = false;
        boolean canShowNewImage = true;
        for (AxisScroller scroller : this.scrollers_) {
            if (!scroller.getIsSuperlocked()) continue;
            canShowNewImage = false;
            break;
        }
        int height = 0;
        for (AxisScroller scroller : this.scrollers_) {
            int imagePosition = event.getPositionForAxis(scroller.getAxis());
            if (scroller.getMaximum() <= imagePosition) {
                if (scroller.getMaximum() == 1) {
                    scroller.setVisible(true);
                    this.add((Component)scroller, "wrap 0px, align center, growx");
                    didShowNewScrollers = true;
                }
                scroller.setMaximum(imagePosition + 1);
            }
            if (canShowNewImage) {
                scroller.forcePosition(imagePosition);
            }
            if (!scroller.isVisible()) continue;
            height += scroller.getPreferredSize().height;
        }
        if (didShowNewScrollers) {
            this.bus_.post((Object)new LayoutChangedEvent());
        }
        if (canShowNewImage && this.canMakeTimers_) {
            if (this.snapBackTimer_ != null) {
                this.snapBackTimer_.cancel();
            }
            this.snapBackTimer_ = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    for (AxisScroller scroller : ScrollerPanel.this.scrollers_) {
                        scroller.restorePosition();
                    }
                }
            };
            this.snapBackTimer_.schedule(task, 500L);
        }
    }

    public void setFramesPerSecond(double newFPS) {
        this.framesPerSec_ = newFPS;
        this.resetAnimationTimer();
    }

    public void setPosition(String axis, int position) {
        for (AxisScroller scroller : this.scrollers_) {
            if (!scroller.getAxis().equals(axis)) continue;
            scroller.setPosition(position);
            break;
        }
    }

    public int getPosition(String axis) {
        for (AxisScroller scroller : this.scrollers_) {
            if (!scroller.getAxis().equals(axis)) continue;
            return scroller.getPosition();
        }
        return 0;
    }

    public int getMaxPosition(String axis) {
        for (AxisScroller scroller : this.scrollers_) {
            if (!scroller.getAxis().equals(axis)) continue;
            return scroller.getMaximum();
        }
        return 0;
    }

    public void setMaxPosition(String axis, int max) {
        for (AxisScroller scroller : this.scrollers_) {
            if (!scroller.getAxis().equals(axis)) continue;
            scroller.setMaximum(max);
        }
    }

    public static class LayoutChangedEvent {
    }

    public static class SetImageEvent {
        private HashMap<String, Integer> axisToPosition_;

        public SetImageEvent(HashMap<String, Integer> axisToPosition) {
            this.axisToPosition_ = axisToPosition;
        }

        public Integer getPositionForAxis(String axis) {
            if (this.axisToPosition_.containsKey(axis)) {
                return this.axisToPosition_.get(axis);
            }
            return 0;
        }
    }
}

