/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.micromanager.utils.TooltipTextMaker;

public class ScrollbarLockIcon
extends JComponent {
    private static final int WIDTH = 17;
    private static final int HEIGHT = 14;
    private LockedState lockedState_;
    private String axis_;
    private EventBus bus_;
    private final Color BACKGROUND_COLOR = Color.white;
    private final Color LOCK_COLOR = Color.black;
    private final Color SUPERLOCK_COLOR = Color.red;
    private Color foreground_ = this.LOCK_COLOR;

    public ScrollbarLockIcon(String axis, EventBus bus) {
        this.lockedState_ = LockedState.UNLOCKED;
        this.axis_ = axis;
        this.bus_ = bus;
        this.setSize(17, 14);
        this.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Lock the scrollbar to its current postion"));
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScrollbarLockIcon.this.advanceLockedState();
            }
        });
    }

    private void advanceLockedState() {
        switch (this.lockedState_) {
            case UNLOCKED: {
                this.setLockedState(LockedState.LOCKED);
                break;
            }
            case LOCKED: {
                this.setLockedState(LockedState.SUPERLOCKED);
                break;
            }
            default: {
                this.setLockedState(LockedState.UNLOCKED);
            }
        }
    }

    public void setLockedState(LockedState state) {
        this.lockedState_ = state;
        this.foreground_ = this.lockedState_ == LockedState.SUPERLOCKED ? this.SUPERLOCK_COLOR : this.LOCK_COLOR;
        this.bus_.post((Object)new LockEvent(this.axis_, this.lockedState_));
        this.repaint();
    }

    public LockedState getLockedState() {
        return this.lockedState_;
    }

    public boolean getIsLocked() {
        return this.lockedState_ == LockedState.LOCKED || this.lockedState_ == LockedState.SUPERLOCKED;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(17, 14);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(17, 14);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(17, 14);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, 17, 14);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.lockedState_ == LockedState.UNLOCKED) {
            this.drawUnlocked(g2d);
        } else {
            this.drawLocked(g2d);
        }
    }

    private void drawUnlocked(Graphics2D g) {
        g.setColor(this.foreground_);
        g.fillRect(1, 7, 10, 6);
        g.fillRect(8, 4, 2, 3);
        g.fillRect(14, 4, 2, 3);
        g.fillArc(8, 1, 8, 8, 0, 180);
        g.setColor(this.BACKGROUND_COLOR);
        g.fillArc(10, 3, 4, 4, 0, 180);
    }

    private void drawLocked(Graphics2D g) {
        g.setColor(this.foreground_);
        g.fillRect(1, 7, 10, 6);
        g.fillRect(2, 4, 2, 3);
        g.fillRect(8, 4, 2, 3);
        g.fillArc(2, 1, 8, 8, 0, 180);
        g.setColor(this.BACKGROUND_COLOR);
        g.fillArc(4, 3, 4, 4, 0, 180);
    }

    public static class LockEvent {
        private String axis_;
        private LockedState lockedState_;

        public LockEvent(String axis, LockedState lockedState) {
            this.axis_ = axis;
            this.lockedState_ = lockedState;
        }

        public String getAxis() {
            return this.axis_;
        }

        public LockedState getLockedState() {
            return this.lockedState_;
        }
    }

    public static enum LockedState {
        UNLOCKED,
        LOCKED,
        SUPERLOCKED;

    }
}

