/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class ScrollbarAnimateIcon
extends Canvas {
    private static final int WIDTH = 24;
    private static final int HEIGHT = 14;
    private BasicStroke stroke = new BasicStroke(2.0f);
    private String label_;
    private boolean isAnimated_;

    public ScrollbarAnimateIcon(String axis) {
        this.setSize(24, 14);
        this.label_ = axis.substring(0, 1);
        this.isAnimated_ = false;
    }

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated_ = isAnimated;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(24, 14);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, 24, 14);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawPlayPauseButton(g2d);
        this.drawLetter(g);
    }

    private void drawCenteredLetter(Graphics g) {
        g.setFont(new Font("SansSerif", 0, 14));
        g.setColor(Color.black);
        g.drawString(this.label_, 8, 12);
    }

    private void drawLetter(Graphics g) {
        g.setFont(new Font("SansSerif", 0, 14));
        g.setColor(Color.black);
        g.drawString(this.label_, 4, 12);
    }

    private void drawPlayPauseButton(Graphics2D g) {
        if (this.isAnimated_) {
            g.setColor(Color.red);
            g.setStroke(this.stroke);
            g.drawLine(15, 3, 15, 11);
            g.drawLine(20, 3, 20, 11);
        } else {
            g.setColor(new Color(0, 150, 0));
            GeneralPath path = new GeneralPath();
            path.moveTo(15.0f, 2.0f);
            path.lineTo(22.0f, 7.0f);
            path.lineTo(15.0f, 12.0f);
            path.lineTo(15.0f, 2.0f);
            g.fill(path);
        }
    }
}

