/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import ij.ImagePlus;
import ij.gui.ImageWindow;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.ContrastPanel;
import org.micromanager.imagedisplay.AcquisitionVirtualStack;
import org.micromanager.imagedisplay.DisplayWindow;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ImageFocusListener;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class MetadataPanel
extends JPanel
implements ImageFocusListener {
    private JSplitPane CommentsSplitPane;
    private JLabel imageCommentsLabel;
    private JPanel imageCommentsPanel;
    private JScrollPane imageCommentsScrollPane;
    private JTextArea imageCommentsTextArea;
    private JPanel imageMetadataScrollPane;
    private JTable imageMetadataTable;
    private JScrollPane imageMetadataTableScrollPane;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSplitPane metadataSplitPane;
    private JCheckBox showUnchangingPropertiesCheckbox;
    private JLabel summaryCommentsLabel;
    private JPanel summaryCommentsPane;
    private JScrollPane summaryCommentsScrollPane;
    private JTextArea summaryCommentsTextArea;
    private JPanel summaryMetadataPanel;
    private JScrollPane summaryMetadataScrollPane;
    private JTable summaryMetadataTable;
    private JTabbedPane tabbedPane;
    private ContrastPanel contrastPanel_;
    private final MetadataTableModel imageMetadataModel_;
    private final MetadataTableModel summaryMetadataModel_;
    private final String[] columnNames_ = new String[]{"Property", "Value"};
    private boolean showUnchangingKeys_;
    private ImageWindow currentWindow_;
    private VirtualAcquisitionDisplay currentDisplay_;
    private Timer updateTimer_;

    public MetadataPanel() {
        this.imageMetadataModel_ = new MetadataTableModel();
        this.summaryMetadataModel_ = new MetadataTableModel();
        this.makeContrastPanel();
        this.initialize();
        GUIUtils.registerImageFocusListener(this);
        this.imageMetadataTable.setModel(this.imageMetadataModel_);
        this.summaryMetadataTable.setModel(this.summaryMetadataModel_);
        this.addTextChangeListeners();
        this.addFocusListeners();
    }

    private void makeContrastPanel() {
        this.contrastPanel_ = new ContrastPanel();
        this.contrastPanel_.setFont(new Font("", 0, 10));
    }

    private void initialize() {
        this.tabbedPane = new JTabbedPane();
        this.metadataSplitPane = new JSplitPane();
        this.imageMetadataScrollPane = new JPanel();
        this.imageMetadataTableScrollPane = new JScrollPane();
        this.imageMetadataTable = new JTable();
        this.showUnchangingPropertiesCheckbox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.summaryMetadataPanel = new JPanel();
        this.summaryMetadataScrollPane = new JScrollPane();
        this.summaryMetadataTable = new JTable();
        this.jLabel3 = new JLabel();
        this.CommentsSplitPane = new JSplitPane();
        this.summaryCommentsPane = new JPanel();
        this.summaryCommentsLabel = new JLabel();
        this.summaryCommentsScrollPane = new JScrollPane();
        this.summaryCommentsTextArea = new JTextArea();
        this.imageCommentsPanel = new JPanel();
        this.imageCommentsLabel = new JLabel();
        this.imageCommentsScrollPane = new JScrollPane();
        this.imageCommentsTextArea = new JTextArea();
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setPreferredSize(new Dimension(400, 640));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MetadataPanel.this.tabbedPaneStateChanged(evt);
            }
        });
        this.tabbedPane.addTab("Contrast", this.contrastPanel_);
        this.metadataSplitPane.setBorder(null);
        this.metadataSplitPane.setOrientation(0);
        this.imageMetadataTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.imageMetadataTable.setToolTipText("Metadata tags for each individual image");
        this.imageMetadataTable.setDebugGraphicsOptions(-1);
        this.imageMetadataTable.setDoubleBuffered(true);
        this.imageMetadataTableScrollPane.setViewportView(this.imageMetadataTable);
        this.showUnchangingPropertiesCheckbox.setText("Show unchanging properties");
        this.showUnchangingPropertiesCheckbox.setToolTipText("Show/hide properties that are the same for all images in the acquisition");
        this.showUnchangingPropertiesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataPanel.this.showUnchangingPropertiesCheckboxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Per-image properties");
        GroupLayout imageMetadataScrollPaneLayout = new GroupLayout(this.imageMetadataScrollPane);
        this.imageMetadataScrollPane.setLayout(imageMetadataScrollPaneLayout);
        imageMetadataScrollPaneLayout.setHorizontalGroup(imageMetadataScrollPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageMetadataTableScrollPane, -1, 620, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, imageMetadataScrollPaneLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 308, Short.MAX_VALUE).addComponent(this.showUnchangingPropertiesCheckbox)));
        imageMetadataScrollPaneLayout.setVerticalGroup(imageMetadataScrollPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imageMetadataScrollPaneLayout.createSequentialGroup().addGroup(imageMetadataScrollPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showUnchangingPropertiesCheckbox).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageMetadataTableScrollPane, -1, 517, Short.MAX_VALUE)));
        this.metadataSplitPane.setRightComponent(this.imageMetadataScrollPane);
        this.summaryMetadataPanel.setMinimumSize(new Dimension(0, 100));
        this.summaryMetadataPanel.setPreferredSize(new Dimension(539, 100));
        this.summaryMetadataScrollPane.setMinimumSize(new Dimension(0, 0));
        this.summaryMetadataScrollPane.setPreferredSize(new Dimension(454, 80));
        this.summaryMetadataTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Property", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.summaryMetadataTable.setToolTipText("Metadata tags for the whole acquisition");
        this.summaryMetadataScrollPane.setViewportView(this.summaryMetadataTable);
        this.jLabel3.setText("Acquisition properties");
        GroupLayout summaryMetadataPanelLayout = new GroupLayout(this.summaryMetadataPanel);
        this.summaryMetadataPanel.setLayout(summaryMetadataPanelLayout);
        summaryMetadataPanelLayout.setHorizontalGroup(summaryMetadataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryMetadataScrollPane, GroupLayout.Alignment.TRAILING, -1, 620, Short.MAX_VALUE).addGroup(summaryMetadataPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap()));
        summaryMetadataPanelLayout.setVerticalGroup(summaryMetadataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, summaryMetadataPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(4, 4, 4).addComponent(this.summaryMetadataScrollPane, -1, -1, Short.MAX_VALUE)));
        this.metadataSplitPane.setLeftComponent(this.summaryMetadataPanel);
        this.tabbedPane.addTab("Metadata", this.metadataSplitPane);
        this.CommentsSplitPane.setBorder(null);
        this.CommentsSplitPane.setDividerLocation(200);
        this.CommentsSplitPane.setOrientation(0);
        this.summaryCommentsLabel.setText("Acquisition comments:");
        this.summaryCommentsTextArea.setColumns(20);
        this.summaryCommentsTextArea.setLineWrap(true);
        this.summaryCommentsTextArea.setRows(1);
        this.summaryCommentsTextArea.setTabSize(3);
        this.summaryCommentsTextArea.setToolTipText("Enter your comments for the whole acquisition here");
        this.summaryCommentsTextArea.setWrapStyleWord(true);
        this.summaryCommentsScrollPane.setViewportView(this.summaryCommentsTextArea);
        GroupLayout summaryCommentsPaneLayout = new GroupLayout(this.summaryCommentsPane);
        this.summaryCommentsPane.setLayout(summaryCommentsPaneLayout);
        summaryCommentsPaneLayout.setHorizontalGroup(summaryCommentsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryCommentsPaneLayout.createSequentialGroup().addComponent(this.summaryCommentsLabel).addContainerGap(491, Short.MAX_VALUE)).addComponent(this.summaryCommentsScrollPane, -1, 620, Short.MAX_VALUE));
        summaryCommentsPaneLayout.setVerticalGroup(summaryCommentsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryCommentsPaneLayout.createSequentialGroup().addComponent(this.summaryCommentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryCommentsScrollPane, -1, 177, Short.MAX_VALUE)));
        this.CommentsSplitPane.setLeftComponent(this.summaryCommentsPane);
        this.imageCommentsPanel.setPreferredSize(new Dimension(500, 300));
        this.imageCommentsLabel.setText("Per-image comments:");
        this.imageCommentsTextArea.setColumns(20);
        this.imageCommentsTextArea.setLineWrap(true);
        this.imageCommentsTextArea.setRows(1);
        this.imageCommentsTextArea.setTabSize(3);
        this.imageCommentsTextArea.setToolTipText("Comments for each image may be entered here.");
        this.imageCommentsTextArea.setWrapStyleWord(true);
        this.imageCommentsScrollPane.setViewportView(this.imageCommentsTextArea);
        GroupLayout imageCommentsPanelLayout = new GroupLayout(this.imageCommentsPanel);
        this.imageCommentsPanel.setLayout(imageCommentsPanelLayout);
        imageCommentsPanelLayout.setHorizontalGroup(imageCommentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imageCommentsPanelLayout.createSequentialGroup().addComponent(this.imageCommentsLabel).addGap(400, 400, 400)).addComponent(this.imageCommentsScrollPane, -1, 620, Short.MAX_VALUE));
        imageCommentsPanelLayout.setVerticalGroup(imageCommentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imageCommentsPanelLayout.createSequentialGroup().addComponent(this.imageCommentsLabel).addGap(0, 0, 0).addComponent(this.imageCommentsScrollPane, -1, 429, Short.MAX_VALUE)));
        this.CommentsSplitPane.setRightComponent(this.imageCommentsPanel);
        this.tabbedPane.addTab("Comments", this.CommentsSplitPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 625, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 680, Short.MAX_VALUE).addContainerGap()));
    }

    private void showUnchangingPropertiesCheckboxActionPerformed(ActionEvent evt) {
        this.showUnchangingKeys_ = this.showUnchangingPropertiesCheckbox.isSelected();
        this.imageChangedUpdate(this.currentDisplay_);
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        this.imageChangedUpdate(this.currentDisplay_);
    }

    private void addFocusListeners() {
        FocusListener listener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    ((MetadataPanel)MetadataPanel.this).currentDisplay_.imageCache_.writeDisplaySettings();
                }
            }
        };
        this.summaryCommentsTextArea.addFocusListener(listener);
        this.imageCommentsTextArea.addFocusListener(listener);
    }

    private void addTextChangeListeners() {
        this.summaryCommentsTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void handleChange() {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    MetadataPanel.this.writeSummaryComments();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleChange();
            }
        });
        this.imageCommentsTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void handleChange() {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    MetadataPanel.this.writeImageComments();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleChange();
            }
        });
    }

    private JSONObject selectChangingTags(ImagePlus imgp, JSONObject md) {
        JSONObject mdChanging = new JSONObject();
        ImageCache cache = this.getCache(imgp);
        if (cache != null) {
            for (String key : cache.getChangingKeys()) {
                if (!md.has(key)) continue;
                try {
                    mdChanging.put(key, md.get(key));
                }
                catch (JSONException ex) {
                    try {
                        mdChanging.put(key, "");
                    }
                    catch (JSONException ex1) {
                        ReportingUtils.logError(ex1);
                    }
                }
            }
        }
        return mdChanging;
    }

    private void writeSummaryComments() {
        if (this.currentDisplay_ == null) {
            return;
        }
        this.currentDisplay_.setSummaryComment(this.summaryCommentsTextArea.getText());
    }

    private void writeImageComments() {
        if (this.currentDisplay_ == null) {
            return;
        }
        this.currentDisplay_.setImageComment(this.imageCommentsTextArea.getText());
    }

    private ImageCache getCache(ImagePlus imgp) {
        if (VirtualAcquisitionDisplay.getDisplay(imgp) != null) {
            return VirtualAcquisitionDisplay.getDisplay((ImagePlus)imgp).imageCache_;
        }
        return null;
    }

    public ImageWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public synchronized void displayChanged(ImageWindow win) {
        if (win == this.currentWindow_) {
            return;
        }
        this.currentWindow_ = win;
        if (win == null || !(win instanceof DisplayWindow)) {
            this.currentDisplay_ = null;
            this.contrastPanel_.displayChanged(null);
            this.imageChangedUpdate(this.currentDisplay_);
            return;
        }
        this.currentDisplay_ = this.getVirtualAcquisitionDisplay(win.getImagePlus());
        if (this.currentDisplay_ != null) {
            this.summaryCommentsTextArea.setText(this.currentDisplay_.getSummaryComment());
            this.imageCommentsTextArea.setText(this.currentDisplay_.getImageComment());
            this.contrastPanel_.displayChanged(this.currentDisplay_);
            this.imageChangedUpdate(this.currentDisplay_);
        }
    }

    @Override
    public void focusReceived(ImageWindow focusedWindow) {
        this.displayChanged(focusedWindow);
    }

    private VirtualAcquisitionDisplay getVirtualAcquisitionDisplay(ImagePlus imgp) {
        if (imgp == null) {
            return null;
        }
        return VirtualAcquisitionDisplay.getDisplay(imgp);
    }

    public void imageChangedUpdate(final VirtualAcquisitionDisplay disp) {
        int tabSelected = this.tabbedPane.getSelectedIndex();
        if (disp == null || !disp.isActiveDisplay()) {
            this.imageMetadataModel_.setMetadata(null);
            this.summaryMetadataModel_.setMetadata(null);
            this.summaryCommentsTextArea.setText("");
            this.imageCommentsTextArea.setText("");
            this.contrastPanel_.imageChanged();
        } else {
            if (this.updateTimer_ == null) {
                this.updateTimer_ = new Timer("Metadata update");
            }
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    MetadataPanel.this.imageCommentsTextArea.setText(disp.getImageComment());
                    AcquisitionVirtualStack stack = disp.virtualStack_;
                    if (stack != null) {
                        JSONObject md = disp.getCurrentMetadata();
                        if (md == null) {
                            MetadataPanel.this.imageMetadataModel_.setMetadata(null);
                        } else {
                            if (!MetadataPanel.this.showUnchangingKeys_) {
                                md = MetadataPanel.this.selectChangingTags(disp.getHyperImage(), md);
                            }
                            MetadataPanel.this.imageMetadataModel_.setMetadata(md);
                        }
                        MetadataPanel.this.summaryMetadataModel_.setMetadata(disp.getSummaryMetadata());
                    } else {
                        MetadataPanel.this.imageMetadataModel_.setMetadata(null);
                    }
                }
            };
            this.updateTimer_.purge();
            this.updateTimer_.schedule(task, 125L);
            if (tabSelected == 0) {
                this.contrastPanel_.imageChanged();
            }
        }
        if (tabSelected == 1 || tabSelected == 0 || tabSelected == 2) {
            // empty if block
        }
    }

    public ContrastPanel getContrastPanel() {
        return this.contrastPanel_;
    }

    public void redrawSizeBar() {
        if (this.contrastPanel_ != null) {
            this.contrastPanel_.redrawSizeBar();
        }
    }

    class MetadataTableModel
    extends AbstractTableModel {
        Vector<Vector<String>> data_ = new Vector();

        MetadataTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data_.size();
        }

        public void addRow(Vector<String> rowData) {
            this.data_.add(rowData);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public synchronized Object getValueAt(int rowIndex, int columnIndex) {
            if (this.data_.size() > rowIndex) {
                Vector<String> row = this.data_.get(rowIndex);
                if (row.size() > columnIndex) {
                    return this.data_.get(rowIndex).get(columnIndex);
                }
                return "";
            }
            return "";
        }

        public void clear() {
            this.data_.clear();
        }

        @Override
        public String getColumnName(int colIndex) {
            return MetadataPanel.this.columnNames_[colIndex];
        }

        public synchronized void setMetadata(JSONObject md) {
            this.clear();
            if (md != null) {
                Object[] keys = MDUtils.getKeys(md);
                Arrays.sort(keys);
                for (Object key : keys) {
                    Vector<String> rowData = new Vector<String>();
                    rowData.add((String)key);
                    try {
                        rowData.add(md.getString((String)key));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    this.addRow(rowData);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

