/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import ij.ImagePlus;
import ij.ImageStack;
import org.micromanager.imagedisplay.DrawEvent;
import org.micromanager.imagedisplay.IMMImagePlus;
import org.micromanager.imagedisplay.MouseIntensityEvent;

public class MMImagePlus
extends ImagePlus
implements IMMImagePlus {
    private EventBus bus_;

    MMImagePlus(String title, ImageStack stack, EventBus bus) {
        super(title, stack);
        this.bus_ = bus;
    }

    public int getImageStackSize() {
        return this.nChannels * this.nSlices * this.nFrames;
    }

    public int getStackSize() {
        return this.getImageStackSize();
    }

    @Override
    public int getNChannelsUnverified() {
        return this.nChannels;
    }

    @Override
    public int getNSlicesUnverified() {
        return this.nSlices;
    }

    @Override
    public int getNFramesUnverified() {
        return this.nFrames;
    }

    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        this.bus_.post((Object)new MouseIntensityEvent(x, y, this.getPixel(x, y)));
    }

    @Override
    public void setNChannelsUnverified(int nChannels) {
        this.nChannels = nChannels;
    }

    @Override
    public void setNSlicesUnverified(int nSlices) {
        this.nSlices = nSlices;
    }

    @Override
    public void setNFramesUnverified(int nFrames) {
        this.nFrames = nFrames;
    }

    private void superDraw() {
        if (this.win != null) {
            super.getCanvas().repaint();
        }
    }

    public void draw() {
        this.bus_.post((Object)new DrawEvent());
        this.getWindow().getCanvas().setImageUpdated();
        this.superDraw();
    }

    @Override
    public void drawWithoutUpdate() {
        this.getWindow().getCanvas().setImageUpdated();
        this.superDraw();
    }

    @Override
    public int[] getPixelIntensities(int x, int y) {
        return super.getPixel(x, y);
    }
}

