/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.LUT;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.micromanager.imagedisplay.DrawEvent;
import org.micromanager.imagedisplay.IMMImagePlus;
import org.micromanager.imagedisplay.MouseIntensityEvent;
import org.micromanager.utils.CanvasPaintPending;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;

public class MMCompositeImage
extends CompositeImage
implements IMMImagePlus {
    private ImagePlus hyperImage_;
    private String title_;
    private EventBus bus_;

    MMCompositeImage(ImagePlus imgp, int type, String title, EventBus bus) {
        super(imgp, type);
        this.hyperImage_ = imgp;
        this.title_ = title;
        this.bus_ = bus;
    }

    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        this.bus_.post((Object)new MouseIntensityEvent(x, y, this.getPixel(x, y)));
    }

    public String getTitle() {
        return this.title_;
    }

    public int getImageStackSize() {
        return this.nChannels * this.nSlices * this.nFrames;
    }

    public int getStackSize() {
        return this.getImageStackSize();
    }

    @Override
    public int getNChannelsUnverified() {
        return this.nChannels;
    }

    @Override
    public int getNSlicesUnverified() {
        return this.nSlices;
    }

    @Override
    public int getNFramesUnverified() {
        return this.nFrames;
    }

    @Override
    public void setNChannelsUnverified(int nChannels) {
        this.nChannels = nChannels;
    }

    @Override
    public void setNSlicesUnverified(int nSlices) {
        this.nSlices = nSlices;
    }

    @Override
    public void setNFramesUnverified(int nFrames) {
        this.nFrames = nFrames;
    }

    private void superReset() {
        super.reset();
    }

    public void reset() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.reset();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MMCompositeImage.this.superReset();
                }
            });
        }
    }

    public synchronized void setMode(int mode) {
        this.superSetMode(mode);
    }

    private void superSetMode(int mode) {
        super.setMode(mode);
    }

    public synchronized void setChannelLut(LUT lut) {
        this.superSetLut(lut);
    }

    private void superSetLut(LUT lut) {
        super.setChannelLut(lut);
    }

    public synchronized void updateImage() {
        this.superUpdateImage();
    }

    private void superUpdateImage() {
        Object curVal = null;
        try {
            curVal = JavaUtils.getRestrictedFieldValue(null, ContrastAdjuster.class, "instance");
            JavaUtils.setRestrictedFieldValue(null, ContrastAdjuster.class, "instance", null);
        }
        catch (NoSuchFieldException e) {
            ReportingUtils.logError(e, "ImageJ ContrastAdjuster doesn't have field named instance");
        }
        super.updateImage();
        try {
            JavaUtils.setRestrictedFieldValue(null, ContrastAdjuster.class, "instance", curVal);
        }
        catch (NoSuchFieldException e) {
            ReportingUtils.logError(e, "Couldn't restore ImageJ ContrastAdjuster instance.");
        }
    }

    public void updateAndDraw(boolean forceUpdateAndPaint) {
        if (forceUpdateAndPaint) {
            CanvasPaintPending.removePaintPending(this.hyperImage_.getCanvas(), this);
            this.updateAndDraw();
        } else {
            this.updateAndDraw();
        }
    }

    public void updateAndDraw() {
        if (CanvasPaintPending.isMyPaintPending(super.getCanvas(), this)) {
            return;
        }
        CanvasPaintPending.setPaintPending(super.getCanvas(), this);
        try {
            this.superUpdateImage();
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            ReportingUtils.logError(aex);
            CanvasPaintPending.removePaintPending(super.getCanvas(), this);
            return;
        }
        this.bus_.post((Object)new DrawEvent());
        try {
            GUIUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaUtils.invokeRestrictedMethod((Object)this, ImagePlus.class, "notifyListeners", 2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    MMCompositeImage.this.superDraw();
                }
            });
        }
        catch (InterruptedException e) {
            ReportingUtils.logError(e);
        }
        catch (InvocationTargetException e) {
            ReportingUtils.logError(e);
        }
    }

    private void superDraw() {
        if (this.win != null) {
            super.getCanvas().repaint();
        }
    }

    public void draw() {
        this.bus_.post((Object)new DrawEvent());
        this.superDraw();
    }

    @Override
    public void drawWithoutUpdate() {
        super.getCanvas().setPaintPending(true);
        this.getWindow().getCanvas().setImageUpdated();
        this.superDraw();
    }

    @Override
    public int[] getPixelIntensities(int x, int y) {
        return super.getPixel(x, y);
    }
}

