/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.swtdesigner.SwingResourceManager;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.imagedisplay.FPSEvent;
import org.micromanager.imagedisplay.IMMImagePlus;
import org.micromanager.imagedisplay.MMCompositeImage;
import org.micromanager.imagedisplay.MouseIntensityEvent;
import org.micromanager.imagedisplay.NewImageEvent;
import org.micromanager.imagedisplay.ScrollerPanel;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.internalinterfaces.LiveModeListener;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class HyperstackControls
extends DisplayControls
implements LiveModeListener {
    private static final int DEFAULT_FPS = 10;
    private static final double MAX_FPS = 5000.0;
    private static final int CONTROLS_HEIGHT = 65;
    private final VirtualAcquisitionDisplay display_;
    private EventBus bus_;
    private int mouseX_ = -1;
    private int mouseY_ = -1;
    private JPanel subPanel_;
    private ScrollerPanel scrollerPanel_;
    private JLabel pixelInfoLabel_;
    private JLabel imageInfoLabel_;
    private JLabel countdownLabel_;
    private JButton showFolderButton_;
    private JButton saveButton_;
    private JLabel fpsLabel_;
    private JTextField fpsField_;
    private JButton abortButton_;
    private JToggleButton pauseAndResumeToggleButton_;
    private JButton snapButton_;
    private JButton snapToAlbumButton_;
    private JButton liveButton_;

    public HyperstackControls(VirtualAcquisitionDisplay display, EventBus bus, boolean shouldUseLiveControls, boolean isAcquisition) {
        super(new FlowLayout(3));
        this.bus_ = bus;
        this.initComponents(display, shouldUseLiveControls, isAcquisition);
        this.display_ = display;
        this.bus_.register((Object)this);
        MMStudio.getInstance().getSnapLiveManager().addLiveModeListener(this);
    }

    private void initComponents(VirtualAcquisitionDisplay display, final boolean shouldUseLiveControls, boolean isAcquisition) {
        this.subPanel_ = new JPanel((LayoutManager)new MigLayout("insets 0, fillx, align center"));
        JPanel labelsPanel = new JPanel((LayoutManager)new MigLayout("insets 0"));
        this.pixelInfoLabel_ = new JLabel("                                         ");
        this.pixelInfoLabel_.setMinimumSize(new Dimension(150, 10));
        this.pixelInfoLabel_.setFont(new Font("Lucida Grande", 0, 10));
        labelsPanel.add(this.pixelInfoLabel_);
        this.imageInfoLabel_ = new JLabel("                                         ");
        this.imageInfoLabel_.setMinimumSize(new Dimension(150, 10));
        this.imageInfoLabel_.setFont(new Font("Lucida Grande", 0, 10));
        labelsPanel.add(this.imageInfoLabel_);
        this.countdownLabel_ = new JLabel("                                         ");
        this.countdownLabel_.setMinimumSize(new Dimension(150, 10));
        this.countdownLabel_.setFont(new Font("Lucida Grande", 0, 10));
        labelsPanel.add(this.countdownLabel_);
        this.subPanel_.add((Component)labelsPanel, "span, growx, align center, wrap");
        int numChannels = 0;
        int numFrames = 0;
        int numSlices = 0;
        int numPositions = 0;
        if (!isAcquisition) {
            numChannels = display.getNumChannels();
            numFrames = display.getImageCache().lastAcquiredFrame() + 1;
            numSlices = display.getNumSlices();
            JSONObject tags = display.getImageCache().getSummaryMetadata();
            numPositions = 0;
            try {
                numPositions = MDUtils.getNumPositions(tags);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.scrollerPanel_ = new ScrollerPanel(this.bus_, new String[]{"channel", "position", "time", "z"}, new Integer[]{numChannels, numPositions, numFrames, numSlices}, 10.0);
        this.subPanel_.add((Component)this.scrollerPanel_, "span, growx, wrap 0px");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0", "[]0[]0[]0[]0[]0[]"));
        this.showFolderButton_ = new JButton();
        this.saveButton_ = new JButton();
        buttonPanel.add(this.showFolderButton_);
        buttonPanel.add(this.saveButton_);
        this.showFolderButton_.setBackground(new Color(255, 255, 255));
        this.showFolderButton_.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/folder.png")));
        this.showFolderButton_.setToolTipText("Show containing folder");
        this.showFolderButton_.setFocusable(false);
        this.showFolderButton_.setHorizontalTextPosition(0);
        this.showFolderButton_.setMaximumSize(new Dimension(30, 28));
        this.showFolderButton_.setMinimumSize(new Dimension(30, 28));
        this.showFolderButton_.setPreferredSize(new Dimension(30, 28));
        this.showFolderButton_.setVerticalTextPosition(3);
        this.showFolderButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyperstackControls.this.showFolderButtonActionPerformed(evt);
            }
        });
        this.saveButton_.setBackground(new Color(255, 255, 255));
        this.saveButton_.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/disk.png")));
        this.saveButton_.setToolTipText("Save as...");
        this.saveButton_.setFocusable(false);
        this.saveButton_.setHorizontalTextPosition(0);
        this.saveButton_.setMaximumSize(new Dimension(30, 28));
        this.saveButton_.setMinimumSize(new Dimension(30, 28));
        this.saveButton_.setPreferredSize(new Dimension(30, 28));
        this.saveButton_.setVerticalTextPosition(3);
        this.saveButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyperstackControls.this.saveButtonActionPerformed(evt, shouldUseLiveControls);
            }
        });
        this.fpsLabel_ = new JLabel("                      ", 4);
        this.fpsLabel_.setFont(new Font("Lucida Grande", 0, 10));
        this.fpsLabel_.setFocusable(false);
        if (shouldUseLiveControls) {
            this.makeSnapLiveControls(buttonPanel);
        } else {
            this.makeStandardControls(buttonPanel);
        }
        this.subPanel_.add(buttonPanel);
        this.add(this.subPanel_);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension curSize = HyperstackControls.this.getSize();
                HyperstackControls.this.subPanel_.setSize(new Dimension(curSize.width - 10, curSize.height - 10));
                HyperstackControls.this.invalidate();
                HyperstackControls.this.validate();
            }
        });
    }

    private void makeSnapLiveControls(JPanel buttonPanel) {
        this.snapButton_ = new JButton();
        this.snapButton_.setFocusable(false);
        this.snapButton_.setIconTextGap(6);
        this.snapButton_.setText("Snap");
        this.snapButton_.setMinimumSize(new Dimension(90, 28));
        this.snapButton_.setPreferredSize(new Dimension(90, 28));
        this.snapButton_.setMaximumSize(new Dimension(90, 28));
        this.snapButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/camera.png"));
        this.snapButton_.setFont(new Font("Arial", 0, 10));
        this.snapButton_.setToolTipText("Snap single image");
        this.snapButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MMStudio.getInstance().doSnap();
            }
        });
        this.liveButton_ = new JButton();
        this.liveButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/camera_go.png"));
        this.liveButton_.setIconTextGap(6);
        this.liveButton_.setText("Live");
        this.liveButton_.setMinimumSize(new Dimension(90, 28));
        this.liveButton_.setPreferredSize(new Dimension(90, 28));
        this.liveButton_.setMaximumSize(new Dimension(90, 28));
        this.liveButton_.setFocusable(false);
        this.liveButton_.setToolTipText("Continuous live view");
        this.liveButton_.setFont(new Font("Arial", 0, 10));
        this.liveButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperstackControls.this.liveButtonAction();
            }
        });
        this.snapToAlbumButton_ = new JButton("Album");
        this.snapToAlbumButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/arrow_right.png"));
        this.snapToAlbumButton_.setIconTextGap(6);
        this.snapToAlbumButton_.setToolTipText("Add current image to album");
        this.snapToAlbumButton_.setFocusable(false);
        this.snapToAlbumButton_.setMaximumSize(new Dimension(90, 28));
        this.snapToAlbumButton_.setMinimumSize(new Dimension(90, 28));
        this.snapToAlbumButton_.setPreferredSize(new Dimension(90, 28));
        this.snapToAlbumButton_.setFont(new Font("Arial", 0, 10));
        this.snapToAlbumButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyperstackControls.this.snapToAlbumButtonActionPerformed();
            }
        });
        buttonPanel.add(this.snapButton_);
        buttonPanel.add(this.liveButton_);
        buttonPanel.add(this.snapToAlbumButton_);
        this.fpsLabel_.setText("                          ");
        buttonPanel.add((Component)this.fpsLabel_, "span, wrap, width 120px, align right");
    }

    private void makeStandardControls(JPanel buttonPanel) {
        this.fpsField_ = new JTextField(String.valueOf(10), 4);
        this.abortButton_ = new JButton();
        this.pauseAndResumeToggleButton_ = new JToggleButton();
        buttonPanel.add(this.abortButton_);
        buttonPanel.add(this.pauseAndResumeToggleButton_);
        JPanel fpsPanel = new JPanel((LayoutManager)new MigLayout("insets 0"));
        fpsPanel.add(this.fpsLabel_);
        fpsPanel.add(this.fpsField_);
        buttonPanel.add((Component)fpsPanel, "span, gapleft push, wrap");
        this.fpsField_.setToolTipText("Set the speed at which the acquisition is played back.");
        this.fpsField_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HyperstackControls.this.fpsField_FocusLost(evt);
            }
        });
        this.fpsField_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HyperstackControls.this.fpsField_KeyReleased(evt);
            }
        });
        this.abortButton_.setBackground(new Color(255, 255, 255));
        this.abortButton_.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/cancel.png")));
        this.abortButton_.setToolTipText("Stop acquisition");
        this.abortButton_.setFocusable(false);
        this.abortButton_.setHorizontalTextPosition(0);
        this.abortButton_.setMaximumSize(new Dimension(30, 28));
        this.abortButton_.setMinimumSize(new Dimension(30, 28));
        this.abortButton_.setPreferredSize(new Dimension(30, 28));
        this.abortButton_.setVerticalTextPosition(3);
        this.abortButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyperstackControls.this.abortButtonActionPerformed(evt);
            }
        });
        this.pauseAndResumeToggleButton_.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/control_pause.png")));
        this.pauseAndResumeToggleButton_.setToolTipText("Pause acquisition");
        this.pauseAndResumeToggleButton_.setFocusable(false);
        this.pauseAndResumeToggleButton_.setMargin(new Insets(0, 0, 0, 0));
        this.pauseAndResumeToggleButton_.setMaximumSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton_.setMinimumSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton_.setPreferredSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton_.setPressedIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/resultset_next.png")));
        this.pauseAndResumeToggleButton_.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/resultset_next.png")));
        this.pauseAndResumeToggleButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HyperstackControls.this.pauseAndResumeToggleButtonActionPerformed(evt);
            }
        });
    }

    @Subscribe
    public void onMouseMoved(MouseIntensityEvent event) {
        this.mouseX_ = event.x_;
        this.mouseY_ = event.y_;
        this.setPixelInfo(this.mouseX_, this.mouseY_, event.intensities_[0]);
    }

    private void setPixelInfo(int x, int y, int intensity) {
        this.pixelInfoLabel_.setText(String.format("x=%d, y=%d, value=%d", x, y, intensity));
    }

    @Subscribe
    public void onSetImage(ScrollerPanel.SetImageEvent event) {
        int position = -1;
        int channel = -1;
        int frame = -1;
        int slice = -1;
        try {
            position = event.getPositionForAxis("position");
            this.display_.updatePosition(position);
            channel = event.getPositionForAxis("channel") + 1;
            frame = event.getPositionForAxis("time") + 1;
            slice = event.getPositionForAxis("z") + 1;
            ImagePlus plus = this.display_.getHyperImage();
            if (plus instanceof IMMImagePlus) {
                IMMImagePlus tmp = (IMMImagePlus)plus;
                if (plus.getNFrames() < frame) {
                    tmp.setNFramesUnverified(frame);
                }
                if (plus.getNChannels() < channel) {
                    tmp.setNChannelsUnverified(channel);
                }
                if (plus.getNSlices() < slice) {
                    tmp.setNSlicesUnverified(slice);
                }
            } else {
                MMCompositeImage tmp = (MMCompositeImage)plus;
                if (plus.getNFrames() < frame) {
                    tmp.setNFramesUnverified(frame);
                }
                if (plus.getNChannels() < channel) {
                    tmp.setNChannelsUnverified(channel);
                }
                if (plus.getNSlices() < slice) {
                    tmp.setNSlicesUnverified(slice);
                }
            }
            plus.setPosition(channel, slice, frame);
            this.display_.updateAndDraw(true);
        }
        catch (Exception e) {
            ReportingUtils.logError(e, String.format("Failed to set image at %d, %d, %d, %d", position, frame, slice, channel));
        }
    }

    @Subscribe
    public void onNewImage(NewImageEvent event) {
        if (this.mouseX_ != -1 && this.mouseY_ != -1) {
            try {
                int intensity = this.display_.getIntensityAt(this.mouseX_, this.mouseY_);
                this.setPixelInfo(this.mouseX_, this.mouseY_, intensity);
            }
            catch (Exception e) {
                ReportingUtils.logError(e, "Error in HyperstackControls onNewImage");
            }
        }
    }

    @Subscribe
    public void onLayoutChange(ScrollerPanel.LayoutChangedEvent event) {
        this.invalidate();
        this.validate();
    }

    private void showFolderButtonActionPerformed(ActionEvent evt) {
        this.display_.showFolder();
    }

    private void fpsField_FocusLost(FocusEvent evt) {
        this.updateFPS();
    }

    private void fpsField_KeyReleased(KeyEvent evt) {
        this.updateFPS();
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.display_.abort();
    }

    private void pauseAndResumeToggleButtonActionPerformed(ActionEvent evt) {
        this.display_.pause();
    }

    private void saveButtonActionPerformed(ActionEvent evt, final boolean isSimpleDisplay) {
        new Thread(){

            @Override
            public void run() {
                HyperstackControls.this.display_.saveAs(!isSimpleDisplay);
            }
        }.start();
    }

    private void snapToAlbumButtonActionPerformed() {
        try {
            MMStudio gui = MMStudio.getInstance();
            gui.copyFromLiveModeToAlbum(this.display_);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    private void liveButtonAction() {
        MMStudio.getInstance().enableLiveMode(!MMStudio.getInstance().isLiveModeOn());
    }

    private void updateFPS() {
        if (this.fpsField_ != null) {
            try {
                double fps = NumberUtils.displayStringToDouble(this.fpsField_.getText());
                fps = Math.max(1.0, Math.min(fps, 5000.0));
                this.scrollerPanel_.setFramesPerSecond(fps);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void setImageInfoLabel(String text) {
        this.imageInfoLabel_.setText(text);
    }

    private void updateStatusLine(JSONObject tags) {
        String status = "";
        try {
            try {
                String xyPosition = MDUtils.getPositionName(tags);
                if (xyPosition != null && !xyPosition.contentEquals("null")) {
                    status = status + xyPosition + ", ";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                double seconds = MDUtils.getElapsedTimeMs(tags) / 1000.0;
                status = status + HyperstackControls.elapsedTimeDisplayString(seconds);
            }
            catch (JSONException ex) {
                ReportingUtils.logError("MetaData did not contain ElapsedTime-ms field");
            }
            try {
                String zPosition = NumberUtils.doubleToDisplayString(MDUtils.getZPositionUm(tags));
                status = status + ", z: " + zPosition + " um";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String chan = MDUtils.getChannelName(tags);
                if (chan != null && !chan.contentEquals("null")) {
                    status = status + ", " + chan;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setImageInfoLabel(status);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    public static String elapsedTimeDisplayString(double seconds) {
        long wholeSeconds = (long)Math.floor(seconds);
        double fraction = seconds - (double)wholeSeconds;
        long hours = TimeUnit.SECONDS.toHours(wholeSeconds);
        wholeSeconds -= TimeUnit.HOURS.toSeconds(hours);
        String hoursString = "";
        if (hours > 0L) {
            hoursString = hours + "h ";
        }
        long minutes = TimeUnit.SECONDS.toMinutes(wholeSeconds);
        wholeSeconds -= TimeUnit.MINUTES.toSeconds(minutes);
        String minutesString = "";
        if (minutes > 0L) {
            minutesString = minutes + "m ";
        }
        String secondsString = hours == 0L && fraction > 0.01 ? String.format("%.2fs", (double)wholeSeconds + fraction) : wholeSeconds + "s";
        return hoursString + minutesString + secondsString;
    }

    @Override
    public void newImageUpdate(JSONObject tags) {
        if (tags == null) {
            return;
        }
        this.updateStatusLine(tags);
        if (!this.display_.acquisitionIsRunning() || this.display_.getNextWakeTime() <= 0L) {
            return;
        }
        final long nextImageTime = this.display_.getNextWakeTime();
        if (System.nanoTime() / 1000000L >= nextImageTime) {
            return;
        }
        try {
            final Timer timer = new Timer("Next frame display");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    double timeRemainingS = ((double)nextImageTime - (double)System.nanoTime() / 1000000.0) / 1000.0;
                    if (timeRemainingS > 0.0 && HyperstackControls.this.display_.acquisitionIsRunning()) {
                        HyperstackControls.this.countdownLabel_.setText(String.format("Next frame: %.2fs", timeRemainingS));
                    } else {
                        timer.cancel();
                        HyperstackControls.this.countdownLabel_.setText("");
                    }
                }
            };
            timer.schedule(task, 500L, 100L);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public void acquiringImagesUpdate(boolean state) {
        if (this.abortButton_ != null) {
            this.abortButton_.setEnabled(state);
        }
        if (this.pauseAndResumeToggleButton_ != null) {
            this.pauseAndResumeToggleButton_.setEnabled(state);
        }
    }

    @Override
    public void imagesOnDiskUpdate(boolean enabled) {
        this.showFolderButton_.setEnabled(enabled);
    }

    @Override
    public void prepareForClose() {
        this.scrollerPanel_.prepareForClose();
        this.bus_.unregister((Object)this);
        MMStudio.getInstance().getSnapLiveManager().removeLiveModeListener(this);
    }

    @Override
    public void setPosition(int p) {
        this.scrollerPanel_.setPosition("position", p);
    }

    @Override
    public int getPosition() {
        return this.scrollerPanel_.getPosition("position");
    }

    @Override
    public void setChannel(int c) {
        this.scrollerPanel_.setPosition("channel", c);
    }

    @Subscribe
    public void onFPSUpdate(FPSEvent event) {
        String newLabel = "";
        if (event.getDataFPS() != 0.0) {
            newLabel = String.format("FPS: %.1f (display %.1f)", event.getDataFPS(), event.getDisplayFPS());
        } else if (this.fpsField_ != null) {
            newLabel = "Playback FPS:";
        }
        this.fpsLabel_.setText(newLabel);
    }

    @Override
    public void liveModeEnabled(boolean isEnabled) {
        if (this.liveButton_ == null) {
            return;
        }
        String label = isEnabled ? "Stop Live" : "Live";
        String iconPath = isEnabled ? "/org/micromanager/icons/cancel.png" : "/org/micromanager/icons/camera_go.png";
        this.liveButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, iconPath));
        this.liveButton_.setText(label);
        if (this.snapButton_ != null) {
            this.snapButton_.setEnabled(!isEnabled);
        }
    }

    @Override
    public int getNumPositions() {
        return this.scrollerPanel_.getMaxPosition("position");
    }
}

