/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import net.miginfocom.swing.MigLayout;
import org.micromanager.MMStudio;
import org.micromanager.imagedisplay.MMCompositeImage;
import org.micromanager.imagedisplay.ScrollerPanel;
import org.micromanager.imagedisplay.UpdateTitleEvent;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.utils.CanvasPaintPending;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public final class DisplayWindow
extends StackWindow {
    private boolean closed_ = false;
    private final EventBus bus_;
    private ImagePlus plus_;
    private JPanel canvasPanel_;
    private Dimension canvasSizeLastPack_;
    private static final int DEFAULTPOSX = 300;
    private static final int DEFAULTPOSY = 100;
    private static Preferences displayPrefs_;
    private static final String WINDOWPOSX = "WindowPosX";
    private static final String WINDOWPOSY = "WindowPosY";

    public DisplayWindow(ImagePlus plus, DisplayControls controls, final EventBus bus) {
        super(plus);
        this.plus_ = plus;
        this.bus_ = bus;
        this.initializePrefs();
        int posX = 300;
        int posY = 100;
        if (displayPrefs_ != null && GUIUtils.getGraphicsConfigurationContaining(posX = displayPrefs_.getInt(WINDOWPOSX, 300), posY = displayPrefs_.getInt(WINDOWPOSY, 100)) == null) {
            posX = 300;
            posY = 100;
        }
        this.setLocation(posX, posY);
        MMStudio.getInstance().addMMBackgroundListener((Component)((Object)this));
        this.setBackground(MMStudio.getInstance().getBackgroundColor());
        this.bus_.register((Object)this);
        if (this.cSelector != null) {
            this.remove((Component)this.cSelector);
        }
        if (this.tSelector != null) {
            this.remove((Component)this.tSelector);
        }
        if (this.zSelector != null) {
            this.remove((Component)this.zSelector);
        }
        this.setLayout((LayoutManager)new MigLayout("insets 1, fillx, filly", "[grow, fill]", "[grow, fill]related[]"));
        this.remove((Component)this.ic);
        CanvasPaintPending.removeAllPaintPending(this.ic);
        this.ic = new ImageCanvas(this.plus_){

            public void paint(Graphics g) {
                super.paint(g);
                if (DisplayWindow.this.plus_.isComposite()) {
                    Color color = ((CompositeImage)DisplayWindow.this.plus_).getChannelColor();
                    if (Color.green.equals(color)) {
                        color = new Color(0, 180, 0);
                    }
                    g.setColor(color);
                }
                Rectangle rect = this.getBounds();
                int drawnWidth = (int)((double)DisplayWindow.this.plus_.getWidth() * DisplayWindow.this.ic.getMagnification());
                int drawnHeight = (int)((double)DisplayWindow.this.plus_.getHeight() * DisplayWindow.this.ic.getMagnification());
                int widthSlop = (rect.width - drawnWidth) / 2;
                int heightSlop = (rect.height - drawnHeight) / 2;
                rect.x += widthSlop;
                rect.y += heightSlop;
                rect.width = drawnWidth;
                rect.height = drawnHeight;
                rect.y -= this.getBounds().y;
                if (!Prefs.noBorder && !IJ.isLinux()) {
                    g.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
                }
                Dimension size = this.getSize();
                g.clearRect(0, 0, size.width, heightSlop - 1);
                g.clearRect(0, 0, widthSlop - 1, size.height);
                g.clearRect(widthSlop + drawnWidth + 1, 0, widthSlop, size.height);
                g.clearRect(0, heightSlop + drawnHeight + 1, size.width, heightSlop);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.dstWidth + 2, this.dstHeight + 2);
            }
        };
        this.ic.setMinimumSize(new Dimension(16, 16));
        this.canvasPanel_ = new JPanel();
        this.canvasPanel_.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        MMStudio.getInstance().addMMBackgroundListener(this.canvasPanel_);
        this.canvasPanel_.setBackground(MMStudio.getInstance().getBackgroundColor());
        this.canvasPanel_.add((Component)this.ic);
        this.add(this.canvasPanel_, "align center, wrap");
        this.add(controls, "align center, wrap, growx");
        this.canvasPanel_.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = DisplayWindow.this.canvasPanel_.getSize();
                double dataAspect = (double)DisplayWindow.this.plus_.getWidth() / (double)DisplayWindow.this.plus_.getHeight();
                double viewAspect = (double)size.width / (double)size.height;
                int viewWidth = size.width;
                int viewHeight = size.height;
                if (viewAspect > dataAspect) {
                    viewWidth = (int)((double)viewHeight * dataAspect);
                } else {
                    viewHeight = (int)((double)viewWidth / dataAspect);
                }
                DisplayWindow.this.ic.setDrawingSize((int)Math.ceil(viewWidth), (int)Math.ceil(viewHeight));
                Rectangle curRect = DisplayWindow.this.ic.getSrcRect();
                int xCenter = curRect.x + curRect.width / 2;
                int yCenter = curRect.y + curRect.height / 2;
                double curMag = DisplayWindow.this.ic.getMagnification();
                int newWidth = (int)Math.ceil((double)viewWidth / curMag);
                int newHeight = (int)Math.ceil((double)viewHeight / curMag);
                int xCorner = xCenter - newWidth / 2;
                int yCorner = yCenter - newHeight / 2;
                Rectangle viewRect = new Rectangle(xCorner, yCorner, newWidth, newHeight);
                DisplayWindow.this.ic.setSourceRect(viewRect);
                DisplayWindow.this.doLayout();
            }
        });
        this.ic.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (Toolbar.getToolId() == 11) {
                    bus.post((Object)new UpdateTitleEvent());
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (DisplayWindow.this.plus_ instanceof MMCompositeImage) {
                    ((MMCompositeImage)DisplayWindow.this.plus_).updateAndDraw(true);
                } else {
                    DisplayWindow.this.plus_.updateAndDraw();
                }
            }
        });
        this.zoomToPreferredSize();
        this.pack();
    }

    public void paint(Graphics g) {
        this.drawInfo(g);
    }

    private void initializePrefs() {
        if (displayPrefs_ == null) {
            try {
                displayPrefs_ = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
    }

    private void zoomToPreferredSize() {
        Point location = this.getLocation();
        double mag = MMStudio.getInstance().getPreferredWindowMag();
        if (mag < this.ic.getMagnification()) {
            while (mag < this.ic.getMagnification() && Math.abs(mag - this.ic.getMagnification()) > 0.01) {
                this.ic.zoomOut(this.ic.getWidth() / 2, this.ic.getHeight() / 2);
            }
        } else if (mag > this.ic.getMagnification()) {
            while (mag > this.ic.getMagnification() && Math.abs(mag - this.ic.getMagnification()) > 0.01) {
                this.ic.zoomIn(this.ic.getWidth() / 2, this.ic.getHeight() / 2);
            }
        }
        Rectangle rect = GUIUtils.getMaxWindowSizeForPoint(location.x, location.y);
        if (location.x + this.getWidth() > rect.x + rect.width) {
            location.x -= location.x + this.getWidth() - rect.x - rect.width;
        }
        if (location.y + this.getHeight() > rect.y + rect.height) {
            location.y -= location.y + this.getHeight() - rect.y - rect.height;
        }
        this.setLocation(location);
    }

    public boolean close() {
        this.windowClosing(null);
        return this.closed_;
    }

    public void windowClosing(WindowEvent e) {
        if (!this.closed_) {
            this.bus_.post((Object)new RequestToCloseEvent(this));
        }
    }

    @Subscribe
    public void onLayoutChange(ScrollerPanel.LayoutChangedEvent event) {
        this.pack();
    }

    public void forceClosed() {
        try {
            super.close();
        }
        catch (NullPointerException ex) {
            ReportingUtils.showError((Throwable)ex, "Null pointer error in ImageJ code while closing window");
        }
        MMStudio.getInstance().removeMMBackgroundListener((Component)((Object)this));
        MMStudio.getInstance().removeMMBackgroundListener(this.canvasPanel_);
        this.closed_ = true;
    }

    public void windowClosed(WindowEvent E) {
        try {
            super.windowClosed(E);
        }
        catch (NullPointerException ex) {
            ReportingUtils.showError((Throwable)ex, "Null pointer error in ImageJ code while closing window");
        }
    }

    public void windowActivated(WindowEvent e) {
        if (!this.isClosed()) {
            super.windowActivated(e);
        }
    }

    public Component[] getComponents() {
        StackTraceElement[] stack;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("Orthogonal_Views")) continue;
            return new Component[]{this.ic, this.cSelector};
        }
        return super.getComponents();
    }

    public void pack() {
        Rectangle displayBounds = GUIUtils.getMaxWindowSizeForPoint(this.getX(), this.getY());
        int displayWidth = displayBounds.width;
        int displayHeight = displayBounds.height;
        if (this.canvasSizeLastPack_ == null) {
            this.canvasSizeLastPack_ = this.ic.getSize();
        }
        Dimension origWindowSize = this.getSize();
        Dimension desiredCanvasSize = this.ic.getPreferredSize();
        if (desiredCanvasSize.width + 50 > displayWidth || desiredCanvasSize.height + 150 > displayHeight) {
            double nextMag;
            double origMagnification;
            double curMag = origMagnification = this.ic.getMagnification();
            Dimension newSize = new Dimension(desiredCanvasSize);
            while ((newSize.width + 50 > displayWidth || newSize.height + 150 > displayHeight) && (nextMag = ImageCanvas.getLowerZoomLevel((double)curMag)) != curMag) {
                curMag = nextMag;
                newSize = new Dimension((int)((double)desiredCanvasSize.width * curMag / origMagnification), (int)((double)desiredCanvasSize.height * curMag / origMagnification));
            }
            this.ic.setMagnification(curMag);
            this.ic.zoomOut(displayWidth - 50, displayHeight - 150);
        }
        int deltaWidth = origWindowSize.width - this.canvasSizeLastPack_.width;
        int deltaHeight = origWindowSize.height - this.canvasSizeLastPack_.height;
        if (this.canvasPanel_ != null) {
            this.canvasPanel_.setSize(this.ic.getSize());
        }
        this.setSize(this.ic.getSize().width + deltaWidth, this.ic.getSize().height + deltaHeight);
        this.canvasSizeLastPack_ = this.ic.getSize();
        super.pack();
    }

    public static class RequestToCloseEvent {
        public DisplayWindow window_;

        public RequestToCloseEvent(DisplayWindow window) {
            if (displayPrefs_ != null) {
                displayPrefs_.putInt(DisplayWindow.WINDOWPOSX, window.getLocation().x);
                displayPrefs_.putInt(DisplayWindow.WINDOWPOSY, window.getLocation().y);
            }
            this.window_ = window;
        }
    }
}

