/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputAdapter;
import net.miginfocom.swing.MigLayout;
import org.micromanager.imagedisplay.ScrollbarAnimateIcon;
import org.micromanager.imagedisplay.ScrollbarLockIcon;

public class AxisScroller
extends JPanel {
    private String axis_;
    private EventBus bus_;
    private boolean isAnimated_;
    private int rememberedPosition_ = -1;
    private boolean shouldIgnoreScrollbarEvent_;
    private ScrollbarAnimateIcon animateIcon_;
    private final JScrollBar scrollbar_;
    private ScrollbarLockIcon lock_;
    private static final int HEIGHT = 14;
    private static final int LABEL_WIDTH = 24;

    public AxisScroller(String axis, int maximum, final EventBus bus, boolean canAnimate) {
        super((LayoutManager)new MigLayout("insets 0, fillx", "[][grow][]"));
        this.axis_ = axis;
        this.bus_ = bus;
        this.shouldIgnoreScrollbarEvent_ = false;
        this.animateIcon_ = new ScrollbarAnimateIcon(axis);
        Dimension size = new Dimension(24, 14);
        this.animateIcon_.setPreferredSize(size);
        this.animateIcon_.setMaximumSize(size);
        if (canAnimate) {
            this.animateIcon_.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!AxisScroller.this.lock_.getIsLocked()) {
                        AxisScroller.this.isAnimated_ = !AxisScroller.this.isAnimated_;
                        AxisScroller.this.animateIcon_.setIsAnimated(AxisScroller.this.isAnimated_);
                    }
                    bus.post((Object)new AnimationToggleEvent(AxisScroller.this, AxisScroller.this.isAnimated_));
                }
            });
        }
        this.add((Component)this.animateIcon_, "grow 0");
        this.scrollbar_ = new JScrollBar(0, 0, 1, 0, maximum);
        this.scrollbar_.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                AxisScroller.this.handleScrollerMotion();
            }
        });
        this.add((Component)this.scrollbar_, "growx");
        this.lock_ = new ScrollbarLockIcon(axis, this.bus_);
        this.add((Component)this.lock_, "grow 0");
        bus.register((Object)this);
    }

    private void handleScrollerMotion() {
        if (this.shouldIgnoreScrollbarEvent_) {
            this.shouldIgnoreScrollbarEvent_ = false;
        } else {
            this.bus_.post((Object)new ScrollPositionEvent(this, this.scrollbar_.getValue()));
        }
    }

    @Subscribe
    public void onLockToggle(ScrollbarLockIcon.LockEvent event) {
        if (!event.getAxis().equals(this.axis_)) {
            return;
        }
        if (this.lock_.getIsLocked() && this.isAnimated_) {
            this.isAnimated_ = false;
            this.animateIcon_.setIsAnimated(this.isAnimated_);
            this.bus_.post((Object)new AnimationToggleEvent(this, this.isAnimated_));
        }
        this.animateIcon_.setEnabled(!this.lock_.getIsLocked());
    }

    public void advancePosition(int offset, boolean shouldPostEvent) {
        if (this.lock_.getIsLocked()) {
            return;
        }
        this.shouldIgnoreScrollbarEvent_ = this.shouldIgnoreScrollbarEvent_ || shouldPostEvent;
        int target = (this.scrollbar_.getValue() + offset) % this.scrollbar_.getMaximum();
        this.scrollbar_.setValue(target);
    }

    public String getAxis() {
        return this.axis_;
    }

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated_ = isAnimated;
        this.animateIcon_.setIsAnimated(isAnimated);
        if (this.lock_.getIsLocked() && this.isAnimated_) {
            this.lock_.setLockedState(ScrollbarLockIcon.LockedState.UNLOCKED);
        }
        this.bus_.post((Object)new AnimationToggleEvent(this, this.isAnimated_));
    }

    public boolean getIsAnimated() {
        return this.isAnimated_;
    }

    public boolean getIsSuperlocked() {
        return this.lock_.getLockedState() == ScrollbarLockIcon.LockedState.SUPERLOCKED;
    }

    public int getPosition() {
        return this.scrollbar_.getValue();
    }

    public void setPosition(int newPosition) {
        if (!this.lock_.getIsLocked()) {
            this.scrollbar_.setValue(newPosition);
        }
    }

    public void forcePosition(int newPosition) {
        if (this.rememberedPosition_ == -1 && (this.isAnimated_ || this.lock_.getIsLocked())) {
            this.rememberedPosition_ = this.scrollbar_.getValue();
        }
        this.scrollbar_.setValue(newPosition);
    }

    public void restorePosition() {
        if (this.rememberedPosition_ != -1) {
            this.scrollbar_.setValue(this.rememberedPosition_);
            this.rememberedPosition_ = -1;
        }
    }

    public int getMaximum() {
        return this.scrollbar_.getMaximum();
    }

    public void setMaximum(int newMax) {
        this.scrollbar_.setMaximum(newMax);
    }

    public static class ScrollPositionEvent {
        private int value_;
        public AxisScroller scroller_;

        public ScrollPositionEvent(AxisScroller scroller, int value) {
            this.scroller_ = scroller;
            this.value_ = value;
        }

        public int getValue() {
            return this.value_;
        }
    }

    public static class AnimationToggleEvent {
        private boolean isAnimated_;
        public AxisScroller scroller_;

        public AnimationToggleEvent(AxisScroller scroller, boolean isAnimated) {
            this.scroller_ = scroller;
            this.isAnimated_ = isAnimated;
        }

        public boolean getIsAnimated() {
            return this.isAnimated_;
        }
    }
}

