/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.imagedisplay;

import ij.ImagePlus;
import ij.VirtualStack;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionVirtualStack
extends VirtualStack {
    private final TaggedImageStorage imageCache_;
    private final VirtualAcquisitionDisplay acq_;
    protected final int width_;
    protected final int height_;
    protected final int type_;
    private final int nSlices_;
    private int positionIndex_ = 0;

    public AcquisitionVirtualStack(int width, int height, int type, ColorModel cm, TaggedImageStorage imageCache, int nSlices, VirtualAcquisitionDisplay acq) {
        super(width, height, cm, "");
        this.imageCache_ = imageCache;
        this.width_ = width;
        this.height_ = height;
        this.nSlices_ = nSlices;
        this.acq_ = acq;
        this.type_ = type;
    }

    public void setPositionIndex(int pos) {
        this.positionIndex_ = pos;
    }

    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public VirtualAcquisitionDisplay getVirtualAcquisitionDisplay() {
        return this.acq_;
    }

    private TaggedImage getTaggedImage(int flatIndex) {
        ImagePlus imagePlus = this.acq_.getImagePlus();
        if (imagePlus == null) {
            return this.getTaggedImage(0, 0, 0);
        }
        int[] pos = imagePlus.convertIndexToPosition(flatIndex);
        int chanIndex = this.acq_.grayToRGBChannel(pos[0] - 1);
        int frame = pos[2] - 1;
        int slice = pos[1] - 1;
        return this.getTaggedImage(chanIndex, slice, frame);
    }

    protected TaggedImage getTaggedImage(int chanIndex, int slice, int frame) {
        ImagePlus imagePlus = this.acq_.getImagePlus();
        int nSlices = imagePlus == null ? 1 : imagePlus.getNSlices();
        try {
            TaggedImage img = this.imageCache_.getImage(chanIndex, slice, frame, this.positionIndex_);
            int backIndex = slice - 1;
            int forwardIndex = slice + 1;
            int frameSearchIndex = frame;
            while (img == null && (img = this.imageCache_.getImage(chanIndex, slice, frameSearchIndex, this.positionIndex_)) == null) {
                if (backIndex >= 0) {
                    img = this.imageCache_.getImage(chanIndex, backIndex, frameSearchIndex, this.positionIndex_);
                    if (img != null) break;
                    --backIndex;
                }
                if (forwardIndex < nSlices) {
                    img = this.imageCache_.getImage(chanIndex, forwardIndex, frameSearchIndex, this.positionIndex_);
                    if (img != null) break;
                    ++forwardIndex;
                }
                if (backIndex >= 0 || forwardIndex < nSlices) continue;
                backIndex = slice - 1;
                forwardIndex = slice + 1;
                if (--frameSearchIndex >= 0) continue;
            }
            return img;
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    public JSONObject getImageTags(int flatIndex) {
        TaggedImage img = this.getTaggedImage(flatIndex);
        if (img == null) {
            return null;
        }
        return img.tags;
    }

    public Object getPixels(int flatIndex) {
        Object pixels = null;
        try {
            TaggedImage image = this.getTaggedImage(flatIndex);
            if (image == null) {
                pixels = ImageUtils.makeProcessor(this.type_, this.width_, this.height_).getPixels();
            } else if (MDUtils.isGRAY(image)) {
                pixels = image.pix;
            } else if (MDUtils.isRGB32(image)) {
                pixels = ImageUtils.singleChannelFromRGB32((byte[])image.pix, (flatIndex - 1) % 3);
            } else if (MDUtils.isRGB64(image)) {
                pixels = ImageUtils.singleChannelFromRGB64((short[])image.pix, (flatIndex - 1) % 3);
            }
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
        catch (MMScriptException ex) {
            ReportingUtils.logError(ex);
        }
        return pixels;
    }

    public ImageProcessor getProcessor(int flatIndex) {
        return ImageUtils.makeProcessor(this.type_, this.width_, this.height_, this.getPixels(flatIndex));
    }

    public int getSize() {
        int size = this.acq_.getStackSize();
        if (size == -1) {
            return this.nSlices_;
        }
        return size;
    }

    public String getSliceLabel(int n) {
        TaggedImage img = this.getTaggedImage(n);
        if (img == null) {
            return "";
        }
        JSONObject md = img.tags;
        try {
            return md.get("Acquisition-PixelSizeUm") + " um/px";
        }
        catch (Exception ex) {
            return "";
        }
    }
}

