/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import com.swtdesigner.SwingResourceManager;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.micromanager.MMStudio;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.HistogramPanel;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.HistogramUtils;
import org.micromanager.utils.NumberUtils;

public class SingleChannelHistogram
extends JPanel
implements Histograms,
HistogramPanel.CursorListener {
    private static final long serialVersionUID = 1L;
    private static final int SLOW_HIST_UPDATE_INTERVAL_MS = 1000;
    private long lastUpdateTime_;
    private JComboBox histRangeComboBox_;
    private JComboBox lutComboBox_;
    private HistogramPanel histogramPanel_;
    private JLabel maxLabel_;
    private JLabel minLabel_;
    private JLabel meanLabel_;
    private JLabel stdDevLabel_;
    private double gamma_ = 1.0;
    private int histMax_;
    private int maxIntensity_;
    private int bitDepth_;
    private double mean_;
    private double stdDev_;
    private int pixelMin_ = 0;
    private int pixelMax_ = 255;
    private double binSize_ = 1.0;
    private static final int HIST_BINS = 256;
    private int contrastMin_;
    private int contrastMax_;
    private double minAfterRejectingOutliers_;
    private double maxAfterRejectingOutliers_;
    private VirtualAcquisitionDisplay display_;
    private ImagePlus img_;
    private ImageCache cache_;
    private static final byte[][] fireLUT_ = new byte[3][256];
    private static final byte[][] redHotLUT_;
    private static final byte[][] spectrumLUT_;

    public SingleChannelHistogram(VirtualAcquisitionDisplay disp) {
        this.display_ = disp;
        this.img_ = disp.getImagePlus();
        this.cache_ = disp.getImageCache();
        this.bitDepth_ = this.cache_.getBitDepth();
        this.histMax_ = this.maxIntensity_ = (int)(Math.pow(2.0, this.bitDepth_) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.initGUI();
        this.loadDisplaySettings();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setFont(new Font("", 0, 10));
        this.histogramPanel_ = new HistogramPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.black);
                g.setFont(new Font("Lucida Grande", 0, 10));
                String label = "" + SingleChannelHistogram.this.histMax_;
                g.drawString(label, this.getSize().width - 7 * label.length(), this.getSize().height);
            }
        };
        this.histogramPanel_.setMargins(12.0f, 10.0f);
        this.histogramPanel_.setTraceStyle(true, Color.white);
        this.histogramPanel_.addCursorListener(this);
        this.add((Component)this.histogramPanel_, "Center");
        JPanel controls = new JPanel();
        JPanel controlHolder = new JPanel(new BorderLayout());
        controlHolder.add((Component)controls, "First");
        this.add((Component)controlHolder, "Before");
        int iconWidth = 128;
        int iconHeight = 10;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
            g[i] = (byte)i;
            b[i] = (byte)i;
        }
        ImageIcon grayIcon = SingleChannelHistogram.getIcon(r, g, b, 128, 10);
        for (int i = 0; i < 6; ++i) {
            r[i] = 0;
            g[i] = 0;
            b[i] = -1;
            r[255 - i] = -1;
            g[255 - i] = 0;
            b[255 - i] = 0;
        }
        ImageIcon glowOverUnderIcon = SingleChannelHistogram.getIcon(r, g, b, 128, 10);
        ImageIcon fireIcon = SingleChannelHistogram.getIcon(fireLUT_[0], fireLUT_[1], fireLUT_[2], 128, 10);
        ImageIcon redHotIcon = SingleChannelHistogram.getIcon(redHotLUT_[0], redHotLUT_[1], redHotLUT_[2], 128, 10);
        ImageIcon spectrumIcon = SingleChannelHistogram.getIcon(spectrumLUT_[0], spectrumLUT_[1], spectrumLUT_[2], 128, 10);
        Object[] items = new Object[]{grayIcon, glowOverUnderIcon, fireIcon, redHotIcon, spectrumIcon};
        this.lutComboBox_ = new JComboBox<Object>(items);
        this.lutComboBox_.setFont(new Font("", 0, 10));
        this.lutComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.lutComboAction();
            }
        });
        JButton fullScaleButton = new JButton();
        fullScaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.fullButtonAction();
            }
        });
        fullScaleButton.setFont(new Font("Arial", 0, 10));
        fullScaleButton.setToolTipText("Set display levels to full pixel range");
        fullScaleButton.setText("Full");
        JButton autoScaleButton = new JButton();
        autoScaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.autoButtonAction();
            }
        });
        autoScaleButton.setFont(new Font("Arial", 0, 10));
        autoScaleButton.setToolTipText("Set display levels to maximum contrast");
        autoScaleButton.setText("Auto");
        this.minLabel_ = new JLabel();
        this.minLabel_.setFont(new Font("", 0, 10));
        this.maxLabel_ = new JLabel();
        this.maxLabel_.setFont(new Font("", 0, 10));
        this.meanLabel_ = new JLabel();
        this.meanLabel_.setFont(new Font("", 0, 10));
        this.stdDevLabel_ = new JLabel();
        this.stdDevLabel_.setFont(new Font("", 0, 10));
        JButton zoomInButton = new JButton();
        zoomInButton.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/zoom_in.png"));
        JButton zoomOutButton = new JButton();
        zoomOutButton.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/zoom_out.png"));
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.zoomInAction();
            }
        });
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.zoomOutAction();
            }
        });
        zoomInButton.setPreferredSize(new Dimension(22, 22));
        zoomOutButton.setPreferredSize(new Dimension(22, 22));
        JPanel p = new JPanel();
        JLabel histRangeLabel = new JLabel("Hist range:");
        histRangeLabel.setFont(new Font("Arial", 0, 10));
        p.add(histRangeLabel);
        p.add(zoomInButton);
        p.add(zoomOutButton);
        this.histRangeComboBox_ = new JComboBox();
        this.histRangeComboBox_.setFont(new Font("", 0, 10));
        this.histRangeComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleChannelHistogram.this.histRangeComboAction();
            }
        });
        this.histRangeComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Camera Depth", "4bit (0-15)", "5bit (0-31)", "6bit (0-63)", "7bit (0-127)", "8bit (0-255)", "9bit (0-511)", "10bit (0-1023)", "11bit (0-2047)", "12bit (0-4095)", "13bit (0-8191)", "14bit (0-16383)", "15bit (0-32767)", "16bit (0-65535)"}));
        GridBagLayout layout = new GridBagLayout();
        controls.setLayout(layout);
        JPanel statsPanel = new JPanel(new GridLayout(5, 1));
        statsPanel.add(new JLabel(" "));
        statsPanel.add(this.minLabel_);
        statsPanel.add(this.maxLabel_);
        statsPanel.add(this.meanLabel_);
        statsPanel.add(this.stdDevLabel_);
        JPanel histZoomLine = new JPanel();
        histZoomLine.add(histRangeLabel);
        histZoomLine.add(zoomOutButton);
        histZoomLine.add(zoomInButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        controls.add((Component)new JLabel(" "), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        controls.add((Component)this.lutComboBox_, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        fullScaleButton.setPreferredSize(new Dimension(60, 15));
        controls.add((Component)fullScaleButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        autoScaleButton.setPreferredSize(new Dimension(60, 15));
        controls.add((Component)autoScaleButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        controls.add((Component)histZoomLine, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        controls.add((Component)this.histRangeComboBox_, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        controls.add((Component)statsPanel, gbc);
    }

    private void loadDisplaySettings() {
        this.contrastMax_ = this.cache_.getChannelMax(0);
        if (this.contrastMax_ < 0 || this.contrastMax_ > this.maxIntensity_) {
            this.contrastMax_ = this.maxIntensity_;
        }
        this.contrastMin_ = this.cache_.getChannelMin(0);
        this.gamma_ = this.cache_.getChannelGamma(0);
        int histMax = this.cache_.getChannelHistogramMax(0);
        if (histMax != -1) {
            int index = (int)(Math.ceil(Math.log(histMax) / Math.log(2.0)) - 3.0);
            this.histRangeComboBox_.setSelectedIndex(index);
        }
    }

    private void autoButtonAction() {
        this.autostretch();
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    private void fullButtonAction() {
        this.setFullScale();
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    private void histRangeComboAction() {
        this.setHistMaxAndBinSize();
        this.calcAndDisplayHistAndStats(true);
    }

    private void lutComboAction() {
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void rejectOutliersChangeAction() {
        this.calcAndDisplayHistAndStats(true);
        this.autoButtonAction();
    }

    @Override
    public void autoscaleAllChannels() {
        this.autoButtonAction();
    }

    @Override
    public void applyLUTToImage() {
        double val;
        int i;
        if (this.img_ == null) {
            return;
        }
        ImageProcessor ip = this.img_.getProcessor();
        if (ip == null) {
            return;
        }
        double maxValue = 255.0;
        int length = 256;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        if (this.lutComboBox_.getSelectedIndex() < 2) {
            for (i = 0; i < 256; ++i) {
                val = Math.pow((double)i / 255.0, this.gamma_) * 255.0;
                r[i] = (byte)val;
                g[i] = (byte)val;
                b[i] = (byte)val;
            }
            if (this.lutComboBox_.getSelectedIndex() == 1) {
                r[0] = 0;
                g[0] = 0;
                b[0] = -1;
                r[255] = -1;
                g[255] = 0;
                b[255] = 0;
            }
        }
        if (this.lutComboBox_.getSelectedIndex() == 2) {
            for (i = 0; i < 256; ++i) {
                val = Math.pow((double)i / 255.0, this.gamma_) * 255.0;
                r[i] = fireLUT_[0][(int)val];
                g[i] = fireLUT_[1][(int)val];
                b[i] = fireLUT_[2][(int)val];
            }
        }
        if (this.lutComboBox_.getSelectedIndex() == 3) {
            for (i = 0; i < 256; ++i) {
                val = Math.pow((double)i / 255.0, this.gamma_) * 255.0;
                r[i] = redHotLUT_[0][(int)val];
                g[i] = redHotLUT_[1][(int)val];
                b[i] = redHotLUT_[2][(int)val];
            }
        }
        if (this.lutComboBox_.getSelectedIndex() == 4) {
            for (i = 0; i < 256; ++i) {
                val = Math.pow((double)i / 255.0, this.gamma_) * 255.0;
                r[i] = spectrumLUT_[0][(int)val];
                g[i] = spectrumLUT_[1][(int)val];
                b[i] = spectrumLUT_[2][(int)val];
            }
        }
        ip.setColorModel((ColorModel)new LUT(8, 256, r, g, b));
        ip.setMinAndMax((double)this.contrastMin_, (double)this.contrastMax_);
        this.saveDisplaySettings();
        this.updateHistogram();
    }

    public static int fire(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] b = new int[]{0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    public static int redhot(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 1, 27, 52, 78, 103, 130, 155, 181, 207, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 29, 55, 81, 106, 133, 158, 184, 209, 236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] b = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 32, 58, 84, 110, 135, 161, 187, 160, 213, 255};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    public static int spectrum(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
            reds[i] = (byte)c.getRed();
            greens[i] = (byte)c.getGreen();
            blues[i] = (byte)c.getBlue();
        }
        return 256;
    }

    public static void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    public static ImageIcon getIcon(byte[] r, byte[] g, byte[] b, int width, int height) {
        int[] pixels = new int[width * height];
        double ratio = 256.0 / (double)width;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = (int)(ratio * (double)x);
                int ri = 0xFF & r[index];
                int rg = 0xFF & g[index];
                int rb = 0xFF & b[index];
                pixels[y * width + x] = 0xFF000000 | ri << 16 | rg << 8 | rb;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return new ImageIcon(image);
    }

    public void saveDisplaySettings() {
        int histMax = this.histRangeComboBox_.getSelectedIndex() == 0 ? -1 : this.histMax_;
        this.display_.storeChannelHistogramSettings(0, this.contrastMin_, this.contrastMax_, this.gamma_, histMax, 1);
    }

    @Override
    public void setChannelHistogramDisplayMax(int channelIndex, int histMax) {
        if (channelIndex != 0) {
            return;
        }
        int index = (int)(histMax == -1 ? 0.0 : Math.ceil(Math.log(histMax) / Math.log(2.0)) - 3.0);
        this.histRangeComboBox_.setSelectedIndex(index);
    }

    private void updateHistogram() {
        this.histogramPanel_.setCursorText(this.contrastMin_ + "", this.contrastMax_ + "");
        this.histogramPanel_.setCursors((double)this.contrastMin_ / this.binSize_, (double)(this.contrastMax_ + 1) / this.binSize_, this.gamma_);
        this.histogramPanel_.repaint();
    }

    private void zoomInAction() {
        int selected = this.histRangeComboBox_.getSelectedIndex();
        if (selected == 0) {
            selected = this.bitDepth_ - 3;
        }
        if (selected != 1) {
            --selected;
        }
        this.histRangeComboBox_.setSelectedIndex(selected);
    }

    private void zoomOutAction() {
        int selected = this.histRangeComboBox_.getSelectedIndex();
        if (selected == 0) {
            selected = this.bitDepth_ - 3;
        }
        if (selected < this.histRangeComboBox_.getModel().getSize() - 1) {
            ++selected;
        }
        this.histRangeComboBox_.setSelectedIndex(selected);
    }

    private void setHistMaxAndBinSize() {
        int bits = this.histRangeComboBox_.getSelectedIndex() + 3;
        this.histMax_ = bits == 3 ? this.maxIntensity_ : (int)(Math.pow(2.0, bits) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.updateHistogram();
        this.saveDisplaySettings();
    }

    @Override
    public void autostretch() {
        this.contrastMin_ = this.pixelMin_;
        this.contrastMax_ = this.pixelMax_;
        if (this.pixelMin_ == this.pixelMax_) {
            if (this.pixelMax_ > 0) {
                --this.contrastMin_;
            } else {
                ++this.contrastMax_;
            }
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            if ((double)this.contrastMin_ < this.minAfterRejectingOutliers_ && 0.0 < this.minAfterRejectingOutliers_) {
                this.contrastMin_ = (int)this.minAfterRejectingOutliers_;
            }
            if (this.maxAfterRejectingOutliers_ < (double)this.contrastMax_) {
                this.contrastMax_ = (int)this.maxAfterRejectingOutliers_;
            }
            if (this.contrastMax_ <= this.contrastMin_) {
                if (this.contrastMax_ > 0) {
                    this.contrastMin_ = this.contrastMax_ - 1;
                } else {
                    this.contrastMax_ = this.contrastMin_ + 1;
                }
            }
        }
    }

    private void setFullScale() {
        this.setHistMaxAndBinSize();
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = 0;
        this.contrastMax_ = this.histMax_;
    }

    @Override
    public void imageChanged() {
        boolean update = true;
        if ((this.display_.acquisitionIsRunning() || MMStudio.getInstance().isLiveModeOn()) && this.display_.getHistogramControlsState().slowHist) {
            long time = System.currentTimeMillis();
            if (time - this.lastUpdateTime_ < 1000L) {
                update = false;
            } else {
                this.lastUpdateTime_ = time;
            }
        }
        if (update) {
            this.calcAndDisplayHistAndStats(this.display_.isActiveDisplay());
            if (this.display_.getHistogramControlsState().autostretch) {
                this.autostretch();
            }
            this.applyLUTToImage();
        }
    }

    @Override
    public void calcAndDisplayHistAndStats(boolean drawHist) {
        if (this.img_ == null || this.img_.getProcessor() == null) {
            return;
        }
        int[] rawHistogram = this.img_.getProcessor().getHistogram();
        int imgWidth = this.img_.getWidth();
        int imgHeight = this.img_.getHeight();
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            this.maxAfterRejectingOutliers_ = rawHistogram.length;
            int totalPoints = imgHeight * imgWidth;
            HistogramUtils hu = new HistogramUtils(rawHistogram, totalPoints, 0.01 * this.display_.getHistogramControlsState().percentToIgnore);
            this.minAfterRejectingOutliers_ = hu.getMinAfterRejectingOutliers();
            this.maxAfterRejectingOutliers_ = hu.getMaxAfterRejectingOutliers();
        }
        GraphData histogramData = new GraphData();
        int numBins = (int)Math.min((double)rawHistogram.length / this.binSize_, 256.0);
        int[] histogram = new int[256];
        int total = 0;
        for (int i = 0; i < numBins; ++i) {
            histogram[i] = 0;
            int j = 0;
            while ((double)j < this.binSize_) {
                int rawHistIndex = (int)((double)i * this.binSize_ + (double)j);
                int rawHistVal = rawHistogram[rawHistIndex];
                int n = i;
                histogram[n] = histogram[n] + rawHistVal;
                ++j;
            }
            total += histogram[i];
            if (!this.display_.getHistogramControlsState().logHist) continue;
            histogram[i] = histogram[i] > 0 ? (int)(1000.0 * Math.log(histogram[i])) : 0;
        }
        if (total == 0) {
            if (this.img_.getProcessor().getMin() == 0.0) {
                histogram[0] = imgWidth * imgHeight;
            } else if (numBins > 0) {
                histogram[numBins - 1] = imgWidth * imgHeight;
            }
        }
        if (drawHist) {
            ImageStatistics stats = this.img_.getStatistics(22);
            this.pixelMax_ = (int)stats.max;
            this.pixelMin_ = (int)stats.min;
            this.mean_ = stats.mean;
            this.stdDev_ = stats.stdDev;
            histogramData.setData(histogram);
            this.histogramPanel_.setData(histogramData);
            this.histogramPanel_.setAutoScale();
            this.histogramPanel_.setToolTipText("Click and drag curve to adjust gamma");
            this.maxLabel_.setText("Max: " + NumberUtils.intToDisplayString(this.pixelMax_));
            this.minLabel_.setText("Min: " + NumberUtils.intToDisplayString(this.pixelMin_));
            this.meanLabel_.setText("Mean: " + NumberUtils.intToDisplayString((int)this.mean_));
            this.stdDevLabel_.setText("Std Dev: " + NumberUtils.intToDisplayString((int)this.stdDev_));
            this.updateHistogram();
        }
    }

    @Override
    public void setChannelContrast(int channelIndex, int min, int max, double gamma) {
        if (channelIndex != 0) {
            return;
        }
        this.contrastMax_ = Math.min(this.maxIntensity_, max);
        this.contrastMin_ = min;
        this.gamma_ = gamma;
    }

    @Override
    public void contrastMinInput(int min) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = min;
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMin_ < 0) {
            this.contrastMin_ = 0;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void contrastMaxInput(int max) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = max;
        if (this.contrastMax_ > this.maxIntensity_) {
            this.contrastMax_ = this.maxIntensity_;
        }
        if (this.contrastMax_ < 0) {
            this.contrastMax_ = 0;
        }
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void onLeftCursor(double pos) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = (int)(Math.max(0.0, pos) * this.binSize_);
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void onRightCursor(double pos) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = (int)(Math.min(255.0, pos) * this.binSize_);
        if (this.contrastMax_ < 1) {
            this.contrastMax_ = 1;
        }
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void onGammaCurve(double gamma) {
        if (gamma != 0.0) {
            this.gamma_ = gamma > 0.9 & gamma < 1.1 ? 1.0 : gamma;
            this.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    @Override
    public void setupChannelControls(ImageCache cache) {
    }

    @Override
    public ContrastSettings getChannelContrastSettings(int channel) {
        if (channel != 0) {
            return null;
        }
        return new ContrastSettings(this.contrastMin_, this.contrastMax_, this.gamma_);
    }

    @Override
    public int getNumberOfChannels() {
        return 1;
    }

    static {
        int l = SingleChannelHistogram.fire(fireLUT_[0], fireLUT_[1], fireLUT_[2]);
        if (l < 256) {
            SingleChannelHistogram.interpolate(fireLUT_[0], fireLUT_[1], fireLUT_[2], l);
        }
        if ((l = SingleChannelHistogram.redhot((redHotLUT_ = new byte[3][256])[0], redHotLUT_[1], redHotLUT_[2])) < 256) {
            SingleChannelHistogram.interpolate(redHotLUT_[0], redHotLUT_[1], redHotLUT_[2], l);
        }
        if ((l = SingleChannelHistogram.spectrum((spectrumLUT_ = new byte[3][256])[0], spectrumLUT_[1], spectrumLUT_[2])) < 256) {
            SingleChannelHistogram.interpolate(spectrumLUT_[0], spectrumLUT_[1], spectrumLUT_[2], l);
        }
    }
}

