/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import ij.CompositeImage;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.micromanager.MMStudio;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.ChannelControlPanel;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public final class MultiChannelHistograms
extends JPanel
implements Histograms {
    private static final int SLOW_HIST_UPDATE_INTERVAL_MS = 1000;
    private long lastUpdateTime_;
    private ArrayList<ChannelControlPanel> ccpList_;
    private VirtualAcquisitionDisplay display_;
    private ImageCache cache_;
    private CompositeImage img_;
    private boolean updatingCombos_ = false;

    public MultiChannelHistograms(VirtualAcquisitionDisplay disp) {
        this.display_ = disp;
        this.img_ = (CompositeImage)disp.getImagePlus();
        this.cache_ = disp.getImageCache();
        this.setupChannelControls(this.cache_);
    }

    @Override
    public synchronized void setupChannelControls(ImageCache cache) {
        boolean rgb;
        this.removeAll();
        this.invalidate();
        try {
            rgb = MDUtils.isRGB(this.display_.getSummaryMetadata());
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            rgb = false;
        }
        int nChannels = rgb ? 3 : this.display_.getNumChannels();
        GridLayout layout = new GridLayout(nChannels, 1);
        this.setLayout(layout);
        Dimension dim = new Dimension(ChannelControlPanel.MINIMUM_SIZE.width, nChannels * ChannelControlPanel.MINIMUM_SIZE.height);
        this.setMinimumSize(dim);
        this.setSize(dim);
        this.ccpList_ = new ArrayList();
        for (int i = 0; i < nChannels; ++i) {
            ChannelControlPanel ccp = new ChannelControlPanel(i, this, this.display_);
            this.add(ccp);
            this.ccpList_.add(ccp);
        }
        this.validate();
    }

    public void updateChannelNamesAndColors() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel c : this.ccpList_) {
            c.updateChannelNameAndColorFromCache();
        }
    }

    public void fullScaleChannels() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel c : this.ccpList_) {
            c.setFullScale();
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public void applyContrastToAllChannels(int min, int max, double gamma) {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel c : this.ccpList_) {
            c.setContrast(min, max, gamma);
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public ContrastSettings getChannelContrastSettings(int channel) {
        if (this.ccpList_ == null || this.ccpList_.size() - 1 > channel) {
            return null;
        }
        return new ContrastSettings(this.ccpList_.get(channel).getContrastMin(), this.ccpList_.get(channel).getContrastMax(), this.ccpList_.get(channel).getContrastGamma());
    }

    public void updateOtherDisplayCombos(int selectedIndex) {
        if (this.updatingCombos_) {
            return;
        }
        this.updatingCombos_ = true;
        for (int i = 0; i < this.ccpList_.size(); ++i) {
            this.ccpList_.get(i).setDisplayComboIndex(selectedIndex);
        }
        this.updatingCombos_ = false;
    }

    public void setChannelDisplayModeFromFirst() {
        if (this.ccpList_ == null || this.ccpList_.size() <= 1) {
            return;
        }
        int displayIndex = this.ccpList_.get(0).getDisplayComboIndex();
        this.ccpList_.get(0).setDisplayComboIndex(displayIndex);
    }

    public void setChannelContrastFromFirst() {
        if (this.ccpList_ == null || this.ccpList_.size() <= 1) {
            return;
        }
        int min = this.ccpList_.get(0).getContrastMin();
        int max = this.ccpList_.get(0).getContrastMax();
        double gamma = this.ccpList_.get(0).getContrastGamma();
        for (int i = 1; i < this.ccpList_.size(); ++i) {
            this.ccpList_.get(i).setContrast(min, max, gamma);
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    @Override
    public void setChannelHistogramDisplayMax(int channelIndex, int histMax) {
        if (this.ccpList_ == null || this.ccpList_.size() <= channelIndex) {
            return;
        }
        int index = (int)(histMax == -1 ? 0.0 : Math.ceil(Math.log(histMax) / Math.log(2.0)) - 3.0);
        this.ccpList_.get(channelIndex).setDisplayComboIndex(index);
    }

    @Override
    public void applyLUTToImage() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel c : this.ccpList_) {
            c.applyChannelLUTToImage();
        }
    }

    @Override
    public void imageChanged() {
        boolean update = true;
        if ((this.display_.acquisitionIsRunning() || MMStudio.getInstance().isLiveModeOn()) && this.display_.getHistogramControlsState().slowHist) {
            long time = System.currentTimeMillis();
            if (time - this.lastUpdateTime_ < 1000L) {
                update = false;
            } else {
                this.lastUpdateTime_ = time;
            }
        }
        this.updateActiveChannels();
        if (update) {
            for (ChannelControlPanel c : this.ccpList_) {
                c.calcAndDisplayHistAndStats(this.display_.isActiveDisplay());
                if (this.display_.getHistogramControlsState().autostretch) {
                    c.autostretch();
                }
                c.applyChannelLUTToImage();
            }
        }
    }

    private void updateActiveChannels() {
        int currentChannel = this.img_.getChannel() - 1;
        boolean[] active = this.img_.getActiveChannels();
        if (this.img_.getMode() != 1) {
            for (int i = 0; i < active.length; ++i) {
                active[i] = currentChannel == i;
            }
        }
    }

    @Override
    public void setChannelContrast(int channelIndex, int min, int max, double gamma) {
        if (channelIndex >= this.ccpList_.size()) {
            return;
        }
        this.ccpList_.get(channelIndex).setContrast(min, max, gamma);
    }

    public void setDisplayMode(int mode) {
        this.display_.setDisplayMode(mode);
    }

    @Override
    public void autoscaleAllChannels() {
        if (this.ccpList_ != null && this.ccpList_.size() > 0) {
            for (ChannelControlPanel c : this.ccpList_) {
                c.autoButtonAction();
            }
        }
    }

    @Override
    public void rejectOutliersChangeAction() {
        if (this.ccpList_ != null && this.ccpList_.size() > 0) {
            for (ChannelControlPanel c : this.ccpList_) {
                c.calcAndDisplayHistAndStats(true);
                c.autoButtonAction();
            }
        }
    }

    @Override
    public void calcAndDisplayHistAndStats(boolean drawHist) {
        if (this.ccpList_ != null) {
            for (ChannelControlPanel c : this.ccpList_) {
                c.calcAndDisplayHistAndStats(drawHist);
            }
        }
    }

    @Override
    public void autostretch() {
        if (this.ccpList_ != null) {
            for (ChannelControlPanel c : this.ccpList_) {
                c.autostretch();
            }
        }
    }

    @Override
    public int getNumberOfChannels() {
        return this.ccpList_.size();
    }
}

