/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.micromanager.graph.GraphData;
import org.micromanager.utils.JavaUtils;

public class HistogramPanel
extends JPanel
implements FocusListener,
KeyListener {
    private static final int LUT_HANDLE_SIZE = 10;
    private static final Color HIGHLIGHT_COLOR = Color.blue;
    private static final int TOP_HANDLE_OFFSET = JavaUtils.isMac() ? 7 : 3;
    private static final int BOTTOM_HANDLE_OFFSET = JavaUtils.isMac() ? 3 : 3;
    private static final int PIXELS_PER_HANDLE_DIGIT = 6;
    private static final long serialVersionUID = -1789623844214721902L;
    private int xMin_ = 0;
    private int xMax_ = 255;
    private int currentHandle_;
    private int clickLocation_ = 0;
    private ArrayList<CursorListener> cursorListeners_;
    private Point2D.Float ptDevBottom_;
    private Point2D.Float ptDevTop_;
    private Point2D.Float ptDevTopUnclippedX_;
    private boolean contrastMinEditable_ = false;
    private boolean contrastMaxEditable_ = false;
    private String newContrast_ = "";
    private String cursorTextLow_ = "";
    private String cursorTextHigh_ = "";
    private GraphData data_;
    protected GraphData.Bounds bounds_;
    private float xMargin_ = 50.0f;
    private float yMargin_ = 50.0f;
    float cursorLoPos_;
    float cursorHiPos_;
    double gamma_;
    private boolean fillTrace_ = false;
    private Color traceColor_ = Color.black;

    public HistogramPanel() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.data_ = new GraphData();
        this.setAutoBounds();
        this.cursorLoPos_ = (float)this.bounds_.xMin;
        this.cursorHiPos_ = (float)this.bounds_.xMax;
        this.gamma_ = 1.0;
        this.setFocusable(true);
        this.cursorListeners_ = new ArrayList();
        this.setupMouseListeners();
    }

    private GeneralPath generateGammaCurvePath(Point2D.Float ptDevTop, Point2D.Float ptDevBottom, double gamma) {
        int w = (int)(ptDevTop.x - ptDevBottom.x) + 1;
        int h = (int)(ptDevBottom.y - ptDevTop.y);
        GeneralPath path = new GeneralPath();
        path.moveTo(ptDevBottom.x, ptDevBottom.y);
        for (int x = 0; x < w; x += 3) {
            double xn = (double)x / (double)w;
            double yn = Math.pow(xn, gamma);
            int X = x + (int)ptDevBottom.x;
            int Y = (int)((1.0 - yn) * (double)h + (double)ptDevTop.y);
            path.lineTo(X, Y);
        }
        path.lineTo(ptDevTop.x, ptDevTop.y);
        return path;
    }

    public void setAutoScale() {
        this.setAutoBounds();
    }

    public void setDataSource(GraphData data) {
        this.setData(data);
        this.refresh();
    }

    public void drawCursor(Graphics2D g, Rectangle box, float xPos) {
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 0.0) {
            return;
        }
        float xUnit = (float)((double)box.width / this.bounds_.getRangeX());
        float yUnit = (float)((double)box.height / this.bounds_.getRangeY());
        Point2D.Float ptPosBottom = new Point2D.Float(xPos, (float)this.bounds_.yMax);
        Point2D.Float ptDevBottom = this.getDevicePoint(ptPosBottom, box, xUnit, yUnit);
        Point2D.Float ptPosTop = new Point2D.Float(xPos, (float)this.bounds_.yMin);
        Point2D.Float ptDevTop = this.getDevicePoint(ptPosTop, box, xUnit, yUnit);
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(new Color(120, 120, 120));
        float[] dash1 = new float[]{3.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        g.setStroke(dashed);
        g.draw(new Line2D.Float(ptDevBottom, ptDevTop));
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public void drawMapping(Graphics2D g, Rectangle box, float xStart, float xEnd, double gamma) {
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 1.0E-10) {
            return;
        }
        float xUnit = (float)((double)box.width / this.bounds_.getRangeX());
        float yUnit = (float)((double)box.height / this.bounds_.getRangeY());
        Point2D.Float ptPosBottom = new Point2D.Float(xStart, (float)this.bounds_.yMin);
        this.ptDevBottom_ = this.getDevicePoint(ptPosBottom, box, xUnit, yUnit);
        Point2D.Float ptPosTop = new Point2D.Float(xEnd, (float)this.bounds_.yMax);
        this.ptDevTop_ = this.getDevicePoint(ptPosTop, box, xUnit, yUnit);
        this.ptDevTopUnclippedX_ = this.getDevicePointUnclippedXMax(ptPosTop, box, xUnit, yUnit);
        GeneralPath path = this.generateGammaCurvePath(this.ptDevTopUnclippedX_, this.ptDevBottom_, gamma);
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(new Color(120, 120, 120));
        BasicStroke solid = new BasicStroke(2.0f, 0, 0);
        g.setStroke(solid);
        g.draw(path);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        this.drawLUTHandles(g, (int)this.ptDevBottom_.x, (int)this.ptDevBottom_.y, (int)this.ptDevTop_.x, (int)this.ptDevTop_.y);
    }

    private void drawLUTHandles(Graphics2D g, int xmin, int ymin, int xmax, int ymax) {
        this.drawTopHandle(g, xmax, ymax);
        this.drawBottomHandle(g, xmin, ymin);
    }

    private void drawTopHandle(Graphics2D g, int x, int y) {
        HistogramPanel.drawTriangle(g, x, y, true);
        g.setFont(new Font("Lucida Grande", 0, 11));
        String text = this.cursorTextHigh_;
        if (this.contrastMaxEditable_ && this.newContrast_.length() != 0) {
            text = this.newContrast_;
        }
        int width = 6 * text.length() + TOP_HANDLE_OFFSET;
        if (this.contrastMaxEditable_) {
            g.setColor(HIGHLIGHT_COLOR);
            g.fillRect(x - width, y - 10, width, 10);
            g.setColor(UIManager.getColor("Panel.background"));
            g.drawString(text, x - width, y - 1);
        } else {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(x - width, y - 10, width, 10);
            g.setColor(Color.black);
            g.drawString(text, x - width, y - 1);
        }
    }

    private void drawBottomHandle(Graphics2D g, int x, int y) {
        HistogramPanel.drawTriangle(g, x, y, false);
        g.setFont(new Font("Lucida Grande", 0, 11));
        String text = this.cursorTextLow_;
        if (this.contrastMinEditable_ && this.newContrast_.length() != 0) {
            text = this.newContrast_;
        }
        int width = 6 * text.length() + 7;
        if (this.contrastMinEditable_) {
            g.setColor(HIGHLIGHT_COLOR);
            g.fillRect(x, y, width, 11);
            g.setColor(UIManager.getColor("Panel.background"));
            g.drawString(this.newContrast_.length() != 0 ? this.newContrast_ : text, x + BOTTOM_HANDLE_OFFSET, y + 10);
        } else {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(x, y, width, 11);
            g.setColor(Color.black);
            g.drawString(text, x + BOTTOM_HANDLE_OFFSET, y + 10);
        }
    }

    static void drawTriangle(Graphics2D g, int x, int y, boolean top) {
        int s = 10;
        if (top) {
            s = -s;
        }
        int[] xs = new int[]{x, x - s, x};
        int[] ys = new int[]{y, y + s, y + s};
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(top ? Color.white : Color.black);
        g.fillPolygon(xs, ys, 3);
        g.setColor(Color.black);
        g.drawPolygon(xs, ys, 3);
        g.setStroke(oldStroke);
    }

    public void refresh() {
        GraphData.Bounds bounds = this.getGraphBounds();
        bounds.xMin = this.xMin_;
        bounds.xMax = this.xMax_;
        this.setBounds(bounds);
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.applyContrastValues();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        try {
            int i = Integer.parseInt("" + e.getKeyChar());
            if (this.contrastMaxEditable_ || this.contrastMinEditable_) {
                this.newContrast_ = this.newContrast_ + i;
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.applyContrastValues();
        } else if (e.getKeyCode() == 37) {
            if (this.contrastMaxEditable_ && this.newContrast_.length() == 0) {
                this.setContrastMax(Integer.parseInt(this.cursorTextHigh_) - 1);
            } else if (this.contrastMinEditable_ && this.newContrast_.length() == 0) {
                this.setContrastMin(Integer.parseInt(this.cursorTextLow_) - 1);
            }
        } else if (e.getKeyCode() == 39) {
            if (this.contrastMaxEditable_ && this.newContrast_.length() == 0) {
                this.setContrastMax(Integer.parseInt(this.cursorTextHigh_) + 1);
            } else if (this.contrastMinEditable_ && this.newContrast_.length() == 0) {
                this.setContrastMin(Integer.parseInt(this.cursorTextLow_) + 1);
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void addCursorListener(CursorListener cursorListener) {
        this.cursorListeners_.add(cursorListener);
    }

    public void removeCursorListeners(CursorListener cursorListener) {
        this.cursorListeners_.remove(cursorListener);
    }

    public CursorListener[] getCursorListeners() {
        return (CursorListener[])this.cursorListeners_.toArray();
    }

    private void notifyCursorLeft(double pos) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onLeftCursor(pos);
        }
    }

    private void notifyCursorRight(double pos) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onRightCursor(pos);
        }
    }

    private void notifyGammaMouse(double gamma) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onGammaCurve(gamma);
        }
    }

    private void setContrastMax(int max) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.contrastMaxInput(max);
        }
    }

    private void setContrastMin(int min) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.contrastMinInput(min);
        }
    }

    private void applyContrastValues() {
        if (!this.newContrast_.equals("")) {
            if (this.contrastMaxEditable_) {
                this.setContrastMax(Integer.parseInt(this.newContrast_));
            } else if (this.contrastMinEditable_) {
                this.setContrastMin(Integer.parseInt(this.newContrast_));
            }
        }
        this.contrastMaxEditable_ = false;
        this.contrastMinEditable_ = false;
        this.newContrast_ = "";
        this.repaint();
    }

    private void setupMouseListeners() {
        final HistogramPanel panelRef = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                panelRef.requestFocus();
                int x = e.getX();
                int y = e.getY();
                HistogramPanel.this.getClickBand(x, y);
                if (HistogramPanel.this.currentHandle_ != 0) {
                    double gamma;
                    Point2D.Float pt = HistogramPanel.this.getPositionPoint(x, y);
                    if (HistogramPanel.this.currentHandle_ == 1) {
                        HistogramPanel.this.notifyCursorLeft(pt.x);
                    }
                    if (HistogramPanel.this.currentHandle_ == 2) {
                        HistogramPanel.this.notifyCursorRight(pt.x);
                    }
                    if (HistogramPanel.this.currentHandle_ == 3 && Math.abs((HistogramPanel.this.gamma_ - (gamma = HistogramPanel.this.getGammaFromMousePosition(x, y))) / HistogramPanel.this.gamma_) < 0.2) {
                        HistogramPanel.this.notifyGammaMouse(HistogramPanel.this.getGammaFromMousePosition(x, y));
                        HistogramPanel.this.currentHandle_ = 4;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                HistogramPanel.this.currentHandle_ = 0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && HistogramPanel.this.clickLocation_ == 1) {
                    HistogramPanel.this.applyContrastValues();
                    HistogramPanel.this.contrastMinEditable_ = true;
                    HistogramPanel.this.contrastMaxEditable_ = false;
                } else if (e.getClickCount() >= 2 && HistogramPanel.this.clickLocation_ == 2) {
                    HistogramPanel.this.applyContrastValues();
                    HistogramPanel.this.contrastMaxEditable_ = true;
                    HistogramPanel.this.contrastMinEditable_ = false;
                } else if (HistogramPanel.this.clickLocation_ == 0) {
                    HistogramPanel.this.applyContrastValues();
                }
                HistogramPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (HistogramPanel.this.currentHandle_ == 0) {
                    return;
                }
                Point2D.Float pt = HistogramPanel.this.getPositionPoint(e.getX(), e.getY());
                if (HistogramPanel.this.currentHandle_ == 1) {
                    HistogramPanel.this.notifyCursorLeft(pt.x);
                }
                if (HistogramPanel.this.currentHandle_ == 2) {
                    HistogramPanel.this.notifyCursorRight(pt.x);
                }
                if (HistogramPanel.this.currentHandle_ == 4) {
                    HistogramPanel.this.notifyGammaMouse(HistogramPanel.this.getGammaFromMousePosition(e.getX(), e.getY()));
                }
            }
        });
    }

    private double getGammaFromMousePosition(int x, int y) {
        if (this.ptDevTopUnclippedX_ == null || this.ptDevBottom_ == null) {
            return 0.0;
        }
        double width = this.ptDevTopUnclippedX_.x - this.ptDevBottom_.x;
        double height = this.ptDevBottom_.y - this.ptDevTopUnclippedX_.y;
        double xn = (double)((float)x - this.ptDevBottom_.x) / width;
        double yn = (double)(this.ptDevBottom_.y - (float)y) / height;
        double gammaClick = xn > 0.05 && xn < 0.95 && yn > 0.05 && yn < 0.95 ? Math.log(yn) / Math.log(xn) : 0.0;
        return gammaClick;
    }

    static int clipVal(int v, int min, int max) {
        return Math.max(min, Math.min(v, max));
    }

    private float getHistogramTopNumbersWidth() {
        return 6 * this.cursorTextHigh_.length() + TOP_HANDLE_OFFSET;
    }

    private float getHistogramBottomNumbersWidth() {
        return 6 * this.cursorTextLow_.length() + BOTTOM_HANDLE_OFFSET;
    }

    private void getClickBand(int x, int y) {
        Rectangle box = this.getBox();
        int ymin = box.y + box.height;
        int ymax = box.y;
        float xUnit = (float)((double)box.width / this.bounds_.getRangeX());
        float deviceCursorLoX = this.getDevicePoint((Point2D.Float)new Point2D.Float((float)this.cursorLoPos_, (float)0.0f), (Rectangle)box, (float)xUnit, (float)1.0f).x;
        float deviceCursorHiX = this.getDevicePoint((Point2D.Float)new Point2D.Float((float)this.cursorHiPos_, (float)0.0f), (Rectangle)box, (float)xUnit, (float)1.0f).x;
        this.clickLocation_ = 0;
        if (y < ymin + 10 && y >= ymin) {
            if ((float)x > deviceCursorLoX && (float)x < deviceCursorLoX + this.getHistogramBottomNumbersWidth()) {
                this.clickLocation_ = 1;
                this.currentHandle_ = 0;
                return;
            }
            this.currentHandle_ = 1;
        } else if (y <= ymax && y > ymax - 10) {
            if ((float)x < deviceCursorHiX && (float)x > deviceCursorHiX - this.getHistogramTopNumbersWidth()) {
                this.clickLocation_ = 2;
                this.currentHandle_ = 0;
                return;
            }
            this.currentHandle_ = 2;
        } else {
            this.currentHandle_ = (float)x > deviceCursorLoX - 5.0f && (float)x < deviceCursorLoX + 5.0f ? 1 : ((float)x > deviceCursorHiX - 5.0f && (float)x < deviceCursorHiX + 5.0f ? 2 : (y > ymax && y < ymin ? 3 : 0));
        }
    }

    public void setData(GraphData d) {
        this.data_ = d;
    }

    public void setGamma(double gamma) {
        this.gamma_ = gamma;
    }

    public void setTraceStyle(boolean fillTrace, Color color) {
        this.fillTrace_ = fillTrace;
        this.traceColor_ = color;
    }

    public final void setAutoBounds() {
        this.bounds_ = this.data_.getBounds();
        this.AdjustCursors();
    }

    public void setMargins(float x, float y) {
        this.xMargin_ = x;
        this.yMargin_ = y;
    }

    public void setCursorText(String low, String high) {
        this.cursorTextLow_ = low;
        this.cursorTextHigh_ = high;
    }

    public void setCursors(double low, double high, double gamma) {
        this.cursorLoPos_ = (float)low;
        this.cursorHiPos_ = (float)high;
        this.gamma_ = gamma;
    }

    public GraphData.Bounds getGraphBounds() {
        return this.bounds_;
    }

    public void setBounds(double xMin, double xMax, double yMin, double yMax) {
        this.bounds_.xMin = xMin;
        this.bounds_.xMax = xMax;
        this.bounds_.yMin = yMin;
        this.bounds_.yMax = yMax;
        this.AdjustCursors();
    }

    public void setBounds(GraphData.Bounds b) {
        this.bounds_ = b;
        this.AdjustCursors();
    }

    private void AdjustCursors() {
        this.cursorLoPos_ = Math.max(this.cursorLoPos_, (float)this.bounds_.xMin);
    }

    protected void drawGraph(Graphics2D g, Rectangle box) {
        if (this.data_.getSize() < 2) {
            return;
        }
        Color oldC = g.getColor();
        g.setColor(Color.black);
        g.fillRect(box.x, box.y, box.width, box.height);
        g.setColor(oldC);
        Color oldColor = g.getColor();
        g.setColor(this.traceColor_);
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 1.0E-10) {
            return;
        }
        float xUnit = (float)((double)box.width / this.bounds_.getRangeX());
        float yUnit = (float)((double)box.height / this.bounds_.getRangeY());
        GeneralPath trace = new GeneralPath(0, this.data_.getSize() + 1);
        Point2D.Float pt0 = this.getDevicePoint(new Point2D.Float(0.0f, 0.0f), box, xUnit, yUnit);
        trace.moveTo(pt0.x, pt0.y);
        Point2D.Float pt1 = this.getDevicePoint(new Point2D.Float(1.0f, 0.0f), box, xUnit, yUnit);
        float halfWidth = (pt1.x - pt0.x) / 2.0f;
        for (int i = 0; i < this.data_.getSize(); ++i) {
            Point2D.Float pt = this.getDevicePoint(this.data_.getPoint(i), box, xUnit, yUnit);
            trace.lineTo(pt.x - halfWidth, pt.y);
            trace.lineTo(pt.x + halfWidth, pt.y);
        }
        pt0 = this.getDevicePoint(new Point2D.Float((float)this.data_.getPoint(this.data_.getSize() - 1).getX(), 0.0f), box, xUnit, yUnit);
        trace.lineTo(pt0.x, pt0.y);
        if (this.fillTrace_) {
            g.fill(trace);
        } else {
            g.draw(trace);
        }
        g.setColor(oldColor);
    }

    public Point2D.Float getDevicePointUnclippedXMax(Point2D.Float pt, Rectangle box, float xUnit, float yUnit) {
        Point2D.Float ptDev = new Point2D.Float((float)((double)pt.x - this.bounds_.xMin) * xUnit + (float)box.x, (float)box.height - (float)((double)pt.y - this.bounds_.yMin) * yUnit + (float)box.y);
        ptDev.x = Math.max(ptDev.x, (float)box.x);
        ptDev.y = Math.max(Math.min(ptDev.y, (float)box.y + (float)box.height), (float)box.y);
        return ptDev;
    }

    public Point2D.Float getDevicePoint(Point2D.Float pt, Rectangle box, float xUnit, float yUnit) {
        Point2D.Float ptDev = new Point2D.Float((float)((double)pt.x - this.bounds_.xMin) * xUnit + (float)box.x, (float)box.height - (float)((double)pt.y - this.bounds_.yMin) * yUnit + (float)box.y);
        ptDev.x = Math.max(Math.min(ptDev.x, (float)box.x + (float)box.width), (float)box.x);
        ptDev.y = Math.max(Math.min(ptDev.y, (float)box.y + (float)box.height), (float)box.y);
        return ptDev;
    }

    public Point2D.Float getPositionPoint(int x, int y) {
        Rectangle box = this.getBox();
        Point2D.Float posPt = new Point2D.Float((float)((double)((float)(x - box.x) / (float)box.width) * (this.bounds_.xMax - this.bounds_.xMin)), (float)((double)((float)(box.y + box.height - y) / (float)box.height) * (this.bounds_.yMax - this.bounds_.yMin)));
        return posPt;
    }

    public Rectangle getBox() {
        Rectangle box = this.getBounds();
        box.x = (int)this.xMargin_;
        box.y = (int)this.yMargin_;
        box.height = (int)((float)box.height - 2.0f * this.yMargin_);
        box.width = (int)((float)box.width - 2.0f * this.xMargin_);
        return box;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.red);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle box = this.getBox();
        Color oldColor = g2d.getColor();
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(Color.black);
        g2d.setStroke(new BasicStroke(2.0f));
        this.drawGraph(g2d, box);
        this.drawCursor(g2d, box, this.cursorLoPos_);
        this.drawCursor(g2d, box, this.cursorHiPos_);
        this.drawMapping(g2d, box, this.cursorLoPos_, this.cursorHiPos_, this.gamma_);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
    }

    public static interface CursorListener {
        public void contrastMinInput(int var1);

        public void contrastMaxInput(int var1);

        public void onLeftCursor(double var1);

        public void onRightCursor(double var1);

        public void onGammaCurve(double var1);
    }
}

