/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.micromanager.graph.GraphData;
import org.micromanager.utils.ReportingUtils;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = -1280955888510181945L;
    private GraphData data_;
    protected GraphData.Bounds bounds_;
    private float xMargin_ = 50.0f;
    private float yMargin_ = 50.0f;
    boolean textVisible_ = true;
    boolean gridVisible_ = true;
    private int TEXT_SIZE = 10;
    private float TEXT_OFFSET_X = 40.0f;
    private float TEXT_OFFSET_Y = 20.0f;
    float cursorLoPos_;
    float cursorHiPos_;
    double gamma_;
    private boolean fillTrace_ = false;
    private Color traceColor_ = Color.black;

    public GraphPanel() {
        this.data_ = new GraphData();
        this.setAutoBounds();
        this.cursorLoPos_ = (float)this.bounds_.xMin;
        this.cursorHiPos_ = (float)this.bounds_.xMax;
        this.gamma_ = 1.0;
    }

    public void setData(GraphData d) {
        this.data_ = d;
    }

    public void setGamma(double gamma) {
        this.gamma_ = gamma;
    }

    public void setTraceStyle(boolean fillTrace, Color color) {
        this.fillTrace_ = fillTrace;
        this.traceColor_ = color;
    }

    public final void setAutoBounds() {
        this.bounds_ = this.data_.getBounds();
        this.AdjustCursors();
    }

    public void setMargins(float x, float y) {
        this.xMargin_ = x;
        this.yMargin_ = y;
    }

    public void setCursors(double low, double high, double gamma) {
        this.cursorLoPos_ = (float)low;
        this.cursorHiPos_ = (float)high;
        this.gamma_ = gamma;
    }

    public void setTextVisible(boolean state) {
        this.textVisible_ = state;
    }

    public void setGridVisible(boolean state) {
        this.gridVisible_ = state;
    }

    public GraphData.Bounds getGraphBounds() {
        return this.bounds_;
    }

    public void setBounds(double xMin, double xMax, double yMin, double yMax) {
        this.bounds_.xMin = xMin;
        this.bounds_.xMax = xMax;
        this.bounds_.yMin = yMin;
        this.bounds_.yMax = yMax;
        this.AdjustCursors();
    }

    public void setBounds(GraphData.Bounds b) {
        this.bounds_ = b;
        this.AdjustCursors();
    }

    private void AdjustCursors() {
        this.cursorLoPos_ = Math.max(this.cursorLoPos_, (float)this.bounds_.xMin);
    }

    protected void drawGraph(Graphics2D g, Rectangle box) {
        if (this.data_.getSize() < 2) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(this.traceColor_);
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 1.0E-10) {
            return;
        }
        float xUnit = (float)((double)box.width / this.bounds_.getRangeX());
        float yUnit = (float)((double)box.height / this.bounds_.getRangeY());
        GeneralPath trace = new GeneralPath(0, this.data_.getSize() + 1);
        Point2D.Float pt0 = this.getDevicePoint(new Point2D.Float(0.0f, 0.0f), box, xUnit, yUnit);
        trace.moveTo(pt0.x, pt0.y);
        Point2D.Float pt1 = this.getDevicePoint(new Point2D.Float(1.0f, 0.0f), box, xUnit, yUnit);
        float halfWidth = (pt1.x - pt0.x) / 2.0f;
        for (int i = 0; i < this.data_.getSize(); ++i) {
            Point2D.Float pt = this.getDevicePoint(this.data_.getPoint(i), box, xUnit, yUnit);
            trace.lineTo(pt.x - halfWidth, pt.y);
            trace.lineTo(pt.x + halfWidth, pt.y);
        }
        pt0 = this.getDevicePoint(new Point2D.Float((float)this.data_.getPoint(this.data_.getSize() - 1).getX(), 0.0f), box, xUnit, yUnit);
        trace.lineTo(pt0.x, pt0.y);
        if (this.fillTrace_) {
            g.fill(trace);
        } else {
            g.draw(trace);
        }
        g.setColor(oldColor);
    }

    public void drawCursor(Graphics2D g, Rectangle box, float xPos) {
    }

    public void drawMapping(Graphics2D g, Rectangle box, float xStart, float xEnd, double gamma) {
    }

    public Point2D.Float getDevicePointUnclippedXMax(Point2D.Float pt, Rectangle box, float xUnit, float yUnit) {
        Point2D.Float ptDev = new Point2D.Float((float)((double)pt.x - this.bounds_.xMin) * xUnit + (float)box.x, (float)box.height - (float)((double)pt.y - this.bounds_.yMin) * yUnit + (float)box.y);
        ptDev.x = Math.max(ptDev.x, (float)box.x);
        ptDev.y = Math.max(Math.min(ptDev.y, (float)box.y + (float)box.height), (float)box.y);
        return ptDev;
    }

    public Point2D.Float getDevicePoint(Point2D.Float pt, Rectangle box, float xUnit, float yUnit) {
        Point2D.Float ptDev = new Point2D.Float((float)((double)pt.x - this.bounds_.xMin) * xUnit + (float)box.x, (float)box.height - (float)((double)pt.y - this.bounds_.yMin) * yUnit + (float)box.y);
        ptDev.x = Math.max(Math.min(ptDev.x, (float)box.x + (float)box.width), (float)box.x);
        ptDev.y = Math.max(Math.min(ptDev.y, (float)box.y + (float)box.height), (float)box.y);
        return ptDev;
    }

    public Point2D.Float getPositionPoint(int x, int y) {
        Rectangle box = this.getBox();
        Point2D.Float posPt = new Point2D.Float((float)((double)((float)(x - box.x) / (float)box.width) * (this.bounds_.xMax - this.bounds_.xMin)), (float)((double)((float)(box.y + box.height - y) / (float)box.height) * (this.bounds_.yMax - this.bounds_.yMin)));
        return posPt;
    }

    private void drawGrid(Graphics2D g, Rectangle box) {
        if (this.data_.getSize() < 2) {
            ReportingUtils.logMessage("Invalid size " + this.data_.getSize());
            return;
        }
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 0.0) {
            return;
        }
        int tickCountX = 5;
        int tickCountY = 5;
        int tickSizeX = box.width / tickCountX;
        int tickSizeY = box.height / tickCountY;
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(1.0f));
        g.draw(box);
        if (this.gridVisible_) {
            int i;
            for (i = 1; i < tickCountX; ++i) {
                int x = box.x + tickSizeX * i;
                g.draw(new Line2D.Float(x, box.y + box.height, x, box.y));
            }
            for (i = 1; i < tickCountX; ++i) {
                int y = box.y + tickSizeY * i;
                g.draw(new Line2D.Float(box.x, y, box.x + box.width, y));
            }
        }
        g.setColor(Color.black);
        if (this.textVisible_) {
            Font fnt = new Font("Arial", 0, this.TEXT_SIZE);
            Font oldFont = g.getFont();
            g.setFont(fnt);
            DecimalFormat fmt = new DecimalFormat("#0.00");
            g.drawString(fmt.format(this.bounds_.xMin), (float)box.x, (float)(box.y + box.height) + this.TEXT_OFFSET_Y);
            g.drawString(fmt.format(this.bounds_.xMax).toString(), (float)(box.x + box.width), (float)(box.y + box.height) + this.TEXT_OFFSET_Y);
            g.drawString(fmt.format(this.bounds_.yMin).toString(), (float)box.x - this.TEXT_OFFSET_X, (float)(box.y + box.height));
            g.drawString(fmt.format(this.bounds_.yMax).toString(), (float)box.x - this.TEXT_OFFSET_X, (float)box.y);
            g.setFont(oldFont);
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public Rectangle getBox() {
        Rectangle box = this.getBounds();
        box.x = (int)this.xMargin_;
        box.y = (int)this.yMargin_;
        box.height = (int)((float)box.height - 2.0f * this.yMargin_);
        box.width = (int)((float)box.width - 2.0f * this.xMargin_);
        return box;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle box = this.getBox();
        Color oldColor = g2d.getColor();
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(Color.black);
        g2d.setStroke(new BasicStroke(2.0f));
        this.drawGraph(g2d, box);
        this.drawGrid(g2d, box);
        this.drawCursor(g2d, box, this.cursorLoPos_);
        this.drawCursor(g2d, box, this.cursorHiPos_);
        this.drawMapping(g2d, box, this.cursorLoPos_, this.cursorHiPos_, this.gamma_);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
    }
}

