/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import org.micromanager.MMStudio;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.GraphPanel;
import org.micromanager.utils.MMFrame;

public class GraphFrame
extends MMFrame {
    private static final long serialVersionUID = -4969643705861534777L;
    private JTextField fldYMax;
    private JTextField fldYMin;
    private JTextField fldXMax;
    private JTextField fldXMin;
    private SpringLayout springLayout;
    private GraphPanel panel_;

    private void updateBounds() {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        DecimalFormat fmt = new DecimalFormat("#0.00");
        this.fldXMin.setText(fmt.format(bounds.xMin));
        this.fldXMax.setText(fmt.format(bounds.xMax));
        this.fldYMin.setText(fmt.format(bounds.yMin));
        this.fldYMax.setText(fmt.format(bounds.yMax));
    }

    public void setAutoScale() {
        this.panel_.setAutoBounds();
        this.updateBounds();
        this.refresh();
    }

    public void setData(GraphData data) {
        this.panel_.setData(data);
        this.refresh();
    }

    public void refresh() {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        if (this.fldXMin.getText().length() > 0 && this.fldYMin.getText().length() > 0 && this.fldXMax.getText().length() > 0 && this.fldYMax.getText().length() > 0) {
            bounds.xMin = Double.parseDouble(this.fldXMin.getText());
            bounds.xMax = Double.parseDouble(this.fldXMax.getText());
            bounds.yMin = Double.parseDouble(this.fldYMin.getText());
            bounds.yMax = Double.parseDouble(this.fldYMax.getText());
        }
        this.panel_.setBounds(bounds);
        this.panel_.repaint();
    }

    public void SetXLimits(double xmin, double xmax) {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        if (this.fldXMin.getText().length() > 0 && this.fldYMin.getText().length() > 0 && this.fldXMax.getText().length() > 0 && this.fldYMax.getText().length() > 0) {
            bounds.xMin = xmin;
            bounds.xMax = xmax;
            bounds.yMin = Double.parseDouble(this.fldYMin.getText());
            bounds.yMax = Double.parseDouble(this.fldYMax.getText());
        }
        this.panel_.setBounds(bounds);
        this.panel_.repaint();
    }

    public GraphFrame() {
        this.setFont(new Font("Arial", 0, 10));
        this.setTitle("Graph");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.loadAndRestorePosition(100, 100, 542, 298);
        this.setDefaultCloseOperation(2);
        this.panel_ = new GraphPanel();
        this.panel_.setBorder(new LineBorder(Color.black, 1, false));
        this.getContentPane().add(this.panel_);
        this.springLayout.putConstraint("South", (Component)this.panel_, -9, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.panel_, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.panel_, 10, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.panel_, 120, "West", (Component)this.getContentPane());
        JLabel xMinLabel = new JLabel();
        xMinLabel.setFont(new Font("Arial", 0, 10));
        xMinLabel.setText("X Min");
        this.getContentPane().add(xMinLabel);
        this.springLayout.putConstraint("East", (Component)xMinLabel, 44, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)xMinLabel, 9, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)xMinLabel, 15, "North", (Component)this.getContentPane());
        this.fldXMin = new JTextField();
        this.getContentPane().add(this.fldXMin);
        this.springLayout.putConstraint("South", (Component)this.fldXMin, 32, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldXMin, -5, "West", (Component)this.panel_);
        this.springLayout.putConstraint("North", (Component)this.fldXMin, 15, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.fldXMin, 50, "West", (Component)this.getContentPane());
        JLabel xMinLabel_1 = new JLabel();
        xMinLabel_1.setFont(new Font("Arial", 0, 10));
        xMinLabel_1.setText("X Max");
        this.getContentPane().add(xMinLabel_1);
        this.springLayout.putConstraint("South", (Component)xMinLabel_1, 50, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)xMinLabel_1, 36, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)xMinLabel_1, 49, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)xMinLabel_1, 9, "West", (Component)this.getContentPane());
        this.fldXMax = new JTextField();
        this.getContentPane().add(this.fldXMax);
        this.springLayout.putConstraint("South", (Component)this.fldXMax, 53, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldXMax, 36, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldXMax, 0, "East", (Component)this.fldXMin);
        this.springLayout.putConstraint("West", (Component)this.fldXMax, 50, "West", (Component)this.getContentPane());
        JLabel xMinLabel_2 = new JLabel();
        xMinLabel_2.setFont(new Font("Arial", 0, 10));
        xMinLabel_2.setText("Y Min");
        this.getContentPane().add(xMinLabel_2);
        this.springLayout.putConstraint("South", (Component)xMinLabel_2, 79, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)xMinLabel_2, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)xMinLabel_2, 49, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)xMinLabel_2, 9, "West", (Component)this.getContentPane());
        this.fldYMin = new JTextField();
        this.getContentPane().add(this.fldYMin);
        this.springLayout.putConstraint("South", (Component)this.fldYMin, 82, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldYMin, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldYMin, 0, "East", (Component)this.fldXMax);
        this.springLayout.putConstraint("West", (Component)this.fldYMin, 50, "West", (Component)this.getContentPane());
        this.fldYMax = new JTextField();
        this.getContentPane().add(this.fldYMax);
        this.springLayout.putConstraint("South", (Component)this.fldYMax, 103, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldYMax, 86, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldYMax, 0, "East", (Component)this.fldYMin);
        this.springLayout.putConstraint("West", (Component)this.fldYMax, 50, "West", (Component)this.getContentPane());
        JLabel xMinLabel_1_2 = new JLabel();
        xMinLabel_1_2.setFont(new Font("Arial", 0, 10));
        xMinLabel_1_2.setText("Y Max");
        this.getContentPane().add(xMinLabel_1_2);
        this.springLayout.putConstraint("South", (Component)xMinLabel_1_2, 100, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)xMinLabel_1_2, 86, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)xMinLabel_1_2, 55, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)xMinLabel_1_2, 9, "West", (Component)this.getContentPane());
        JButton btnAutoscale = new JButton();
        btnAutoscale.setFont(new Font("Arial", 0, 10));
        btnAutoscale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphFrame.this.setAutoScale();
            }
        });
        btnAutoscale.setText("Autoscale");
        this.getContentPane().add(btnAutoscale);
        this.springLayout.putConstraint("East", (Component)btnAutoscale, 116, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)btnAutoscale, 115, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)btnAutoscale, 25, "West", (Component)this.getContentPane());
        JButton btnRefresh = new JButton();
        btnRefresh.setFont(new Font("Arial", 0, 10));
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MMStudio.getInstance().updateLineProfile();
            }
        });
        btnRefresh.setText("Refresh");
        this.getContentPane().add(btnRefresh);
        this.springLayout.putConstraint("North", (Component)btnRefresh, 137, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)btnRefresh, 116, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)btnRefresh, 25, "West", (Component)this.getContentPane());
    }
}

