/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.geom.Point2D;

public class GraphData {
    private double[] xVals_ = new double[100];
    private double[] yVals_ = new double[100];
    private double xBinSize_;

    public GraphData() {
        for (int i = 0; i < this.xVals_.length; ++i) {
            this.xVals_[i] = i;
            this.yVals_[i] = 0.0;
        }
    }

    public Bounds getBounds() {
        int i;
        Bounds b = new Bounds();
        b.xMax = Double.MIN_VALUE;
        b.xMin = Double.MAX_VALUE;
        b.yMax = Double.MIN_VALUE;
        b.yMin = Double.MAX_VALUE;
        for (i = 0; i < this.xVals_.length; ++i) {
            if (this.xVals_[i] > b.xMax) {
                b.xMax = this.xVals_[i];
            }
            if (!(this.xVals_[i] < b.xMin)) continue;
            b.xMin = this.xVals_[i];
        }
        for (i = 0; i < this.yVals_.length; ++i) {
            if (this.yVals_[i] > b.yMax) {
                b.yMax = this.yVals_[i];
            }
            if (!(this.yVals_[i] < b.yMin)) continue;
            b.yMin = this.yVals_[i];
        }
        return b;
    }

    public int getSize() {
        return this.xVals_.length;
    }

    public double getXBinSize() {
        return this.xBinSize_;
    }

    public void setXBinSize(double binSize) {
        this.xBinSize_ = binSize;
    }

    public Point2D.Float getPoint(int index) {
        double x = this.xVals_[index];
        double y = index < this.yVals_.length ? this.yVals_[index] : 0.0;
        return new Point2D.Float((float)x, (float)y);
    }

    public void setData(double[] xVals, double[] yVals) {
        this.xVals_ = xVals;
        this.yVals_ = yVals;
    }

    public void setData(double[] yVals) {
        this.yVals_ = yVals;
        this.xVals_ = new double[yVals.length];
        for (int i = 0; i < this.xVals_.length; ++i) {
            this.xVals_[i] = i;
        }
    }

    public void setData(int[] yIntVals) {
        this.yVals_ = new double[yIntVals.length];
        this.xVals_ = new double[yIntVals.length];
        for (int i = 0; i < yIntVals.length; ++i) {
            this.yVals_[i] = yIntVals[i];
            this.xVals_[i] = i;
        }
    }

    public class Bounds {
        public double xMin = 0.0;
        public double xMax = 0.0;
        public double yMin = 0.0;
        public double yMax = 0.0;

        public Bounds() {
            GraphData.this.xBinSize_ = 1.0;
        }

        double getRangeX() {
            return this.xMax - this.xMin;
        }

        double getRangeY() {
            return this.yMax - this.yMin;
        }
    }
}

