/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.gui.Overlay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.micromanager.graph.HistogramControlsState;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.MMScaleBar;

public class ContrastPanel
extends JPanel {
    private static final String PREF_AUTOSTRETCH = "stretch_contrast";
    private static final String PREF_REJECT_OUTLIERS = "reject_outliers";
    private static final String PREF_REJECT_FRACTION = "reject_fraction";
    private static final String PREF_LOG_HIST = "log_hist";
    private static final String PREF_SYNC_CHANNELS = "sync_channels";
    private static final String PREF_SLOW_HIST = "slow_hist";
    private JScrollPane histDisplayScrollPane_;
    private JComboBox displayModeCombo_;
    private JCheckBox autostretchCheckBox_;
    private JCheckBox rejectOutliersCheckBox_;
    private JSpinner rejectPercentSpinner_;
    private JCheckBox logHistCheckBox_;
    private JCheckBox sizeBarCheckBox_;
    private JComboBox sizeBarComboBox_;
    private JComboBox sizeBarColorComboBox_;
    private JCheckBox syncChannelsCheckBox_;
    private JCheckBox slowHistCheckBox_;
    private JLabel displayModeLabel_;
    private Preferences prefs_;
    private Color overlayColor_ = Color.white;
    private Histograms currentHistograms_;
    private VirtualAcquisitionDisplay currentDisplay_;

    public ContrastPanel() {
        this.initializeGUI();
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.initializeHistogramDisplayArea();
    }

    private void initializeHistogramDisplayArea() {
        this.histDisplayScrollPane_.setHorizontalScrollBarPolicy(31);
        this.showCurrentHistograms();
        this.configureControls();
    }

    private void showCurrentHistograms() {
        this.histDisplayScrollPane_.setViewportView(this.currentHistograms_ != null ? (JPanel)((Object)this.currentHistograms_) : new JPanel());
        if (this.currentDisplay_ != null && this.currentDisplay_.getImageCache().getNumDisplayChannels() > 1) {
            this.histDisplayScrollPane_.setVerticalScrollBarPolicy(20);
        } else {
            this.histDisplayScrollPane_.setVerticalScrollBarPolicy(21);
        }
        this.repaint();
    }

    public HistogramControlsState createDefaultControlsState() {
        HistogramControlsState state = new HistogramControlsState();
        state.autostretch = this.prefs_.getBoolean(PREF_AUTOSTRETCH, true);
        state.percentToIgnore = this.prefs_.getDouble(PREF_REJECT_FRACTION, 2.0);
        state.logHist = this.prefs_.getBoolean(PREF_LOG_HIST, false);
        state.ignoreOutliers = this.prefs_.getBoolean(PREF_REJECT_OUTLIERS, false);
        state.syncChannels = this.prefs_.getBoolean(PREF_SYNC_CHANNELS, false);
        state.slowHist = this.prefs_.getBoolean(PREF_SLOW_HIST, false);
        state.scaleBar = false;
        state.scaleBarColorIndex = 0;
        state.scaleBarLocationIndex = 0;
        return state;
    }

    private void configureControls() {
        this.loadControlsStates();
        if (this.currentDisplay_ == null) {
            this.displayModeLabel_.setEnabled(false);
            this.displayModeCombo_.setEnabled(false);
            this.sizeBarCheckBox_.setEnabled(false);
            this.sizeBarComboBox_.setEnabled(false);
            this.sizeBarColorComboBox_.setEnabled(false);
            this.autostretchCheckBox_.setEnabled(false);
            this.slowHistCheckBox_.setEnabled(false);
            this.logHistCheckBox_.setEnabled(false);
            this.rejectOutliersCheckBox_.setEnabled(false);
            this.rejectPercentSpinner_.setEnabled(false);
            this.syncChannelsCheckBox_.setEnabled(false);
        } else if (this.currentDisplay_.getImageCache().getNumDisplayChannels() == 1) {
            this.displayModeLabel_.setEnabled(false);
            this.displayModeCombo_.setEnabled(false);
            this.sizeBarCheckBox_.setEnabled(true);
            this.sizeBarComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.sizeBarColorComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.syncChannelsCheckBox_.setEnabled(false);
            this.logHistCheckBox_.setEnabled(true);
            this.slowHistCheckBox_.setEnabled(true);
            this.autostretchCheckBox_.setEnabled(true);
            if (this.autostretchCheckBox_.isSelected()) {
                this.rejectOutliersCheckBox_.setEnabled(true);
                this.rejectPercentSpinner_.setEnabled(this.rejectOutliersCheckBox_.isSelected());
            } else {
                this.rejectOutliersCheckBox_.setEnabled(false);
                this.rejectPercentSpinner_.setEnabled(false);
            }
        } else {
            this.displayModeLabel_.setEnabled(true);
            this.displayModeCombo_.setEnabled(true);
            this.sizeBarCheckBox_.setEnabled(true);
            this.sizeBarComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.sizeBarColorComboBox_.setEnabled(this.sizeBarCheckBox_.isSelected());
            this.logHistCheckBox_.setEnabled(true);
            this.slowHistCheckBox_.setEnabled(true);
            this.syncChannelsCheckBox_.setEnabled(true);
        }
    }

    private void loadControlsStates() {
        HistogramControlsState state = this.currentDisplay_ != null ? this.currentDisplay_.getHistogramControlsState() : this.createDefaultControlsState();
        this.logHistCheckBox_.setSelected(state.logHist);
        this.rejectPercentSpinner_.setValue(state.percentToIgnore);
        this.autostretchCheckBox_.setSelected(state.autostretch);
        this.rejectOutliersCheckBox_.setSelected(state.ignoreOutliers);
        this.syncChannelsCheckBox_.setSelected(state.syncChannels);
        this.slowHistCheckBox_.setSelected(state.slowHist);
        boolean bar = state.scaleBar;
        int color = state.scaleBarColorIndex;
        int location = state.scaleBarLocationIndex;
        this.sizeBarCheckBox_.setSelected(bar);
        this.sizeBarColorComboBox_.setSelectedIndex(color);
        this.sizeBarComboBox_.setSelectedIndex(location);
        if (this.currentDisplay_ != null && this.currentDisplay_.getImagePlus() instanceof CompositeImage) {
            CompositeImage ci = (CompositeImage)this.currentDisplay_.getImagePlus();
            boolean[] active = new boolean[ci.getActiveChannels().length];
            System.arraycopy(ci.getActiveChannels(), 0, active, 0, active.length);
            int index = ((CompositeImage)this.currentDisplay_.getImagePlus()).getMode() - 2;
            if (index == -1) {
                index = 2;
            }
            this.displayModeCombo_.setSelectedIndex(index);
            System.arraycopy(active, 0, ci.getActiveChannels(), 0, active.length);
            ci.updateAndDraw();
            this.currentDisplay_.updateAndDraw(true);
        } else {
            this.displayModeCombo_.setSelectedIndex(1);
        }
    }

    private void saveCheckBoxStates() {
        this.prefs_.putBoolean(PREF_AUTOSTRETCH, this.autostretchCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_LOG_HIST, this.logHistCheckBox_.isSelected());
        this.prefs_.putDouble(PREF_REJECT_FRACTION, (Double)this.rejectPercentSpinner_.getValue());
        this.prefs_.putBoolean(PREF_REJECT_OUTLIERS, this.rejectOutliersCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_SYNC_CHANNELS, this.syncChannelsCheckBox_.isSelected());
        this.prefs_.putBoolean(PREF_SLOW_HIST, this.slowHistCheckBox_.isSelected());
        if (this.currentDisplay_ == null) {
            return;
        }
        HistogramControlsState s = this.currentDisplay_.getHistogramControlsState();
        s.autostretch = this.autostretchCheckBox_.isSelected();
        s.ignoreOutliers = this.rejectOutliersCheckBox_.isSelected();
        s.logHist = this.logHistCheckBox_.isSelected();
        s.percentToIgnore = (Double)this.rejectPercentSpinner_.getValue();
        s.slowHist = this.slowHistCheckBox_.isSelected();
        s.syncChannels = this.syncChannelsCheckBox_.isSelected();
        s.scaleBar = this.sizeBarCheckBox_.isSelected();
        s.scaleBarColorIndex = this.sizeBarColorComboBox_.getSelectedIndex();
        s.scaleBarLocationIndex = this.sizeBarComboBox_.getSelectedIndex();
    }

    private void initializeGUI() {
        JPanel jPanel1 = new JPanel();
        this.displayModeLabel_ = new JLabel();
        this.displayModeCombo_ = new JComboBox();
        this.autostretchCheckBox_ = new JCheckBox();
        this.rejectOutliersCheckBox_ = new JCheckBox();
        this.rejectPercentSpinner_ = new JSpinner();
        this.logHistCheckBox_ = new JCheckBox();
        this.sizeBarCheckBox_ = new JCheckBox();
        this.sizeBarComboBox_ = new JComboBox();
        this.sizeBarColorComboBox_ = new JComboBox();
        this.histDisplayScrollPane_ = new JScrollPane();
        this.setPreferredSize(new Dimension(400, 594));
        this.displayModeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Color", "Grayscale", "Composite"}));
        this.displayModeCombo_.setToolTipText("<html>Choose display mode:<br> - Composite = Multicolor overlay<br> - Color = Single channel color view<br> - Grayscale = Single channel grayscale view</li></ul></html>");
        this.displayModeCombo_.setSelectedIndex(2);
        this.displayModeCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.displayModeComboActionPerformed();
            }
        });
        this.displayModeLabel_.setText("Display mode:");
        this.autostretchCheckBox_.setText("Autostretch");
        this.autostretchCheckBox_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ContrastPanel.this.autostretchCheckBoxStateChanged();
            }
        });
        this.rejectOutliersCheckBox_.setText("ignore %");
        this.rejectOutliersCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.rejectOutliersCheckBoxAction();
            }
        });
        this.rejectPercentSpinner_.setFont(new Font("Lucida Grande", 0, 10));
        this.rejectPercentSpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ContrastPanel.this.rejectPercentageChanged();
            }
        });
        this.rejectPercentSpinner_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ContrastPanel.this.rejectPercentageChanged();
            }
        });
        this.rejectPercentSpinner_.setModel(new SpinnerNumberModel(0.02, 0.0, 100.0, 0.1));
        this.logHistCheckBox_.setText("Log hist");
        this.logHistCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.logScaleCheckBoxActionPerformed();
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).addComponent(this.displayModeLabel_).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayModeCombo_, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autostretchCheckBox_).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rejectOutliersCheckBox_).addGap(6, 6, 6).addComponent(this.rejectPercentSpinner_, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logHistCheckBox_)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.autostretchCheckBox_).addComponent(this.rejectOutliersCheckBox_).addComponent(this.rejectPercentSpinner_, -2, -1, -2).addComponent(this.logHistCheckBox_)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayModeCombo_, -2, -1, -2).addComponent(this.displayModeLabel_)));
        this.sizeBarCheckBox_.setText("Scale Bar");
        this.sizeBarCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.sizeBarCheckBoxActionPerformed();
            }
        });
        this.sizeBarComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Top-Left", "Top-Right", "Bottom-Left", "Bottom-Right"}));
        this.sizeBarComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.sizeBarComboBoxActionPerformed();
            }
        });
        this.sizeBarColorComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"White", "Black", "Yellow", "Gray"}));
        this.sizeBarColorComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContrastPanel.this.overlayColorComboBox_ActionPerformed();
            }
        });
        this.syncChannelsCheckBox_ = new JCheckBox("Sync channels");
        this.syncChannelsCheckBox_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContrastPanel.this.syncChannelsCheckboxAction();
            }
        });
        this.slowHistCheckBox_ = new JCheckBox("Slow hist");
        this.slowHistCheckBox_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContrastPanel.this.slowHistCheckboxAction();
            }
        });
        GroupLayout channelsTablePanel_Layout = new GroupLayout(this);
        this.setLayout(channelsTablePanel_Layout);
        channelsTablePanel_Layout.setHorizontalGroup(channelsTablePanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsTablePanel_Layout.createSequentialGroup().addComponent(this.sizeBarCheckBox_).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sizeBarComboBox_, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeBarColorComboBox_, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.syncChannelsCheckBox_, -2, -1, -2).addComponent(this.slowHistCheckBox_, -2, -1, -2)).addComponent(jPanel1, -2, -1, -2).addGroup(channelsTablePanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.histDisplayScrollPane_, -1, 620, Short.MAX_VALUE)));
        channelsTablePanel_Layout.setVerticalGroup(channelsTablePanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsTablePanel_Layout.createSequentialGroup().addGroup(channelsTablePanel_Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeBarCheckBox_).addComponent(this.sizeBarComboBox_, -2, -1, -2).addComponent(this.sizeBarColorComboBox_, -2, -1, -2).addComponent(this.syncChannelsCheckBox_, -2, -1, -2).addComponent(this.slowHistCheckBox_, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addContainerGap(589, Short.MAX_VALUE)).addGroup(channelsTablePanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(channelsTablePanel_Layout.createSequentialGroup().addGap(79, 79, 79).addComponent(this.histDisplayScrollPane_, -1, 571, Short.MAX_VALUE))));
    }

    public void setDisplayMode(int mode) {
        if (mode == 1) {
            this.displayModeCombo_.setSelectedIndex(2);
        } else if (mode == 2) {
            this.displayModeCombo_.setSelectedIndex(0);
        } else if (mode == 3) {
            this.displayModeCombo_.setSelectedIndex(1);
        }
    }

    public void redrawSizeBar() {
        this.showSizeBar();
    }

    private void showSizeBar() {
        boolean show = this.sizeBarCheckBox_.isSelected();
        if (this.currentDisplay_ == null) {
            return;
        }
        ImagePlus ip = this.currentDisplay_.getHyperImage();
        if (ip == null) {
            return;
        }
        if (show) {
            MMScaleBar sizeBar = new MMScaleBar(ip);
            Overlay ol = ip.getOverlay();
            if (ol != null) {
                this.removeScaleBarFromOverlay(ol);
            } else {
                ol = new Overlay();
            }
            ol.setStrokeColor(this.overlayColor_);
            String selected = (String)this.sizeBarComboBox_.getSelectedItem();
            if (selected.equals("Top-Right")) {
                sizeBar.setPosition(MMScaleBar.Position.TOPRIGHT);
            }
            if (selected.equals("Top-Left")) {
                sizeBar.setPosition(MMScaleBar.Position.TOPLEFT);
            }
            if (selected.equals("Bottom-Right")) {
                sizeBar.setPosition(MMScaleBar.Position.BOTTOMRIGHT);
            }
            if (selected.equals("Bottom-Left")) {
                sizeBar.setPosition(MMScaleBar.Position.BOTTOMLEFT);
            }
            sizeBar.addToOverlay(ol);
            ol.setStrokeColor(this.overlayColor_);
            ip.setOverlay(ol);
        } else {
            Overlay ol = ip.getOverlay();
            if (ol != null) {
                this.removeScaleBarFromOverlay(ol);
            }
            ip.setOverlay(ol);
        }
        this.saveCheckBoxStates();
    }

    private void removeScaleBarFromOverlay(Overlay ol) {
        MMScaleBar.removeScaleBarFromOverlay(ol);
    }

    private void overlayColorComboBox_ActionPerformed() {
        if (this.sizeBarColorComboBox_.getSelectedItem().equals("Black")) {
            this.overlayColor_ = Color.black;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("White")) {
            this.overlayColor_ = Color.white;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("Yellow")) {
            this.overlayColor_ = Color.yellow;
        } else if (this.sizeBarColorComboBox_.getSelectedItem().equals("Gray")) {
            this.overlayColor_ = Color.gray;
        }
        if (this.sizeBarCheckBox_.isSelected()) {
            this.showSizeBar();
        }
    }

    private void syncChannelsCheckboxAction() {
        if (!this.syncChannelsCheckBox_.isEnabled()) {
            return;
        }
        boolean synced = this.syncChannelsCheckBox_.isSelected();
        if (synced) {
            this.autostretchCheckBox_.setSelected(false);
            this.autostretchCheckBox_.setEnabled(false);
            if (this.currentHistograms_ != null) {
                ((MultiChannelHistograms)this.currentHistograms_).setChannelContrastFromFirst();
                ((MultiChannelHistograms)this.currentHistograms_).setChannelDisplayModeFromFirst();
            }
        } else {
            this.autostretchCheckBox_.setEnabled(true);
        }
        this.saveCheckBoxStates();
    }

    private void slowHistCheckboxAction() {
        this.saveCheckBoxStates();
    }

    public void displayModeComboActionPerformed() {
        if (this.currentDisplay_ == null || !(this.currentDisplay_.getHyperImage() instanceof CompositeImage)) {
            return;
        }
        int state = this.displayModeCombo_.getSelectedIndex();
        int mode = state == 0 ? 2 : (state == 1 ? 3 : 1);
        CompositeImage ci = (CompositeImage)this.currentDisplay_.getHyperImage();
        if (state == 2 && this.currentDisplay_.getImageCache().getNumDisplayChannels() > 7) {
            JOptionPane.showMessageDialog(this, "Images with more than 7 channels cannot be displayed in Composite mode");
            this.displayModeCombo_.setSelectedIndex(ci.getMode() - 2);
            return;
        }
        ci.setMode(mode);
        ci.updateAndDraw();
        this.currentDisplay_.updateAndDraw(true);
        this.saveCheckBoxStates();
    }

    private void autostretchCheckBoxStateChanged() {
        this.rejectOutliersCheckBox_.setEnabled(this.autostretchCheckBox_.isSelected());
        boolean rejectem = this.rejectOutliersCheckBox_.isSelected() && this.autostretchCheckBox_.isSelected();
        this.rejectPercentSpinner_.setEnabled(rejectem);
        this.saveCheckBoxStates();
        if (this.autostretchCheckBox_.isSelected()) {
            if (this.currentHistograms_ != null) {
                this.currentHistograms_.autoscaleAllChannels();
            }
        } else {
            this.rejectOutliersCheckBox_.setSelected(false);
        }
    }

    private void rejectOutliersCheckBoxAction() {
        this.saveCheckBoxStates();
        this.rejectPercentSpinner_.setEnabled(this.rejectOutliersCheckBox_.isSelected());
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.rejectOutliersChangeAction();
        }
    }

    private void rejectPercentageChanged() {
        this.saveCheckBoxStates();
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.rejectOutliersChangeAction();
        }
    }

    private void logScaleCheckBoxActionPerformed() {
        this.saveCheckBoxStates();
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.calcAndDisplayHistAndStats(true);
        }
    }

    public void sizeBarCheckBoxActionPerformed() {
        boolean checked = this.sizeBarCheckBox_.isSelected();
        this.sizeBarComboBox_.setEnabled(checked);
        this.sizeBarColorComboBox_.setEnabled(checked);
        this.showSizeBar();
    }

    private void sizeBarComboBoxActionPerformed() {
        if (this.sizeBarCheckBox_.isSelected()) {
            this.showSizeBar();
        }
    }

    public void autostretch() {
        if (this.currentHistograms_ != null) {
            this.currentHistograms_.autostretch();
        }
    }

    public void imageChanged() {
        if (this.currentHistograms_ != null) {
            ((JPanel)((Object)this.currentHistograms_)).repaint();
        }
    }

    public synchronized void displayChanged(VirtualAcquisitionDisplay disp) {
        this.currentDisplay_ = disp;
        this.currentHistograms_ = disp != null ? disp.getHistograms() : null;
        this.configureControls();
        this.showCurrentHistograms();
    }

    public void disableAutostretch() {
        this.autostretchCheckBox_.setSelected(false);
        this.saveCheckBoxStates();
    }
}

