/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import com.swtdesigner.SwingResourceManager;
import ij.CompositeImage;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mmcorej.CMMCore;
import org.json.JSONArray;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.api.ImageCache;
import org.micromanager.dialogs.AcqControlDlg;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.HistogramPanel;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.imagedisplay.MMCompositeImage;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.utils.HistogramUtils;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class ChannelControlPanel
extends JPanel
implements HistogramPanel.CursorListener {
    private static final Dimension CONTROLS_SIZE = new Dimension(130, 150);
    public static final Dimension MINIMUM_SIZE = new Dimension(400, ChannelControlPanel.CONTROLS_SIZE.height);
    private static final int NUM_BINS = 256;
    private final int channelIndex_;
    private HistogramPanel hp_;
    private final MultiChannelHistograms mcHistograms_;
    private final VirtualAcquisitionDisplay display_;
    private final ImageCache cache_;
    private final CompositeImage img_;
    private JButton autoButton_;
    private JButton zoomInButton_;
    private JButton zoomOutButton_;
    private JCheckBox channelNameCheckbox_;
    private JLabel colorPickerLabel_;
    private JButton fullButton_;
    private JPanel histogramPanelHolder_;
    private JLabel minMaxLabel_;
    private JComboBox histRangeComboBox_;
    private double binSize_;
    private int height_;
    private String histMaxLabel_;
    private int histMax_;
    private JPanel controls_;
    private JPanel controlsHolderPanel_;
    private int contrastMin_;
    private int contrastMax_;
    private double gamma_ = 1.0;
    private int minAfterRejectingOutliers_;
    private int maxAfterRejectingOutliers_;
    private int pixelMin_ = 0;
    private int pixelMax_ = 255;
    private final int maxIntensity_;
    private final int bitDepth_;
    private Color color_;
    private final String name_;

    public ChannelControlPanel(int channelIndex, MultiChannelHistograms mcHistograms, VirtualAcquisitionDisplay disp) {
        this.display_ = disp;
        this.img_ = (CompositeImage)disp.getHyperImage();
        this.cache_ = disp.getImageCache();
        this.color_ = this.cache_.getChannelColor(channelIndex);
        this.name_ = this.cache_.getChannelName(channelIndex);
        this.bitDepth_ = this.cache_.getBitDepth();
        this.maxIntensity_ = (int)Math.pow(2.0, this.bitDepth_) - 1;
        this.histMax_ = this.maxIntensity_ + 1;
        this.binSize_ = this.histMax_ / 256;
        this.histMaxLabel_ = "" + this.histMax_;
        this.mcHistograms_ = mcHistograms;
        this.channelIndex_ = channelIndex;
        this.initComponents();
        this.loadDisplaySettings(this.cache_);
        this.updateHistogram();
    }

    private void initComponents() {
        this.fullButton_ = new JButton();
        this.autoButton_ = new JButton();
        this.colorPickerLabel_ = new JLabel();
        this.channelNameCheckbox_ = new JCheckBox();
        this.histogramPanelHolder_ = new JPanel();
        this.minMaxLabel_ = new JLabel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(250, this.height_));
        this.fullButton_.setFont(this.fullButton_.getFont().deriveFont(9.0f));
        this.fullButton_.setName("Full channel histogram width");
        this.fullButton_.setText("Full");
        this.fullButton_.setToolTipText("Stretch the display gamma curve over the full pixel range");
        this.fullButton_.setMargin(new Insets(2, 4, 2, 4));
        this.fullButton_.setPreferredSize(new Dimension(75, 30));
        this.fullButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelControlPanel.this.fullButtonAction();
            }
        });
        this.autoButton_.setFont(this.autoButton_.getFont().deriveFont(9.0f));
        this.autoButton_.setName("Auto channel histogram width");
        this.autoButton_.setText("Auto");
        this.autoButton_.setToolTipText("Align the display gamma curve with minimum and maximum measured intensity values");
        this.autoButton_.setHorizontalTextPosition(0);
        this.autoButton_.setIconTextGap(0);
        this.autoButton_.setMargin(new Insets(2, 4, 2, 4));
        this.autoButton_.setMaximumSize(new Dimension(75, 30));
        this.autoButton_.setMinimumSize(new Dimension(75, 30));
        this.autoButton_.setPreferredSize(new Dimension(75, 30));
        this.autoButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelControlPanel.this.autoButtonAction();
            }
        });
        this.colorPickerLabel_.setBackground(this.color_);
        this.colorPickerLabel_.setToolTipText("Change the color for displaying this channel");
        this.colorPickerLabel_.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.colorPickerLabel_.setOpaque(true);
        this.colorPickerLabel_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChannelControlPanel.this.colorPickerLabelMouseClicked();
            }
        });
        this.channelNameCheckbox_.setText(this.name_);
        this.channelNameCheckbox_.setToolTipText("Show/hide this channel in the multi-dimensional viewer");
        this.channelNameCheckbox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelControlPanel.this.channelNameCheckboxAction();
            }
        });
        this.histogramPanelHolder_.setToolTipText("Adjust the brightness and contrast by dragging triangles at top and bottom. Change the gamma by dragging the curve. (These controls only change display, and do not edit the image data.)");
        this.histogramPanelHolder_.setAlignmentX(0.3f);
        this.histogramPanelHolder_.setPreferredSize(new Dimension(0, 100));
        this.histogramPanelHolder_.setLayout(new BorderLayout());
        this.minMaxLabel_.setFont(new Font("Lucida Grande", 0, 10));
        this.minMaxLabel_.setText("Min:   Max:");
        this.histRangeComboBox_ = new JComboBox();
        this.histRangeComboBox_.setFont(new Font("", 0, 10));
        this.histRangeComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ChannelControlPanel)ChannelControlPanel.this).display_.getHistogramControlsState().syncChannels) {
                    ChannelControlPanel.this.mcHistograms_.updateOtherDisplayCombos(ChannelControlPanel.this.histRangeComboBox_.getSelectedIndex());
                }
                ChannelControlPanel.this.displayComboAction();
            }
        });
        this.histRangeComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Camera Depth", "4bit (0-15)", "5bit (0-31)", "6bit (0-63)", "7bit (0-127)", "8bit (0-255)", "9bit (0-511)", "10bit (0-1023)", "11bit (0-2047)", "12bit (0-4095)", "13bit (0-8191)", "14bit (0-16383)", "15bit (0-32767)", "16bit (0-65535)"}));
        this.zoomInButton_ = new JButton();
        this.zoomInButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/zoom_in.png"));
        this.zoomOutButton_ = new JButton();
        this.zoomOutButton_.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/zoom_out.png"));
        this.zoomInButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelControlPanel.this.zoomInAction();
            }
        });
        this.zoomOutButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelControlPanel.this.zoomOutAction();
            }
        });
        this.setMinimumSize(MINIMUM_SIZE);
        this.setPreferredSize(MINIMUM_SIZE);
        this.hp_ = this.addHistogramPanel();
        this.setLayout(new BorderLayout());
        this.controlsHolderPanel_ = new JPanel(new BorderLayout());
        this.controlsHolderPanel_.setPreferredSize(CONTROLS_SIZE);
        this.controls_ = new JPanel();
        this.add((Component)this.controlsHolderPanel_, "Before");
        this.add((Component)this.histogramPanelHolder_, "Center");
        this.controlsHolderPanel_.add((Component)this.controls_, "First");
        GridBagLayout gbl = new GridBagLayout();
        this.controls_.setLayout(gbl);
        JLabel histRangeLabel = new JLabel("Hist. range:");
        histRangeLabel.setFont(new Font("Lucida Grande", 0, 11));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.controls_.add((Component)this.channelNameCheckbox_, gbc);
        this.fullButton_.setPreferredSize(new Dimension(45, 20));
        this.autoButton_.setPreferredSize(new Dimension(45, 20));
        this.colorPickerLabel_.setPreferredSize(new Dimension(18, 18));
        FlowLayout flow = new FlowLayout();
        flow.setHgap(4);
        flow.setVgap(0);
        JPanel line2 = new JPanel(flow);
        line2.setPreferredSize(CONTROLS_SIZE);
        line2.add(this.fullButton_);
        line2.add(this.autoButton_);
        line2.add(this.colorPickerLabel_);
        line2.setPreferredSize(new Dimension(ChannelControlPanel.CONTROLS_SIZE.width, 20));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 5;
        gbc.anchor = 21;
        this.controls_.add((Component)line2, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 21;
        this.controls_.add((Component)histRangeLabel, gbc);
        this.zoomInButton_.setPreferredSize(new Dimension(22, 22));
        this.zoomOutButton_.setPreferredSize(new Dimension(22, 22));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        this.controls_.add((Component)this.zoomInButton_, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        this.controls_.add((Component)this.zoomOutButton_, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 5;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.controls_.add((Component)this.histRangeComboBox_, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 5;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.controls_.add((Component)this.minMaxLabel_, gbc);
        this.controls_.setPreferredSize(this.controls_.getMinimumSize());
    }

    public void setDisplayComboIndex(int index) {
        this.histRangeComboBox_.setSelectedIndex(index);
    }

    public int getDisplayComboIndex() {
        return this.histRangeComboBox_.getSelectedIndex();
    }

    private void zoomInAction() {
        int selected = this.histRangeComboBox_.getSelectedIndex();
        if (selected == 0) {
            selected = this.bitDepth_ - 3;
        }
        if (selected != 1) {
            --selected;
        }
        this.histRangeComboBox_.setSelectedIndex(selected);
    }

    private void zoomOutAction() {
        int selected = this.histRangeComboBox_.getSelectedIndex();
        if (selected == 0) {
            selected = this.bitDepth_ - 3;
        }
        if (selected < this.histRangeComboBox_.getModel().getSize() - 1) {
            ++selected;
        }
        this.histRangeComboBox_.setSelectedIndex(selected);
    }

    public void displayComboAction() {
        int bits = this.histRangeComboBox_.getSelectedIndex() + 3;
        this.histMax_ = bits == 3 ? this.maxIntensity_ : (int)(Math.pow(2.0, bits) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.histMaxLabel_ = this.histMax_ + "";
        this.updateHistogram();
        this.calcAndDisplayHistAndStats(true);
        this.storeDisplaySettings();
    }

    private void updateHistogram() {
        this.hp_.setCursorText(this.contrastMin_ + "", this.contrastMax_ + "");
        this.hp_.setCursors((double)this.contrastMin_ / this.binSize_, (double)(this.contrastMax_ + 1) / this.binSize_, this.gamma_);
        this.hp_.repaint();
    }

    private void fullButtonAction() {
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.mcHistograms_.fullScaleChannels();
        } else {
            this.setFullScale();
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    public void autoButtonAction() {
        this.autostretch();
        this.applyLUT();
    }

    private void colorPickerLabelMouseClicked() {
        Color newColor;
        String name = "selected";
        if (this.cache_.getChannelName(this.channelIndex_) != null) {
            name = this.cache_.getChannelName(this.channelIndex_);
        }
        if ((newColor = JColorChooser.showDialog(this, "Choose a color for the " + name + " channel", this.cache_.getChannelColor(this.channelIndex_))) != null) {
            this.cache_.setChannelColor(this.channelIndex_, newColor.getRGB());
        }
        this.updateChannelNameAndColorFromCache();
        if (newColor != null) {
            this.saveColorPreference(this.cache_, newColor.getRGB());
        }
    }

    private void saveColorPreference(ImageCache cache, int color) {
        CMMCore core = MMStudio.getInstance().getCore();
        JSONObject summary = cache.getSummaryMetadata();
        if (core == null || summary == null) {
            return;
        }
        try {
            JSONArray dataNames = summary.getJSONArray("ChNames");
            Preferences root = Preferences.userNodeForPackage(AcqControlDlg.class);
            Preferences colorPrefs = root.node(root.absolutePath() + "/" + "ColorSettings");
            colorPrefs.putInt("Color_Camera_" + dataNames.getString(this.channelIndex_), color);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex, "Error storing color preferences");
        }
    }

    private void channelNameCheckboxAction() {
        boolean[] active = this.img_.getActiveChannels();
        if (this.img_.getMode() != 1) {
            if (active[this.channelIndex_]) {
                this.channelNameCheckbox_.setSelected(true);
                return;
            }
            this.display_.setChannel(this.channelIndex_);
        } else {
            this.img_.getActiveChannels()[this.channelIndex_] = this.channelNameCheckbox_.isSelected();
        }
        this.img_.getActiveChannels()[this.channelIndex_] = this.channelNameCheckbox_.isSelected();
        this.img_.updateAndDraw();
    }

    public void setFullScale() {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = 0;
        this.contrastMax_ = this.histMax_;
    }

    public void autostretch() {
        this.contrastMin_ = this.pixelMin_;
        this.contrastMax_ = this.pixelMax_;
        if (this.pixelMin_ == this.pixelMax_) {
            if (this.pixelMax_ > 0) {
                --this.contrastMin_;
            } else {
                ++this.contrastMax_;
            }
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            if (this.contrastMin_ < this.minAfterRejectingOutliers_ && 0 < this.minAfterRejectingOutliers_) {
                this.contrastMin_ = this.minAfterRejectingOutliers_;
            }
            if (this.maxAfterRejectingOutliers_ < this.contrastMax_) {
                this.contrastMax_ = this.maxAfterRejectingOutliers_;
            }
            if (this.contrastMax_ <= this.contrastMin_) {
                if (this.contrastMax_ > 0) {
                    this.contrastMin_ = this.contrastMax_ - 1;
                } else {
                    this.contrastMax_ = this.contrastMin_ + 1;
                }
            }
        }
    }

    private void loadDisplaySettings(ImageCache cache) {
        this.contrastMax_ = cache.getChannelMax(this.channelIndex_);
        if (this.contrastMax_ < 0 || this.contrastMax_ > this.maxIntensity_) {
            this.contrastMax_ = this.maxIntensity_;
        }
        this.contrastMin_ = cache.getChannelMin(this.channelIndex_);
        this.gamma_ = cache.getChannelGamma(this.channelIndex_);
        int histMax = cache.getChannelHistogramMax(this.channelIndex_);
        if (histMax != -1) {
            int index = (int)(Math.ceil(Math.log(histMax) / Math.log(2.0)) - 3.0);
            this.histRangeComboBox_.setSelectedIndex(index);
        }
    }

    private HistogramPanel addHistogramPanel() {
        HistogramPanel hp = new HistogramPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.black);
                g.setFont(new Font("Lucida Grande", 0, 10));
                g.drawString(ChannelControlPanel.this.histMaxLabel_, this.getSize().width - 8 * ChannelControlPanel.this.histMaxLabel_.length(), this.getSize().height);
            }
        };
        hp.setMargins(12.0f, 12.0f);
        hp.setTraceStyle(true, this.color_);
        hp.setToolTipText("Click and drag curve to adjust gamma");
        this.histogramPanelHolder_.add((Component)hp, "Center");
        hp.addCursorListener(this);
        return hp;
    }

    public void updateChannelNameAndColorFromCache() {
        this.color_ = this.cache_.getChannelColor(this.channelIndex_);
        this.colorPickerLabel_.setBackground(this.color_);
        this.hp_.setTraceStyle(true, this.color_);
        String name = this.cache_.getChannelName(this.channelIndex_);
        if (name.length() > 11) {
            name = name.substring(0, 9) + "...";
        }
        this.channelNameCheckbox_.setText(name);
        this.calcAndDisplayHistAndStats(true);
        this.mcHistograms_.applyLUTToImage();
        this.display_.drawWithoutUpdate();
        this.repaint();
    }

    public int getContrastMin() {
        return this.contrastMin_;
    }

    public int getContrastMax() {
        return this.contrastMax_;
    }

    public double getContrastGamma() {
        return this.gamma_;
    }

    public void setContrast(int min, int max, double gamma) {
        this.contrastMin_ = min;
        this.contrastMax_ = Math.min(this.maxIntensity_, max);
        this.gamma_ = gamma;
    }

    public void applyChannelLUTToImage() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (!ChannelControlPanel.this.cache_.getIsOpen()) {
                    return;
                }
                Color color = ChannelControlPanel.this.cache_.getChannelColor(ChannelControlPanel.this.channelIndex_);
                LUT lut = ImageUtils.makeLUT(color, ChannelControlPanel.this.gamma_);
                lut.min = ChannelControlPanel.this.contrastMin_;
                lut.max = ChannelControlPanel.this.contrastMax_;
                ChannelControlPanel.this.img_.setChannelLut(lut, ChannelControlPanel.this.channelIndex_ + 1);
                try {
                    if (ChannelControlPanel.this.img_.getMode() == 2 || ChannelControlPanel.this.img_.getMode() == 3) {
                        JavaUtils.setRestrictedFieldValue(ChannelControlPanel.this.img_, CompositeImage.class, "currentChannel", -1);
                    }
                }
                catch (NoSuchFieldException ex) {
                    ReportingUtils.logError(ex);
                }
                if (ChannelControlPanel.this.img_.getChannel() == ChannelControlPanel.this.channelIndex_ + 1) {
                    LUT grayLut = ImageUtils.makeLUT(Color.white, ChannelControlPanel.this.gamma_);
                    ImageProcessor processor = ChannelControlPanel.this.img_.getProcessor();
                    if (processor != null) {
                        processor.setColorModel((ColorModel)grayLut);
                        processor.setMinAndMax((double)ChannelControlPanel.this.contrastMin_, (double)ChannelControlPanel.this.contrastMax_);
                    }
                    if (ChannelControlPanel.this.img_.getMode() == 3) {
                        ChannelControlPanel.this.img_.updateImage();
                    }
                }
                ChannelControlPanel.this.storeDisplaySettings();
                ChannelControlPanel.this.updateHistogram();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void storeDisplaySettings() {
        int histMax = this.histRangeComboBox_.getSelectedIndex() == 0 ? -1 : this.histMax_;
        this.display_.storeChannelHistogramSettings(this.channelIndex_, this.contrastMin_, this.contrastMax_, this.gamma_, histMax, ((MMCompositeImage)this.img_).getMode());
    }

    public int getChannelIndex() {
        return this.channelIndex_;
    }

    public void calcAndDisplayHistAndStats(boolean drawHist) {
        int i;
        int imgHeight;
        int imgWidth;
        ImageProcessor ip;
        if (this.img_ == null || this.img_.getProcessor() == null) {
            return;
        }
        if (this.img_.getMode() == 1) {
            ip = this.img_.getProcessor(this.channelIndex_ + 1);
            if (ip != null) {
                ip.setRoi(this.img_.getRoi());
            }
        } else {
            MMCompositeImage ci = (MMCompositeImage)this.img_;
            int flatIndex = 1 + this.channelIndex_ + (this.img_.getSlice() - 1) * ci.getNChannelsUnverified() + (this.img_.getFrame() - 1) * ci.getNSlicesUnverified() * ci.getNChannelsUnverified();
            ip = this.img_.getStack().getProcessor(flatIndex);
        }
        if (((MMCompositeImage)this.img_).getNChannelsUnverified() <= 7) {
            boolean active = this.img_.getActiveChannels()[this.channelIndex_];
            this.channelNameCheckbox_.setSelected(active);
            if (!active) {
                drawHist = false;
            }
        }
        if (((MMCompositeImage)this.img_).getMode() != 1 && this.img_.getChannel() - 1 != this.channelIndex_) {
            drawHist = false;
        }
        if (ip == null) {
            return;
        }
        int[] rawHistogram = ip.getHistogram();
        if (rawHistogram[0] == (imgWidth = this.img_.getWidth()) * (imgHeight = this.img_.getHeight())) {
            return;
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            this.maxAfterRejectingOutliers_ = rawHistogram.length;
            int totalPoints = imgHeight * imgWidth;
            HistogramUtils hu = new HistogramUtils(rawHistogram, totalPoints, 0.01 * this.display_.getHistogramControlsState().percentToIgnore);
            this.minAfterRejectingOutliers_ = hu.getMinAfterRejectingOutliers();
            this.maxAfterRejectingOutliers_ = hu.getMaxAfterRejectingOutliers();
        }
        GraphData histogramData = new GraphData();
        this.pixelMin_ = -1;
        this.pixelMax_ = 0;
        int numBins = (int)Math.min((double)rawHistogram.length / this.binSize_, 256.0);
        int[] histogram = new int[256];
        int total = 0;
        for (i = 0; i < numBins; ++i) {
            histogram[i] = 0;
            int j = 0;
            while ((double)j < this.binSize_) {
                int rawHistIndex = (int)((double)i * this.binSize_ + (double)j);
                int rawHistVal = rawHistogram[rawHistIndex];
                int n = i;
                histogram[n] = histogram[n] + rawHistVal;
                if (rawHistVal > 0) {
                    this.pixelMax_ = rawHistIndex;
                    if (this.pixelMin_ == -1) {
                        this.pixelMin_ = rawHistIndex;
                    }
                }
                ++j;
            }
            total += histogram[i];
            if (!this.display_.getHistogramControlsState().logHist) continue;
            histogram[i] = histogram[i] > 0 ? (int)(1000.0 * Math.log(histogram[i])) : 0;
        }
        if (this.histRangeComboBox_.getSelectedIndex() != -1) {
            this.pixelMin_ = rawHistogram.length - 1;
            for (i = rawHistogram.length - 1; i > 0; --i) {
                if (rawHistogram[i] > 0 && i > this.pixelMax_) {
                    this.pixelMax_ = i;
                }
                if (rawHistogram[i] <= 0 || i >= this.pixelMin_) continue;
                this.pixelMin_ = i;
            }
        }
        if (total == 0) {
            if (this.img_.getProcessor().getMin() == 0.0) {
                histogram[0] = imgWidth * imgHeight;
            } else {
                histogram[numBins - 1] = imgWidth * imgHeight;
            }
        }
        if (drawHist) {
            this.hp_.setVisible(true);
            histogramData.setData(histogram);
            this.hp_.setData(histogramData);
            this.hp_.setAutoScale();
            this.hp_.repaint();
            this.minMaxLabel_.setText("Min: " + NumberUtils.intToDisplayString(this.pixelMin_) + "   " + "Max: " + NumberUtils.intToDisplayString(this.pixelMax_));
        } else {
            this.hp_.setVisible(false);
        }
    }

    @Override
    public void contrastMaxInput(int max) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = max;
        if (this.contrastMax_ > this.maxIntensity_) {
            this.contrastMax_ = this.maxIntensity_;
        }
        if (this.contrastMax_ < 0) {
            this.contrastMax_ = 0;
        }
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        this.applyLUT();
    }

    @Override
    public void contrastMinInput(int min) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = min;
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMin_ < 0) {
            this.contrastMin_ = 0;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        this.applyLUT();
    }

    @Override
    public void onLeftCursor(double pos) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = (int)(Math.max(0.0, pos) * this.binSize_);
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        this.applyLUT();
    }

    @Override
    public void onRightCursor(double pos) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = (int)(Math.min(255.0, pos) * this.binSize_);
        if (this.contrastMax_ < 1) {
            this.contrastMax_ = 1;
        }
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        this.applyLUT();
    }

    @Override
    public void onGammaCurve(double gamma) {
        if (gamma != 0.0) {
            this.gamma_ = gamma > 0.9 & gamma < 1.1 ? 1.0 : gamma;
            this.applyLUT();
        }
    }

    private void applyLUT() {
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.mcHistograms_.applyContrastToAllChannels(this.contrastMin_, this.contrastMax_, this.gamma_);
        } else {
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }
}

