/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.events;

import com.google.common.eventbus.EventBus;
import org.micromanager.api.MMListenerInterface;
import org.micromanager.api.events.ConfigGroupChangedEvent;
import org.micromanager.api.events.ExposureChangedEvent;
import org.micromanager.api.events.PixelSizeChangedEvent;
import org.micromanager.api.events.PropertiesChangedEvent;
import org.micromanager.api.events.PropertyChangedEvent;
import org.micromanager.api.events.SLMExposureChangedEvent;
import org.micromanager.api.events.StagePositionChangedEvent;
import org.micromanager.api.events.SystemConfigurationLoadedEvent;
import org.micromanager.api.events.XYStagePositionChangedEvent;

public class MMListenerProxy
implements MMListenerInterface {
    private EventBus bus_;

    public MMListenerProxy(EventBus bus) {
        this.bus_ = bus;
    }

    @Override
    public void propertiesChangedAlert() {
        this.bus_.post((Object)new PropertiesChangedEvent());
    }

    @Override
    public void propertyChangedAlert(String device, String property, String value) {
        this.bus_.post((Object)new PropertyChangedEvent(device, property, value));
    }

    @Override
    public void configGroupChangedAlert(String groupName, String newConfig) {
        this.bus_.post((Object)new ConfigGroupChangedEvent(groupName, newConfig));
    }

    @Override
    public void systemConfigurationLoaded() {
        this.bus_.post((Object)new SystemConfigurationLoadedEvent());
    }

    @Override
    public void pixelSizeChangedAlert(double newPixelSizeUm) {
        this.bus_.post((Object)new PixelSizeChangedEvent(newPixelSizeUm));
    }

    @Override
    public void stagePositionChangedAlert(String deviceName, double pos) {
        this.bus_.post((Object)new StagePositionChangedEvent(deviceName, pos));
    }

    @Override
    public void xyStagePositionChanged(String deviceName, double xPos, double yPos) {
        this.bus_.post((Object)new XYStagePositionChangedEvent(deviceName, xPos, yPos));
    }

    @Override
    public void exposureChanged(String cameraName, double newExposureTime) {
        this.bus_.post((Object)new ExposureChangedEvent(cameraName, newExposureTime));
    }

    @Override
    public void slmExposureChanged(String cameraName, double newExposureTime) {
        this.bus_.post((Object)new SLMExposureChangedEvent(cameraName, newExposureTime));
    }
}

