/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.micromanager.utils.ReportingUtils;

public class RegistrationDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String REGISTRATION = "registered";
    public static final String REGISTRATION_NEVER = "reg_never";
    public static final String REGISTRATION_ATTEMPTS = "registration_attempts";
    public static final String REGISTRATION_NAME = "reg_name";
    public static final String REGISTRATION_INST = "reg_institution";
    private JTextArea welcomeTextArea_;
    private JTextField email_;
    private JTextField inst_;
    private JTextField name_;
    private Preferences prefs_;

    public RegistrationDlg(Preferences prefs) {
        this.prefs_ = prefs;
        this.incrementRegistrationAttempts();
        this.setModal(true);
        this.setUndecorated(true);
        this.setTitle("Micro-Manager Registration");
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setBounds(100, 100, 398, 299);
        Dimension winSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - winSize.width / 2, screenSize.height / 2 - winSize.height / 2);
        JLabel nameLabel = new JLabel();
        nameLabel.setText("Name");
        nameLabel.setBounds(10, 198, 65, 14);
        this.getContentPane().add(nameLabel);
        JLabel institutionLabel = new JLabel();
        institutionLabel.setText("Institution");
        institutionLabel.setBounds(10, 220, 65, 14);
        this.getContentPane().add(institutionLabel);
        JLabel emailLabel = new JLabel();
        emailLabel.setText("Email");
        emailLabel.setBounds(10, 240, 65, 14);
        this.getContentPane().add(emailLabel);
        this.name_ = new JTextField();
        this.name_.setBounds(77, 195, 256, 20);
        this.getContentPane().add(this.name_);
        this.inst_ = new JTextField();
        this.inst_.setBounds(77, 218, 256, 20);
        this.getContentPane().add(this.inst_);
        this.email_ = new JTextField();
        this.email_.setBounds(77, 240, 256, 20);
        this.getContentPane().add(this.email_);
        JButton okButton = new JButton();
        okButton.setFont(new Font("", 1, 12));
        okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (RegistrationDlg.this.name_.getText().length() == 0 || RegistrationDlg.this.email_.getText().length() == 0) {
                    JOptionPane.showMessageDialog(RegistrationDlg.this, "Name and email fields can't be empty.");
                } else {
                    try {
                        RegistrationDlg.this.prefs_.put(RegistrationDlg.REGISTRATION_NAME, RegistrationDlg.this.name_.getText());
                        RegistrationDlg.this.prefs_.put(RegistrationDlg.REGISTRATION_INST, RegistrationDlg.this.inst_.getText());
                        String name = RegistrationDlg.this.name_.getText().replaceAll("[ \t]", "%20");
                        name = name.replaceAll("[&]", "%20and%20");
                        String inst = RegistrationDlg.this.inst_.getText().replaceAll("[ \t]", "%20");
                        inst = inst.replaceAll("[&]", "%20and%20");
                        String email = RegistrationDlg.this.email_.getText().replaceAll("[ \t]", "%20");
                        email = email.replaceAll("[&]", "%20and%20");
                        String regText = "http://valelab.ucsf.edu/micro-manager-registration.php?Name=" + name + "&Institute=" + inst + "&email=" + email;
                        URL url = new URL(regText);
                        InputStream is = url.openStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String response = br.readLine();
                        if (response.compareTo("SUCCESS") != 0) {
                            JOptionPane.showMessageDialog(RegistrationDlg.this, "Registration did not succeed. You will be prompted again next time.");
                            RegistrationDlg.this.dispose();
                            return;
                        }
                    }
                    catch (UnknownHostException e) {
                        ReportingUtils.showError((Throwable)e, "Registration did not succeed. You are probably not connected to the Internet.\nYou will be prompted again next time you start.");
                    }
                    catch (MalformedURLException e) {
                        ReportingUtils.showError(e);
                    }
                    catch (IOException e) {
                        ReportingUtils.showError(e);
                    }
                    catch (SecurityException e) {
                        ReportingUtils.showError((Throwable)e, "\nThe program failed to save registration status.\nMost likely you are not logged in with administrator privileges.\nPlease try registering again using the administrator's account.");
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(e);
                    }
                    finally {
                        RegistrationDlg.this.dispose();
                    }
                    RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION, true);
                }
            }
        });
        okButton.setText("OK");
        okButton.setBounds(50, 266, 100, 23);
        this.getContentPane().add(okButton);
        this.welcomeTextArea_ = new JTextArea();
        this.welcomeTextArea_.setMargin(new Insets(10, 10, 10, 10));
        this.welcomeTextArea_.setLineWrap(true);
        this.welcomeTextArea_.setBackground(new Color(192, 192, 192));
        this.welcomeTextArea_.setFocusable(false);
        this.welcomeTextArea_.setEditable(false);
        this.welcomeTextArea_.setFont(new Font("Arial", 0, 12));
        this.welcomeTextArea_.setWrapStyleWord(true);
        this.welcomeTextArea_.setText("Welcome to Micro-Manager.\n\nPlease take a minute to let us know that you are using this software. The information you enter will only be used to estimate how many people use Micro-Manager. Accurate tracking of the number of users is very important for our funding efforts and essential for the long-term survival of Micro-Manager.\n\nYour information will never be made public or given away to third parties, however, we might very occasionally inform you of Micro-Manager developments.");
        this.welcomeTextArea_.setBounds(10, 10, 378, 179);
        this.getContentPane().add(this.welcomeTextArea_);
        JButton skipButton = new JButton();
        skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(RegistrationDlg.this, "You choose to postpone registration.\nThis prompt will appear again next time you start the application.");
                RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION_NEVER, false);
                RegistrationDlg.this.dispose();
            }
        });
        skipButton.setText("Later");
        skipButton.setBounds(160, 266, 100, 23);
        this.getContentPane().add(skipButton);
        if (this.getRegistrationAttempts() > 1) {
            JButton neverButton = new JButton();
            neverButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JOptionPane.showMessageDialog(RegistrationDlg.this, "You have chosen never to register. \nIf you change your mind in the future, please\nchoose the \"Register\" option in the Help menu.");
                    RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION_NEVER, true);
                    RegistrationDlg.this.dispose();
                }
            });
            neverButton.setText("Never");
            neverButton.setBounds(270, 266, 100, 23);
            this.getContentPane().add(neverButton);
        }
    }

    private int incrementRegistrationAttempts() {
        int attempts = this.getRegistrationAttempts();
        this.prefs_.putInt(REGISTRATION_ATTEMPTS, ++attempts);
        return attempts;
    }

    public final int getRegistrationAttempts() {
        return this.prefs_.getInt(REGISTRATION_ATTEMPTS, 0);
    }
}

