/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.ConfigDialog;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.ReportingUtils;

public class PresetEditor
extends ConfigDialog {
    private static final long serialVersionUID = 8281144157746745260L;

    public PresetEditor(String groupName, String presetName, ScriptInterface gui, CMMCore core, boolean newItem) {
        super(groupName, presetName, gui, core, newItem);
        this.instructionsText_ = "Here you can specifiy the property values\nin a configuration preset.";
        this.nameFieldLabelText_ = "Preset name:";
        this.initName_ = this.presetName_;
        this.TITLE = "Preset editor for the \"" + groupName + "\" configuration group";
        this.showUnused_ = false;
        this.showFlagsPanelVisible = false;
        this.scrollPaneTop_ = 70;
        this.numColumns_ = 2;
        this.data_ = new PropertyTableData(this.core_, this.groupName_, this.presetName_, 1, 2, true);
        this.initializeData();
        this.data_.setColumnNames("Property Name", "Preset Value", "");
        this.data_.setShowReadOnly(true);
        this.initialize();
    }

    @Override
    public void okChosen() {
        String newName = this.nameField_.getText();
        if (this.writePreset(this.initName_, newName)) {
            this.dispose();
        }
    }

    public boolean writePreset(String initName, String newName) {
        if (newName.length() == 0) {
            this.showMessageDialog("Please enter a name for this preset.");
            return false;
        }
        StrVector groups = this.core_.getAvailableConfigs(this.groupName_);
        int i = 0;
        while ((long)i < groups.size()) {
            if (groups.get(i).contentEquals(newName) && !newName.contentEquals(initName)) {
                this.showMessageDialog("A preset by this name already exists in the \"" + this.groupName_ + "\" group.\nPlease enter a different name.");
                return false;
            }
            ++i;
        }
        StrVector cfgs = this.core_.getAvailableConfigs(this.groupName_);
        try {
            int j = 0;
            while ((long)j < cfgs.size()) {
                boolean same = true;
                if (this.newItem_ || !cfgs.get(j).contentEquals(initName)) {
                    Configuration otherPreset = this.core_.getConfigData(this.groupName_, cfgs.get(j));
                    for (PropertyItem item : this.data_.getPropList()) {
                        if (!item.confInclude || !otherPreset.isPropertyIncluded(item.device, item.name) || item.getValueInCoreFormat().contentEquals(otherPreset.getSetting(item.device, item.name).getPropertyValue())) continue;
                        same = false;
                    }
                    if (same) {
                        this.showMessageDialog("This combination of properties is already found in the \"" + cfgs.get(j) + "\" preset.\nPlease choose unique property values for your new preset.");
                        return false;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        if (!this.newItem_ && !initName.contentEquals(newName)) {
            try {
                this.core_.renameConfig(this.groupName_, initName, newName);
            }
            catch (Exception e1) {
                ReportingUtils.logError(e1);
            }
        }
        for (PropertyItem item_ : this.data_.getPropList()) {
            if (!item_.confInclude) continue;
            try {
                this.core_.defineConfig(this.groupName_, newName, item_.device, item_.name, item_.getValueInCoreFormat());
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        this.gui_.setConfigChanged(true);
        return true;
    }
}

