/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import mmcorej.CMMCore;
import net.miginfocom.swing.MigLayout;
import org.micromanager.MMOptions;
import org.micromanager.MMStudio;
import org.micromanager.api.ScriptInterface;
import org.micromanager.logging.LogFileManager;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.UIMonitor;

public class OptionsDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private final JTextField startupScriptFile_;
    private final JTextField bufSizeField_;
    private JTextField logDeleteDaysField_;
    private final JComboBox comboDisplayBackground_;
    private MMOptions opts_;
    private CMMCore core_;
    private Preferences mainPrefs_;
    private ScriptInterface parent_;
    private GUIColors guiColors_;

    public OptionsDlg(MMOptions opts, CMMCore core, Preferences mainPrefs, ScriptInterface parent) {
        this.parent_ = parent;
        this.opts_ = opts;
        this.core_ = core;
        this.mainPrefs_ = mainPrefs;
        this.guiColors_ = new GUIColors();
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Micro-Manager Options");
        this.loadAndRestorePosition(100, 100);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OptionsDlg.this.closeRequested();
            }
        });
        final JCheckBox debugLogEnabledCheckBox = new JCheckBox();
        debugLogEnabledCheckBox.setText("Enable debug logging");
        debugLogEnabledCheckBox.setToolTipText("Enable verbose logging for troubleshooting and debugging");
        debugLogEnabledCheckBox.setSelected(this.opts_.debugLogEnabled_);
        debugLogEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((OptionsDlg)OptionsDlg.this).opts_.debugLogEnabled_ = debugLogEnabledCheckBox.isSelected();
                OptionsDlg.this.core_.enableDebugLog(((OptionsDlg)OptionsDlg.this).opts_.debugLogEnabled_);
                UIMonitor.enable(((OptionsDlg)OptionsDlg.this).opts_.debugLogEnabled_);
            }
        });
        final JCheckBox doNotAskForConfigFileCheckBox = new JCheckBox();
        doNotAskForConfigFileCheckBox.setText("Do not ask for config file at startup");
        doNotAskForConfigFileCheckBox.setSelected(this.opts_.doNotAskForConfigFile_);
        doNotAskForConfigFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.doNotAskForConfigFile_ = doNotAskForConfigFileCheckBox.isSelected();
            }
        });
        final JCheckBox deleteLogCheckBox = new JCheckBox();
        deleteLogCheckBox.setText("Delete log files after");
        deleteLogCheckBox.setSelected(this.opts_.deleteOldCoreLogs_);
        deleteLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((OptionsDlg)OptionsDlg.this).opts_.deleteOldCoreLogs_ = deleteLogCheckBox.isSelected();
            }
        });
        this.logDeleteDaysField_ = new JTextField(Integer.toString(this.opts_.deleteCoreLogAfterDays_), 2);
        JButton deleteLogFilesButton = new JButton();
        deleteLogFilesButton.setText("Delete Log Files Now");
        deleteLogFilesButton.setToolTipText("Delete all CoreLog files except for the current one");
        deleteLogFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir2;
                String dir1 = LogFileManager.getLogFileDirectory().getAbsolutePath();
                String dirs = dir1.equals(dir2 = LogFileManager.getLegacyLogFileDirectory().getAbsolutePath()) ? dir1 : dir1 + " and " + dir2;
                int answer = JOptionPane.showConfirmDialog(OptionsDlg.this, "<html><body><p style='width: 400px;'>Delete all CoreLog files in " + dirs + "?" + "</p></body></html>", "Delete Log Files", 0, 3);
                if (answer == 0) {
                    LogFileManager.deleteLogFilesDaysOld(0, OptionsDlg.this.core_.getPrimaryLogFile());
                }
            }
        });
        JButton clearRegistryButton = new JButton();
        clearRegistryButton.setText("Reset Preferences");
        clearRegistryButton.setToolTipText("Clear all preference settings and restore defaults");
        clearRegistryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(OptionsDlg.this, "Reset all preference settings?", "Reset Preferences", 0, 3);
                if (answer != 0) {
                    return;
                }
                try {
                    boolean previouslyRegistered = OptionsDlg.this.mainPrefs_.getBoolean("registered", false);
                    OptionsDlg.this.mainPrefs_.clear();
                    Preferences acqPrefs = OptionsDlg.this.mainPrefs_.node(OptionsDlg.this.mainPrefs_.absolutePath() + "/" + "AcquistionSettings");
                    acqPrefs.clear();
                    OptionsDlg.this.mainPrefs_.putBoolean("registered", previouslyRegistered);
                    OptionsDlg.this.dispose();
                    OptionsDlg.this.opts_.resetSettings();
                }
                catch (BackingStoreException exc) {
                    ReportingUtils.showError(e);
                }
            }
        });
        this.bufSizeField_ = new JTextField(Integer.toString(this.opts_.circularBufferSizeMB_), 5);
        this.comboDisplayBackground_ = new JComboBox<String>(this.guiColors_.styleOptions);
        this.comboDisplayBackground_.setMaximumRowCount(2);
        this.comboDisplayBackground_.setSelectedItem(this.opts_.displayBackground_);
        this.comboDisplayBackground_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDlg.this.changeBackground();
            }
        });
        this.startupScriptFile_ = new JTextField(this.opts_.startupScript_);
        final JCheckBox closeOnExitCheckBox = new JCheckBox();
        closeOnExitCheckBox.setText("Close app when quitting MM");
        closeOnExitCheckBox.setSelected(this.opts_.closeOnExit_);
        closeOnExitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.closeOnExit_ = closeOnExitCheckBox.isSelected();
                MMStudio.getFrame().setExitStrategy(((OptionsDlg)OptionsDlg.this).opts_.closeOnExit_);
            }
        });
        final JComboBox<String> prefZoomCombo = new JComboBox<String>();
        prefZoomCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"8%", "12%", "16%", "25%", "33%", "50%", "75%", "100%", "150%", "200%", "300%", "400%", "600%"}));
        double mag = this.opts_.windowMag_;
        int index = 0;
        if (mag == 0.08333333333333333) {
            index = 0;
        } else if (mag == 0.125) {
            index = 1;
        } else if (mag == 0.16) {
            index = 2;
        } else if (mag == 0.25) {
            index = 3;
        } else if (mag == 0.33) {
            index = 4;
        } else if (mag == 0.5) {
            index = 5;
        } else if (mag == 0.75) {
            index = 6;
        } else if (mag == 1.0) {
            index = 7;
        } else if (mag == 1.5) {
            index = 8;
        } else if (mag == 2.0) {
            index = 9;
        } else if (mag == 3.0) {
            index = 10;
        } else if (mag == 4.0) {
            index = 11;
        } else if (mag == 6.0) {
            index = 12;
        }
        prefZoomCombo.setSelectedIndex(index);
        prefZoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (prefZoomCombo.getSelectedIndex()) {
                    case 0: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.08333333333333333;
                        break;
                    }
                    case 1: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.125;
                        break;
                    }
                    case 2: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.16;
                        break;
                    }
                    case 3: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.25;
                        break;
                    }
                    case 4: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.33;
                        break;
                    }
                    case 5: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.5;
                        break;
                    }
                    case 6: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 0.75;
                        break;
                    }
                    case 7: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 1.0;
                        break;
                    }
                    case 8: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 1.5;
                        break;
                    }
                    case 9: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 2.0;
                        break;
                    }
                    case 10: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 3.0;
                        break;
                    }
                    case 11: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 4.0;
                        break;
                    }
                    case 12: {
                        ((OptionsDlg)OptionsDlg.this).opts_.windowMag_ = 6.0;
                    }
                }
            }
        });
        final JCheckBox metadataFileWithMultipageTiffCheckBox = new JCheckBox();
        metadataFileWithMultipageTiffCheckBox.setText("Create metadata.txt file with Image Stack Files");
        metadataFileWithMultipageTiffCheckBox.setSelected(this.opts_.mpTiffMetadataFile_);
        metadataFileWithMultipageTiffCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.mpTiffMetadataFile_ = metadataFileWithMultipageTiffCheckBox.isSelected();
            }
        });
        final JCheckBox separateFilesForPositionsMPTiffCheckBox = new JCheckBox();
        separateFilesForPositionsMPTiffCheckBox.setText("Save XY positions in separate Image Stack Files");
        separateFilesForPositionsMPTiffCheckBox.setSelected(this.opts_.mpTiffSeparateFilesForPositions_);
        separateFilesForPositionsMPTiffCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.mpTiffSeparateFilesForPositions_ = separateFilesForPositionsMPTiffCheckBox.isSelected();
            }
        });
        final JCheckBox syncExposureMainAndMDA = new JCheckBox();
        syncExposureMainAndMDA.setText("Sync exposure between Main and MDA windows");
        syncExposureMainAndMDA.setSelected(this.opts_.syncExposureMainAndMDA_);
        syncExposureMainAndMDA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.syncExposureMainAndMDA_ = syncExposureMainAndMDA.isSelected();
            }
        });
        final JCheckBox hideMDAdisplay = new JCheckBox();
        hideMDAdisplay.setText("Hide MDA display");
        hideMDAdisplay.setSelected(this.opts_.hideMDADisplay_);
        hideMDAdisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((OptionsDlg)OptionsDlg.this).opts_.hideMDADisplay_ = hideMDAdisplay.isSelected();
            }
        });
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                OptionsDlg.this.closeRequested();
            }
        });
        this.setLayout((LayoutManager)new MigLayout("fill, insets dialog", "[fill]"));
        this.add((Component)new JLabel("Display Background:"), "split 2, gapright push");
        this.add((Component)this.comboDisplayBackground_, "wrap");
        this.add((Component)new JLabel("Preferred Image Window Zoom:"), "split 2, gapright push");
        this.add(prefZoomCombo, "wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)new JLabel("Sequence Buffer Size:"), "split 3, gapright push");
        this.add((Component)this.bufSizeField_, "gapright related");
        this.add((Component)new JLabel("MB"), "wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)metadataFileWithMultipageTiffCheckBox, "wrap");
        this.add((Component)separateFilesForPositionsMPTiffCheckBox, "wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)doNotAskForConfigFileCheckBox, "wrap");
        this.add((Component)new JLabel("Startup Script:"), "split 2, grow 0, gapright related");
        this.add((Component)this.startupScriptFile_, "wrap");
        this.add((Component)closeOnExitCheckBox, "wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)debugLogEnabledCheckBox, "wrap");
        this.add((Component)deleteLogCheckBox, "split 3, gapright related");
        this.add((Component)this.logDeleteDaysField_, "gapright related");
        this.add((Component)new JLabel("days"), "gapright push, wrap");
        this.add((Component)deleteLogFilesButton, "split 3, gapleft push, gapright push, wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)syncExposureMainAndMDA, "wrap");
        this.add((Component)hideMDAdisplay, "wrap");
        this.add((Component)new JSeparator(), "wrap");
        this.add((Component)clearRegistryButton, "split 2, sizegroup bottomBtns, gapright unrelated");
        this.add((Component)closeButton, "sizegroup bottomBtns");
        this.pack();
    }

    private void changeBackground() {
        String background;
        this.opts_.displayBackground_ = background = (String)this.comboDisplayBackground_.getSelectedItem();
        this.setBackground(this.guiColors_.background.get(background));
        if (this.parent_ != null) {
            MMStudio.getInstance().setBackgroundStyle(background);
        }
    }

    private void closeRequested() {
        int deleteLogDays;
        int seqBufSize;
        try {
            seqBufSize = NumberUtils.displayStringToInt(this.bufSizeField_.getText());
            deleteLogDays = NumberUtils.displayStringToInt(this.logDeleteDaysField_.getText());
        }
        catch (ParseException ex) {
            ReportingUtils.showError(ex);
            return;
        }
        this.opts_.circularBufferSizeMB_ = seqBufSize;
        this.opts_.startupScript_ = this.startupScriptFile_.getText();
        this.opts_.deleteCoreLogAfterDays_ = deleteLogDays;
        this.opts_.saveSettings();
        this.parent_.makeActive();
        this.dispose();
    }
}

