/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import com.swtdesigner.SwingResourceManager;
import ij.IJ;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import org.micromanager.MMStudio;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.JavaUtils;

public class MMIntroDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextArea welcomeTextArea_;
    private boolean okFlag_ = true;
    ArrayList<String> mruCFGFileList_;
    private JComboBox cfgFileDropperDown_;
    public static String DISCLAIMER_TEXT = "This software is distributed free of charge in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of merchantability or fitness for a particular purpose. In no event shall the copyright owner or contributors be liable for any direct, indirect, incidental, special, examplary, or consequential damages.\n\nCopyright University of California San Francisco, 2007, 2008, 2009, 2010. All rights reserved.";
    public static String SUPPORT_TEXT = "Micro-Manager was initially funded by grants from the Sandler Foundation and is now supported by a grant from the NIH.";
    public static String CITATION_TEXT = "If you have found this software useful, please cite Micro-Manager in your publications.";

    public MMIntroDlg(String ver, ArrayList<String> mruCFGFileList) {
        this.mruCFGFileList_ = mruCFGFileList;
        this.setFont(new Font("Arial", 0, 10));
        this.setTitle("Micro-Manager Startup");
        this.getContentPane().setLayout(null);
        this.setName("Intro");
        this.setResizable(false);
        this.setModal(true);
        this.setUndecorated(true);
        if (!IJ.isMacOSX()) {
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        this.setSize(new Dimension(392, 533));
        Dimension winSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - winSize.width / 2, screenSize.height / 2 - winSize.height / 2);
        JLabel introImage = new JLabel();
        introImage.setIcon(SwingResourceManager.getIcon(MMIntroDlg.class, "/org/micromanager/icons/splash.gif"));
        introImage.setLayout(null);
        introImage.setBounds(0, 0, 392, 197);
        introImage.setFocusable(false);
        introImage.setBorder(new LineBorder(Color.black, 1, false));
        introImage.setText("New JLabel");
        this.getContentPane().add(introImage);
        JButton okButton = new JButton();
        okButton.setFont(new Font("Arial", 0, 10));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MMIntroDlg.this.okFlag_ = true;
                MMIntroDlg.this.setVisible(false);
            }
        });
        okButton.setText("OK");
        okButton.setBounds(JavaUtils.isMac() ? 200 : 100, 497, 81, 24);
        this.getContentPane().add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.requestFocusInWindow();
        JButton cancelButton = new JButton();
        cancelButton.setFont(new Font("Arial", 0, 10));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MMIntroDlg.this.okFlag_ = false;
                MMIntroDlg.this.setVisible(false);
            }
        });
        cancelButton.setText("Cancel");
        cancelButton.setBounds(JavaUtils.isMac() ? 100 : 200, 497, 81, 24);
        this.getContentPane().add(cancelButton);
        JLabel microscopeManagerLabel = new JLabel();
        microscopeManagerLabel.setFont(new Font("", 1, 12));
        microscopeManagerLabel.setText("Micro-Manager startup configuration");
        microscopeManagerLabel.setBounds(5, 198, 259, 22);
        this.getContentPane().add(microscopeManagerLabel);
        JLabel version10betaLabel = new JLabel();
        version10betaLabel.setFont(new Font("Arial", 0, 10));
        version10betaLabel.setText("MMStudio Version " + ver);
        version10betaLabel.setBounds(5, 216, 193, 13);
        this.getContentPane().add(version10betaLabel);
        JLabel loadConfigurationLabel = new JLabel();
        loadConfigurationLabel.setFont(new Font("Arial", 0, 10));
        loadConfigurationLabel.setText("Configuration file:");
        loadConfigurationLabel.setBounds(5, 225, 319, 19);
        this.getContentPane().add(loadConfigurationLabel);
        JButton browseButton = new JButton();
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MMIntroDlg.this.loadConfigFile();
            }
        });
        browseButton.setText("...");
        browseButton.setBounds(350, 245, 36, 26);
        this.getContentPane().add(browseButton);
        this.cfgFileDropperDown_ = new JComboBox();
        this.cfgFileDropperDown_.setFont(new Font("Arial", 0, 10));
        this.cfgFileDropperDown_.setBounds(5, 245, 342, 26);
        this.getContentPane().add(this.cfgFileDropperDown_);
        this.welcomeTextArea_ = new JTextArea(){

            @Override
            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.welcomeTextArea_.setBorder(new EtchedBorder());
        this.welcomeTextArea_.setWrapStyleWord(true);
        this.welcomeTextArea_.setText(DISCLAIMER_TEXT + "\n\n" + SUPPORT_TEXT + "\n\n" + CITATION_TEXT);
        this.welcomeTextArea_.setLineWrap(true);
        this.welcomeTextArea_.setFont(new Font("Arial", 0, 10));
        this.welcomeTextArea_.setFocusable(false);
        this.welcomeTextArea_.setEditable(false);
        this.welcomeTextArea_.setBackground(Color.WHITE);
        this.welcomeTextArea_.setBounds(10, 284, 356, 205);
        this.getContentPane().add(this.welcomeTextArea_);
    }

    public boolean okChosen() {
        return this.okFlag_;
    }

    public void setConfigFile(String path) {
        this.cfgFileDropperDown_.removeAllItems();
        File cfg = new File(path);
        Boolean doesExist = cfg.exists();
        if (doesExist.booleanValue() && !this.mruCFGFileList_.contains(path)) {
            if (6 <= this.mruCFGFileList_.size()) {
                this.mruCFGFileList_.remove(this.mruCFGFileList_.size() - 2);
            }
            this.mruCFGFileList_.add(0, path);
        }
        for (String ofi : this.mruCFGFileList_) {
            String tvalue;
            this.cfgFileDropperDown_.addItem(ofi.toString());
            if (!doesExist.booleanValue() || !(tvalue = ofi.toString()).equals(path)) continue;
            this.cfgFileDropperDown_.setSelectedIndex(this.cfgFileDropperDown_.getItemCount() - 1);
        }
        this.cfgFileDropperDown_.addItem("(none)");
        if (!doesExist.booleanValue()) {
            this.cfgFileDropperDown_.setSelectedIndex(this.cfgFileDropperDown_.getItemCount() - 1);
        }
    }

    public String getConfigFile() {
        String nvalue = "(none)";
        String tvalue = this.cfgFileDropperDown_.getSelectedItem().toString();
        if (nvalue.equals(tvalue)) {
            tvalue = "";
        }
        return tvalue;
    }

    public String getScriptFile() {
        return "";
    }

    protected void loadConfigFile() {
        File f = FileDialogs.openFile(this, "Choose a config file", MMStudio.MM_CONFIG_FILE);
        if (f != null) {
            this.setConfigFile(f.getAbsolutePath());
        }
    }
}

