/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.util.Arrays;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.ConfigDialog;
import org.micromanager.dialogs.PresetEditor;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SortFunctionObjects;

public class GroupEditor
extends ConfigDialog {
    private static final long serialVersionUID = 8281144157746745260L;

    public GroupEditor(String groupName, String presetName, ScriptInterface gui, CMMCore core, boolean newItem) {
        super(groupName, presetName, gui, core, newItem);
        this.instructionsText_ = "Here you can specify the properties included\nin a configuration group.";
        this.nameFieldLabelText_ = "Group name:";
        this.initName_ = this.groupName_;
        this.TITLE = "Group Editor";
        this.showUnused_ = true;
        this.showFlagsPanelVisible = true;
        this.scrollPaneTop_ = 140;
        this.numColumns_ = 3;
        this.data_ = new PropertyTableData(this.core_, this.groupName_, this.presetName_, 2, 1, false);
        this.initializeData();
        this.data_.setColumnNames("Property Name", "Use in Group?", "Current Property Value");
        this.showShowReadonlyCheckBox_ = true;
        this.initialize();
    }

    @Override
    public void okChosen() {
        String newName = this.nameField_.getText();
        if (this.writeGroup(this.initName_, newName)) {
            this.groupName_ = newName;
            this.dispose();
        }
    }

    public boolean writeGroup(String initName, String newName) {
        int itemsIncludedCount = 0;
        for (PropertyItem item : this.data_.getPropList()) {
            if (!item.confInclude) continue;
            ++itemsIncludedCount;
        }
        if (itemsIncludedCount == 0) {
            this.showMessageDialog("Please select at least one property for this group.");
            return false;
        }
        if (newName.length() == 0) {
            this.showMessageDialog("Please enter a name for this group.");
            return false;
        }
        StrVector groups = this.core_.getAvailableConfigGroups();
        int i = 0;
        while ((long)i < groups.size()) {
            if (groups.get(i).contentEquals(newName) && !newName.contentEquals(initName)) {
                this.showMessageDialog("A group by this name already exists. Please enter a different name.");
                return false;
            }
            ++i;
        }
        StrVector cfgs = this.core_.getAvailableConfigs(newName);
        try {
            if (!this.newItem_) {
                int i2 = 0;
                while ((long)i2 < cfgs.size()) {
                    Configuration first = this.core_.getConfigData(initName, cfgs.get(i2));
                    int j = i2 + 1;
                    while ((long)j < cfgs.size()) {
                        boolean same = true;
                        Configuration second = this.core_.getConfigData(initName, cfgs.get(j));
                        for (PropertyItem item : this.data_.getPropList()) {
                            if (!item.confInclude || !first.isPropertyIncluded(item.device, item.name) || !second.isPropertyIncluded(item.device, item.name) || first.getSetting(item.device, item.name).getPropertyValue().contentEquals(second.getSetting(item.device, item.name).getPropertyValue())) continue;
                            same = false;
                        }
                        if (same) {
                            this.showMessageDialog("By removing properties, you would create duplicate presets.\nTo avoid duplicates when you remove properties, you should\nfirst delete some of the presets in this group.");
                            return false;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        if (!this.newItem_ && !initName.contentEquals(newName)) {
            try {
                this.core_.renameConfigGroup(initName, newName);
            }
            catch (Exception e1) {
                ReportingUtils.logError(e1);
            }
        }
        if (this.newItem_) {
            try {
                this.core_.defineConfigGroup(newName);
                for (PropertyItem item : this.data_.getPropList()) {
                    if (!item.confInclude) continue;
                    if (itemsIncludedCount == 1 && item.allowed.length > 0) {
                        if (PropertyType.Float == item.type) {
                            Arrays.sort(item.allowed, new SortFunctionObjects.DoubleStringComp());
                        } else if (PropertyType.Integer == item.type) {
                            Arrays.sort(item.allowed, new SortFunctionObjects.IntStringComp());
                        } else if (PropertyType.String == item.type) {
                            boolean allNumeric = true;
                            for (int k = 0; k < item.allowed.length; ++k) {
                                if (Character.isDigit(item.allowed[k].charAt(0))) continue;
                                allNumeric = false;
                                break;
                            }
                            if (allNumeric) {
                                Arrays.sort(item.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                            } else {
                                Arrays.sort(item.allowed);
                            }
                        }
                        for (String allowedValue : item.allowed) {
                            if (allowedValue.equals("")) continue;
                            String presetName = allowedValue.replaceAll("[/\\*!']", "-");
                            this.core_.defineConfig(newName, presetName, item.device, item.name, allowedValue);
                        }
                        continue;
                    }
                    this.core_.defineConfig(newName, "NewPreset", item.device, item.name, item.getValueInCoreFormat());
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
            if (itemsIncludedCount > 1) {
                new PresetEditor(newName, "NewPreset", this.gui_, this.core_, false);
            }
        } else {
            String cfg = null;
            try {
                Configuration unionCfg = this.core_.getConfigGroupState(newName);
                for (PropertyItem item : this.data_.getPropList()) {
                    int i3;
                    if (!item.confInclude && unionCfg.isPropertyIncluded(item.device, item.name)) {
                        i3 = 0;
                        while ((long)i3 < cfgs.size()) {
                            cfg = cfgs.get(i3);
                            if (this.core_.getConfigData(newName, cfg).isPropertyIncluded(item.device, item.name)) {
                                this.core_.deleteConfig(newName, cfg, item.device, item.name);
                            }
                            ++i3;
                        }
                        continue;
                    }
                    if (!item.confInclude || unionCfg.isPropertyIncluded(item.device, item.name)) continue;
                    i3 = 0;
                    while ((long)i3 < cfgs.size()) {
                        cfg = cfgs.get(i3);
                        if (!this.core_.getConfigData(this.groupName_, cfg).isPropertyIncluded(item.device, item.name)) {
                            this.core_.defineConfig(newName, cfg, item.device, item.name, item.getValueInCoreFormat());
                        }
                        ++i3;
                    }
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        this.gui_.setConfigChanged(true);
        return true;
    }
}

