/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.TooltipTextMaker;

public class CustomTimeIntervalsPanel
extends JPanel {
    private final AcquisitionEngine acqEng_;
    private JTable timeIntervalTable_;
    private TimeIntervalTableModel intervalTableModel_;
    private JPanel buttonsPanel_;
    private JScrollPane scrollPane_;
    private JPanel infoPanel_;
    private LinearTimeDialog linearTimeDialog_;
    private LogTimeDialog logTimeDialog_;
    private JCheckBox useIntervalsCheckBox_;
    private final JTabbedPane window_;

    public CustomTimeIntervalsPanel(AcquisitionEngine acqEng, JTabbedPane window, ScriptInterface gui) {
        this.window_ = window;
        this.acqEng_ = acqEng;
        this.createTable();
        this.createButtons();
        this.createInfoPanel();
        this.configureLayout();
        if (gui != null) {
            this.setBackground(gui.getBackgroundColor());
            gui.addMMBackgroundListener(this);
        }
    }

    private void createInfoPanel() {
        this.infoPanel_ = new JPanel(new BorderLayout());
        JLabel info = new JLabel("<html>This tab allows you to set custom time intervals between successive frames.  The above table shows the list of time intervals currently supplied to Micromanager, as well as their indices and the expected elapsed time at the start of collection of each frame.  Each time interval represents the minimum delay from the start of the previous frame to the start of the current one.  The interval corresponding to frame 0 is the delay before the start of acquisition, and should be set to 0 ms unless such a delay is desired.  Note that the actual intervals between frames and the actual elapsed times may exceed the values listed here, depending on the speed with which the hardware can acquire images.  Intervals can be typed in manually, or created with the \"Create Logarithmic Intervals\" and \"Create Constant Intervals\" buttons. </html>");
        info.setFont(new Font("Arial", 0, 10));
        this.infoPanel_.add(info);
    }

    private void createTable() {
        this.intervalTableModel_ = new TimeIntervalTableModel();
        this.timeIntervalTable_ = new JTable(this.intervalTableModel_);
        this.timeIntervalTable_.setDefaultRenderer(Object.class, new IntervalTableCellRenderer());
        this.scrollPane_ = new JScrollPane(this.timeIntervalTable_);
    }

    public void closeLinearDialog() {
        this.linearTimeDialog_.setVisible(false);
    }

    public void closeLogDialog() {
        this.logTimeDialog_.setVisible(false);
    }

    private void createButtons() {
        this.buttonsPanel_ = new JPanel();
        BoxLayout buttonsPanelLayout = new BoxLayout(this.buttonsPanel_, 1);
        this.buttonsPanel_.setLayout(buttonsPanelLayout);
        JButton removeAllButton = new JButton("Remove All");
        removeAllButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(removeAllButton);
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.removeAll();
            }
        });
        removeAllButton.setMaximumSize(new Dimension(165, 25));
        JButton removeButton = new JButton("Remove");
        removeButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(removeButton);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selectedRows = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRows();
                if (selectedRows.length == 0) {
                    JOptionPane.showMessageDialog(CustomTimeIntervalsPanel.this.buttonsPanel_, "Must select row(s) to be removed");
                } else if (selectedRows.length == 1) {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.removeRow(selectedRows[0]);
                } else {
                    Arrays.sort(selectedRows);
                    for (int k = selectedRows.length - 1; k >= 0; --k) {
                        CustomTimeIntervalsPanel.this.intervalTableModel_.removeRow(selectedRows[k]);
                    }
                }
            }
        });
        removeButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Remove currently selected row(s)"));
        removeButton.setMaximumSize(new Dimension(165, 25));
        JButton addButton = new JButton("Add one frame");
        addButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int selectedRow = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow();
                if (selectedRow == -1) {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.addRow(0.0);
                } else {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.insertRow(0.0, selectedRow);
                    CustomTimeIntervalsPanel.this.timeIntervalTable_.addRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                }
            }
        });
        addButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Add new time point (Inserts above currently selected row(s) or at bottom of list if no row selected)"));
        addButton.setMaximumSize(new Dimension(165, 25));
        JButton createLinearTimePointsButton = new JButton("Create Constant Intervals");
        createLinearTimePointsButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(createLinearTimePointsButton);
        createLinearTimePointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomTimeIntervalsPanel.this.linearTimeDialog_ == null) {
                    CustomTimeIntervalsPanel.this.linearTimeDialog_ = new LinearTimeDialog();
                }
                CustomTimeIntervalsPanel.this.linearTimeDialog_.setVisible(true);
            }
        });
        createLinearTimePointsButton.setMaximumSize(new Dimension(165, 25));
        createLinearTimePointsButton.setToolTipText("Create series of equally spaced frames");
        JButton createLogTimePointsButton = new JButton("Create Logarithmic Intervals");
        createLogTimePointsButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(createLogTimePointsButton);
        createLogTimePointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomTimeIntervalsPanel.this.logTimeDialog_ == null) {
                    CustomTimeIntervalsPanel.this.logTimeDialog_ = new LogTimeDialog();
                }
                CustomTimeIntervalsPanel.this.logTimeDialog_.setVisible(true);
            }
        });
        createLogTimePointsButton.setMaximumSize(new Dimension(165, 25));
        createLogTimePointsButton.setToolTipText("Create series of equally logarithmically spaced frames");
        this.buttonsPanel_.add(new JLabel("      "));
        this.useIntervalsCheckBox_ = new JCheckBox("Use custom intervals");
        this.useIntervalsCheckBox_.setEnabled(this.acqEng_.getCustomTimeIntervals() != null);
        this.useIntervalsCheckBox_.setSelected(this.acqEng_.customTimeIntervalsEnabled());
        this.buttonsPanel_.add(this.useIntervalsCheckBox_);
        this.useIntervalsCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomTimeIntervalsPanel.this.acqEng_.enableCustomTimeIntervals(CustomTimeIntervalsPanel.this.useIntervalsCheckBox_.isSelected());
                CustomTimeIntervalsPanel.this.setTabTitle();
            }
        });
    }

    private void setTabTitle() {
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            this.window_.setTitleAt(0, "Custom time intervals (Enabled)");
        } else {
            this.window_.setTitleAt(0, "Custom time intervals (Disabled)");
        }
    }

    private void configureLayout() {
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.scrollPane_, "Center");
        topPanel.add((Component)this.buttonsPanel_, "After");
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.add(topPanel);
        this.add(this.infoPanel_);
    }

    public void syncCheckBoxFromAcqEng() {
        this.useIntervalsCheckBox_.setEnabled(this.acqEng_.getCustomTimeIntervals() != null);
        this.useIntervalsCheckBox_.setSelected(this.acqEng_.customTimeIntervalsEnabled());
        this.setTabTitle();
    }

    public void syncIntervalsFromAcqEng() {
        this.intervalTableModel_.syncIntervalsFromAcqEng();
    }

    private class TimeIntervalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Frame Index", "Time interval (ms)", "Elapsed time(ms)"};
        private final ArrayList<Double> timeIntervals_ = new ArrayList();

        public TimeIntervalTableModel() {
            this.syncIntervalsFromAcqEng();
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    CustomTimeIntervalsPanel.this.syncCheckBoxFromAcqEng();
                }
            });
        }

        private void sendIntervalsToAcqEng() {
            if (this.timeIntervals_ == null || this.timeIntervals_.isEmpty()) {
                CustomTimeIntervalsPanel.this.acqEng_.setCustomTimeIntervals(null);
            } else {
                double[] intervalsArray = new double[this.timeIntervals_.size()];
                for (int i = 0; i < this.timeIntervals_.size(); ++i) {
                    intervalsArray[i] = this.timeIntervals_.get(i);
                }
                CustomTimeIntervalsPanel.this.acqEng_.setCustomTimeIntervals(intervalsArray);
            }
            this.fireTableDataChanged();
        }

        public final void syncIntervalsFromAcqEng() {
            this.timeIntervals_.clear();
            double[] existingCustomIntervals = CustomTimeIntervalsPanel.this.acqEng_.getCustomTimeIntervals();
            if (existingCustomIntervals != null) {
                for (double d : existingCustomIntervals) {
                    this.timeIntervals_.add(d);
                }
            }
            this.fireTableDataChanged();
        }

        public ArrayList<Double> getIntervals() {
            return this.timeIntervals_;
        }

        public void replaceList(ArrayList<Double> intervals) {
            this.timeIntervals_.clear();
            this.timeIntervals_.addAll(intervals);
            this.sendIntervalsToAcqEng();
        }

        public void addListToStart(ArrayList<Double> intervals) {
            this.addList(0, intervals);
        }

        public void addListToEnd(ArrayList<Double> intervals) {
            this.addList(this.timeIntervals_.size(), intervals);
        }

        public void addList(int index, ArrayList<Double> intervals) {
            this.timeIntervals_.addAll(index, intervals);
            this.sendIntervalsToAcqEng();
        }

        @Override
        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.timeIntervals_.size();
        }

        public void removeAll() {
            this.timeIntervals_.clear();
            this.sendIntervalsToAcqEng();
        }

        public void removeRow(int index) {
            this.timeIntervals_.remove(index);
            this.sendIntervalsToAcqEng();
        }

        public void addRow(double interval) {
            this.timeIntervals_.add(interval);
            this.sendIntervalsToAcqEng();
        }

        public void insertRow(double interval, int row) {
            this.timeIntervals_.add(row, interval);
            this.sendIntervalsToAcqEng();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return rowIndex;
            }
            if (columnIndex == 1) {
                return this.timeIntervals_.get(rowIndex);
            }
            if (columnIndex == 2) {
                return this.calcElapsedTime(rowIndex);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            if (this.isCellEditable(rowIndex, colIndex)) {
                String str = (String)value;
                if (str.equals("")) {
                    this.timeIntervals_.set(rowIndex, 0.0);
                } else {
                    Double number = Double.parseDouble(str);
                    this.timeIntervals_.set(rowIndex, number);
                }
            }
            this.sendIntervalsToAcqEng();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && row < this.timeIntervals_.size();
        }

        private double calcElapsedTime(int row) {
            double elapsed = 0.0;
            for (int i = 0; i <= row; ++i) {
                elapsed += this.timeIntervals_.get(i).doubleValue();
            }
            return elapsed;
        }
    }

    private class IntervalTableCellRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat formatter = new DecimalFormat("0.##");

        private IntervalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, this.formatter.format((Number)value), isSelected, hasFocus, row, column);
            if (column == 0 || column == 2) {
                if (isSelected) {
                    cell.setBackground(Color.LIGHT_GRAY);
                    cell.setForeground(Color.BLACK);
                } else {
                    cell.setBackground(Color.DARK_GRAY);
                    cell.setForeground(Color.WHITE);
                }
            } else if (isSelected) {
                cell.setBackground(Color.BLUE);
                cell.setForeground(Color.WHITE);
            } else {
                cell.setBackground(Color.WHITE);
                cell.setForeground(Color.BLACK);
            }
            return cell;
        }
    }

    private class LinearTimeDialog
    extends MMDialog {
        private JSpinner numFrames_;
        private JFormattedTextField interval_;
        private JComboBox timeUnitCombo_;
        private JComboBox creationTypeCombo_;

        public LinearTimeDialog() {
            this.setModal(true);
            this.setSize(new Dimension(350, 200));
            this.setResizable(false);
            this.initComponents();
            this.setTitle("Create equal interval time points");
            this.setLocationRelativeTo(CustomTimeIntervalsPanel.this.window_);
        }

        private void initComponents() {
            final LinearTimeDialog selfPointer = this;
            GridLayout layout = new GridLayout(4, 1);
            this.getContentPane().setLayout(layout);
            JPanel row1 = new JPanel();
            this.add(row1);
            JLabel numberLabel = new JLabel();
            numberLabel.setFont(new Font("Arial", 0, 14));
            numberLabel.setText("Number of time points to create");
            row1.add(numberLabel);
            SpinnerNumberModel sModel = new SpinnerNumberModel(new Integer(2), new Integer(2), null, new Integer(1));
            this.numFrames_ = new JSpinner(sModel);
            this.numFrames_.setPreferredSize(new Dimension(80, 22));
            ((JSpinner.DefaultEditor)this.numFrames_.getEditor()).getTextField().setFont(new Font("Arial", 0, 14));
            row1.add(this.numFrames_);
            JPanel row2 = new JPanel();
            this.add(row2);
            JLabel intervalLabel = new JLabel();
            intervalLabel.setFont(new Font("Arial", 0, 14));
            intervalLabel.setText("Time interval between points");
            intervalLabel.setToolTipText("Interval between successive time points.  Setting an intervalof 0 will cause micromanager to acquire 'burts' of images as fast as possible");
            row2.add(intervalLabel);
            this.interval_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.interval_.setFont(new Font("Arial", 0, 14));
            this.interval_.setValue(1.0);
            this.interval_.setPreferredSize(new Dimension(80, 22));
            row2.add(this.interval_);
            this.timeUnitCombo_ = new JComboBox();
            this.timeUnitCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.timeUnitCombo_.setFont(new Font("Arial", 0, 14));
            row2.add(this.timeUnitCombo_);
            JPanel row3 = new JPanel();
            this.add(row3);
            this.creationTypeCombo_ = new JComboBox();
            this.creationTypeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Replace current time point list", "Add to start of current list", "Add to end of current list", "Insert at currently selected position"}));
            this.creationTypeCombo_.setFont(new Font("Arial", 0, 14));
            row3.add(this.creationTypeCombo_);
            JPanel row4 = new JPanel();
            this.add(row4);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setFont(new Font("Arial", 0, 14));
            row4.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CustomTimeIntervalsPanel.this.closeLinearDialog();
                }
            });
            JLabel spacer = new JLabel("        ");
            row4.add(spacer);
            JButton createButton = new JButton("Create");
            createButton.setFont(new Font("Arial", 0, 14));
            row4.add(createButton);
            createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int numFrames = (Integer)LinearTimeDialog.this.numFrames_.getValue();
                    double interval = ((Number)LinearTimeDialog.this.interval_.getValue()).doubleValue();
                    int units = LinearTimeDialog.this.timeUnitCombo_.getSelectedIndex();
                    int creationType = LinearTimeDialog.this.creationTypeCombo_.getSelectedIndex();
                    if (numFrames >= 1 && interval >= 0.0) {
                        if (units == 1) {
                            interval *= 1000.0;
                        } else if (units == 2) {
                            interval *= 60000.0;
                        }
                        ArrayList<Double> newIntervals = new ArrayList<Double>();
                        newIntervals.add(0.0);
                        for (int k = 1; k < numFrames; ++k) {
                            newIntervals.add(interval);
                        }
                        if (creationType == 0) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.replaceList(newIntervals);
                        } else if (creationType == 1) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.addListToStart(newIntervals);
                        } else if (creationType == 2) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(newIntervals);
                        } else {
                            int selected = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow();
                            if (selected == -1) {
                                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(newIntervals);
                            } else {
                                CustomTimeIntervalsPanel.this.intervalTableModel_.addList(selected, newIntervals);
                            }
                        }
                        CustomTimeIntervalsPanel.this.closeLinearDialog();
                    } else {
                        JOptionPane.showMessageDialog(selfPointer, "Invalid number of frames or time interval");
                    }
                }
            });
        }
    }

    private class LogTimeDialog
    extends MMDialog {
        private JComboBox creationTypeCombo_;
        private JFormattedTextField aValue_;
        private JFormattedTextField rValue_;
        private JFormattedTextField tValue_;
        private JComboBox aCombo_;
        private JComboBox tCombo_;
        private JSpinner nValue_;
        private JCheckBox aCheck_;
        private JCheckBox rCheck_;
        private JCheckBox nCheck_;
        private JCheckBox tCheck_;
        private double r_;
        private double t_;
        private double a_;
        private int n_;

        public LogTimeDialog() {
            this.setModal(true);
            this.setSize(new Dimension(520, 300));
            this.setResizable(false);
            this.setTitle("Create logarithmically spaced time points");
            this.setLocationRelativeTo(CustomTimeIntervalsPanel.this.window_);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.createCheckBoxes();
            this.createCreationComboandButtons();
        }

        private double convertToMS(double num, JComboBox unitCombo) {
            double result = num;
            int units = unitCombo.getSelectedIndex();
            if (units == 1) {
                result *= 1000.0;
            } else if (units == 2) {
                result *= 60000.0;
            }
            return result;
        }

        private void calcFourthParameter() {
            try {
                this.rValue_.commitEdit();
                this.nValue_.commitEdit();
                this.aValue_.commitEdit();
                this.tValue_.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!this.aCheck_.isSelected()) {
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.a_ = this.t_ / Math.pow(this.r_, this.n_ - 2);
            } else if (!this.rCheck_.isSelected()) {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.r_ = Math.pow(this.t_ / this.a_, 1.0 / (double)(this.n_ - 2));
            } else if (!this.tCheck_.isSelected()) {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.a_ * Math.pow(this.r_, this.n_ - 2);
            } else {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (int)Math.max(3.0, Math.log(this.t_ / this.a_) / Math.log(this.r_) + 2.0);
            }
        }

        private int numberBoxesChecked() {
            int countSelected = 0;
            if (this.aCheck_.isSelected()) {
                ++countSelected;
            }
            if (this.rCheck_.isSelected()) {
                ++countSelected;
            }
            if (this.tCheck_.isSelected()) {
                ++countSelected;
            }
            if (this.nCheck_.isSelected()) {
                ++countSelected;
            }
            return countSelected;
        }

        private void updateParameterValues() {
            if (this.numberBoxesChecked() != 3) {
                return;
            }
            this.calcFourthParameter();
            if (!this.aCheck_.isSelected()) {
                double dispVal = this.a_;
                if (this.aCombo_.getSelectedIndex() == 1) {
                    dispVal /= 1000.0;
                } else if (this.aCombo_.getSelectedIndex() == 2) {
                    dispVal /= 60000.0;
                }
                this.aValue_.setValue(dispVal);
            } else if (!this.rCheck_.isSelected()) {
                this.rValue_.setValue(this.r_);
            } else if (!this.tCheck_.isSelected()) {
                double dispVal = this.t_;
                if (this.tCombo_.getSelectedIndex() == 1) {
                    dispVal /= 1000.0;
                } else if (this.aCombo_.getSelectedIndex() == 2) {
                    dispVal /= 60000.0;
                }
                this.tValue_.setValue(dispVal);
            } else if (!this.nCheck_.isSelected()) {
                this.nValue_.setValue(this.n_);
            }
        }

        private void createCheckBoxes() {
            JPanel checkBoxPanel = new JPanel();
            checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 1));
            this.add(checkBoxPanel);
            JPanel labelPanel = new JPanel();
            this.add(labelPanel);
            labelPanel.add(new JLabel("Specify 3 of the following 4 parameters"));
            final JPanel row1 = new JPanel();
            final JPanel row2 = new JPanel();
            final JPanel row3 = new JPanel();
            final JPanel row4 = new JPanel();
            this.add(row1);
            this.add(row2);
            this.add(row3);
            this.add(row4);
            this.aCheck_ = new JCheckBox("Length of interval between first two frames", true);
            this.rCheck_ = new JCheckBox("Ratio of elapsed time of consecutive points", true);
            this.tCheck_ = new JCheckBox("Total time length", true);
            this.nCheck_ = new JCheckBox("Number of Frames", false);
            row1.add(this.aCheck_);
            row2.add(this.rCheck_);
            row3.add(this.tCheck_);
            row4.add(this.nCheck_);
            ActionListener boxesListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block15: {
                        int checkCount;
                        block13: {
                            block17: {
                                block16: {
                                    block14: {
                                        checkCount = 0;
                                        if (LogTimeDialog.this.aCheck_.isSelected()) {
                                            ++checkCount;
                                        }
                                        if (LogTimeDialog.this.rCheck_.isSelected()) {
                                            ++checkCount;
                                        }
                                        if (LogTimeDialog.this.tCheck_.isSelected()) {
                                            ++checkCount;
                                        }
                                        if (LogTimeDialog.this.nCheck_.isSelected()) {
                                            ++checkCount;
                                        }
                                        if (checkCount != 3) break block13;
                                        if (LogTimeDialog.this.aCheck_.isSelected()) break block14;
                                        for (Component c : row1.getComponents()) {
                                            c.setEnabled(false);
                                        }
                                        break block15;
                                    }
                                    if (LogTimeDialog.this.rCheck_.isSelected()) break block16;
                                    for (Component c : row2.getComponents()) {
                                        c.setEnabled(false);
                                    }
                                    break block15;
                                }
                                if (LogTimeDialog.this.tCheck_.isSelected()) break block17;
                                for (Component c : row3.getComponents()) {
                                    c.setEnabled(false);
                                }
                                break block15;
                            }
                            if (LogTimeDialog.this.nCheck_.isSelected()) break block15;
                            for (Component c : row4.getComponents()) {
                                c.setEnabled(false);
                            }
                            break block15;
                        }
                        if (checkCount == 2) {
                            for (Component c : row1.getComponents()) {
                                c.setEnabled(true);
                            }
                            for (Component c : row2.getComponents()) {
                                c.setEnabled(true);
                            }
                            for (Component c : row3.getComponents()) {
                                c.setEnabled(true);
                            }
                            for (Component c : row4.getComponents()) {
                                c.setEnabled(true);
                            }
                        }
                    }
                }
            };
            this.aCheck_.addActionListener(boxesListener);
            this.rCheck_.addActionListener(boxesListener);
            this.nCheck_.addActionListener(boxesListener);
            this.tCheck_.addActionListener(boxesListener);
            this.aValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.aValue_.setFont(new Font("Arial", 0, 14));
            this.aValue_.setValue(1.0);
            this.aValue_.setPreferredSize(new Dimension(80, 22));
            this.aCombo_ = new JComboBox();
            this.aCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.aCombo_.setFont(new Font("Arial", 0, 14));
            row1.add(this.aValue_);
            row1.add(this.aCombo_);
            this.rValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.rValue_.setFont(new Font("Arial", 0, 14));
            this.rValue_.setValue(2.0);
            this.rValue_.setPreferredSize(new Dimension(80, 22));
            row2.add(this.rValue_);
            this.tValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.tValue_.setFont(new Font("Arial", 0, 14));
            this.tValue_.setValue(1000.0);
            this.tValue_.setPreferredSize(new Dimension(80, 22));
            this.tCombo_ = new JComboBox();
            this.tCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.tCombo_.setFont(new Font("Arial", 0, 14));
            row3.add(this.tValue_);
            row3.add(this.tCombo_);
            SpinnerNumberModel sModel = new SpinnerNumberModel(new Integer(3), new Integer(3), null, new Integer(1));
            this.nValue_ = new JSpinner(sModel);
            this.nValue_.setPreferredSize(new Dimension(80, 22));
            ((JSpinner.DefaultEditor)this.nValue_.getEditor()).getTextField().setFont(new Font("Arial", 0, 14));
            row1.add(this.nValue_);
            row4.add(this.nValue_);
            ActionListener dynamicUpdater = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogTimeDialog.this.updateParameterValues();
                }
            };
            this.aCombo_.addActionListener(dynamicUpdater);
            this.tCombo_.addActionListener(dynamicUpdater);
            this.aValue_.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (LogTimeDialog.this.aValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.tValue_.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (LogTimeDialog.this.tValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.rValue_.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (LogTimeDialog.this.rValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.nValue_.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LogTimeDialog.this.nValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            ((JSpinner.DefaultEditor)this.nValue_.getEditor()).getTextField().addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (LogTimeDialog.this.nValue_.isEnabled() && (Integer)LogTimeDialog.this.nValue_.getValue() >= 3) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            for (Component co : row4.getComponents()) {
                co.setEnabled(false);
            }
            this.updateParameterValues();
        }

        private boolean checkParametersValid() {
            if (!this.aCheck_.isSelected()) {
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            } else if (!this.rCheck_.isSelected()) {
                if (this.t_ <= this.a_) {
                    JOptionPane.showMessageDialog(this, "Total time must be greater than interval between first two frames");
                    return false;
                }
            } else if (!this.tCheck_.isSelected()) {
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            } else if (!this.nCheck_.isSelected()) {
                if (this.t_ <= this.a_) {
                    JOptionPane.showMessageDialog(this, "Total time must be greater than interval between first two frames");
                    return false;
                }
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            }
            return true;
        }

        private void createButtonAction() {
            if (this.numberBoxesChecked() != 3) {
                JOptionPane.showMessageDialog(this, "Select 3 parameters to specify");
                return;
            }
            this.calcFourthParameter();
            if (!this.checkParametersValid()) {
                return;
            }
            ArrayList<Double> newIntervals = new ArrayList<Double>();
            newIntervals.add(0.0);
            newIntervals.add(this.a_);
            for (int i = 2; i < this.n_; ++i) {
                newIntervals.add(this.a_ * (Math.pow(this.r_, i - 1) - Math.pow(this.r_, i - 2)));
            }
            int creationType = this.creationTypeCombo_.getSelectedIndex();
            if (creationType == 0) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.replaceList(newIntervals);
            } else if (creationType == 1) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToStart(newIntervals);
            } else if (creationType == 2) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(newIntervals);
            } else if (CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow() == -1) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(newIntervals);
            } else {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addList(CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow(), newIntervals);
            }
            CustomTimeIntervalsPanel.this.closeLogDialog();
        }

        private void createCreationComboandButtons() {
            JPanel creationTypeRow = new JPanel();
            this.add(creationTypeRow);
            this.creationTypeCombo_ = new JComboBox();
            this.creationTypeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Replace current time point list", "Add to start of current list", "Add to end of current list", "Insert at currently selected position"}));
            this.creationTypeCombo_.setFont(new Font("Arial", 0, 14));
            creationTypeRow.add(this.creationTypeCombo_);
            JPanel buttonsRow = new JPanel();
            this.add(buttonsRow);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setFont(new Font("Arial", 0, 14));
            buttonsRow.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CustomTimeIntervalsPanel.this.closeLogDialog();
                }
            });
            JLabel spacer = new JLabel("        ");
            buttonsRow.add(spacer);
            JButton createButton = new JButton("Create");
            createButton.setFont(new Font("Arial", 0, 14));
            buttonsRow.add(createButton);
            createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LogTimeDialog.this.createButtonAction();
                }
            });
        }
    }
}

