/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.PropertyNameCellRenderer;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.PropertyUsageCellEditor;
import org.micromanager.utils.PropertyUsageCellRenderer;
import org.micromanager.utils.PropertyValueCellEditor;
import org.micromanager.utils.PropertyValueCellRenderer;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;
import org.micromanager.utils.ShowFlagsPanel;

public class ConfigDialog
extends MMDialog {
    private static final long serialVersionUID = 5819669941239786807L;
    protected CMMCore core_;
    protected ScriptInterface gui_;
    private JTable table_;
    protected PropertyTableData data_;
    private JScrollPane scrollPane_;
    private ShowFlags flags_;
    private ShowFlagsPanel showFlagsPanel_;
    private final SpringLayout springLayout_;
    private JTextArea textArea_;
    private JCheckBox showReadonlyCheckBox_;
    protected boolean showShowReadonlyCheckBox_ = false;
    protected JTextField nameField_;
    private JLabel nameFieldLabel_;
    private JButton okButton_;
    private JButton cancelButton_;
    protected String TITLE = "";
    protected String instructionsText_ = "Instructions go here.";
    protected String nameFieldLabelText_ = "GroupOrPreset Name";
    protected String initName_ = "";
    protected String groupName_;
    protected String presetName_;
    protected Boolean showUnused_ = true;
    protected int numColumns_ = 3;
    protected boolean newItem_ = true;
    protected boolean showFlagsPanelVisible = true;
    protected int scrollPaneTop_;

    public ConfigDialog(String groupName, String presetName, ScriptInterface gui, CMMCore core, boolean newItem) {
        this.groupName_ = groupName;
        this.presetName_ = presetName;
        this.newItem_ = newItem;
        this.gui_ = gui;
        this.core_ = core;
        this.springLayout_ = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout_);
        this.loadAndRestorePosition(100, 100, 550, 600);
        this.setMinimumSize(new Dimension(400, 200));
    }

    public void initialize() {
        this.initializePropertyTable();
        this.initializeWidgets();
        this.initializeFlags();
        this.setupKeys();
        this.setVisible(true);
        this.setTitle(this.TITLE);
        this.nameField_.requestFocus();
        this.setFocusable(true);
        this.update();
    }

    protected void setupKeys() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        actionMap.put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigDialog.this.table_.isEditing() && ConfigDialog.this.table_.getCellEditor() != null) {
                    ConfigDialog.this.table_.getCellEditor().stopCellEditing();
                }
                ConfigDialog.this.okChosen();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        actionMap.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.cancelChosen();
            }
        });
        this.table_.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
    }

    public void initializeData() {
        this.data_.setGUI(this.gui_);
        this.data_.setShowUnused(this.showUnused_);
    }

    protected void initializeWidgets() {
        this.textArea_ = new JTextArea();
        this.textArea_.setFont(new Font("Arial", 0, 12));
        this.textArea_.setWrapStyleWord(true);
        this.textArea_.setText(this.instructionsText_);
        this.textArea_.setEditable(false);
        this.textArea_.setOpaque(false);
        this.getContentPane().add(this.textArea_);
        this.springLayout_.putConstraint("East", (Component)this.textArea_, 250, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.textArea_, 5, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("South", (Component)this.textArea_, 37, "North", (Component)this.getContentPane());
        this.springLayout_.putConstraint("North", (Component)this.textArea_, 5, "North", (Component)this.getContentPane());
        if (this.showShowReadonlyCheckBox_) {
            this.showReadonlyCheckBox_ = new JCheckBox();
            this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
            this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigDialog.this.data_.setShowReadOnly(ConfigDialog.this.showReadonlyCheckBox_.isSelected());
                    ConfigDialog.this.data_.update(false);
                    ConfigDialog.this.data_.fireTableStructureChanged();
                }
            });
            this.showReadonlyCheckBox_.setText("Show read-only properties");
            this.getContentPane().add(this.showReadonlyCheckBox_);
            this.springLayout_.putConstraint("East", (Component)this.showReadonlyCheckBox_, 250, "West", (Component)this.getContentPane());
            this.springLayout_.putConstraint("West", (Component)this.showReadonlyCheckBox_, 5, "West", (Component)this.getContentPane());
            this.springLayout_.putConstraint("North", (Component)this.showReadonlyCheckBox_, 45, "North", (Component)this.getContentPane());
            this.springLayout_.putConstraint("South", (Component)this.showReadonlyCheckBox_, 70, "North", (Component)this.getContentPane());
        }
        this.nameField_ = new JTextField();
        this.nameField_.setText(this.initName_);
        this.nameField_.setEditable(true);
        this.nameField_.setSelectionStart(0);
        this.nameField_.setSelectionEnd(this.nameField_.getText().length());
        this.getContentPane().add(this.nameField_);
        this.springLayout_.putConstraint("East", (Component)this.nameField_, 280, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.nameField_, 95, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("South", (Component)this.nameField_, -3, "North", (Component)this.scrollPane_);
        this.springLayout_.putConstraint("North", (Component)this.nameField_, -30, "North", (Component)this.scrollPane_);
        this.nameFieldLabel_ = new JLabel();
        this.nameFieldLabel_.setText(this.nameFieldLabelText_);
        this.nameFieldLabel_.setFont(new Font("Arial", 1, 12));
        this.nameFieldLabel_.setHorizontalAlignment(4);
        this.getContentPane().add(this.nameFieldLabel_);
        this.springLayout_.putConstraint("East", (Component)this.nameFieldLabel_, 90, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.nameFieldLabel_, 5, "West", (Component)this.getContentPane());
        this.springLayout_.putConstraint("South", (Component)this.nameFieldLabel_, -3, "North", (Component)this.scrollPane_);
        this.springLayout_.putConstraint("North", (Component)this.nameFieldLabel_, -30, "North", (Component)this.scrollPane_);
        this.okButton_ = new JButton("OK");
        this.getContentPane().add(this.okButton_);
        this.springLayout_.putConstraint("East", (Component)this.okButton_, -5, "East", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.okButton_, -105, "East", (Component)this.getContentPane());
        this.springLayout_.putConstraint("South", (Component)this.okButton_, 30, "North", (Component)this.getContentPane());
        this.springLayout_.putConstraint("North", (Component)this.okButton_, 5, "North", (Component)this.getContentPane());
        this.okButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigDialog.this.table_.isEditing() && ConfigDialog.this.table_.getCellEditor() != null) {
                    ConfigDialog.this.table_.getCellEditor().stopCellEditing();
                }
                ConfigDialog.this.okChosen();
            }
        });
        this.cancelButton_ = new JButton("Cancel");
        this.getContentPane().add(this.cancelButton_);
        this.springLayout_.putConstraint("East", (Component)this.cancelButton_, -5, "East", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.cancelButton_, -105, "East", (Component)this.getContentPane());
        this.springLayout_.putConstraint("South", (Component)this.cancelButton_, 57, "North", (Component)this.getContentPane());
        this.springLayout_.putConstraint("North", (Component)this.cancelButton_, 32, "North", (Component)this.getContentPane());
        this.cancelButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.cancelChosen();
            }
        });
    }

    protected void initializeFlags() {
        this.flags_ = new ShowFlags();
        if (this.showFlagsPanelVisible) {
            this.flags_.load(this.getPrefsNode());
            try {
                Configuration cfg = this.presetName_.length() == 0 ? new Configuration() : this.core_.getConfigState(this.groupName_, this.presetName_);
                this.showFlagsPanel_ = new ShowFlagsPanel(this.data_, this.flags_, this.core_, cfg);
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
            this.getContentPane().add(this.showFlagsPanel_);
            this.springLayout_.putConstraint("East", (Component)this.showFlagsPanel_, 440, "West", (Component)this.getContentPane());
            this.springLayout_.putConstraint("West", (Component)this.showFlagsPanel_, 290, "West", (Component)this.getContentPane());
            this.springLayout_.putConstraint("South", (Component)this.showFlagsPanel_, 135, "North", (Component)this.getContentPane());
            this.springLayout_.putConstraint("North", (Component)this.showFlagsPanel_, 5, "North", (Component)this.getContentPane());
        }
        this.data_.setFlags(this.flags_);
    }

    public void initializePropertyTable() {
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout_.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout_.putConstraint("North", (Component)this.scrollPane_, this.scrollPaneTop_, "North", (Component)this.getContentPane());
        this.springLayout_.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout_.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.table_ = new JTable();
        this.table_.setSelectionMode(2);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.table_);
        this.table_.setModel(this.data_);
        if (this.numColumns_ == 3) {
            this.table_.addColumn(new TableColumn(0, 200, new PropertyNameCellRenderer(), null));
            this.table_.addColumn(new TableColumn(1, 75, new PropertyUsageCellRenderer(), new PropertyUsageCellEditor()));
            this.table_.addColumn(new TableColumn(2, 200, new PropertyValueCellRenderer(true), new PropertyValueCellEditor(true)));
        } else if (this.numColumns_ == 2) {
            this.table_.addColumn(new TableColumn(0, 200, new PropertyNameCellRenderer(), null));
            this.table_.addColumn(new TableColumn(1, 200, new PropertyValueCellRenderer(false), new PropertyValueCellEditor(false)));
        }
    }

    public void okChosen() {
    }

    public void cancelChosen() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.savePosition();
        this.gui_.refreshGUI();
    }

    public void update() {
        this.data_.update(false);
    }

    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }
}

