/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.micromanager.MMOptions;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TooltipTextMaker;

public class ChannelTableModel
extends AbstractTableModel
implements TableModelListener {
    private static final long serialVersionUID = 3290621191844925827L;
    private ArrayList<ChannelSpec> channels_;
    private final ScriptInterface studio_;
    private final AcquisitionEngine acqEng_;
    private final Preferences exposurePrefs_;
    private final Preferences colorPrefs_;
    private final MMOptions options_;
    public final String[] COLUMN_NAMES = new String[]{"Use?", "Configuration", "Exposure", "Z-offset", "Z-stack", "Skip Fr.", "Color"};
    private final String[] TOOLTIPS = new String[]{"Toggle channel/group on/off", "Choose preset property values for channel or group", "Set exposure time in ms", TooltipTextMaker.addHTMLBreaksForTooltip("Set a Z offset specific to this channel/group (the main object in one of the channels/groups is in a different focal plane from the other channels/groups"), "Collect images in multiple Z planes?", TooltipTextMaker.addHTMLBreaksForTooltip("Setting 'Skip Frame' to a number other than 0 will cause the acquisition to 'skip' taking images in that channel (after taking the first image) for the indicated number of time intervals. The 5D-Image Viewer will 'fill in' these skipped frames with the previous image. In some situations it may be desirable to acquire certain channels at lower sampling rates, to reduce photo-toxicity and to save disk space. "), "Select channel/group color for display in viewer"};

    public String getToolTipText(int columnIndex) {
        return this.TOOLTIPS[columnIndex];
    }

    public ChannelTableModel(ScriptInterface studio, AcquisitionEngine eng, Preferences exposurePrefs, Preferences colorPrefs, MMOptions options) {
        this.studio_ = studio;
        this.acqEng_ = eng;
        this.exposurePrefs_ = exposurePrefs;
        this.colorPrefs_ = colorPrefs;
        this.options_ = options;
    }

    @Override
    public int getRowCount() {
        if (this.channels_ == null) {
            return 0;
        }
        return this.channels_.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.channels_ != null && rowIndex < this.channels_.size()) {
            if (columnIndex == 0) {
                return this.channels_.get((int)rowIndex).useChannel;
            }
            if (columnIndex == 1) {
                return this.channels_.get((int)rowIndex).config;
            }
            if (columnIndex == 2) {
                return this.channels_.get((int)rowIndex).exposure;
            }
            if (columnIndex == 3) {
                return this.channels_.get((int)rowIndex).zOffset;
            }
            if (columnIndex == 4) {
                return this.channels_.get((int)rowIndex).doZStack;
            }
            if (columnIndex == 5) {
                return this.channels_.get((int)rowIndex).skipFactorFrame;
            }
            if (columnIndex == 6) {
                return this.channels_.get((int)rowIndex).color;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.channels_.size() || value == null) {
            return;
        }
        ChannelSpec channel = this.channels_.get(row);
        if (col == 0) {
            channel.useChannel = (Boolean)value;
        } else if (col == 1) {
            channel.config = value.toString();
            channel.exposure = this.exposurePrefs_.getDouble("Exposure_" + this.acqEng_.getChannelGroup() + "_" + channel.config, 10.0);
        } else if (col == 2) {
            channel.exposure = (Double)value;
            this.exposurePrefs_.putDouble("Exposure_" + this.acqEng_.getChannelGroup() + "_" + channel.config, channel.exposure);
            if (this.options_.syncExposureMainAndMDA_) {
                this.studio_.setChannelExposureTime(this.acqEng_.getChannelGroup(), channel.config, channel.exposure);
            }
        } else if (col == 3) {
            channel.zOffset = (Double)value;
        } else if (col == 4) {
            channel.doZStack = (Boolean)value;
        } else if (col == 5) {
            channel.skipFactorFrame = (Integer)value;
        } else if (col == 6) {
            channel.color = (Color)value;
        }
        this.acqEng_.setChannel(row, channel);
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return nCol != 4 || this.acqEng_.isZSliceSettingEnabled();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        if (row < 0) {
            return;
        }
        int col = e.getColumn();
        if (col < 0) {
            return;
        }
        ChannelSpec channel = this.channels_.get(row);
        TableModel model = (TableModel)e.getSource();
        if (col == 6) {
            Color color = (Color)model.getValueAt(row, col);
            this.colorPrefs_.putInt("Color_" + this.acqEng_.getChannelGroup() + "_" + channel.config, color.getRGB());
        }
    }

    public void setChannels(ArrayList<ChannelSpec> ch) {
        this.channels_ = ch;
    }

    public ArrayList<ChannelSpec> getChannels() {
        return this.channels_;
    }

    public void addNewChannel() {
        ChannelSpec channel = new ChannelSpec();
        channel.config = "";
        if (this.acqEng_.getChannelConfigs().length > 0) {
            for (String config : this.acqEng_.getChannelConfigs()) {
                boolean unique = true;
                for (ChannelSpec chan : this.channels_) {
                    if (!config.contentEquals(chan.config)) continue;
                    unique = false;
                }
                if (!unique) continue;
                channel.config = config;
                break;
            }
            if (channel.config.length() == 0) {
                ReportingUtils.showMessage("No more channels are available\nin this channel group.");
            } else {
                channel.color = new Color(this.colorPrefs_.getInt("Color_" + this.acqEng_.getChannelGroup() + "_" + channel.config, Color.white.getRGB()));
                channel.exposure = this.exposurePrefs_.getDouble("Exposure_" + this.acqEng_.getChannelGroup() + "_" + channel.config, 10.0);
                this.channels_.add(channel);
            }
        }
    }

    public void removeChannel(int chIndex) {
        if (chIndex >= 0 && chIndex < this.channels_.size()) {
            this.channels_.remove(chIndex);
        }
    }

    public int rowDown(int rowIdx) {
        if (rowIdx >= 0 && rowIdx < this.channels_.size() - 1) {
            ChannelSpec channel = this.channels_.get(rowIdx);
            this.channels_.remove(rowIdx);
            this.channels_.add(rowIdx + 1, channel);
            return rowIdx + 1;
        }
        return rowIdx;
    }

    public int rowUp(int rowIdx) {
        if (rowIdx >= 1 && rowIdx < this.channels_.size()) {
            ChannelSpec channel = this.channels_.get(rowIdx);
            this.channels_.remove(rowIdx);
            this.channels_.add(rowIdx - 1, channel);
            return rowIdx - 1;
        }
        return rowIdx;
    }

    public String[] getAvailableChannels() {
        return this.acqEng_.getChannelConfigs();
    }

    public void cleanUpConfigurationList() {
        Iterator<ChannelSpec> it = this.channels_.iterator();
        while (it.hasNext()) {
            String config = it.next().config;
            if (config.contentEquals("") || this.acqEng_.isConfigAvailable(config)) continue;
            it.remove();
        }
        this.fireTableStructureChanged();
    }

    public boolean duplicateChannels() {
        for (int i = 0; i < this.channels_.size() - 1; ++i) {
            for (int j = i + 1; j < this.channels_.size(); ++j) {
                if (!this.channels_.get((int)i).config.equals(this.channels_.get((int)j).config)) continue;
                return true;
            }
        }
        return false;
    }

    public void setChannelExposureTime(String channelGroup, String channel, double exposure) {
        if (!channelGroup.equals(this.acqEng_.getChannelGroup())) {
            return;
        }
        for (ChannelSpec ch : this.channels_) {
            if (!ch.config.equals(channel)) continue;
            ch.exposure = exposure;
            this.fireTableDataChanged();
        }
    }
}

