/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.dialogs.ChannelTableModel;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.NumberUtils;

public class ChannelCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -4328340719459382679L;
    private AcquisitionEngine acqEng_;

    public ChannelCellRenderer(AcquisitionEngine acqEng) {
        this.acqEng_ = acqEng;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        ChannelTableModel model = (ChannelTableModel)table.getModel();
        ArrayList<ChannelSpec> channels = model.getChannels();
        ChannelSpec channel = channels.get(rowIndex);
        this.setEnabled(table.isEnabled());
        colIndex = table.convertColumnIndexToModel(colIndex);
        this.setOpaque(false);
        if (colIndex == 0) {
            JCheckBox check = new JCheckBox("", channel.useChannel);
            check.setEnabled(table.isEnabled());
            check.setOpaque(true);
            if (isSelected) {
                check.setBackground(table.getSelectionBackground());
                check.setOpaque(true);
            } else {
                check.setOpaque(false);
                check.setBackground(table.getBackground());
            }
            return check;
        }
        if (colIndex == 1) {
            this.setText(channel.config);
        } else if (colIndex == 2) {
            this.setText(NumberUtils.doubleToDisplayString(channel.exposure));
        } else if (colIndex == 3) {
            this.setText(NumberUtils.doubleToDisplayString(channel.zOffset));
        } else {
            if (colIndex == 4) {
                JCheckBox check = new JCheckBox("", (boolean)channel.doZStack);
                check.setEnabled(this.acqEng_.isZSliceSettingEnabled() && table.isEnabled());
                if (isSelected) {
                    check.setBackground(table.getSelectionBackground());
                    check.setOpaque(true);
                } else {
                    check.setOpaque(false);
                    check.setBackground(table.getBackground());
                }
                return check;
            }
            if (colIndex == 5) {
                this.setText(Integer.toString(channel.skipFactorFrame));
            } else if (colIndex == 6) {
                this.setText("");
                this.setBackground(channel.color);
                this.setOpaque(true);
            }
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
            this.setBackground(table.getBackground());
        }
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

