/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.dialogs.ChannelTableModel;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class ChannelCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -8374637422965302637L;
    JTextField text_ = new JTextField();
    JComboBox combo_ = new JComboBox();
    JCheckBox checkBox_ = new JCheckBox();
    JLabel colorLabel_ = new JLabel();
    int editCol_ = -1;
    int editRow_ = -1;
    ChannelSpec channel_ = null;
    private AcquisitionEngine acqEng_;
    private Preferences exposurePrefs_;
    private Preferences colorPrefs_;

    public ChannelCellEditor(AcquisitionEngine engine, Preferences exposurePrefs, Preferences colorPrefs) {
        this.acqEng_ = engine;
        this.exposurePrefs_ = exposurePrefs;
        this.colorPrefs_ = colorPrefs;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
        ChannelSpec channel;
        if (isSelected) {
            // empty if block
        }
        ChannelTableModel model = (ChannelTableModel)table.getModel();
        ArrayList<ChannelSpec> channels = model.getChannels();
        this.channel_ = channel = channels.get(rowIndex);
        colIndex = table.convertColumnIndexToModel(colIndex);
        this.editRow_ = rowIndex;
        this.editCol_ = colIndex;
        if (colIndex == 0) {
            this.checkBox_.setSelected((Boolean)value);
            return this.checkBox_;
        }
        if (colIndex == 2 || colIndex == 3) {
            this.text_.setText(NumberUtils.doubleToDisplayString((Double)value));
            return this.text_;
        }
        if (colIndex == 4) {
            this.checkBox_.setSelected((Boolean)value);
            return this.checkBox_;
        }
        if (colIndex == 5) {
            this.text_.setText(NumberUtils.intToDisplayString((Integer)value));
            return this.text_;
        }
        if (colIndex == 1) {
            this.combo_.removeAllItems();
            ActionListener[] l = this.combo_.getActionListeners();
            for (int i = 0; i < l.length; ++i) {
                this.combo_.removeActionListener(l[i]);
            }
            this.combo_.removeAllItems();
            String[] configs = model.getAvailableChannels();
            for (int i = 0; i < configs.length; ++i) {
                this.combo_.addItem(configs[i]);
            }
            this.combo_.setSelectedItem(channel.config);
            this.combo_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChannelCellEditor.this.channel_.color = new Color(ChannelCellEditor.this.colorPrefs_.getInt("Color_" + ChannelCellEditor.this.acqEng_.getChannelGroup() + "_" + (String)ChannelCellEditor.this.combo_.getSelectedItem(), Color.white.getRGB()));
                    ChannelCellEditor.this.channel_.exposure = ChannelCellEditor.this.exposurePrefs_.getDouble("Exposure_" + ChannelCellEditor.this.acqEng_.getChannelGroup() + "_" + (String)ChannelCellEditor.this.combo_.getSelectedItem(), 10.0);
                    ChannelCellEditor.this.fireEditingStopped();
                }
            });
            return this.combo_;
        }
        return this.colorLabel_;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (this.editCol_ == 0) {
                return this.checkBox_.isSelected();
            }
            if (this.editCol_ == 1) {
                this.channel_.color = new Color(this.colorPrefs_.getInt("Color_" + this.acqEng_.getChannelGroup() + "_" + this.combo_.getSelectedItem(), Color.white.getRGB()));
                this.channel_.exposure = this.exposurePrefs_.getDouble("Exposure_" + this.acqEng_.getChannelGroup() + "_" + this.channel_.config, 10.0);
                return this.combo_.getSelectedItem();
            }
            if (this.editCol_ == 2 || this.editCol_ == 3) {
                return new Double(NumberUtils.displayStringToDouble(this.text_.getText()));
            }
            if (this.editCol_ == 4) {
                return this.checkBox_.isSelected();
            }
            if (this.editCol_ == 5) {
                return new Integer(NumberUtils.displayStringToInt(this.text_.getText()));
            }
            if (this.editCol_ == 6) {
                Color c = this.colorLabel_.getBackground();
                return c;
            }
            String err = "Internal error: unknown column";
            return err;
        }
        catch (ParseException p) {
            ReportingUtils.showError(p);
            String err = "Internal error: unknown column";
            return err;
        }
    }
}

